
package itourbaskClases;

import itourbaskBeans.q53OpcionBean;
import itourbaskBeans.q53PreguntaBean;
import itourbaskBeans.q53RespuestaBean;
import itourbaskBeans.q53RespuestaFechaBean;
import itourbaskBeans.q53RespuestaGrupoBean;
import itourbaskBeans.q53RespuestaGruposBean;
import itourbaskBeans.q53RespuestaOpcionesBean;
import itourbaskBeans.q53RespuestaProcedenciaBean;
import itourbaskBeans.q53RespuestaTextoBean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53RespuestaTablaClass {
  /**
     * Metodo para encontrar todas las respuestas a una encuesta entre un periodo de tiempo
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */





    public static List getRespuestas(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion) throws ProcletException {

        List encuestasList = new ArrayList();
        String selectEncuestas = "select M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI') m0_fecha_resp, M0_TIPO_ENCUESTA "
            + " from respuesta"
            + " where ";

        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += "M0_COD_OFICINA = '" + codOficina + "' and ";
        }
        selectEncuestas += " respuesta.m0_fecha BETWEEN TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS') "
                + " AND TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS') "
                + " AND M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " order by m0_fecha_resp";

        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);

        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            for (int i = 0; i < numEnc; i++) {
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                respuestaBean.setCodRespuesta(sd.gOS("encuestas[" + i + "].m0_cod_respuesta"));
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                encuestasList.add(respuestaBean);
            }
        }
        return encuestasList;
    }
    
    /**
     * Mtodo que nos devuelve las opciones de las respuestas de tipo grupos
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de la respuesta
     * @param codPregunta String que es el cdigo de la pregunta
     * @param respuestaBean Objeto que contien los datos de las respuesta
     *
     * @return q53RespuestaBean Nuevo objeto con los datos de la respuesta de
     *         tipo grupos
     *
     * @throws ProcletException
     */
    private static q53RespuestaBean getOptionsAndGroupsResponse(
            ProcletServiceData sd, String codRespuesta, String codPregunta,
            q53RespuestaBean respuestaBean) throws ProcletException {

        String selectGroupHombres = "select N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES " 
            + "from resp_grupos"
            + " where N9_COD_RESPUESTA = " + codRespuesta 
            + " and resp_grupos.N9_COD_PREGUNTA='" + codPregunta + "'"
            + " AND N9_COD_GRUPO='1'";
        PSP.sqlProclet(sd, "selectGroupHombres[]=" + selectGroupHombres);

        int numHombres = 0;
        int numMujeres = 0;
        if(sd.gI("selectGroupHombres.length")>0){
            String grupo2 = sd.gOS("selectGroupHombres[0].n9_cod_grupo");
            numHombres = sd.gI("selectGroupHombres[0].n9_hombres");
            numMujeres = sd.gI("selectGroupHombres[0].n9_mujeres");
        }
        String selectGroupMujeres = "select N9_HOMBRES,N9_MUJERES " 
            + "from resp_grupos"
            + " where N9_COD_RESPUESTA = " + codRespuesta 
            + " and resp_grupos.N9_COD_PREGUNTA='" + codPregunta + "'"
            + " AND N9_COD_GRUPO='2'";
        PSP.sqlProclet(sd, "selectGroupMujeres[]=" + selectGroupMujeres);
        if(sd.gI("selectGroupMujeres.length")>0){
            numHombres = numHombres + sd.gI("selectGroupMujeres[0].n9_hombres");
            numMujeres = numMujeres + sd.gI("selectGroupMujeres[0].n9_mujeres");
        }
        int numPersonas = numHombres + numMujeres;
        respuestaBean.setNumPersonas((new Integer(numPersonas)).toString());
        return respuestaBean;
    }
    
    /**
     * Mtodo que nos devuelve el nombre  de la opcion de la pregunta de tipo
     * opciones
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de respuesta
     * @param codPregunta String que es el cdigo de pregunta
     *
     * @return String que es la descripcion de la opcion
     *
     * @throws ProcletException
     */
    private static String getOpcionName(ProcletServiceData sd,
            String codRespuesta, String codPregunta) throws ProcletException {
        String selectOpcion = "SELECT M2_COD_OPCION"
            + " FROM RESP_OPCIONES"
            + " WHERE M2_COD_RESPUESTA='" + codRespuesta + "'"
            + " AND M2_COD_PREGUNTA='" + codPregunta + "'";
        PSP.sqlProclet(sd, "selectOpcion[]=" + selectOpcion);

        String opcion_4 = sd.gOS("selectOpcion[0].m2_cod_opcion");
        return q53Util.getLiteral(sd, "N3_" + codPregunta + "_" + opcion_4, q53Util.getIdioma(sd));
    }
    
    /**
     * Mtodo que nos devuelve la fecha de introduccion de la respuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de respuesta
     *
     * @return String con la fecha de introduccion en el formato adecuado
     *
     * @throws ProcletException
     */
/* 25.10.2007 No se usa*/
/*
    private static String getDateInterview(ProcletServiceData sd,
            String codRespuesta) throws ProcletException {
        String selectFecha =
                "SELECT to_char(M6_FECHA,'DD/MM/YYYY HH24:MI') M6_FECHA FROM RESP_FECHA WHERE M6_COD_RESPUESTA='" +
                codRespuesta + "'";
        PSP.sqlProclet(sd, "selectFecha[]=" + selectFecha);
        
        String fecha = sd.gOS("selectFecha[0].m6_fecha");
        
        return fecha;
    }
*/
    
    /**
     * Mtodo para insertar las respuestas de la encuesta en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param gvCodEncuesta String que es el cdigo de la encuesta del g.v. (el
     *        0)
     * @param gvCodVersion String que es el cdigo de la version de la encuesta
     *        del g.v. (el 0)
     * @param codRespuesta String que es el cdigo de respuesta
     *
     * @throws ProcletException
     */
    public static void guardarRespuestasEncGV(ProcletServiceData sd,
            String gvCodEncuesta, String gvCodVersion, String codRespuesta, int cont)
            throws ProcletException {
        //List preguntasList = getGVPreguntasData(sd, gvCodEncuesta, gvCodVersion);
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                gvCodEncuesta, gvCodVersion);
        String query_final = "";
        int lineaA=cont-1;
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();
            q53LogEstadisticas.printDebug("numero de preguntas: "  + numPregs);
            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
                String tipo_pregunta = preguntaBean.getTipoPregunta();
                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                	q53LogEstadisticas.printLog("Tipo opciones");                	
                    String respOpciones=guardarRptaOpciones(sd, preguntaBean, i, codRespuesta, cont);               	
                    query_final +=respOpciones;
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                	q53LogEstadisticas.printLog("Tipo texto");
					String respTexto=guardarRptaTexto(sd, preguntaBean, i, codRespuesta, cont);
                    q53LogEstadisticas.printDebug("pregunta de tipo texto: "  + respTexto);
					query_final += respTexto;
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                	q53LogEstadisticas.printLog("Tipo procedencia"); 
										String respProcedencia= guardarRptaProcedencia(sd, preguntaBean, i, codRespuesta, cont);
                    query_final += respProcedencia;
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                	q53LogEstadisticas.printLog("Tipo fecha");                	
									if (!sd.gOS("id"+cont).equals(sd.gOS("id"+lineaA))){
										String respFecha=guardarRptaFecha(sd, preguntaBean, i, codRespuesta, cont);
                    query_final += respFecha;
                  }
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                	q53LogEstadisticas.printLog("Tipo grupos");									
					String respGrupos="";
					if (!sd.gOS("id"+cont).equals(sd.gOS("id"+lineaA))){
						respGrupos=guardarRptaGrupos(sd, preguntaBean, i, codRespuesta ,cont);
						query_final += respGrupos;
					}
                }
            }
            q53LogEstadisticas.printLog("INSERT DE LA TABLAPRES guardarRespuestasEncGV() -> " + query_final + " <-");
            try{
            	PSP.sqlProclet(sd, query_final);
            }catch(Exception e){
            	q53LogEstadisticas.printLog("Ha saltado una excepcion : "+e.getMessage());
            }
            q53LogEstadisticas.printLog("Query_final ejecutada");
        }
    }
    
    /**
     * Mtodo para insertar las respuestas de la encuesta en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codEncuestaOfi String que es el cdigo de la encuesta propia de
     *        la oficina
     * @param codVersionEncOfi String que es el cdigo de la version de la
     *        encuesta propia de la oficina
     * @param codRespOfi String que es el cdigo de la respuesta propia de la
     *        oficina
     *
     * @throws ProcletException
     */
    public static void guardarRespuestasEncOfi(ProcletServiceData sd,
            String codEncuestaOfi, String codVersionEncOfi, String codRespOfi, int cont)
            throws ProcletException {
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                codEncuestaOfi, codVersionEncOfi);
        String query_final = "";

        q53LogEstadisticas.printLog("preguntas en oficina");
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();
            String isFecha = "N";
            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
                String tipo_pregunta = preguntaBean.getTipoPregunta();
                
                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                    query_final += guardarRptaOpciones(sd, preguntaBean, i, codRespOfi, cont);
                    q53LogEstadisticas.printLog("guardado tipo opciones");
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                    query_final += guardarRptaTexto(sd, preguntaBean, i, codRespOfi, cont);
                    q53LogEstadisticas.printLog("guardado tipo texto");
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                    query_final += guardarRptaFecha(sd, preguntaBean, i, codRespOfi, cont);
                    q53LogEstadisticas.printLog("guardado tipo fecha");
                    isFecha="S";
                }
            }

/*
29.11.2007 Nuevo. Hay que actualizar el valor de m0_fecha_resp siempre.
Este valor se actualiza mediante un trigger en la bbdd, al meter un valor en el campo m6_fecha se dispara
pero cuando la encuesta propia no tiene preguntas de tipo fecha, este campo queda vacio,
y al sacar las estadisticas no salen los datos.
*/
            q53LogEstadisticas.printLog("isFecha -" + isFecha + "-");
            if (isFecha.equals("N"))
            { // hay que actualizar el registro de RESPUESTA para meter m0_fecha_resp
                String fechaUpdate = "UPDATE respuesta"
                    + " SET m0_fecha_resp = (SELECT r1.m0_fecha_resp fecha"
                    + " FROM respuesta r1, respuesta r2"
                    + " WHERE r1.m0_cod_respuesta = r2.m0_cod_respuesta_rd"
                    + " AND r2.m0_cod_respuesta = "+codRespOfi+")"
                    + " WHERE m0_cod_respuesta = "+codRespOfi;
                query_final += "="+fechaUpdate+";";
            }

            q53LogEstadisticas.printLog("INSERT DE LA TABLAPRES guardarRespuestasEncOfi() -> " + query_final + " <-");
            PSP.sqlProclet(sd, query_final);
        }
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo opcion en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto que contiene los datos de la pregunta
     * @param i Numero de la pregunta en el array. No se usa.
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaOpciones(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta, int cont)
            throws ProcletException {

        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        // mirar que formato tiene la pregunta: combobox, check, radio button
        String sql_tmp = "SELECT n2_formato formato"
            + " FROM pr_opciones"
            + " WHERE n2_cod_pregunta=" + cod_pregunta;
        PSP.sqlProclet(sd, "formato_tmp="+sql_tmp);

        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA"
            + " (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        rtdo = "=" + insert_pregunta + ";";

        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_RADIO)) {
            // Pregunta de opciones con formato radio button.
        	q53LogEstadisticas.printLog("formato radio");      
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "" + cont + "()");
            q53LogEstadisticas.printLog("RADIO!!!::::opt_" + cod_pregunta +""+cont+"::::"+sd.gOS("opt_" + cod_pregunta +""+cont).equals(""));  
            if (!sd.gOS("opt_" + cod_pregunta +""+cont).equals("")) { 
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES"
                    + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",${opt_" + cod_pregunta + "" + cont + "})";
                rtdo += "=" + insert_pregunta_tipo + ";";
                q53LogEstadisticas.printLog("INSERT DE LA OPCION <-"+insert_pregunta_tipo+"->");
            }
        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_CHECK)) {
        	q53LogEstadisticas.printLog("formato check");                	
            // Pregunta de opciones de formato check (multiple respuestas!!)
            PSP.paramProclet(sd, "opt_check_" + cod_pregunta + "" + cont + "()");
            String opt = sd.gOS("opt_check_" + cod_pregunta+ "" + cont);
            String cadena_insert = "";
            List existentes=new ArrayList();
            while (opt.length() != 0) {
                int indice = opt.indexOf(",");
                String opt_tmp = "";
                boolean esta=false;
                if (indice != -1) {
                    opt_tmp = opt.substring(0, indice);
                    opt = opt.substring(indice + 1, opt.length());
                    int lon=existentes.size();
                    for(int e=0;e<lon;e++){
                    	if(existentes.get(e).toString().equals(opt_tmp)){
                    		esta=true;
                    		break;
                    	}
                    }
                    if(!esta){
                    	existentes.add(opt_tmp);
                    }
                } else {
                   opt_tmp = opt;
                    opt = "";
                    int lon=existentes.size();
                    for(int e=0;e<lon;e++){
                   	if(existentes.get(e).toString().equals(opt_tmp)){
                    		esta=true;
                    		break;
                    	}
                    }
                   
                }
                if(!esta){
                			cadena_insert += "=INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                     +" VALUES (" + cod_respuesta + "," + cod_pregunta + "," + opt_tmp + ");";
                }     
            }
            rtdo += cadena_insert;

        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_SELECT)) {
        	q53LogEstadisticas.printLog("formato select");                	
            // Pregunta de opciones con formato select
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "" +cont+ "()");
            q53LogEstadisticas.printLog("CODIGO DE LA RESPUESTA OPCION <-"+sd.gOS("opt_" + cod_pregunta)+"->");  
            if (!sd.gOS("opt_" + cod_pregunta + "" + cont).equals("")) {
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",${opt_" + cod_pregunta +""+cont+ "})";
                
                rtdo += "=" + insert_pregunta_tipo + ";";
                q53LogEstadisticas.printLog("INSERT DE LA OPCION <-"+insert_pregunta_tipo+"->");
            }
        }
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo texto en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto con los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaTexto(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta, int cont)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        PSP.paramProclet(sd, "txt_" + cod_pregunta + "_"+cont+"()");
        String texto=sd.gOS("txt_" + cod_pregunta + "_"+cont);
        q53LogEstadisticas.printLog("txt_" + cod_pregunta + "_"+cont+"()->" +"<-");                
              String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        String insert_pregunta_tipo = "INSERT INTO RESP_TEXTO (M4_COD_RESPUESTA,M4_COD_PREGUNTA,M4_TEXTO)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",'${txt_" + cod_pregunta + "_"+cont+"}')";
        rtdo = "=" + insert_pregunta+ ";=" + insert_pregunta_tipo+";";
        q53LogEstadisticas.printLog("valor de rtdo-"+rtdo); 
        q53LogEstadisticas.printLog("valor del texto-"+texto);
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Procedencia
     * en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean objeto que contiene los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaProcedencia(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta, int cont)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        q53LogEstadisticas.printLog("Entramos en guardarRptaProcedencia");                
 
		PSP.paramProclet(sd,
                "proc_local_" + cod_pregunta +"_"+ cont+ "(), proc_pais_" + cod_pregunta + "_"+cont+"()," +                
                "cposProc"+cont+"(),personasProc"+cont+"(),"+
				"grp_2_2_1"+cont+"()," +
				"grp_2_2_2"+cont+"()," +
                "local"+cont+"(),id"+cont+"()");

		q53LogEstadisticas.printLog("La fila es (variable cont)" + "->" +cont + "<-");                
                
        String strNumHombres = sd.gOS("grp_2_2_1"+cont+"");
		q53LogEstadisticas.printLog("strNumHombres:"+ "->"+ strNumHombres + "<-");
        if (strNumHombres.equals("")) {
            strNumHombres = "0";
        }
        String strNumMujeres = sd.gOS("grp_2_2_2"+cont+"");
		q53LogEstadisticas.printLog("strNumMujeres:"+ "->"+ strNumMujeres + "<-");
        if (strNumMujeres.equals("")) {
            strNumMujeres = "0";
        }
		int numPersonasProc;
		q53LogEstadisticas.printLog("recalculamos las personas totales proc ");
		int numHombres = Integer.parseInt(strNumHombres);
		q53LogEstadisticas.printLog("numHombres:"+ "->"+ numHombres + "<-");
		int numMujeres =  Integer.parseInt(strNumMujeres);
		q53LogEstadisticas.printLog("numMujeres:"+ "->"+ numMujeres+ "<-");
		numPersonasProc = numHombres + numMujeres;
		q53LogEstadisticas.printLog("Total personas:"+ "->"+ numPersonasProc+ "<-");
				
		String pais=sd.gOS("proc_pais_" + cod_pregunta + "_"+cont);
   		q53LogEstadisticas.printLog("proc_pais_" + cod_pregunta + "_"+cont +"->" +pais+"<-");                

        q53LogEstadisticas.printLog("Inicializamos numLocales y numProc1  a 0");                
		int numLocales = 0;
        int numProc1=0;
		q53LogEstadisticas.printLog("Comprobamos si es local o no");                
		q53LogEstadisticas.printLog("local"+cont+"->" +sd.gOS("local"+cont+"")+"<-");                
 		q53LogEstadisticas.printLog("numero de personas (sd.gOS(totalPersonasProc+cont) " + "<totalPersonasProc"+cont + ">:" + " ->" +sd.gOS("totalPersonasProc"+cont)+"<-");			
		q53LogEstadisticas.printLog("numero de personas (sd.gOS(personasProc+cont) " + "<personasProc"+cont + ">:" + " ->" +sd.gOS("personasProc"+cont)+"<-");
		if(!sd.gOS("local"+cont+"").equals("")){
			q53LogEstadisticas.printLog("Es local");                
			q53LogEstadisticas.printLog("numero de personas (sd.gOS(personasProc+cont) " + "<personasProc"+cont + ">:" + " ->" +sd.gOS("personasProc"+cont)+"<-");
		    if(!sd.gOS("personasProc"+cont).equals("")){
				q53LogEstadisticas.printLog("Dentro de if de asignacion de numLocales");                
	            numLocales = sd.gI("personasProc"+cont+"");
	        }else{
				q53LogEstadisticas.printLog("Dentro de else de asignacion de numLocales");                
	            numLocales = numPersonasProc;
			}
			q53LogEstadisticas.printLog("Ya tenemos metido numero de personas locales");                
			q53LogEstadisticas.printLog("numLocales " + "->" +numLocales+"<-");                
        } else {
			q53LogEstadisticas.printLog("No es Es local");                
			q53LogEstadisticas.printLog("numero de personas (sd.gOS(personasProc+cont) " + "<personasProc"+cont + ">:" + "->" +sd.gOS("personasProc"+cont)+"<-");       
	        if(!sd.gOS("personasProc"+cont).equals("")){
				q53LogEstadisticas.printLog("Dentro de if de asignacion de numProc1");                
	            numProc1 = sd.gI("personasProc"+cont+"");
			}else{
				q53LogEstadisticas.printLog("Dentro de else de asignacion de numProc1");                
	            numProc1 = numPersonasProc;
			}
			q53LogEstadisticas.printLog("Ya tenemos metido numero de personas de procedencias");                
			q53LogEstadisticas.printLog("numProc1 " + "->" +numProc1+"<-");                
      	}
        String cpos1="0";
        String prov1="0";
        String territorio1="";
       
        if(!sd.gOS("cposProc"+cont).equals("")){
            cpos1 = sd.gOS("cposProc"+cont);
			if(pais.equals("0")) {
				if(cpos1.length()==5){
					prov1=cpos1.substring(0,2);
					if(prov1.equals("01") || prov1.equals("1")){
						territorio1="0";
					}else if (prov1.equals("20")){
						territorio1="2";
					}else if (prov1.equals("48")){
						territorio1="1";
					}
				}
			}
        }else{
			if(pais.equals("10")){
				cpos1="999";
			} 	
		}
        
            
        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        rtdo += "=" + insert_pregunta + ";";

        String codOficina = sd.gOS("q53_cki.q53_oficina");
        String codMunicipioOfi = "";
        String selectMuni = "SELECT TO_CHAR(T02_CODPROVINC,'FM09') T02_CODPROVINC,"
            + "TO_CHAR(T02_CODMUNICIP,'FM0999') T02_CODMUNICIP"
            + " FROM OFICINA"
            + " WHERE T02_COOR='" +codOficina + "'";
        PSP.sqlProclet(sd, "selectMuni[]=" + selectMuni );
        codMunicipioOfi = sd.gOS("selectMuni[0].t02_codprovinc")+"_"+sd.gOS("selectMuni[0].t02_codmunicip");
        
        //BUSCAMOS LA COMARCA A LA QUE PERTENECE EL MUNICIPIO
        String selectComarca = "SELECT P3_COD_COMARCA, P3_COD_TERRITORIO"
            + " FROM MUNICIPIO"
            + " WHERE P3_COD_MUNICIPIO='"+codMunicipioOfi+"'";
        PSP.sqlProclet(sd, "selectComarca[]=" + selectComarca );
        String codComarca = sd.gOS("selectComarca[0].p3_cod_comarca");
        String codTerritorio =  sd.gOS("selectComarca[0].p3_cod_territorio");
        
        //BUSCAMOS LA COMUNIDAD AUTONOMA A LA QUE PERTENECE LA PROVINCIA
        String codCCAA1="0";
        if(!sd.gOS("cposProc"+cont).equals("")){
        	if(pais.equals("0")){        	
        		String selectCCAA1 = "SELECT COD_CCAA"
            	+ " FROM Q53P5T00"
            	+ " WHERE COD_PROV='"+prov1+"'";
        		PSP.sqlProclet(sd, "selectCCAA1[]=" + selectCCAA1 );
        		codCCAA1 = sd.gOS("selectCCAA1[0].cod_ccaa");
        	}else if(pais.equals("10")){
        			codCCAA1=sd.gOS("cposProc"+cont);
        	}	
        }else {
        	if(pais.equals("10")){
        		codCCAA1="999";
        	}	
        }
        
		q53LogEstadisticas.printLog("Comprobamos de nuevo si es local o no");                
		q53LogEstadisticas.printLog("local"+cont+" "+"->" +sd.gOS("local"+cont)+"<-");                
		if(!sd.gOS("local"+cont).equals("")){
			q53LogEstadisticas.printLog("Es local");                
			q53LogEstadisticas.printLog("numero de personas (sd.gOS(personasProc+cont) " + "<personasProc"+cont + ">:" + " ->" +sd.gOS("personasProc"+cont)+"<-");	
			q53LogEstadisticas.printLog("numProc1 (no se utiliza) " + "->" +numProc1+"<-");                
 			q53LogEstadisticas.printLog("numLocales " + "->" +numLocales+"<-");                
			q53LogEstadisticas.printDebug("Modificando.......................loc");
            String insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA"
                + " (M5_COD_RESPUESTA,M5_COD_PREGUNTA,M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO,"
                + "M5_COD_PROCEDENCIA,M5_COD_COMARCA,M5_NUM_PERSONAS,M5_CPOS)"
                + " VALUES (" + cod_respuesta + "," +cod_pregunta + ",'S',0,0,"+codTerritorio+",'"+codMunicipioOfi+"','1',"
                + "'"+codComarca+"',"+numLocales+","+cpos1+")";
 			q53LogEstadisticas.printLog("insert_pregunta_tipo " + "->" +insert_pregunta_tipo+"<-");                
            rtdo += "=" + insert_pregunta_tipo + ";";
              insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'2',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";
              insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'3',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";
             insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'4',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";               
        }else{
			q53LogEstadisticas.printLog("NO es local");                
			q53LogEstadisticas.printLog("numero de personas (sd.gOS(personasProc+cont) " + "<personasProc"+cont + ">:" + " ->" +sd.gOS("personasProc"+cont)+"<-");		
			q53LogEstadisticas.printLog("numProc1 " + "->" +numProc1+"<-");                
 			q53LogEstadisticas.printLog("numLocales (no se utiliza)" + "->" +numLocales+"<-");                
            q53LogEstadisticas.printDebug("Modificando.......................noloc");
            String insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'1',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";
             insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'3',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";
             insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'4',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";

			String insert_preguntaProc1="";

			String mun1="";
			String pais1=sd.gOS("proc_pais_6_"+cont);
			if(pais1.equals("0")){mun1=q53Util.getMunicipio(sd,cpos1);}
			if(pais1.equals(""))pais1="0";
			insert_preguntaProc1 = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
				+ "M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO," 
				+ "M5_COD_COMARCA,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS,M5_CPOS) "
				+ "VALUES (" + cod_respuesta + ",6,'N','"+pais1+"','"+codCCAA1+"','"+territorio1+"','"+mun1+"',"
				+ "'','2',"+numProc1+","+cpos1+")";
 			q53LogEstadisticas.printLog("insert_preguntaProc1 " + "->" +insert_preguntaProc1+"<-");                
			rtdo += "=" + insert_preguntaProc1 + ";";
		}
			// q53LogEstadisticas.printLog("valor de rtdo-"+rtdo);                
        return rtdo;
          
        
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Fecha en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto que contiene losd atos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaFecha(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta, int cont)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        
        q53LogEstadisticas.printLog("cod_pregunta :" + cod_pregunta);        
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        q53LogEstadisticas.printLog("tipo_pregunta :" + tipo_pregunta);
        String rtdo = "";
				java.util.Calendar cal=java.util.Calendar.getInstance();
				int hh=cal.get(java.util.Calendar.HOUR_OF_DAY);
        PSP.paramProclet(sd,
                "fech_" + cod_pregunta + "_dia_"+cont+"(),fech_" + cod_pregunta +
                "_mes_"+cont+"(),fech_" + cod_pregunta + "_anio_"+cont+"(),fech_" + cod_pregunta +
                "_hora_"+cont+"("+hh+"),fech_10_dia2_"+cont+"(),fech_10_mes2_"+cont+"(),fech_10_anio2_"+cont+"(),id"+cont+"()");
q53LogEstadisticas.printLog("fech_10_dia_"+cont+" : " + sd.gI("fech_0_dia_"+cont+""));                
q53LogEstadisticas.printLog("fech_10_mes_"+cont+" : " + sd.gI("fech_0_mes_"+cont+""));
q53LogEstadisticas.printLog("fech_10_anio_"+cont+": " + sd.gI("fech_0_anio_"+cont+""));

                
		int mes_fecha =sd.gI("fech_" +cod_pregunta + "_mes_"+cont);
		String sMes_Fecha= "";
		if(mes_fecha <10){
			sMes_Fecha = "0"+(new Integer(mes_fecha)).toString();
		}else{
			sMes_Fecha = (new Integer(mes_fecha)).toString();
		}
		int dia_fecha =sd.gI("fech_" +cod_pregunta + "_dia_"+cont);
		String sdia_fecha= "";
		if(dia_fecha <10){
			sdia_fecha = "0"+(new Integer(dia_fecha)).toString();
		}else{
			sdia_fecha = (new Integer(dia_fecha)).toString();
		}
		int anio_fecha =sd.gI("fech_" +cod_pregunta + "_anio_"+cont);
		String sanio_fecha= "";
		if(anio_fecha <10){
			sanio_fecha = "0"+(new Integer(anio_fecha)).toString();
		}else{
			sanio_fecha = (new Integer(anio_fecha)).toString();
		}
		int hora_fecha =sd.gI("fech_" +cod_pregunta + "_hora_"+cont);
		String shora_fecha= "";
		if(hora_fecha <10){
			shora_fecha = "0"+(new Integer(hora_fecha)).toString();
		}else{
			shora_fecha = (new Integer(hora_fecha)).toString();
		}
	//-------------Fecha 2-----------------------------------------------	
		String sMes_Fecha2= "";
		String sdia_fecha2= "";
		String sanio_fecha2= "";
		String fecha_check=sd.gOS("fech_10_dia2_"+cont);
		if(fecha_check.length()>0){
		int mes_fecha2=sd.gI("fech_10_mes2_"+cont);
		if(mes_fecha2 <10){
			sMes_Fecha2 = "0"+(new Integer(mes_fecha2)).toString();
		}else{
			sMes_Fecha2 = (new Integer(mes_fecha2)).toString();
		}
		int dia_fecha2 =sd.gI("fech_10_dia2_"+cont);
		if(dia_fecha2 <10){
			sdia_fecha2 = "0"+(new Integer(dia_fecha2)).toString();
		}else{
			sdia_fecha2 = (new Integer(dia_fecha2)).toString();
		}
		int anio_fecha2 =sd.gI("fech_10_anio2_"+cont);
		
		if(anio_fecha2 <10){
			sanio_fecha2 = "0"+(new Integer(anio_fecha2)).toString();
		}else{
			sanio_fecha2 = (new Integer(anio_fecha2)).toString();
		}
    }
   int hora_fecha2 =sd.gI("fech_" +cod_pregunta + "_hora_"+cont);
		String shora_fecha2= "";
		if(hora_fecha2 <10){
			shora_fecha2 = "0"+(new Integer(hora_fecha2)).toString();
		}else{
			shora_fecha2 = (new Integer(hora_fecha2)).toString();
		}   
        //int lineaA=cont-1;
        //int lineaAA=cont-2;
        //if(!sd.gOS("id"+cont).equals(sd.gOS("id"+lineaA))&&!sd.gOS("id"+cont).equals(sd.gOS("id"+lineaAA))){
        
        			String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA"
        			    + "(M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
        			    + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        			//String insert_pregunta_tipo = "INSERT INTO RESP_FECHA"
        			//    + " (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA,M6_FECHA_RESPUESTA)"
        			//    + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
        			//    + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
        			//    + sd.gOS("fech_" +cod_pregunta + "_hora_"+cont+")+", " TO_DATE('"+sdia_fecha2+sMes_Fecha2+sanio_fecha2+shora_fecha2+":00:00','DDMMYYYY HH24:MI:SS') ")";
        String insert_pregunta_tipo="";
        if(fecha_check.length()>0){			    
        			insert_pregunta_tipo = "INSERT INTO RESP_FECHA (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA,M6_FECHA_RESPUESTA)"
        			    + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
        			    + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
        			    + sd.gOS("fech_" +cod_pregunta + "_hora_"+cont)+"," 
        			    + " TO_DATE('"+sdia_fecha2+sMes_Fecha2+sanio_fecha2+shora_fecha2+":00:00','DDMMYYYY HH24:MI:SS'))";
        			rtdo += "=" + insert_pregunta + ";=" + insert_pregunta_tipo + ";";
        }else{
        	insert_pregunta_tipo = "INSERT INTO RESP_FECHA (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA)"
        			    + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
        			    + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
        			    + sd.gOS("fech_" +cod_pregunta + "_hora_"+cont)+")";
        			rtdo += "=" + insert_pregunta + ";=" + insert_pregunta_tipo + ";";
        }			
        //}
         // q53LogEstadisticas.printLog("valor de rtdo-"+rtdo);                
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Grupos en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Onjeto que contiene los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaGrupos(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta, int cont)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        PSP.sqlProclet(sd, "formato_tmp=SELECT n7_tipo formato FROM pr_grupos WHERE n7_cod_pregunta=" + cod_pregunta);
        String insert_pregunta = "=INSERT INTO RESPUESTA_PREGUNTA"
            + " (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ");";
        rtdo += insert_pregunta + ";";
        
        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_GRUPO_2)) {
            // Pregunta de grupos con formato de dos campos, 'Numero de personas'.
            String cadena_insert = "";
            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_1"+cont+"()");
            String grp1 = sd.gOS("grp_" + cod_pregunta + "_2_1"+cont+"");
            if (grp1.equals("")) {
                grp1 = "0";
            }
            cadena_insert += "=INSERT INTO RESP_GRUPOS"
                + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", 1, " + grp1 + ", 0);";

            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_2"+cont+"()");
            String grp2 = sd.gOS("grp_" + cod_pregunta + "_2_2"+cont+"");
            if (grp2.equals("")) {
                grp2 = "0";
            }
            cadena_insert += "=INSERT INTO RESP_GRUPOS"
                + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", 2, 0, " + grp2 + ");";

            //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
            //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
            int intGrp1 = Integer.valueOf(grp1).intValue();
            int intGrp2 = Integer.valueOf(grp2).intValue();
            int totalPersonas = intGrp1 + intGrp2;
            String codOpcion = "1"; //Por defecto la opcion es 'Solo'
            if (totalPersonas > 1) {
                codOpcion = "2"; //Si el nmero de personas es ms de 1 la opcin es 'Grupo'
            }
            cadena_insert += "=INSERT INTO RESP_OPCIONES"
                + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", " + codOpcion + ");";

            //Aadimos en la tabla RESPUESTA el nmero de personas que han contestado a esta encuesta
            //para disponer de esta informacion mas facilmente a la hora de realizar las estadisticas
            cadena_insert += "=UPDATE RESPUESTA "
                + " SET M0_PERSONAS = " + totalPersonas
                + " WHERE M0_COD_RESPUESTA=" + cod_respuesta + ";";
            rtdo += cadena_insert;
        }

        else if (sd.gOS("formato_tmp.formato").equals("5")) {
            // Pregunta de grupos con formato de cinco campos, 'Grupos de edad'.
            String cadena_insert = "";
            String cadena_update ="";
            String grpH = "";
            String grpM = "";
            String grpT = "";
            boolean bMostrador = true;
            
            for (int j = 1; j < 6; j++) {
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j + "_H"+cont+"()");
                grpH = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_H"+cont+"");
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j + "_M"+cont+"()");
                grpM = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_M"+cont+"");
                
                if (grpH.equals("")) {
                    grpH = "0";
                }
                if (grpM.equals("")) {
                    grpM = "0";
                }
                
                cadena_insert += "=INSERT INTO RESP_GRUPOS"
                    + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ", " + j + ", " + grpH + ", " + grpM + ");";

                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();
                int total = intGrpH + intGrpM;
                
                if (total > 0) {
                    cadena_insert += "=INSERT INTO RESP_OPCIONES"
                        + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                        + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + j + ");";
                    bMostrador = false;
                }
            }
            
            if (bMostrador) {
                grpH = sd.gOS("grp_2_2_1"+cont+"");
                
                grpM = sd.gOS("grp_2_2_2"+cont+"");
                
                if (grpH.equals("")) {
                    grpH = "0";
                }
                
                if (grpM.equals("")) {
                    grpM = "0";
                }
                cadena_update += "=UPDATE RESP_GRUPOS"
                    + " SET N9_HOMBRES="+grpM+","
                    + " N9_MUJERES="+grpH
                    + " WHERE N9_COD_RESPUESTA= "+cod_respuesta
                    + " AND N9_COD_PREGUNTA="+cod_pregunta
                    + " AND N9_COD_GRUPO=5;";
                
                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();
                int total = intGrpH + intGrpM;
                if (total > 0) {
                    cadena_insert += "=INSERT INTO RESP_OPCIONES"
                        + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                        + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",5);";
                    bMostrador = false;
                }
            }

            rtdo += cadena_insert;
            rtdo += cadena_update;
        }
        return rtdo;
    }

    /**
     * Mtod para insertar una nueva respuesta en la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina String que es el codigo de la oficina
     * @param usuario Strin que es el codigo del usuario que realiza la
     *        encuesta
     * @param gvCodEncuesta String que es el codigo de la encuesta del g.v.
     * @param gvCodVersion String que es el codigo de la version de la encuesta
     *        del g.v.
     *
     * @return
     *
     * @throws ProcletException
     */
    public static String setRespuestaEncGV(ProcletServiceData sd,
            String codOficina, String usuario, String gvCodEncuesta,
            String gvCodVersion,String encuesta,int cont) throws ProcletException {
        q53RespuestaBean respuestaBean = new q53RespuestaBean();
         PSP.paramProclet(sd,"id"+cont+"()");
         q53LogEstadisticas.printLog("El codigo oficina es: "+codOficina);
         q53LogEstadisticas.printLog("El codigo gvCodEncuesta es: "+gvCodEncuesta);
         q53LogEstadisticas.printLog("El codigo gvCodVersion es: "+gvCodVersion);
        
        // insert del registro respuesta...
        String select_cod_rpta = "SELECT SEQ_RESPUESTA.NEXTVAL COD_RESPUESTA FROM DUAL";
        String insert_rpta="";
        String cod_ofi_padre=q53Util.getPadreOficina(sd,codOficina);
        if(encuesta.equals("pres")){
        		insert_rpta = "INSERT INTO RESPUESTA"
            	+ " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_VERSION,M0_COD_OFI_PADRE)"
            	+ " VALUES (${preg_gv_cod_rpta.cod_respuesta}, '" + gvCodEncuesta + "', '" + gvCodVersion + "',"
            	+ " sysdate, '" + codOficina + "', '" + usuario + "', ${preg_gv_cod_rpta.cod_respuesta}, 0,'pres',2,'"+cod_ofi_padre+"')";
      
        }else{
        	insert_rpta = "INSERT INTO RESPUESTA"
            + " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_VERSION,M0_COD_OFI_PADRE)"
            + " VALUES (${preg_gv_cod_rpta.cod_respuesta}, '" + gvCodEncuesta + "', '" + gvCodVersion + "',"
            + " sysdate, '" + codOficina + "', '" + usuario + "', ${preg_gv_cod_rpta.cod_respuesta}, 0,'nopres',2,'"+cod_ofi_padre+"')";        
        }
        q53LogEstadisticas.printLog("INSERT DE LA TABLAPRES setRespuestaEncGV() <- preg_gv_cod_rpta=" + select_cod_rpta + ";=" + insert_rpta +" ->");
        PSP.sqlProclet(sd, "preg_gv_cod_rpta=" + select_cod_rpta + ";=" + insert_rpta);
        String codRespuesta = sd.gOS("preg_gv_cod_rpta.cod_respuesta");
        return codRespuesta;
    }
    
    /**
     * Mtod para insertar una nueva respuesta en la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina String que es el codigo de la oficina
     * @param usuario Strin que es el codigo del usuario que realiza la
     *        encuesta
     * @param codEncuestaOfi String que es el codigo de la encuesta propia de
     *        la oficina.
     * @param codVersionEncOfi String que es el codigo de la version de la
     *        encuesta propia de la oficina
     * @param respRDAsociada String que es el codigo de la respuesta Rd
     *        asociada
     *
     * @return
     *
     * @throws ProcletException
     */
    public static String setRespuestaEncOfi(ProcletServiceData sd,
            String codOficina, String usuario, String codEncuestaOfi,
            String codVersionEncOfi, String respRDAsociada,String encuesta)
            throws ProcletException {
    	q53LogEstadisticas.printLog("El codigo oficina es: "+codOficina);
    	q53LogEstadisticas.printLog("El codigo EncuestaOfi es: "+codEncuestaOfi);
    	q53LogEstadisticas.printLog("El codigo VersionEncOfi es: "+codVersionEncOfi);
        // insert del registro respuesta...
        String select_cod_rpta = "SELECT SEQ_RESPUESTA.NEXTVAL COD_RESPUESTA FROM DUAL";
        String cod_ofi_padre=q53Util.getPadreOficina(sd,codOficina);
        String selectEncuestados = "SELECT M0_PERSONAS AS PERSONAS"
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=0"
            + " AND M0_COD_VERSION=1"
            + " AND M0_COD_RESPUESTA=" + respRDAsociada;
        String insert_rpta = "INSERT INTO RESPUESTA"
        + " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_COD_OFI_PADRE)"
        + " VALUES (${preg_ofi_cod_rpta.cod_respuesta}, " + codEncuestaOfi + ", " + codVersionEncOfi + ","
        + " sysdate, '" + codOficina + "', " + usuario + ", ${respuesta_rd_asociada}, ${encuestados.personas},'"+encuesta+"','"+cod_ofi_padre+"')";
        q53LogEstadisticas.printLog("select_cod_rpta:::-" + select_cod_rpta+ "-");
        q53LogEstadisticas.printLog("insert_rpta:::-" + insert_rpta + "-");
        PSP.sqlProclet(sd, "preg_ofi_cod_rpta=" + select_cod_rpta + ";encuestados=" + selectEncuestados + ";=" + insert_rpta);
        q53LogEstadisticas.printLog("INSERT DE LA TABLAPRES setRespuestaEncOfi() <- preg_ofi_cod_rpta=" + select_cod_rpta + ";encuestados=" + selectEncuestados + ";=" + insert_rpta + "->");
        String codRespOfi = sd.gOS("preg_ofi_cod_rpta.cod_respuesta");
        return codRespOfi;
    }
    
    /**
     * Mtodo que nos devuelve los datos del numero de rspuestas y los codigos
     * de respuesrta mximo y mnimo de la lista de respuesta filtrada por
     * fechas en el caso de la encuesta del g.v. y sin filtrar en el caso dela
     * encuesta propia de la oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param fechaInicio String que es la fecha de inicio (rellenada por el
     *        usuario)
     * @param fechaFin String ue es la fecha de fin (rellenada por el usuario)
     * @param codEncuesta String que es el codigo de la encuesta propia de la
     *        oficina.
     * @param codVersion String que es el codigo de la version de la encuesta
     *        propia de la oficina
     * @param codOficina String que es el codigo de la oficina (para el caso de
     *        la encuesta propia de la oficina)
     *
     * @return q53RespuestaBean objeto que contiene los datos
     *
     * @throws ProcletException
     */
    public static q53RespuestaBean getRespuestasDataFilterByDate(
            ProcletServiceData sd, String fechaInicio, String fechaFin,
            String codEncuesta, String codVersion, String codOficina)
            throws ProcletException {
        q53RespuestaBean respuestBean = null;
        
        String select_resp = "resp[]=SELECT COUNT(M0_COD_RESPUESTA) COUNT_COD_RESPUESTA,"
            + " MIN(M0_COD_RESPUESTA) MIN_COD_RESPUESTA, MAX(M0_COD_RESPUESTA) MAX_COD_RESPUESTA "
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=" + codEncuesta 
            + " AND M0_COD_VERSION=" + codVersion;
        if ((codOficina != null) && !codOficina.equals("")) {
            select_resp += " AND M0_COD_OFICINA='" + codOficina + "'";
        }
        if (fechaInicio.equals("") && fechaFin.equals("")) {
        // nada, se queda como esta
        } else {
            select_resp += " AND m0_fecha BETWEEN TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')"
                + " AND TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS')";
        }
        select_resp += " ORDER BY M0_COD_RESPUESTA";
        PSP.sqlProclet(sd, select_resp);
        int numRespOfi = sd.gI("resp[0].count_cod_respuesta");
        if (numRespOfi > 0) {
            respuestBean = new q53RespuestaBean();
            respuestBean.setNumRespuestas(numRespOfi);
            respuestBean.setCodEncuesta(codEncuesta);
            respuestBean.setCodOficina(codOficina);
            respuestBean.setMaxCodRespuesta(sd.gOS("resp[0].max_cod_respuesta"));
            respuestBean.setMinCodRespuesta(sd.gOS("resp[0].min_cod_respuesta"));
        }
        return respuestBean;
    }

    /**
     * Metodo para recorer las respuestas de la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param preguntasList Lista de objetos q53PreguntaBean con los datos de
     *        las pregutnas de la encuesta
     * @param cod_respuesta String codigo de la respuesta
     *
     * @return List objeto con la lista de objetos q53RespuestaBean con los
     *         datos de las respuestas
     *
     * @throws ProcletException
     */
    public static List recorrerPreguntasRespuesta(ProcletServiceData sd,
            List preguntasList, String cod_respuesta) throws ProcletException {
        List respuestasList = new ArrayList();
        
        int numPregs = preguntasList.size();
        
        for (int i = 0; i < numPregs; i++) {
            q53RespuestaBean respuestabean = new q53RespuestaBean();
            String fechaCreacion = getDateCreationEnc(sd, cod_respuesta);
            respuestabean.setFechaCreacionRespuesta(fechaCreacion);
            
            q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
            String tipo_pregunta = preguntaBean.getTipoPregunta();
            
            if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                q53RespuestaOpcionesBean resOpcionesBean = cogerPreguntaRespuestaOpciones(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setOpcionesBean(resOpcionesBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                q53RespuestaTextoBean respTextoBean = cogerPreguntaRespuestaTexto(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setTextoBean(respTextoBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                List respProcedenciaList = cogerPreguntaRespuestaProcedencia(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setProcedenciaList(respProcedenciaList);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                q53RespuestaFechaBean respFecha = cogerPreguntaRespuestaFecha(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setFechaBean(respFecha);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                q53RespuestaGruposBean respGrupoBean = cogerPreguntaRespuestaGrupos(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setGruposBean(respGrupoBean);
            }
            
            respuestasList.add(respuestabean);
        }
        
        return respuestasList;
    }
    
    /**
     * Mtodo que nos devuelve la fecha de creacin dela respuesta
     *
     * @param sd el onjeto ProcletServiceData
     * @param codRespuesta String con el cdigo de respuesta
     *
     * @return
     *
     * @throws ProcletException
     */
    private static String getDateCreationEnc(ProcletServiceData sd,
            String codRespuesta) throws ProcletException {
        String selectDate = "selectDate[]=SELECT M0_FECHA FROM RESPUESTA WHERE M0_COD_RESPUESTA=" + codRespuesta;
        PSP.sqlProclet(sd, selectDate);
        String fechaCreacion = sd.gOS("selectDate[0].m0_fecha");
        return fechaCreacion;
    }
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo opciones
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaOpcionesBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaOpcionesBean cogerPreguntaRespuestaOpciones(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs+"_"+i+"[]=SELECT N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION, NVL(M2_COD_OPCION, -1) M2_COD_OPCION"
            + " FROM RESP_OPCIONES, PR_OPS_OPCION, PR_OPCIONES"
            + " WHERE N3_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M2_COD_RESPUESTA(+)=" + cod_respuesta
            + " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA"
            + " AND N3_COD_PREGUNTA=M2_COD_PREGUNTA(+)"
            + " AND N3_COD_OPCION=M2_COD_OPCION(+)"
            + " ORDER BY N3_ORDEN;";

        // nota: si la opcin no est en la respuesta, en pregs_i[j].m2_cod_opcion
        // habr un "-". si est en la respuesta tendr el cdigo de la opcion.
        PSP.sqlProclet(sd, select_preg);

        int numOpcion = sd.gI("pregs_" + i + ".length");
        List opcionResList = new ArrayList();
        for (int j = 0; j < numOpcion; j++) {
            String respFormato = sd.gOS("pregs_" + i + "[" + j + "].n2_formato");
            String codOpcion = sd.gOS("pregs_" + i + "[" + j + "].n3_cod_opcion");
            String descOpcion = sd.gOS("pregs_" + i + "[" + j + "].n3_descripcion");
            int valueOpcion = sd.gI("pregs_" + i + "[" + j + "].m2_cod_opcion");
            q53OpcionBean opcionBean = new q53OpcionBean();
            opcionBean.setCodOpciones(codOpcion);
            opcionBean.setDescipcionOpcion(descOpcion);
            opcionBean.setValueOpcion(valueOpcion);
            opcionResList.add(opcionBean);
        }

        q53RespuestaOpcionesBean resOpcionesBean = new q53RespuestaOpcionesBean();
        resOpcionesBean.setCodOpciones(opcionResList);
        resOpcionesBean.setFormato(sd.gOS("pregs[0].n2_formato"));

        return resOpcionesBean;
    }
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo texto
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaTextoBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaTextoBean cogerPreguntaRespuestaTexto(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs + "_" + i + "[]=SELECT M4_TEXTO"
            + " FROM RESP_TEXTO"
            + " WHERE M4_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M4_COD_RESPUESTA=" + cod_respuesta + ";";
        PSP.sqlProclet(sd, select_preg);

        String respTexto = sd.gOS("pregs_" + i + "[0].m4_texto");
        q53RespuestaTextoBean respTextoBean = new q53RespuestaTextoBean();
        respTextoBean.setTextoRespuesta(respTexto);

        return respTextoBean;
    }
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo procedencia
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaProcedenciaBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static List cogerPreguntaRespuestaProcedencia(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
       
        List procedenciaList = new ArrayList();
        for(int j=1;j<5;j++){
            int k=j-1;
             String select_pregs = pregs + "_" + i + "[]=SELECT M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
                + " M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
                + " P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS "
                + " FROM MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA"
                + " WHERE M5_COD_PREGUNTA=" + preguntaBean.getCodPregunta() 
                + " AND M5_COD_RESPUESTA=" + cod_respuesta
                + " AND M5_COD_PROCEDENCIA="+j
                + " AND M5_COD_PAIS = P0_COD_PAIS(+)"
                + " AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
                + " AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+)"
                + " AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
                + " AND M5_COD_COMARCA=P4_COD_COMARCA(+);";
            PSP.sqlProclet(sd, select_pregs);
            boolean local = false;

            if (sd.gOS("pregs_" + i + "[0].m5_local").equals("S")) {
                local = true;
            }

            q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
            respProcedenciaBean.setCodComunidad(sd.gOS("pregs_" + i + "[0].m5_cod_comunidad"));
            respProcedenciaBean.setCodComarca(sd.gOS("pregs_" + i + "[0].m5_cod_comarca"));
            respProcedenciaBean.setCodMunicipio(sd.gOS("pregs_" + i + "[0].m5_cod_municipio"));
            respProcedenciaBean.setCodPais(sd.gOS("pregs_" + i + "[0].m5_cod_pais"));
            respProcedenciaBean.setcLocal(sd.gOS("pregs_" + i + "[0].m5_local"));
            respProcedenciaBean.setcPos(sd.gOS("pregs_" + i + "[0].m5_cpos"));
            respProcedenciaBean.setCodTerritorio(sd.gOS("pregs_" + i + "[0].m5_cod_territorio"));
            respProcedenciaBean.setComunidadNameCas(sd.gOS("pregs_" + i + "[0].p1_nombre_cas"));
            respProcedenciaBean.setComunidadNameEus(sd.gOS("pregs_" + i + "[0].p1_nombre_eus"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("pregs_" + i + "[0].p3_nombre_cas"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("pregs_" + i + "[0].p3_nombre_eus"));
            respProcedenciaBean.setPaisNameCas(sd.gOS("pregs_" + i + "[0].p0_nombre_cas"));
            respProcedenciaBean.setPaisNameEus(sd.gOS("pregs_" + i + "[0].p0_nombre_eus"));
            respProcedenciaBean.setTerritorioNameCas(sd.gOS("pregs_" + i + "[0].p2_nombre_cas"));
            respProcedenciaBean.setTerritorioNameEus(sd.gOS("pregs_" + i + "[0].p2_nombre_eus"));
            respProcedenciaBean.setComarcaNameCas(sd.gOS("pregs_" + i + "[0].p4_nombre_cas"));
            respProcedenciaBean.setComarcaNameEus(sd.gOS("pregs_" + i + "[0].p4_nombre_eus"));
            
            if(sd.gOS("pregs_" + i + "[0].m5_num_personas") != null && !(sd.gOS("pregs_" + i + "[0].m5_num_personas").equals(""))){
                respProcedenciaBean.setNumPersonas(sd.gI("pregs_" + i + "[0].m5_num_personas"));
            }else{
                respProcedenciaBean.setNumPersonas(0);
            }
            procedenciaList.add(respProcedenciaBean);
        }

        return procedenciaList;
    }


    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo fecha
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaFechaBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaFechaBean cogerPreguntaRespuestaFecha(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String formato = q53Constantes.FORMATO_FECHA_HORA_CAS; // por defecto en castellano

        if (sd.gOS("q53_cki.q53_idioma").equals(q53Constantes.IDIOMA_EUS)) {
            formato = q53Constantes.FORMATO_FECHA_HORA_EUS;
        }

        String select_preg = pregs + "_" + i + "[]=SELECT TO_CHAR(M6_FECHA,'" + formato + "') M6_FECHA,M6_HORA,TO_CHAR(M6_FECHA_RESPUESTA,'" + formato + "') M6_FECHA_RESPUESTA"
            + " FROM RESP_FECHA"
            + " WHERE M6_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M6_COD_RESPUESTA=" + cod_respuesta + ";";
        PSP.sqlProclet(sd, select_preg);

        String fechaResp = sd.gOS("pregs_" + i + "[0].m6_fecha");
        String fechaResp_RESP = sd.gOS("pregs_" + i + "[0].m6_fecha_respuesta");
        int horaResp = 0;

        if ((sd.gOS("pregs_" + i + "[0].m6_hora") != null) && !sd.gOS("pregs_" + i + "[0].m6_hora").equals("")) {
            horaResp = sd.gI("pregs_" + i + "[0].m6_hora");
        }

        q53RespuestaFechaBean respfechaBean = new q53RespuestaFechaBean();
        respfechaBean.setFecha(fechaResp);
        respfechaBean.setHora(horaResp);
        respfechaBean.setFecha_resp(fechaResp_RESP);

        return respfechaBean;
    }

    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo grupos
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaGruposBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaGruposBean cogerPreguntaRespuestaGrupos(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs + "_" + i + "[]=SELECT N7_TIPO, N8_COD_GRUPO, N8_DESCRIPCION, NVL(N9_COD_GRUPO, -1) N9_COD_GRUPO,"
            + " NVL(N9_HOMBRES, -1) N9_HOMBRES, NVL(N9_MUJERES, -1) N9_MUJERES, N8_TAMANO"
            + " FROM RESP_GRUPOS, PR_GRPS_GRUPO, PR_GRUPOS"
            + " WHERE N8_COD_PREGUNTA=" + preguntaBean.getCodPregunta() 
            + " AND N9_COD_RESPUESTA(+)=" + cod_respuesta 
            + " AND N8_COD_PREGUNTA=N7_COD_PREGUNTA"
            + " AND N8_COD_PREGUNTA=N9_COD_PREGUNTA(+)"
            + " AND N8_COD_GRUPO=N9_COD_GRUPO(+)"
            + " ORDER BY N8_ORDEN;";
        PSP.sqlProclet(sd, select_preg);

        int numResp = sd.gI("pregs_" + i + ".length");
        List grupoRespList = new ArrayList();

        for (int j = 0; j < numResp; j++) {
            String codGrupo = sd.gOS("pregs_" + i + "[" + j + "].n8_cod_grupo");
            String descGrupo = sd.gOS("pregs_" + i + "[" + j + "].n8_descripcion");
            int valueCodGrupo = sd.gI("pregs_" + i + "[" + j + "].n9_cod_grupo");
            int numHombres = sd.gI("pregs_" + i + "[" + j + "].n9_hombres");
            int numMujeres = sd.gI("pregs_" + i + "[" + j + "].n9_mujeres");
            int tamano = sd.gI("pregs_" + i + "[" + j + "].n8_tamano");

            q53RespuestaGrupoBean respGrupoBean = new q53RespuestaGrupoBean();
            respGrupoBean.setCodOpcion(codGrupo);
            respGrupoBean.setNumHombres(numHombres);
            respGrupoBean.setNumMujeres(numMujeres);
            respGrupoBean.setTamano(tamano);
            respGrupoBean.setValueCodGrupo(valueCodGrupo);
            grupoRespList.add(respGrupoBean);
        }

        q53RespuestaGruposBean resGruposBean = new q53RespuestaGruposBean();
        resGruposBean.setGrupoList(grupoRespList);
        resGruposBean.setTipoGrupo(sd.gOS("pregs_" + i + "[0].n7_tipo"));

        return resGruposBean;
    }
    
    /**
     * Metodo para calcular el numero de respuestas a la encuesta durante un
     * periodo de tiempo
     *
     * @param sd el objeto ProcletServiceData
     * @param cod_respuesta String codigo de la respuesta
     * @param fechaInicio String fecha inicio del periodo
     * @param fechaFin String fecha fin del periodo
     * @param codOficina String codigo dela oficina
     * @param codEncuesta String que es el cdigo de la encuesta
     * @param codVersion String que es el cdigo de la version de la encuesta
     *
     * @return String Numero de respuestas a la encuesta en ese periodo de
     *         tiempo
     *
     * @throws ProcletException
     */
    public static String calcularNumRespuesta(ProcletServiceData sd,
            String cod_respuesta, String fechaInicio, String fechaFin,
            String codOficina, String codEncuesta, String codVersion)
            throws ProcletException {
        String num_respuesta = "";

        String select = "num_resp[]=SELECT NVL(COUNT(M0_COD_RESPUESTA),0) NUM_RESPUESTA"
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=" + codEncuesta
            + " AND M0_COD_VERSION=" + codVersion
            + " AND M0_COD_RESPUESTA<" + cod_respuesta;
        if (!fechaInicio.equals("") && !fechaFin.equals("")) {
            select += " AND respuesta.m0_fecha BETWEEN TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')"
                + " AND TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS')";
        }

        if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            select += " AND M0_COD_OFICINA = '" + codOficina + "'";
        }

        select += ";";
        PSP.sqlProclet(sd, select);
        num_respuesta = "" + (sd.gI("num_resp[0].num_respuesta") + 1);

        return num_respuesta;
    }
    
    /**
     * Metodo para calcular el codigo de respuesta que se va a mostrar por
     * panatalla (Paginacion)
     *
     * @param sd el objeto ProcletServiceData
     * @param respuestaBean q53RespuestaBean objeo que contiene los datos de la
     *        respuesta que se esta mostrando actualmente
     * @param fechaInicio String fecha inicio del periodo
     * @param fechaFin String fecha fin del periodo
     * @param codRespuesta String codigo de respuesta
     * @param codVersion String que es el cdigo de a version de la encuesta
     *
     * @return String Codigo de la respuesta que debe aparecer
     *
     * @throws ProcletException
     */
    public static String calcularCodRespuesta(ProcletServiceData sd,
            q53RespuestaBean respuestaBean, String fechaInicio, String fechaFin,
            String codRespuesta, String codVersion) throws ProcletException {
        String cod_respuesta = "";

        if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA) ||
                codRespuesta.equals("")) {
            // accion es primero o cod_respuesta no viene como parmetro. se coge el cdigo mnimo de
            // las respuestas
            cod_respuesta = respuestaBean.getMinCodRespuesta();
        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
            // accion es anterior. Se coge el max(cod_respuesta) que sea menor
            // que el cod_respuesta actual. Si es null, se devuelve el mismo
            // cod_respuesta
            String select = "cod_resp[] = SELECT NVL(MAX(M0_COD_RESPUESTA)," + codRespuesta + ") COD_RESPUESTA"
                + " FROM RESPUESTA"
                + " WHERE M0_COD_ENCUESTA=" + respuestaBean.getCodEncuesta() 
                + " AND M0_COD_VERSION=" + codVersion
                + " AND M0_COD_RESPUESTA<" + codRespuesta;
            if (!fechaInicio.equals("") && !fechaFin.equals("")) {
                select += " AND respuesta.m0_fecha BETWEEN TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')"
                     + "AND TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS') ";
            }
            if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                select += " AND M0_COD_OFICINA = '" + respuestaBean.getCodOficina() + "'";
            }
            select += ";";
            PSP.sqlProclet(sd, select);
            cod_respuesta = sd.gOS("cod_resp[0].cod_respuesta");

        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
            // accion es siguiente. Se coge el min(cod_respuesta) que sea mayor
            // que el cod_respuesta actual. Si es null, se devuelve el mismo
            // cod_respuesta
            String select = "cod_resp[]=SELECT NVL(MIN(M0_COD_RESPUESTA)," + codRespuesta + ") COD_RESPUESTA"
                + " FROM RESPUESTA"
                + " WHERE M0_COD_ENCUESTA=" + respuestaBean.getCodEncuesta()
                + " AND M0_COD_VERSION=" + codVersion 
                + " AND M0_COD_RESPUESTA>" + codRespuesta;
            if (!fechaInicio.equals("") && !fechaFin.equals("")) {
                select += " AND respuesta.m0_fecha BETWEEN TO_DATE ('" + fechaInicio + "','DD/MM/YYYY HH24:MI:SS')"
                    + " AND TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS') ";
            }
            if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
                select += " AND M0_COD_OFICINA = '" + respuestaBean.getCodOficina() + "'";
            }
            select += ";";
            PSP.sqlProclet(sd, select);
            cod_respuesta = sd.gOS("cod_resp[0].cod_respuesta");
        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
            cod_respuesta = respuestaBean.getMaxCodRespuesta();
        } else {
            // cod_respuesta viene como parmetro y no hay accion
            cod_respuesta = sd.gOS("cod_respuesta");
        }
        
        return cod_respuesta;
    }
    
    
    public  List getOpcionesaMostrar(ProcletServiceData sd, String codPregunta,String idioma){
			List opciones = new ArrayList();
			q53LogEstadisticas.printLog("Recuperando codigos");
			if(codPregunta!= null && codPregunta.equals("")){
				return opciones;	
			}
			try{
				int cod=Integer.parseInt(codPregunta);
			}catch(NumberFormatException ex){
				return opciones;	
			}
			String select="";
			if(idioma.equals(q53Constantes.IDIOMA_CAS)){
				select = "SELECT PR_OPS_OPCION.N3_COD_OPCION,PR_OPS_OPCION.N3_DESCRIPCION FROM PR_OPS_OPCION WHERE PR_OPS_OPCION.N3_COD_PREGUNTA="+codPregunta
								+" ORDER BY PR_OPS_OPCION.N3_COD_OPCION";  
			}else{
				select="SELECT DISTINCT(PR_OPS_OPCION.N3_COD_OPCION),LITERAL.ZZ_EUSK AS N3_DESCRIPCION FROM "
								+" LITERAL,PR_OPS_OPCION"
								+" WHERE"
								+" LITERAL.ZZ_CODIGO  LIKE 'N3_'||PR_OPS_OPCION.N3_COD_PREGUNTA||'_'||PR_OPS_OPCION.N3_COD_OPCION"
								+" AND PR_OPS_OPCION.N3_COD_PREGUNTA="+codPregunta
								+" ORDER BY PR_OPS_OPCION.N3_COD_OPCION";
			}
			try{									
			q53LogEstadisticas.printLog("opciones[]=<"+ select + ">");										
			PSP.sqlProclet(sd, "opciones[]="+ select);
			if (sd.gI("opciones.length") > 0) {
				int lon=sd.gI("opciones.length");
				for(int i=0;i<lon;i++){
					q53LogEstadisticas.printLog("contador <"+ i + ">");										
					String codOpcion=sd.gOS("opciones[" + i + "].n3_cod_opcion");
					q53LogEstadisticas.printLog("codigo de opcion:<"+ codOpcion + ">");										
					String descOpcion=sd.gOS("opciones[" + i + "].n3_descripcion");
					q53LogEstadisticas.printLog("descripcion de opcion: <"+ descOpcion + ">");										
					q53OpcionBean opcionBean = new q53OpcionBean();
					opcionBean.setCodOpciones(codOpcion);
					opcionBean.setDescipcionOpcion(descOpcion);
					opciones.add(opcionBean);										
				}
			}
			}catch(Exception ex){
				q53LogEstadisticas.printLog("Excepcion:::"+ex.getMessage());											
			}
			q53LogEstadisticas.printLog("Finalizado");										
			return opciones;								
		}
		
	public static void guardarLineaEncTemp(ProcletServiceData sd,
            String encuesta,int cont) throws ProcletException {
        
         //PSP.paramProclet(sd,"id"+cont+"(),fech_0_dia_"+cont+"()");

        // insert del registro respuesta...
       	String id=sd.gOS("id"+cont);
        q53LogEstadisticas.printLog("sd.gOS(id+cont): ->" + sd.gOS("id"+cont) + "<-");
       	int numTipo=sd.gI("numTipo");
        q53LogEstadisticas.printLog("sd.gI(numTipo): ->" + sd.gI("numTipo")+ "<-");
      	int numEncActiv=sd.gI("numEncActiv");
        q53LogEstadisticas.printLog("gI(numEncActiv): ->" + sd.gI("numEncActiv")+ "<-");
        String insert_rpta="";
        String dia_fecha =(new Integer(sd.gI("fech_0_dia_"+cont))).toString();
        q53LogEstadisticas.printLog("dia_fecha: ->" + dia_fecha+ "<-");
        String mes_fecha=(new Integer(sd.gI("fech_0_mes_"+cont))).toString();
        q53LogEstadisticas.printLog("mes_fecha: ->" + mes_fecha+ "<-");
        String anio_fecha=(new Integer(sd.gI("fech_0_anio_"+cont))).toString();
        q53LogEstadisticas.printLog("anio_fecha: ->" + anio_fecha+ "<-");
        String hora_fecha=(new Integer(sd.gI("fech_0_hora_"+cont))).toString();
        q53LogEstadisticas.printLog("hora_fecha: ->" + hora_fecha+ "<-");
        
        String opt_local="";
        q53LogEstadisticas.printLog("opt_local: ->" + opt_local+ "<-");
        String cposProc="0";
        q53LogEstadisticas.printLog("cposProc: ->" + cposProc+ "<-");
        String proc_pais_6="";
        q53LogEstadisticas.printLog("proc_pais_6: ->" + proc_pais_6+ "<-");
        
        String opt_check_8="";
        q53LogEstadisticas.printLog("opt_check_8: ->" + opt_check_8+ "<-");
        String opt_12="";
        q53LogEstadisticas.printLog("opt_12: ->" + opt_12+ "<-");
        String cod_usu="";
        
        
        String cadena="";
        
      	if(!sd.gOS("opt_local"+cont).equals("")){
      		opt_local=sd.gOS("opt_local"+cont);
      	}
        q53LogEstadisticas.printLog("opt_local: ->" + opt_local+ "<-");
      	if(!sd.gOS("cposProc"+cont).equals("")){
      		cposProc=sd.gOS("cposProc"+cont);
      	}
        q53LogEstadisticas.printLog("cposProc: ->" + cposProc+ "<-");
      	if(sd.gOS("proc_pais_6_"+cont)!=null){
      		proc_pais_6=sd.gOS("proc_pais_6_"+cont);
      	}
        q53LogEstadisticas.printLog("proc_pais_6: ->" + proc_pais_6+ "<-");
       	
      	if(!sd.gOS("opt_check_8"+cont).equals("")){
      		opt_check_8=sd.gOS("opt_check_8"+cont);
      	}
        q53LogEstadisticas.printLog("opt_check_8: ->" + opt_check_8+ "<-");
     	if(!sd.gOS("opt_12"+cont).equals("")){
      		opt_12=sd.gOS("opt_12"+cont);
      	}
        q53LogEstadisticas.printLog("opt_12: ->" + opt_12+ "<-");
      	if(!sd.gOS("cod_usu").equals("")){
      		cod_usu=sd.gOS("cod_usu");
      	}
      	//recuperacion de los datos sobre la encuesta activada
      	if(numEncActiv!=0){
          		int j=1;
          		while(j<numTipo+1){
          			int codPregunta=0;
          			int numOpciones=0;
          			if(sd.gI("numOpciones"+j)!=0){
          			codPregunta=sd.gI("codPregunta"+j);
          			numOpciones=sd.gI("numOpciones"+j);
          			if (numOpciones!=0 && numOpciones<10){
          				String numeroIndice=Integer.toString(numOpciones).substring(0,1);
          				if(!numeroIndice.equals("")){
            				numOpciones=Integer.parseInt(numeroIndice);
            				for(int w=0;w<numOpciones;w++){
            					if(!sd.gOS("opt_check_a"+codPregunta+w+cont).equals("")){
            						cadena+=" , "+sd.gOS("opt_check_a"+codPregunta+w+cont);
            						q53LogEstadisticas.printLog("check: "+sd.gOS("opt_check_a"+codPregunta+w+cont));
            					}
            				}
          				}
          			}else if(numOpciones!=0){
          				String numeroIndice=Integer.toString(numOpciones).substring(0,2);
          				if(!numeroIndice.equals("")){
            				numOpciones=Integer.parseInt(numeroIndice);
            				for(int w=0;w<numOpciones;w++){
            					if(!sd.gOS("opt_check_a"+codPregunta+w+cont).equals("")){
            						cadena+=" , "+sd.gOS("opt_check_a"+codPregunta+w+cont);
            						q53LogEstadisticas.printLog("check: "+sd.gOS("opt_check_a"+codPregunta+w+cont));
            					}
            				}
          				}
          			}
          			if(!sd.gOS("opt_check_"+codPregunta+cont).equals("")){
          				cadena+=" , "+sd.gOS("opt_check_"+codPregunta+cont);
          				q53LogEstadisticas.printLog("opt_check_: "+sd.gOS("opt_check_"+codPregunta+cont));
          			}
          			if(!sd.gOS("opt_"+codPregunta+cont).equals("")){
          				cadena+=" , "+sd.gOS("opt_"+codPregunta+cont);
          				q53LogEstadisticas.printLog("opt: "+sd.gOS("opt_"+codPregunta+cont));
          			}
          			if(!sd.gOS("txt_"+codPregunta+cont).equals("")){
          				cadena+=" , "+sd.gOS("txt_"+codPregunta+cont);
          				q53LogEstadisticas.printLog("txt: "+sd.gOS("txt_"+codPregunta+cont));
          			}
           			if(!sd.gOS("fech_"+codPregunta+"_dia_"+cont).equals("")){
          				cadena+=" , "+sd.gOS("fech_"+codPregunta+"_dia_"+cont);
          				q53LogEstadisticas.printLog("dia: "+sd.gOS("fech_"+codPregunta+"_dia_"+cont));
          			}
          			if(!sd.gOS("fech_"+codPregunta+"_mes_"+cont).equals("")){
          				cadena+=" , "+sd.gOS("fech_"+codPregunta+"_mes_"+cont);
          				q53LogEstadisticas.printLog("mes: "+sd.gOS("fech_"+codPregunta+"_mes_"+cont));
          			}
          			if(!sd.gOS("fech_"+codPregunta+"_anio_"+cont).equals("")){
          				cadena+=" , "+sd.gOS("fech_"+codPregunta+"_anio_"+cont);
          				q53LogEstadisticas.printLog("anio: "+sd.gOS("fech_"+codPregunta+"_anio_"+cont));
          			}
          			j++;
          		}
          	}
	    }
      	
      	
      	
        q53LogEstadisticas.printLog("encuesta: ->" + encuesta+ "<-");
        if(encuesta.equals("pres")){      	
        	int totvis=0;
	        int grp_2_2_1=0;
	        int grp_2_2_2=0;
	        int grp_5_4_1=0;
	        int grp_5_4_2=0;
	        int grp_5_4_3=0;
	        int grp_5_4_4=0;
	        int totalpersonasproc=0;
			q53LogEstadisticas.printLog("totalpersonasproc: ->" + totalpersonasproc+ "<-");
	        String opt_check_7="";
        	if(!sd.gOS("totvis"+cont).equals("")){
        		totvis=sd.gI("totvis"+cont);
	        }
			q53LogEstadisticas.printLog("totvis: ->" + totvis+ "<-");
	        if(!sd.gOS("grp_2_2_1"+cont).equals("")){
	        	grp_2_2_1=Integer.valueOf(sd.gOS("grp_2_2_1"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_2_2_1: ->" + grp_2_2_1+ "<-");
	      	if(!sd.gOS("grp_2_2_2"+cont).equals("")){
	      		grp_2_2_2=Integer.valueOf(sd.gOS("grp_2_2_2"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_2_2_2: ->" + grp_2_2_2+ "<-");
	        if(!sd.gOS("grp_5_4_1"+cont).equals("")){
	      		grp_5_4_1=Integer.valueOf(sd.gOS("grp_5_4_1"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_5_4_1: ->" + grp_5_4_1+ "<-");
	        if(!sd.gOS("grp_5_4_2"+cont).equals("")){
	      		grp_5_4_2=Integer.valueOf(sd.gOS("grp_5_4_2"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_5_4_2: ->" + grp_5_4_2+ "<-");
	        if(!sd.gOS("grp_5_4_3"+cont).equals("")){
	      		grp_5_4_3=Integer.valueOf(sd.gOS("grp_5_4_3"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_5_4_3: ->" + grp_5_4_3+ "<-");
	        if(!sd.gOS("grp_5_4_4"+cont).equals("")){
	      		grp_5_4_4=Integer.valueOf(sd.gOS("grp_5_4_4"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("grp_5_4_4: ->" + grp_5_4_4+ "<-");
	      	if(!sd.gOS("totalPersonasProc"+cont).equals("")){
	      		totalpersonasproc=Integer.valueOf(sd.gOS("totalPersonasProc"+cont)).intValue();
	      	}
			q53LogEstadisticas.printLog("totalPersonasProc" +cont + " : ->" + sd.gOS("totalPersonasProc"+cont)+ "<-");
	        if(!sd.gOS("opt_check_7"+cont).equals("")){
	      		opt_check_7=sd.gOS("opt_check_7"+cont);
	      	}	
			q53LogEstadisticas.printLog("opt_check_7: ->" + opt_check_7+ "<-");
        	
        	
	        	HashMap mapapresencial=(HashMap)sd.req.getSession().getAttribute("mapapresencial");
	         if(mapapresencial==null)mapapresencial=new HashMap();  
        	boolean existe=mapapresencial.containsKey(id);
        	if(!existe){
				int numEnc = mapapresencial.size()+1;
				mapapresencial.put(id,String.valueOf(numEnc));
				sd.req.getSession(true).setAttribute("mapapresencial",mapapresencial);
				insert_rpta = "INSERT INTO PRESENCIAL"
					+ " (T1_ID,T1_FECH_0_DIA,T1_FECH_0_MES,T1_FECH_0_ANIO,T1_FECH_0_HORA,T1_TOTVIS,T1_GRP_2_2_1, T1_GRP_2_2_2,T1_GRP_5_4_1,T1_GRP_5_4_2,T1_GRP_5_4_3,T1_GRP_5_4_4,T1_TOTALPERSONASPROC,T1_OPT_LOCAL,T1_CPOSPROC,T1_PROC_PAIS_6,T1_OPT_CHECK_7,T1_OPT_CHECK_8, T1_VALORACION_ESTANCIA ,T1_COD_USUARIO";
				for(int i=1;i<numEncActiv+1;i++){
					insert_rpta += ",T1_ACTIVADA_"+i;
	           	 
				}
	       		insert_rpta += ")";
				insert_rpta += " VALUES ("+numEnc+",'"+dia_fecha+"','"+mes_fecha+"','"+anio_fecha+"',"
					+ "'"+hora_fecha+"', "+totvis+","+grp_2_2_1+","+grp_2_2_2+","+grp_5_4_1+","
					+grp_5_4_2+","+grp_5_4_3+","+grp_5_4_4+","+totalpersonasproc+",'"+opt_local+"','"+cposProc+"','"+proc_pais_6+"','"+opt_check_7+"','"+opt_check_8+"','"+opt_12 + "','"+cod_usu+"'";
				q53LogEstadisticas.printLog("numEncActiv: ->"+numEncActiv + "<-");
				q53LogEstadisticas.printLog("preparacin de insert_rpta: ->" + insert_rpta+ "<-");
				for(int i=1;i<numEncActiv+1;i++){
					insert_rpta += ",'"+cadena.split(",")[i]+"'";
	            }
	   			insert_rpta += ")";
				q53LogEstadisticas.printLog("resultado final insert_rpta: ->" + insert_rpta+ "<-");
	       	}else{
				String idtemp=mapapresencial.get(id).toString(); 
	       		insert_rpta = "UPDATE PRESENCIAL"
					+ " SET T1_FECH_0_DIA ="+dia_fecha+","
					+ " T1_FECH_0_MES="+mes_fecha+","
					+ " T1_FECH_0_ANIO="+anio_fecha+","
					+ " T1_FECH_0_HORA="+hora_fecha+","
					+ " T1_TOTVIS="+totvis+","
					+ " T1_GRP_2_2_1="+grp_2_2_1+","
					+ " T1_GRP_2_2_2="+grp_2_2_2+","
					+ " T1_GRP_5_4_1="+grp_5_4_1+","
					+ " T1_GRP_5_4_2="+grp_5_4_2+","
					+ " T1_GRP_5_4_3="+grp_5_4_3+","
					+ " T1_GRP_5_4_4="+grp_5_4_4+","
					+ " T1_TOTALPERSONASPROC="+totalpersonasproc+","
					+ " T1_OPT_LOCAL='"+opt_local+"',"
					+ " T1_CPOSPROC="+cposProc+","
					+ " T1_PROC_PAIS_6="+proc_pais_6+","
					+ " T1_OPT_CHECK_7='"+opt_check_7+"',"
					+ " T1_VALORACION_ESTANCIA='"+opt_12+"',"
					+ " T1_OPT_CHECK_8='"+opt_check_8+"'";
				for(int i=1;i<numEncActiv+1;i++){
					insert_rpta += ",T1_ACTIVADA_"+i+"='"+cadena.split(",")[i]+"'";
	           	}
				insert_rpta += " WHERE T1_ID = "+idtemp+" AND T1_COD_USUARIO='"+cod_usu+"' ;";
				q53LogEstadisticas.printLog("insert_rpta: ->" + insert_rpta+ "<-");
       		}
	       	PSP.sqlProclet(sd, "=" + insert_rpta+";");
       		q53LogEstadisticas.printLog("Existe"+id+":"+existe);
       		q53LogEstadisticas.printLog("mpresencial "+mapapresencial.toString());
        }else{ 
        	int opt_3=(Integer.valueOf(sd.gOS("opt_3"+cont))).intValue();
			String chkhabilitar="";
			String dia2_fecha="0";
			String mes2_fecha="0";
			String anio2_fecha="0";
			String txt="";
			int opt_9=0;
			if(!sd.gOS("chkHabilitar"+cont).equals("")){
				chkhabilitar=sd.gOS("chkHabilitar"+cont);
			}
			if(!sd.gOS("fech_10_dia2_"+cont).equals("")){
				dia2_fecha=sd.gOS("fech_10_dia2_"+cont);
			}
			if(!sd.gOS("fech_10_mes2_"+cont).equals("")){
				mes2_fecha=sd.gOS("fech_10_mes2_"+cont);
			}
			if(!sd.gOS("fech_10_anio2_"+cont).equals("")){
				anio2_fecha=sd.gOS("fech_10_anio2_"+cont);
			}
			opt_9=(Integer.valueOf(sd.gOS("opt_9"+cont))).intValue();
			if(!sd.gOS("txt_"+cont).equals("")){
				txt=sd.gOS("txt_"+cont);
			}
     	
		    HashMap mapanopresencial=(HashMap)sd.req.getSession().getAttribute("mapanopresencial");
		    if(mapanopresencial==null)mapanopresencial=new HashMap();        		
			boolean existe=mapanopresencial.containsKey(id);
        	if(!existe){
				int numEnc =mapanopresencial.size()+1;
				mapanopresencial.put(id,String.valueOf(numEnc));
				sd.req.getSession().setAttribute("mapanopresencial",mapanopresencial);
				insert_rpta = "INSERT INTO NO_PRESENCIAL"
					+ " (T2_ID,T2_FECH_0_DIA,T2_FECH_0_MES,T2_FECH_0_ANIO,T2_FECH_0_HORA,T2_OPT_3,T2_CHKHABILITAR,T2_FECH_10_DIA, T2_FECH_10_MES,T2_FECH_10_ANIO,T2_OPT_9,T2_OPT_LOCAL,T2_CPOSPROC,T2_PROC_PAIS_6,T2_OPT_CHECK_8,T2_TXT,T2_COD_USUARIO";
				for(int i=1;i<numEncActiv+1;i++){
					insert_rpta += ",T2_ACTIVADA_"+i;
					q53LogEstadisticas.printLog("T2_ACTIVADA_"+i);
				}
				insert_rpta += ")";
				insert_rpta += " VALUES ("+numEnc+", '"+dia_fecha+"','"+mes_fecha+"','"+anio_fecha+"','"+hora_fecha+"',"
					+ " "+opt_3+", '"+chkhabilitar+"', '"+dia2_fecha+"','"+mes2_fecha+"','"+anio2_fecha+"' , "+opt_9+",'"+opt_local+"','"+cposProc+"','"+proc_pais_6+"','"+opt_check_8+"','"+txt+"','"+cod_usu+"'";
				for(int i=1;i<numEncActiv+1;i++){
					insert_rpta += ",'"+cadena.split(",")[i]+"'";
	           	}
	      		insert_rpta += ")";
			}else{
				String idtemp=mapanopresencial.get(id).toString();  
				insert_rpta = "UPDATE NO_PRESENCIAL"
					+ " SET T2_FECH_0_DIA ="+dia_fecha+","
					+ " T2_FECH_0_MES="+mes_fecha+","
					+ " T2_FECH_0_ANIO="+anio_fecha+","
					+ " T2_OPT_3="+opt_3+","
					+ " T2_CHKHABILITAR='"+chkhabilitar+"',"
					+ " T2_FECH_10_DIA="+dia2_fecha+","
					+ " T2_FECH_10_MES="+mes2_fecha+","
					+ " T2_FECH_10_ANIO="+anio2_fecha+","
					+ " T2_OPT_9="+opt_9+","
					+ " T2_OPT_LOCAL='"+opt_local+"',"
					+ " T2_CPOSPROC="+cposProc+","
					+ " T2_PROC_PAIS_6="+proc_pais_6+","
					+ " T2_OPT_CHECK_8='"+opt_check_8+"',"
					+ " T2_TXT='"+txt+"'";
				for(int i=1;i<numEncActiv+1;i++){
	           	 	insert_rpta += ",T2_ACTIVADA_"+i+"='"+cadena.split(",")[i]+"'";
	           	}
            	insert_rpta += " WHERE T2_ID = "+idtemp+" AND T2_COD_USUARIO='"+cod_usu+"' ;";
            }
	        PSP.sqlProclet(sd, "=" + insert_rpta+";");
			q53LogEstadisticas.printLog("mpresencial"+mapanopresencial.toString());  
		}
        
    }
}

