package itourbaskClases;

import itourbaskBeans.q53NotificacionBean;
import itourbaskBeans.q53OpcionBean;
import itourbaskBeans.q53PreguntaBean;
import itourbaskBeans.q53RespuestaBean;
import itourbaskBeans.q53RespuestaFechaBean;
import itourbaskBeans.q53RespuestaGrupoBean;
import itourbaskBeans.q53RespuestaGruposBean;
import itourbaskBeans.q53RespuestaOpcionesBean;
import itourbaskBeans.q53RespuestaProcedenciaBean;
import itourbaskBeans.q53RespuestaTextoBean;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */ 
public class q53RespuestaClass {

	/**
	 * Mtodo para insertar en el bean de la respuesta la parte de notificaciones en el caso de tenerlas.
	 *
	 * @param respuestaBean El bean con los datos de la respuesta a la que aadiremos la parte de notificaciones
	 * @param cod_respuesta El codigo de la respuesta 
	 * 
	 * @throws ProcletException
	 
	 */
	 
	 public static String[] getSelectBusquedaCP(String cp) {
		String res = "";
		if ("".equals(cp))
			return new String[]{"", ""};
		int temp = 0;
		// si tiene una longitud mayor que 2 es un CP completo (ej: 41200 o 1012)
	   if (cp.length() > 2)
	   	res += " = " + cp;
	   // si la longitud es 2 o menor de 2 es pq se busca por provincia
		else{
			temp = Integer.parseInt(cp + "000");
			res += " > " +  temp + " and m7_codPostal < " + (temp + 1000);
		}
		return new String[]{", q53m7t00 ", " and m7_cod_Respuesta = M0_cod_Respuesta and m7_codPostal " + res};
	}
	 
	 
	private static q53RespuestaBean meterNotificacion(ProcletServiceData sd,q53RespuestaBean respuestaBean,String cod_respuesta) throws ProcletException {
		q53LogEstadisticas.printLog("q53RespuestaBean.meterNotificacion()");
        String select_notificacion="SELECT * FROM Q53M7T00 WHERE M7_COD_RESPUESTA="+cod_respuesta;
        q53LogEstadisticas.printLog(select_notificacion);
        PSP.sqlProclet(sd, "notificacion[]=" + select_notificacion);
        if(sd.gI("notificacion.length")>0){
        	String tipo_envio= sd.gOS("notificacion[0].m7_tipo_envio");
            q53LogEstadisticas.printLog("El tipo de envio de la notificacion es : "+tipo_envio);
        	respuestaBean.setTiene_notificacion("si");
        	q53NotificacionBean notificacionBean = new q53NotificacionBean();
        	notificacionBean.setTipo_envio(tipo_envio);
        	q53LogEstadisticas.printLog("El tipo de envio de la notificacion es : "+tipo_envio);
        	if(tipo_envio.equals("1")){
        		notificacionBean.setNombre(sd.gOS("notificacion[0].m7_nombre"));
        		notificacionBean.setDireccion(sd.gOS("notificacion[0].m7_direccion"));
        		notificacionBean.setLocalidad(sd.gOS("notificacion[0].m7_localidad"));
        		notificacionBean.setCodPostal(q53Util.padL((new Integer(sd.gI("notificacion[0].m7_codpostal"))).toString(), 5, '0'));  		
        	}else if(tipo_envio.equals("2")){
        		notificacionBean.setEmail(sd.gOS("notificacion[0].m7_email"));    		
        	}else if(tipo_envio.equals("3")){
        		notificacionBean.setFax(sd.gOS("notificacion[0].m7_fax"));		
        		notificacionBean.setFecha(q53Util.convertirFecha(sd.gOS("notificacion[0].m7_fecha")));
        		notificacionBean.setNhojas(sd.gOS("notificacion[0].m7_nhojas"));
        		notificacionBean.setRemitente(sd.gOS("notificacion[0].m7_remitente"));
        		notificacionBean.setDestinatario(sd.gOS("notificacion[0].m7_destinatario"));
        	}
        	respuestaBean.setNotificacionBean(notificacionBean);
        }else{
        	respuestaBean.setTiene_notificacion("no");
        }
        return respuestaBean;
	}

	/**
	 * Mtodo para insertar la informacion para las notificaciones en B.D.
	 *
	 * @param sd El objeto ProcletServiceData
	 * @param codRespuesta String que es el cdigo de respuesta
	 *
	 * @throws ProcletException
	 */
	public static void guardarNotificaciones(ProcletServiceData sd, String codRespuesta) throws ProcletException {
	        	q53LogEstadisticas.printLog("q53RespuestaBean.guardarNotificaciones()");
			String query=" ";
			PSP.paramProclet(sd, "tipo_envio");
	        q53LogEstadisticas.printLog("tipo_envio:"+sd.gOS("tipo_envio"));
			if(sd.gOS("tipo_envio").equals("1")){
				query="=INSERT INTO Q53M7T00 (m7_cod_respuesta,m7_tipo_envio,m7_nombre,m7_direccion," +
				"m7_localidad,m7_codpostal) VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+","+
				"'"+sd.gOS("nombre")+"','"+sd.gOS("direccion")+"',"+
				"'"+sd.gOS("localidad")+"','"+sd.gOS("codPostal")+"');";
			}else if(sd.gOS("tipo_envio").equals("2")){
				query="=INSERT INTO Q53M7T00 (M7_COD_RESPUESTA,M7_TIPO_ENVIO,M7_EMAIL) VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+",'"+sd.gOS("email")+"');";
			}else if(sd.gOS("tipo_envio").equals("3")){
				String q53Idioma = q53Util.getIdioma(sd);
				String fecha=sd.gOS("fecha");
				if(!q53Idioma.equals("C")){
					fecha=q53Util.convertirFechaIdioma(fecha,"EC");
				}
				query="=INSERT INTO Q53M7T00 (M7_COD_RESPUESTA,M7_TIPO_ENVIO,M7_FAX,M7_FECHA,M7_NHOJAS,M7_REMITENTE,M7_DESTINATARIO)" +
				" VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+",'"+sd.gOS("fax")+"',"+
				"'"+fecha+"','"+sd.gOS("hojas")+"','"+sd.gOS("remitente")+"','"+sd.gOS("destinatario")+"');";
			}
			q53LogEstadisticas.printLog("QUERY DE INSERCION DE NOTIFICACIONES:::: -> " +query+ " <-");
	        PSP.sqlProclet(sd, query);
	        q53LogEstadisticas.printLog("FIN QUERY DE INSERCION DE NOTIFICACIONES");
	    }

	public static void deleteNotificaciones(ProcletServiceData sd, String codRespuesta)throws ProcletException {
			String deleteNotificacion = "=DELETE FROM Q53M7T00 WHERE M7_COD_RESPUESTA =" + codRespuesta;
			q53LogEstadisticas.printSql(" borrando datos en m7_:" + deleteNotificacion);
			PSP.sqlProclet(sd, deleteNotificacion);	
	}
	
	
	 public static void updateNotificaciones(ProcletServiceData sd, String codRespuesta)throws ProcletException {
	    	if ((!sd.gOS("check_envio").equals("on")) || ("123".indexOf(sd.gOS("tipo_envio")) == -1))
	    		return;
	    	String query=" ";
	    	String q53Idioma = q53Util.getIdioma(sd);
	    	//Se obtiene la fecha del fax o bien la cadena vacia
	    	String fecha=sd.gOS("fecha");
	    	if(!q53Idioma.equals("C")){
	    	   if (!"".equals(fecha))
	    	   	fecha=q53Util.convertirFechaIdioma(fecha,"EC");
	    	}
	    	query= "=update Q53M7T00 set " +
	    			"m7_tipo_envio = " + sd.gOS("tipo_envio") +
	    			",m7_nombre = '"+ sd.gOS("nombre") +
	    			"',m7_direccion = '" +sd.gOS("direccion") +
	    			"',m7_localidad = '" + sd.gOS("localidad") +
	    			"',m7_codpostal = '" + sd.gOS("codPostal") + 
	    			"',m7_informacion_envio = '${informacion_envio}'" +
	    			",M7_EMAIL = '" + sd.gOS("email") +
	    			"',M7_FAX = '" +sd.gOS("fax")+
	    			"',M7_FECHA = '" +fecha +
	    			"',M7_NHOJAS = '" +sd.gOS("hojas") + 
	    			"',M7_REMITENTE = '" + sd.gOS("remitente") + 
	    			"',M7_DESTINATARIO = '" + sd.gOS("destinatario") +
	    			"' where M7_COD_RESPUESTA = " + codRespuesta;
	    	q53LogEstadisticas.printLog("QUERY DE UPDATE DE NOTIFICACIONES:::: -> " +query+ " <-");
	    	PSP.sqlProclet(sd, query);
	    	q53LogEstadisticas.printLog("FIN QUERY DE UPDATE DE NOTIFICACIONES");
	    }	    

    public static List getRespuestas(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion) throws ProcletException {
            
            
            q53LogEstadisticas.printLog("q53RespuestaBean.getRespuestas()");

        List encuestasList = new ArrayList();
        String selectEncuestas = "select M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "
            + " from respuesta"
            + " where ";

        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += "M0_COD_OFICINA = '" + codOficina + "' and ";
        }
        selectEncuestas += " respuesta.m0_fecha >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS') "
                + " AND respuesta.m0_fecha <= TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS')"
                + " AND M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS')";

        //         q53LogEstadisticas.printLog("getRespuestas()::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);

        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            for (int i = 0; i < numEnc; i++) {
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                respuestaBean.setCodRespuesta(sd.gOS("encuestas[" + i + "].m0_cod_respuesta"));
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                encuestasList.add(respuestaBean);
            }
        }
        return encuestasList;
    } 
   
    
    public static List getUltimaRespuesta(ProcletServiceData sd, String codOficina, String codEncuesta,
            String codVersion,String tipo,String codUsuario,String usuario)  throws ProcletException{
            	
            	q53LogEstadisticas.printLog("q53RespuestaBean.getUltimaRespuesta()");
            
    		List encuestasList =new ArrayList();
    		
    		String select_estado="DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R') estado,";
        String tabla=",resp_fecha";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_desc=" AND M4_COD_PREGUNTA(+)="+q53Util.getLiteral(sd,"PREG_DESC","C")+" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="RESP_TEXTO,";
        if(tipo.equals("pres")){select_estado="";tabla="";join="";}	
    		
    		String selectEncuestas = "select  "+select_estado+"M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
          	+" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc;
        selectEncuestas+=" from "+tdesc+"respuesta"+tabla;
        selectEncuestas+=" where ";
                   
        String select_ultima="SELECT MAX(M0_COD_RESPUESTA) FROM RESPUESTA  WHERE";
        select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'" 
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'";
        q53LogEstadisticas.printLog("codusuario::"+codUsuario);
                if(!usuario.equals("0")){
                	select_ultima+=" AND M0_COD_PERSONA='"+codUsuario+"'";    
                }
    	 	
    	 if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += "M0_COD_OFICINA = '" + codOficina + "' and ";
            select_ultima += " AND M0_COD_OFICINA = '" + codOficina +"'";
        }       
       
       selectEncuestas += " M0_COD_RESPUESTA =("+select_ultima+") "+join+join_desc
       + " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') desc"; 
    	
        q53LogEstadisticas.printLog("getUltimaRespuesta()::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);

        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            for (int i = 0; i < numEnc; i++) {
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));           		
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                if(tipo.equals("pres")){
                	respuestaBean.setEstado("R");
                	respuestaBean.setDescripcion("");
              	}else{
              		respuestaBean.setEstado(sd.gOS("encuestas[" + i + "].estado"));
             		respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
              	}
                List Procedencias=cogerRespuestaProcedencia(sd,cod_respuesta);
                respuestaBean.setProcedenciaList(Procedencias);
                encuestasList.add(respuestaBean);
            }
        }
        return encuestasList;
    	
    	}
    
    public static List getUltimaRespuestaPendiente(ProcletServiceData sd, String codOficina, String codEncuesta,
            String codVersion,String tipo)  throws ProcletException{
            	
            	q53LogEstadisticas.printLog("q53RespuestaBean.getUltimaRespuestaPendiente()");
            
    		List encuestasList =new ArrayList();
    		
    		String select_estado="DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R') estado,";
        String tabla=",resp_fecha";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_desc=" AND M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="RESP_TEXTO,";
        if(tipo.equals("pres")){select_estado="";tabla="";join="";}	
    		
    		String selectEncuestas = "select  "+select_estado+"M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
          	+" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc;
        selectEncuestas+=" from "+tdesc+"respuesta"+tabla;
        selectEncuestas+=" where ";
          
          
        String select_ultima="SELECT MAX(M0_COD_RESPUESTA) FROM "+tdesc+"respuesta"+tabla+" WHERE";
        select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        		+ " AND M0_COD_RESPUESTA=M6_COD_RESPUESTA"
                + " AND M0_COD_VERSION='" + codVersion + "'" 
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"
                + " AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
                
    	 if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += "M0_COD_OFICINA = '" + codOficina + "' and ";
            select_ultima += " AND M0_COD_OFICINA = '" + codOficina +"'";
        }       
       
       selectEncuestas += " M0_COD_RESPUESTA =("+select_ultima+") "+join+join_desc
       + " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') desc"; 
    	
        q53LogEstadisticas.printLog("selectEncuestas::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);

        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            for (int i = 0; i < numEnc; i++) {
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));           		
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                if(tipo.equals("pres")){
                	respuestaBean.setEstado("R");
                	respuestaBean.setDescripcion("");
              	}else{
              		respuestaBean.setEstado(sd.gOS("encuestas[" + i + "].estado"));
             		respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
              	}
                List Procedencias=cogerRespuestaProcedencia(sd,cod_respuesta);
                respuestaBean.setProcedenciaList(Procedencias);
                encuestasList.add(respuestaBean);
            }
        }
        return encuestasList;
    	
    	}
    
       
     /**
     * Metodo para encontrar todas las respuestas pendientes de respuesta de un tipo de encuesta entre unas fechas
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static List getRespuestasTipoEstado(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion,String tipo,String ultima,String valor) throws ProcletException {
            	q53LogEstadisticas.printLog("q53RespuestaBean.getRespuestasTipoEstado()");
        List encuestasList = new ArrayList();
        if(tipo.length()==0 || tipo.equals("pres"))return encuestasList;
        String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String select_procedencia="M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
       		+"M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
       		+"P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS,";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND m0_cod_respuesta=m5_cod_respuesta and M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA=P4_COD_COMARCA(+) and (m5_cpos<>0 or m5_local='S' or m5_cod_pais<>0)";
        String join_desc=" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        
        String selectEncuestas = "select M0_COD_RESPUESTA,"+select_procedencia+" to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc
            + " from "+tdesc+"respuesta"+tabla+tabla_procedencia
            + " where ";
            
        String select_oficina=  "M0_COD_OFICINA = '" + codOficina + "'";
              	
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas +=select_oficina+" and";
        }
                	 		
        String select_fechas=" respuesta.m0_fecha >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')  "
        + " AND  respuesta.m0_fecha <= TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicio==null || fechaFin==null || fechaInicio.length()==0 || fechaFin.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        	selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') desc";        
		}else if(valor.equals("1")){
					selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(M0_FECHA_RESP,'DD/MM/YYYY  HH24:MI:SS') desc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') desc"; 
		}else if(valor.equals("3")){
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by M0_PERSONAS desc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') desc"; 
		}else{
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by m5_cod_pais desc,p1_nombre_cas desc,M5_local desc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') desc"; 
		}
        q53LogEstadisticas.printLog("selectEncuestas::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printSql("select:"+selectEncuestas);
        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

           int i=0;
            int p=0;
							List yaesta=new ArrayList();
							while(i<numEnc){
								if(yaesta.contains(new Integer(i))){
									//q53LogEstadisticas.printLog("el array tiene el indice "+i);
									i=i+1;
								}else{
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                //q53LogEstadisticas.printLog("el codigo en "+i+" es:"+sd.gOS("encuestas["+i+"].m0_cod_respuesta"));
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                respuestaBean.setEstado("P");
                respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
                List procedencias = new ArrayList();
              	q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
	            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+i+"].m5_cod_comunidad"));
	            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+i+"].m5_cod_comarca"));
	            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+i+"].m5_cod_municipio"));
	            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+i+"].m5_cod_pais"));
	            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+i+"].m5_local"));
	             		// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("encuestas["+i+"].m5_local"));
	            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+i+"].m5_cpos"));
	            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+i+"].m5_cod_territorio"));
			            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+i+"].p1_nombre_cas"));
			            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+i+"].p1_nombre_eus"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_cas"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_eus"));
			            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+i+"].p0_nombre_cas"));
			            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+i+"].p0_nombre_eus"));
			            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+i+"].p2_nombre_cas"));
			            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+i+"].p2_nombre_eus"));
			            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+i+"].p4_nombre_cas"));
			            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+i+"].p4_nombre_eus"));
            
			            if(sd.gOS("encuestas["+i+"].m5_num_personas") != null && !(sd.gOS("encuestas["+i+"].m5_num_personas").equals(""))){
			                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+i+"].m5_num_personas"));
			            }else{
			                respProcedenciaBean.setNumPersonas(0);
			            }
			            procedencias.add(p,respProcedenciaBean);
			            p++;
			            
              	for(int j=i+1;j<numEnc;j++){
			            	if(cod_respuesta.equals(sd.gOS("encuestas[" + (j) + "].m0_cod_respuesta"))){
			            		yaesta.add(new Integer(j));
			            		q53LogEstadisticas.printLog("Ha encontrado el mismo codigo:"+sd.gOS("encuestas["+j+"].m0_cod_respuesta"));
		              	 	respProcedenciaBean = new q53RespuestaProcedenciaBean();
			            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+j+"].m5_cod_comunidad"));
			            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+j+"].m5_cod_comarca"));
			            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+j+"].m5_cod_municipio"));
			            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+j+"].m5_cod_pais"));
			            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+j+"].m5_local"));
			             		// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("encuestas["+j+"].m5_local"));
			            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+j+"].m5_cpos"));
			            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+j+"].m5_cod_territorio"));
					            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+j+"].p1_nombre_cas"));
					            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+j+"].p1_nombre_eus"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_cas"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_eus"));
					            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+j+"].p0_nombre_cas"));
					            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+j+"].p0_nombre_eus"));
					            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+j+"].p2_nombre_cas"));
					            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+j+"].p2_nombre_eus"));
					            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+j+"].p4_nombre_cas"));
					            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+j+"].p4_nombre_eus"));
		            
					            if(sd.gOS("encuestas["+j+"].m5_num_personas") != null && !(sd.gOS("encuestas["+j+"].m5_num_personas").equals(""))){
					                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+j+"].m5_num_personas"));
					            }else{
					                respProcedenciaBean.setNumPersonas(0);
					            }
					            procedencias.add(p,respProcedenciaBean);
					            p++;
			          		}
               		}
                respuestaBean.setProcedenciaList(procedencias);
             
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        }
        return encuestasList;
    }
    
    /**
     * Mtodo que nos devuelve las opciones de las respuestas de tipo grupos
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de la respuesta
     * @param codPregunta String que es el cdigo de la pregunta
     * @param respuestaBean Objeto que contien los datos de las respuesta
     *
     * @return q53RespuestaBean Nuevo objeto con los datos de la respuesta de
     *         tipo grupos
     *
     * @throws ProcletException
     */
    private static q53RespuestaBean getOptionsAndGroupsResponse(
            ProcletServiceData sd, String codRespuesta, String codPregunta,
            q53RespuestaBean respuestaBean) throws ProcletException {

        String selectGroupHombres = "select N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES " 
            + "from resp_grupos"
            + " where N9_COD_RESPUESTA = " + codRespuesta 
            + " and resp_grupos.N9_COD_PREGUNTA='" + codPregunta + "'"
            + " AND N9_COD_GRUPO='1'";
        // q53LogEstadisticas.printLog("selectGroupHombres::::"+selectGroupHombres);
        PSP.sqlProclet(sd, "selectGroupHombres[]=" + selectGroupHombres);

        int numHombres = 0;
        int numMujeres = 0;
        if(sd.gI("selectGroupHombres.length")>0){
            String grupo2 = sd.gOS("selectGroupHombres[0].n9_cod_grupo");
            numHombres = sd.gI("selectGroupHombres[0].n9_hombres");
            numMujeres = sd.gI("selectGroupHombres[0].n9_mujeres");
        }
        String selectGroupMujeres = "select N9_HOMBRES,N9_MUJERES " 
            + "from resp_grupos"
            + " where N9_COD_RESPUESTA = " + codRespuesta 
            + " and resp_grupos.N9_COD_PREGUNTA='" + codPregunta + "'"
            + " AND N9_COD_GRUPO='2'";
        // q53LogEstadisticas.printLog("selectGroupMujeres::::"+selectGroupMujeres);
        PSP.sqlProclet(sd, "selectGroupMujeres[]=" + selectGroupMujeres);
        if(sd.gI("selectGroupMujeres.length")>0){
            numHombres = numHombres + sd.gI("selectGroupMujeres[0].n9_hombres");
            numMujeres = numMujeres + sd.gI("selectGroupMujeres[0].n9_mujeres");
        }
        int numPersonas = numHombres + numMujeres;
        respuestaBean.setNumPersonas((new Integer(numPersonas)).toString());
        return respuestaBean;
    }
    
    /**
     * Mtodo que nos devuelve el nombre  de la opcion de la pregunta de tipo
     * opciones
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de respuesta
     * @param codPregunta String que es el cdigo de pregunta
     *
     * @return String que es la descripcion de la opcion
     *
     * @throws ProcletException
     */
    private static String getOpcionName(ProcletServiceData sd,
            String codRespuesta, String codPregunta) throws ProcletException {
        String selectOpcion = "SELECT M2_COD_OPCION"
            + " FROM RESP_OPCIONES"
            + " WHERE M2_COD_RESPUESTA='" + codRespuesta + "'"
            + " AND M2_COD_PREGUNTA='" + codPregunta + "'";
        //q53LogEstadisticas.printLog("selectOpcion::::"+selectOpcion);
        PSP.sqlProclet(sd, "selectOpcion[]=" + selectOpcion);

        String opcion_4 = sd.gOS("selectOpcion[0].m2_cod_opcion");
        return q53Util.getLiteral(sd, "N3_" + codPregunta + "_" + opcion_4, q53Util.getIdioma(sd));
    }
    

    /**
     * Mtodo para insertar las respuestas de la encuesta en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param gvCodEncuesta String que es el cdigo de la encuesta del g.v. (el
     *        0)
     * @param gvCodVersion String que es el cdigo de la version de la encuesta
     *        del g.v. (el 0)
     * @param codRespuesta String que es el cdigo de respuesta
     *
     * @throws ProcletException
     */
    public static void guardarRespuestasEncGV(ProcletServiceData sd,
            String gvCodEncuesta, String gvCodVersion, String codRespuesta)
            throws ProcletException {
            	q53LogEstadisticas.printLog("guardarRespuestasEncGV()");
        //List preguntasList = getGVPreguntasData(sd, gvCodEncuesta, gvCodVersion);
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                gvCodEncuesta, gvCodVersion);
        String query_final = "";
        q53LogEstadisticas.printLog("Guardar Respuestas GV");
 q53LogEstadisticas.printLog("preguntasList-"+preguntasList);
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();
 q53LogEstadisticas.printLog("Antes del for");            
 q53LogEstadisticas.printLog("numPregs-" + numPregs);
            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
 q53LogEstadisticas.printLog("preguntasList.get(-"+i+"-)-" + preguntasList.get(i));                
                String tipo_pregunta = preguntaBean.getTipoPregunta();                 
 q53LogEstadisticas.printLog("tipo_pregunta-"+tipo_pregunta);                            
                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
 q53LogEstadisticas.printLog("valor de   i-"+i);                  	
                	q53LogEstadisticas.printLog("Tipo opciones");                	
                    query_final += guardarRptaOpciones(sd, preguntaBean, i, codRespuesta);                                        
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
 q53LogEstadisticas.printLog("valor  llll de i-"+i);                  	
                	q53LogEstadisticas.printLog("Tipo texto");                	
                    query_final += guardarRptaTexto(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
 q53LogEstadisticas.printLog("valor de i-"+i);                  	
                	q53LogEstadisticas.printLog("Tipo procedencia");                	
                    query_final += guardarRptaProcedencia(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
 q53LogEstadisticas.printLog("valor de i-"+i);                	
                	q53LogEstadisticas.printLog("Tipo fecha");                	    
 q53LogEstadisticas.printLog("codRespuesta-"+codRespuesta);    
                    query_final += guardarRptaFecha(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                	q53LogEstadisticas.printLog("Tipo grupos");                	
                    query_final += guardarRptaGrupos(sd, preguntaBean, i, codRespuesta);
                }
            }
//            String[] valores = sd.getValNames("");
//            for(int g=0;g<valores.length;g++){
//            	q53LogEstadisticas.printLog("VALORES EN EL SD:::: -> " +valores[g] + " <- -> " +sd.getVal(valores[g])+ " <-");
//            }
            q53LogEstadisticas.printLog("QUERY DE INSERCION DE LA RESPUESTA DE GV:::: -> " +query_final+ " <-");
            PSP.sqlProclet(sd, query_final);
            q53LogEstadisticas.printLog("FIN QUERY DE INSERCION DE LA RESPUESTA DE GV:::: -> ");
        }
    }
    
    /**
     * Mtodo para insertar las respuestas de la encuesta en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codEncuestaOfi String que es el cdigo de la encuesta propia de
     *        la oficina
     * @param codVersionEncOfi String que es el cdigo de la version de la
     *        encuesta propia de la oficina
     * @param codRespOfi String que es el cdigo de la respuesta propia de la
     *        oficina
     *
     * @throws ProcletException
     */
    public static void guardarRespuestasEncOfi(ProcletServiceData sd,
            String codEncuestaOfi, String codVersionEncOfi, String codRespOfi)
            throws ProcletException {
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                codEncuestaOfi, codVersionEncOfi);
        String query_final = "";
        q53LogEstadisticas.printLog("Preguntas en oficina");
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();
            String isFecha = "N";
            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
                String tipo_pregunta = preguntaBean.getTipoPregunta();
                
                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                    query_final += guardarRptaOpciones(sd, preguntaBean, i, codRespOfi);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                    query_final += guardarRptaTexto(sd, preguntaBean, i, codRespOfi);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                    query_final += guardarRptaFecha(sd, preguntaBean, i, codRespOfi);
                    isFecha="S";
                }
            }

/*
29.11.2007 Nuevo. Hay que actualizar el valor de m0_fecha_resp siempre.
Este valor se actualiza mediante un trigger en la bbdd, al meter un valor en el campo m6_fecha se dispara
pero cuando la encuesta propia no tiene preguntas de tipo fecha, este campo queda vacio,
y al sacar las estadisticas no salen los datos.
*/
            if (isFecha.equals("N"))
            { // hay que actualizar el registro de RESPUESTA para meter m0_fecha_resp
                String fechaUpdate = "UPDATE respuesta"
                    + " SET m0_fecha_resp = (SELECT r1.m0_fecha_resp fecha"
                    + " FROM respuesta r1, respuesta r2"
                    + " WHERE r1.m0_cod_respuesta = r2.m0_cod_respuesta_rd"
                    + " AND r2.m0_cod_respuesta = "+codRespOfi+")"
                    + " WHERE m0_cod_respuesta = "+codRespOfi;
                query_final += "="+fechaUpdate+";";
            }

            q53LogEstadisticas.printLog("QUERY DE INSERCION DE LA RESPUESTA DE OFICINA::: -> "+query_final+" <-");
            PSP.sqlProclet(sd, query_final);
            q53LogEstadisticas.printLog("FIN QUERY DE INSERCION DE LA RESPUESTA DE OFICINA");
        }
    }
    
    /**
     * obtenerCodigoPregunta
     * 
     * Mtodo que devuelve el codigo de pregunta de una oficina pasando el orden de la misma y vacio "" si no tiene
     *
     * @param sd El objeto ProcletServiceData
     * @param codEncuestaOfi String que es el cdigo de la encuesta propia de
     *        la oficina
     * @param codVersionEncOfi String que es el cdigo de la version de la
     *        encuesta propia de la oficina
     *
     * @throws ProcletException
     */
    
    public static String obtenerCodigoPregunta(ProcletServiceData sd, String codEncuestaOfi, 
    		String codVersionEncOfi, String orden) throws ProcletException {
    	
    	 List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd, codEncuestaOfi, codVersionEncOfi);
    	 int numPregs = preguntasList.size();
         for (int i = 0; i < numPregs; i++) {
             q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
             q53LogEstadisticas.printLog("ORDEN "+preguntaBean.getOrden()+" CODIGO "+preguntaBean.getCodPregunta());
             if(orden.equals(preguntaBean.getOrden())){
            	 return preguntaBean.getCodPregunta();
             }   	 
         }
         return "";
         
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo opcion en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto que contiene los datos de la pregunta
     * @param i Numero de la pregunta en el array. No se usa.
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaOpciones(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta)
            throws ProcletException {

        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        // mirar que formato tiene la pregunta: combobox, check, radio button
        String sql_tmp = "SELECT n2_formato formato"
            + " FROM pr_opciones"
            + " WHERE n2_cod_pregunta=" + cod_pregunta;
        // q53LogEstadisticas.printLog("sql_tmp::::"+sql_tmp);
        PSP.sqlProclet(sd, "formato_tmp="+sql_tmp);

        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA"
            + " (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        rtdo = "=" + insert_pregunta + ";";

        
        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_RADIO)) {
            // Pregunta de opciones con formato radio button.
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");
            if (!sd.gOS("opt_" + cod_pregunta).equals("")) {
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES"
                    + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",${opt_" + cod_pregunta + "})";
                rtdo += "=" + insert_pregunta_tipo + ";";
            }
        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_CHECK)) {
            // Pregunta de opciones de formato check (multiple respuestas!!)
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");
            String opt = sd.gOS("opt_" + cod_pregunta);
            q53LogEstadisticas.printLog("MODIFICAR, OPT: "+opt);
            String cadena_insert = "";
            while (opt.length() != 0) {
                int indice = opt.indexOf("#");
                String opt_tmp = "";
                if (indice != -1) {
                    opt_tmp = opt.substring(0, indice);
                    opt = opt.substring(indice + 1, opt.length());
                } else {
                    opt_tmp = opt;
                    opt = "";
                }
                cadena_insert += "=INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                     +" VALUES (" + cod_respuesta + "," + cod_pregunta + "," + opt_tmp + ");";
            }
            rtdo += cadena_insert;
        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_SELECT)) {
            // Pregunta de opciones con formato select
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");
            
            if (!sd.gOS("opt_" + cod_pregunta).equals("")) {
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",${opt_" + cod_pregunta + "})";
                
                rtdo += "=" + insert_pregunta_tipo + ";";
            }
        }
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo texto en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto con los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaTexto(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        PSP.paramProclet(sd, "txt_" + cod_pregunta + "()");
        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        String insert_pregunta_tipo = "INSERT INTO RESP_TEXTO (M4_COD_RESPUESTA,M4_COD_PREGUNTA,M4_TEXTO)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",'${txt_" + cod_pregunta + "}')";
        rtdo = "=" + insert_pregunta + ";=" + insert_pregunta_tipo+";";
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Procedencia
     * en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean objeto que contiene los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaProcedencia(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        PSP.paramProclet(sd,
                "proc_local_" + cod_pregunta + "(), proc_pais_" + cod_pregunta + "_1()," +
                "proc_pais_" + cod_pregunta +"_2(),proc_pais_" + cod_pregunta +"_3(), " +
                "proc_ccaa_" + cod_pregunta + "_1(),proc_ccaa_" + cod_pregunta + "_2()," +
                "proc_ccaa_" + cod_pregunta + "_3(), proc_territorio_"+ cod_pregunta + "_1()," +
                "proc_territorio_"+ cod_pregunta + "_2(),proc_territorio_"+ cod_pregunta + "_3()," +
                "nPersonasProcedencia_6_1(),nPersonasProcedencia_6_2(),cpos1(),cpos2(),cpos3()," +
                "nPersonasProcedencia_6_3(),local()");
                
	
        int numLocales = 0;
        int numProc1=0;
        if(!sd.gOS("local").equals("") && !sd.gOS("local").equals("N")){
	        if(!sd.gOS("nPersonasProcedencia_6_1").equals("")){
	            numLocales = sd.gI("nPersonasProcedencia_6_1");
	        }
        } else {
	        if(!sd.gOS("nPersonasProcedencia_6_1").equals("")){
	            numProc1 = sd.gI("nPersonasProcedencia_6_1");
	        }
      	}
        // q53LogEstadisticas.printLog("LOCAL::::" + numLocales);
        // q53LogEstadisticas.printLog("NUMPROC1::::" + numProc1);
        int numProc2=0;
        if(!sd.gOS("nPersonasProcedencia_6_2").equals("")){
            numProc2 = sd.gI("nPersonasProcedencia_6_2");
        }
        // q53LogEstadisticas.printLog("NUMPROC2::::" + numProc2);
        int numProc3=0;
        if(!sd.gOS("nPersonasProcedencia_6_3").equals("")){
            numProc3 = sd.gI("nPersonasProcedencia_6_3");
        }
        // q53LogEstadisticas.printLog("NUMPROC3::::" + numProc3);
        String cpos1="0";
        String prov1="0";
        String prov2="0";
        String prov3="0";
        String territorio1="";
        String territorio2="";
        String territorio3="";
        String pais1=sd.gOS("proc_pais_" + cod_pregunta + "_1");
        String pais2=sd.gOS("proc_pais_" + cod_pregunta + "_2");
        String pais3=sd.gOS("proc_pais_" + cod_pregunta + "_3");    
        if(!sd.gOS("cpos1").equals("")){
            cpos1 = sd.gOS("cpos1");
						if(pais1.equals("0")){
            if(cpos1.length()==5){
            	prov1=cpos1.substring(0,2);
            	if(prov1.equals("01") || prov1.equals("1")){
            		territorio1="0";
            	}else if (prov1.equals("20")){
            		territorio1="2";
            	}else if (prov1.equals("48")){
            		territorio1="1";
            	}
            }
          } 
        }   
        String cpos2="0";
        if(!sd.gOS("cpos2").equals("")){
            cpos2 = sd.gOS("cpos2");
           if(pais2.equals("0")){
            if(cpos2.length()==5){
            	prov2=cpos2.substring(0,2);
            }
            	if(prov2.equals("01") || prov2.equals("1")){
            		territorio2="0";
            	}else if (prov2.equals("20")){
            		territorio2="2";
            	}else if (prov2.equals("48")){
            		territorio2="1";
            	}
           }  	
        }    
        String cpos3="0";
        if(!sd.gOS("cpos3").equals("")){
            cpos3 = sd.gOS("cpos3");
            if(pais3.equals("0")){
            if(cpos3.length()==5){
            	prov3=cpos3.substring(0,2);
            }
            	if(prov3.equals("01") || prov3.equals("1")){
            		territorio3="0";
            	}else if (prov3.equals("20")){
            		territorio3="2";
            	}else if (prov3.equals("48")){
            		territorio3="1";
            	}
           }		
        }
        if(pais1.equals("10") && (cpos1.equals("")||cpos1.equals("0")))cpos1="999";
        if(pais2.equals("10") && (cpos2.equals("")||cpos2.equals("0")))cpos2="999";
        if(pais3.equals("10") && (cpos3.equals("")||cpos3.equals("0")))cpos3="999";
        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        rtdo += "=" + insert_pregunta + ";";
        // q53LogEstadisticas.printLog("insert_pregunta::::" + insert_pregunta);

        String codOficina = sd.gOS("q53_cki.q53_oficina");
        String codMunicipioOfi = "";
        String selectMuni = "SELECT TO_CHAR(T02_CODPROVINC,'FM09') T02_CODPROVINC,"
            + "TO_CHAR(T02_CODMUNICIP,'FM0999') T02_CODMUNICIP"
            + " FROM OFICINA"
            + " WHERE T02_COOR='" +codOficina + "'";
        PSP.sqlProclet(sd, "selectMuni[]=" + selectMuni );
        codMunicipioOfi = sd.gOS("selectMuni[0].t02_codprovinc")+"_"+sd.gOS("selectMuni[0].t02_codmunicip");
        
        //BUSCAMOS LA COMARCA A LA QUE PERTENECE EL MUNICIPIO
        String selectComarca = "SELECT P3_COD_COMARCA, P3_COD_TERRITORIO"
            + " FROM MUNICIPIO"
            + " WHERE P3_COD_MUNICIPIO='"+codMunicipioOfi+"'";
        PSP.sqlProclet(sd, "selectComarca[]=" + selectComarca );
        String codComarca = sd.gOS("selectComarca[0].p3_cod_comarca");
        String codTerritorio =  sd.gOS("selectComarca[0].p3_cod_territorio");
        
        //BUSCAMOS LA COMUNIDAD AUTONOMA A LA QUE PERTENECE LA PROVINCIA
        String codCCAA1="0";
        if(!sd.gOS("cpos1").equals("")){
        	if(pais1.equals("0")){        	
        	String selectCCAA1 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov1+"'";
        	PSP.sqlProclet(sd, "selectCCAA1[]=" + selectCCAA1 );
        	codCCAA1 = sd.gOS("selectCCAA1[0].cod_ccaa");
        	}
        }
        String codCCAA2="0";
        if(!sd.gOS("cpos2").equals("")){
        	if(pais2.equals("0")){
        	String selectCCAA2 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov2+"'";
        	PSP.sqlProclet(sd, "selectCCAA2[]=" + selectCCAA2 );
        	codCCAA2 = sd.gOS("selectCCAA2[0].cod_ccaa");
        }
        }
        String codCCAA3="0";
        if(!sd.gOS("cpos3").equals("")){
        	if(pais3.equals("0")){
        	String selectCCAA3 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov3+"'";
        	PSP.sqlProclet(sd, "selectCCAA3[]=" + selectCCAA3 );
        	codCCAA3 = sd.gOS("selectCCAA3[0].cod_ccaa");
        	}
        }
        if(pais1.equals("10"))codCCAA1=cpos1;
        if(pais2.equals("10"))codCCAA2=cpos2;
        if(pais3.equals("10"))codCCAA3=cpos3;
         if(!sd.gOS("local").equals("")){
            String insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA"
                + " (M5_COD_RESPUESTA,M5_COD_PREGUNTA,M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO,"
                + "M5_COD_PROCEDENCIA,M5_COD_COMARCA,M5_NUM_PERSONAS,M5_CPOS)"
                + " VALUES (" + cod_respuesta + "," +cod_pregunta + ",'S',0,0,"+codTerritorio+",'"+codMunicipioOfi+"','1',"
                + "'"+codComarca+"',"+numLocales+","+cpos1+")";
            rtdo += "=" + insert_pregunta_tipo + ";";               
        }else{
        	q53LogEstadisticas.printLog("LLamada a getGruposData 1 insert rep_proc-extranjero");
            String insert_pregunta_tipo = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
                + "M5_LOCAL,M5_COD_PAIS,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS)"
                + " VALUES (" + cod_respuesta + ","+ cod_pregunta + ",'N',0,'1',0)";
            rtdo += "=" + insert_pregunta_tipo + ";";
        }
        String mun1=pais1.equals("0")?q53Util.getMunicipio(sd,cpos1):""; 
        String insert_preguntaProc1="";
        q53LogEstadisticas.printLog("LLamada a getGruposData 2 insert resp_procedencia");
        if(pais1.equals(""))pais1="0";
        insert_preguntaProc1 = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
            + "M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO," 
            + "M5_COD_COMARCA,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS,M5_CPOS) "
            + "VALUES (" + cod_respuesta + ",6,'N','"+pais1+"','"+codCCAA1+"','"+territorio1+"','"+mun1+"',"
            + "'','2',"+numProc1+","+cpos1+")";
        rtdo += "=" + insert_preguntaProc1 + ";";
        String mun2=pais2.equals("0")?q53Util.getMunicipio(sd,cpos2):"";
        String insert_preguntaProc2="";

         q53LogEstadisticas.printLog("LLamada a getGruposData 3 insert resp_procedencia");
         q53LogEstadisticas.printLog("Vuelta de getGruposData");
         if(pais2.equals(""))pais2="0"; 
        insert_preguntaProc2 = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
            + "M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO,"
            + "M5_COD_COMARCA,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS,M5_CPOS) "
            + "VALUES (" + cod_respuesta + "," +cod_pregunta + ",'N','"+pais2+"',"
            + "'"+codCCAA2+"','"+territorio2+"', '"+mun2+"', '', '3', "+numProc2+", "
            +cpos2+")";
        rtdo += "=" + insert_preguntaProc2 + ";";
        String mun3=pais3.equals("0")?q53Util.getMunicipio(sd,cpos3):"";
String insert_preguntaProc3="";

		q53LogEstadisticas.printLog("LLamada a getGruposData 4 insert resp_procedencia");      
		q53LogEstadisticas.printLog("Vuelta de getGruposData");
         if(pais3.equals(""))pais3="0";
        insert_preguntaProc3 = "INSERT INTO RESP_PROCEDENCIA (M5_COD_RESPUESTA,M5_COD_PREGUNTA,"
            + "M5_LOCAL,M5_COD_PAIS,M5_COD_COMUNIDAD,M5_COD_TERRITORIO,M5_COD_MUNICIPIO,"
            + "M5_COD_COMARCA,M5_COD_PROCEDENCIA,M5_NUM_PERSONAS,M5_CPOS) "
            + "VALUES (" + cod_respuesta + "," +cod_pregunta + ",'N','"+pais3+"'," 
            + "'"+codCCAA3+"','"+territorio3+"','"+mun3+"','','4',"+numProc3+","
           +cpos3+")";
        rtdo += "=" + insert_preguntaProc3 + ";";
        return rtdo;
               
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Fecha en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Objeto que contiene losd atos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de la respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaFecha(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        
        q53LogEstadisticas.printLog("cod_pregunta :" + cod_pregunta);        
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        q53LogEstadisticas.printLog("tipo_pregunta :" + tipo_pregunta);
        String rtdo = "";
				java.util.Calendar cal=java.util.Calendar.getInstance();
				int hh=cal.get(java.util.Calendar.HOUR_OF_DAY); 
        PSP.paramProclet(sd,
                "fech_" + cod_pregunta + "_dia(),fech_" + cod_pregunta +
                "_mes(),fech_" + cod_pregunta + "_anio(),fech_" + cod_pregunta +
                "_hora("+hh+"),fech_10_dia2(),fech_10_mes2(),fech_10_anio2()");
		
		int mes_fecha =sd.gI("fech_" +cod_pregunta + "_mes");
		
		String sMes_Fecha= "";
		if(mes_fecha <10){
			sMes_Fecha = "0"+(new Integer(mes_fecha)).toString();
		}else{
			sMes_Fecha = (new Integer(mes_fecha)).toString();
		}
		int dia_fecha =sd.gI("fech_" +cod_pregunta + "_dia");
		String sdia_fecha= "";
		if(dia_fecha <10){
			sdia_fecha = "0"+(new Integer(dia_fecha)).toString();
		}else{
			sdia_fecha = (new Integer(dia_fecha)).toString();
		}
		int anio_fecha =sd.gI("fech_" +cod_pregunta + "_anio");
		String sanio_fecha= "";
		if(anio_fecha <10){
			sanio_fecha = "0"+(new Integer(anio_fecha)).toString();
		}else{
			sanio_fecha = (new Integer(anio_fecha)).toString();
		}
		int hora_fecha =sd.gOS("fech_" +cod_pregunta + "_hora").length()==0?hh:sd.gI("fech_" +cod_pregunta + "_hora");
		String shora_fecha= "";
		if(hora_fecha <10){
			shora_fecha = "0"+(new Integer(hora_fecha)).toString();
		}else{
			shora_fecha = (new Integer(hora_fecha)).toString();
		}
		int mes_fecha2 =sd.gOS("fech_10_mes2").length()==0?-1:sd.gI("fech_10_mes2");
		
		String sMes_Fecha2= "";
		if(mes_fecha2 <10){
			sMes_Fecha2 = "0"+(new Integer(mes_fecha2)).toString();
		}else{
			sMes_Fecha2 = (new Integer(mes_fecha2)).toString();
		}
		int dia_fecha2 =sd.gOS("fech_10_dia2").length()==0?-1:sd.gI("fech_10_dia2");
		String sdia_fecha2= "";
		if(dia_fecha2 <10){
			sdia_fecha2 = "0"+(new Integer(dia_fecha2)).toString();
		}else{
			sdia_fecha2 = (new Integer(dia_fecha2)).toString();
		}
		int anio_fecha2 =sd.gOS("fech_10_anio2").length()==0?-1:sd.gI("fech_10_anio2");
		String sanio_fecha2= "";
		if(anio_fecha2 <10){
			sanio_fecha2 = "0"+(new Integer(anio_fecha2)).toString();
		}else{
			sanio_fecha2 = (new Integer(anio_fecha2)).toString();
		}
		int hora_fecha2 =sd.gOS("fech_" +cod_pregunta + "_hora").length()==0?hh:sd.gI("fech_" +cod_pregunta + "_hora");
		String shora_fecha2= "";
		if(hora_fecha2 <10){
			shora_fecha2 = "0"+(new Integer(hora_fecha2)).toString();
		}else{
			shora_fecha2 = (new Integer(hora_fecha2)).toString();
		}
        
        String insert_pregunta = "INSERT INTO RESPUESTA_PREGUNTA"
            + "(M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        //String insert_pregunta_tipo = "INSERT INTO RESP_FECHA"
        //    + " (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA,M6_FECHA_RESPUESTA)"
        //    + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
        //    + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
        //    + sd.gOS("fech_" +cod_pregunta + "_hora")+", " TO_DATE('"+sdia_fecha2+sMes_Fecha2+sanio_fecha2+shora_fecha2+":00:00','DDMMYYYY HH24:MI:SS') ")";
        
        String insert_pregunta_tipo="";
        if(mes_fecha2<0 || anio_fecha2<0 || dia_fecha2<0){
        	 insert_pregunta_tipo = "INSERT INTO RESP_FECHA (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA)"
            + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
            + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
            + hora_fecha+ ")";
        }else{    
         insert_pregunta_tipo = "INSERT INTO RESP_FECHA (M6_COD_RESPUESTA,M6_COD_PREGUNTA,M6_FECHA,M6_HORA,M6_FECHA_RESPUESTA)"
            + " VALUES (" + cod_respuesta + ","+cod_pregunta + ","
            + " TO_DATE('"+sdia_fecha+sMes_Fecha+sanio_fecha+shora_fecha+":00:00','DDMMYYYY HH24:MI:SS') ,"
            + hora_fecha+ ","
            + " TO_DATE('"+sdia_fecha2+sMes_Fecha2+sanio_fecha2+shora_fecha2+":00:00','DDMMYYYY HH24:MI:SS'))";
        }    
        rtdo += "=" + insert_pregunta + ";=" + insert_pregunta_tipo + ";";
        return rtdo;
    }
    
    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Grupos en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean Onjeto que contiene los datos de la pregunta
     * @param i
     * @param cod_respuesta String que es el cdigo de respuesta
     *
     * @throws ProcletException
     */
    private static String guardarRptaGrupos(ProcletServiceData sd,
            q53PreguntaBean preguntaBean, int i, String cod_respuesta)
            throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        String rtdo = "";

        PSP.sqlProclet(sd, "formato_tmp=SELECT n7_tipo formato FROM pr_grupos WHERE n7_cod_pregunta=" + cod_pregunta);
        String insert_pregunta = "=INSERT INTO RESPUESTA_PREGUNTA"
            + " (M1_COD_RESPUESTA,M1_COD_PREGUNTA,M1_TIPO_PREGUNTA)"
            + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + tipo_pregunta + ")";
        rtdo += insert_pregunta + ";";
        
        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_GRUPO_2)) {
            // Pregunta de grupos con formato de dos campos, 'Numero de personas'.
            String cadena_insert = "";
            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_1()");
            String grp1 = sd.gOS("grp_" + cod_pregunta + "_2_1");
            if (grp1.equals("")) {
                grp1 = "0";
            }
            cadena_insert += "=INSERT INTO RESP_GRUPOS"
                + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", 1, " + grp1 + ", 0);";

            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_2()");
            String grp2 = sd.gOS("grp_" + cod_pregunta + "_2_2");
            if (grp2.equals("")) {
                grp2 = "0";
            }
            cadena_insert += "=INSERT INTO RESP_GRUPOS"
                + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", 2, 0, " + grp2 + ");";

            //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
            //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
            int intGrp1 = Integer.valueOf(grp1).intValue();
            int intGrp2 = Integer.valueOf(grp2).intValue();
            int totalPersonas = intGrp1 + intGrp2;
            String codOpcion = "1"; //Por defecto la opcion es 'Solo'
            if (totalPersonas > 1) {
                codOpcion = "2"; //Si el nmero de personas es ms de 1 la opcin es 'Grupo'
            }
            cadena_insert += "=INSERT INTO RESP_OPCIONES"
                + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                + " VALUES (" + cod_respuesta + ", " + cod_pregunta + ", " + codOpcion + ");";

            //Aadimos en la tabla RESPUESTA el nmero de personas que han contestado a esta encuesta
            //para disponer de esta informacion mas facilmente a la hora de realizar las estadisticas
            cadena_insert += "=UPDATE RESPUESTA "
                + " SET M0_PERSONAS = " + totalPersonas
                + " WHERE M0_COD_RESPUESTA=" + cod_respuesta + ";";
            rtdo += cadena_insert;
        }

        else if (sd.gOS("formato_tmp.formato").equals("5")) {
            // Pregunta de grupos con formato de cinco campos, 'Grupos de edad'.
            String cadena_insert = "";
            String cadena_update ="";
            String grpH = "";
            String grpM = "";
            String grpT = "";
            boolean bMostrador = true;
            
            for (int j = 1; j < 6; j++) {
                
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j + "_H()");
                grpH = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_H");
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j + "_M()");
                grpM = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_M");
                
                if (grpH.equals("")) {
                    grpH = "0";
                }
                if (grpM.equals("")) {
                    grpM = "0";
                }
                
                
                cadena_insert += "=INSERT INTO RESP_GRUPOS"
                    + " (N9_COD_RESPUESTA,N9_COD_PREGUNTA,N9_COD_GRUPO,N9_HOMBRES,N9_MUJERES)"
                    + " VALUES (" + cod_respuesta + "," + cod_pregunta + ", " + j + ", " + grpH + ", " + grpM + ");";
								
                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();
                int total = intGrpH + intGrpM;
                
                if (total > 0) {
                    cadena_insert += "=INSERT INTO RESP_OPCIONES"
                        + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                        + " VALUES (" + cod_respuesta + "," + cod_pregunta + "," + j + ");";
                    bMostrador = false;
                }
            }
            
            if (bMostrador) {
                grpH = sd.gOS("grp_2_2_1");
                
                grpM = sd.gOS("grp_2_2_2");
                
                if (grpH.equals("")) {
                    grpH = "0";
                }
                
                if (grpM.equals("")) {
                    grpM = "0";
                }
                cadena_update += "=UPDATE RESP_GRUPOS"
                    + " SET N9_HOMBRES="+grpM+","
                    + " N9_MUJERES="+grpH
                    + " WHERE N9_COD_RESPUESTA= "+cod_respuesta
                    + " AND N9_COD_PREGUNTA="+cod_pregunta
                    + " AND N9_COD_GRUPO=5;";
                
                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();
                int total = intGrpH + intGrpM;
                if (total > 0) {
                    cadena_insert += "=INSERT INTO RESP_OPCIONES"
                        + " (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)"
                        + " VALUES (" + cod_respuesta + "," + cod_pregunta + ",5);";
                    bMostrador = false;
                }
            }

            rtdo += cadena_insert;
            rtdo += cadena_update;
            
        }
        return rtdo;
    }

    /**
     * Mtod para insertar una nueva respuesta en la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina String que es el codigo de la oficina
     * @param usuario Strin que es el codigo del usuario que realiza la
     *        encuesta
     * @param gvCodEncuesta String que es el codigo de la encuesta del g.v.
     * @param gvCodVersion String que es el codigo de la version de la encuesta
     *        del g.v.
     *
     * @return
     *
     * @throws ProcletException
     */
    public static String setRespuestaEncGV(ProcletServiceData sd,
            String codOficina, String usuario, String gvCodEncuesta,
            String gvCodVersion,String encuesta) throws ProcletException {
        q53RespuestaBean respuestaBean = new q53RespuestaBean();
        q53LogEstadisticas.printLog("ENTRA");
        // insert del registro respuesta...
        String select_cod_rpta = "SELECT SEQ_RESPUESTA.NEXTVAL COD_RESPUESTA FROM DUAL";
        String insert_rpta="";
        String ofiPadre=q53Util.getPadreOficina(sd,codOficina);
        if(encuesta.equals("pres")){
        	insert_rpta = "INSERT INTO RESPUESTA"
            + " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_VERSION,M0_COD_OFI_PADRE)"
            + " VALUES (${preg_gv_cod_rpta.cod_respuesta}, '" + gvCodEncuesta + "', '" + gvCodVersion + "',"
            + " sysdate, '" + codOficina + "', '" + usuario + "', ${preg_gv_cod_rpta.cod_respuesta}, 0,'pres',2,'"+ofiPadre+"')";
        }else{
        	insert_rpta = "INSERT INTO RESPUESTA"
            + " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_VERSION,M0_COD_OFI_PADRE)"
            + " VALUES (${preg_gv_cod_rpta.cod_respuesta}, '" + gvCodEncuesta + "', '" + gvCodVersion + "',"
            + " sysdate, '" + codOficina + "', '" + usuario + "', ${preg_gv_cod_rpta.cod_respuesta}, 0,'nopres',2,'"+ofiPadre+"')";        
        }
        
        q53LogEstadisticas.printLog("select_cod_rpta y tambien insert_rpta=" + select_cod_rpta + ";=" + insert_rpta +" <-");
        PSP.sqlProclet(sd, "preg_gv_cod_rpta=" + select_cod_rpta + ";=" + insert_rpta);
        String codRespuesta = sd.gOS("preg_gv_cod_rpta.cod_respuesta");
        return codRespuesta;
    }
    
    /**
     * Mtod para insertar una nueva respuesta en la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina String que es el codigo de la oficina
     * @param usuario Strin que es el codigo del usuario que realiza la
     *        encuesta
     * @param codEncuestaOfi String que es el codigo de la encuesta propia de
     *        la oficina.
     * @param codVersionEncOfi String que es el codigo de la version de la
     *        encuesta propia de la oficina
     * @param respRDAsociada String que es el codigo de la respuesta Rd
     *        asociada
     *
     * @return
     *
     * @throws ProcletException
     */
    public static String setRespuestaEncOfi(ProcletServiceData sd,
            String codOficina, String usuario, String codEncuestaOfi,
            String codVersionEncOfi, String respRDAsociada,String encuesta)
            throws ProcletException {
        // insert del registro respuesta...
        String select_cod_rpta = "SELECT SEQ_RESPUESTA.NEXTVAL COD_RESPUESTA FROM DUAL";
        String cod_ofi_padre=q53Util.getPadreOficina(sd,codOficina);
        String selectEncuestados = "SELECT M0_PERSONAS AS PERSONAS"
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=0"
            + " AND M0_COD_VERSION=1"
            + " AND M0_COD_RESPUESTA=" + respRDAsociada;
        String insert_rpta = "INSERT INTO RESPUESTA"
        + " (M0_COD_RESPUESTA,M0_COD_ENCUESTA,M0_COD_VERSION,M0_FECHA,M0_COD_OFICINA,M0_COD_PERSONA,M0_COD_RESPUESTA_RD, M0_PERSONAS,M0_TIPO_ENCUESTA,M0_COD_OFI_PADRE)"
        + " VALUES (${preg_ofi_cod_rpta.cod_respuesta}, " + codEncuestaOfi + ", " + codVersionEncOfi + ","
        + " sysdate, '" + codOficina + "', " + usuario + ", ${respuesta_rd_asociada}, ${encuestados.personas},'"+encuesta+"','"+cod_ofi_padre+"')";
        q53LogEstadisticas.printLog("select_cod_rpta y tambien selectEncuestados y tambien insert_rpta = ->" + select_cod_rpta + ";encuestados=" + selectEncuestados + ";=" + insert_rpta +" <-");
        PSP.sqlProclet(sd, "preg_ofi_cod_rpta=" + select_cod_rpta + ";encuestados=" + selectEncuestados + ";=" + insert_rpta);
        // q53LogEstadisticas.printLog("sd.gOS(preg_ofi_cod_rpta.cod_respuesta):::-" + sd.gOS("preg_ofi_cod_rpta.cod_respuesta") + "-");
        String codRespOfi = sd.gOS("preg_ofi_cod_rpta.cod_respuesta");
        return codRespOfi;
    }
    
    /**
     * Mtodo que nos devuelve los datos del numero de rspuestas y los codigos
     * de respuesrta mximo y mnimo de la lista de respuesta filtrada por
     * fechas en el caso de la encuesta del g.v. y sin filtrar en el caso dela
     * encuesta propia de la oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param fechaInicio String que es la fecha de inicio (rellenada por el
     *        usuario)
     * @param fechaFin String ue es la fecha de fin (rellenada por el usuario)
     * @param codEncuesta String que es el codigo de la encuesta propia de la
     *        oficina.
     * @param codVersion String que es el codigo de la version de la encuesta
     *        propia de la oficina
     * @param codOficina String que es el codigo de la oficina (para el caso de
     *        la encuesta propia de la oficina)
     *
     * @return q53RespuestaBean objeto que contiene los datos
     *
     * @throws ProcletException
     */
    public static q53RespuestaBean getRespuestasDataFilterByDate(
            ProcletServiceData sd, String fechaInicio, String fechaFin,
            String codEncuesta, String codVersion, String codOficina)
            throws ProcletException {
        q53RespuestaBean respuestBean = null;
        
        String select_resp = "resp[]=SELECT COUNT(M0_COD_RESPUESTA) COUNT_COD_RESPUESTA,"
            + " MIN(M0_COD_RESPUESTA) MIN_COD_RESPUESTA, MAX(M0_COD_RESPUESTA) MAX_COD_RESPUESTA "
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=" + codEncuesta 
            + " AND M0_COD_VERSION=" + codVersion;    
        if ((codOficina != null) && !codOficina.equals("")) {
            select_resp += " AND M0_COD_OFICINA='" + codOficina + "'";
        }
        if (fechaInicio!=null && fechaFin!=null && fechaInicio.equals("") && fechaFin.equals("")) {
        // nada, se queda como esta
        } else {
            select_resp += " AND m0_fecha >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')"
                + " AND  m0_fecha <= TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS')";
        }
        select_resp += " ORDER BY M0_COD_RESPUESTA DESC ";
        // q53LogEstadisticas.printLog("select_resp::::"+select_resp);
        PSP.sqlProclet(sd, select_resp);
        int numRespOfi = sd.gI("resp[0].count_cod_respuesta");
        if (numRespOfi > 0) {
            respuestBean = new q53RespuestaBean();
            respuestBean.setNumRespuestas(numRespOfi);
            respuestBean.setCodEncuesta(codEncuesta);
            respuestBean.setCodOficina(codOficina);
            respuestBean.setMaxCodRespuesta(sd.gOS("resp[0].max_cod_respuesta"));
            respuestBean.setMinCodRespuesta(sd.gOS("resp[0].min_cod_respuesta"));
        }
        return respuestBean;
    }


 /**
     * Mtodo que nos devuelve los datos del numero de rspuestas y los codigos
     * de respuesrta mximo y mnimo de la lista de respuesta filtrada por
     * fechas en el caso de la encuesta del g.v. y sin filtrar en el caso dela
     * encuesta propia de la oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param fechaInicio String que es la fecha de inicio (rellenada por el
     *        usuario)
     * @param fechaFin String ue es la fecha de fin (rellenada por el usuario)
     * @param codEncuesta String que es el codigo de la encuesta propia de la
     *        oficina.
     * @param codVersion String que es el codigo de la version de la encuesta
     *        propia de la oficina
     * @param codOficina String que es el codigo de la oficina (para el caso de
     *        la encuesta propia de la oficina)
     *
     * @return q53RespuestaBean objeto que contiene los datos
     *
     * @throws ProcletException
     */
    public static q53RespuestaBean getRespuestasDataFilterByDateTipo(
            ProcletServiceData sd, String fechaInicio, String fechaFin, 
            String codEncuesta, String codVersion, String codOficina,String tipo,String estado,String ultima)
            throws ProcletException {
        q53RespuestaBean respuestBean = null;
        
        String codigosRespuesta = sd.gOS("codigosRespuesta");
        q53LogEstadisticas.printLog("codigosRespuesta: "+codigosRespuesta);
        String[]arrayCodigosRespuesta = codigosRespuesta.split(" ");
    	
    	int numRespOfi = arrayCodigosRespuesta.length;
    	q53LogEstadisticas.printLog("numRespOfi: "+numRespOfi);
        if (numRespOfi > 0) {
            respuestBean = new q53RespuestaBean();
            respuestBean.setNumRespuestas(numRespOfi);
            respuestBean.setCodEncuesta(codEncuesta);
            respuestBean.setCodOficina(codOficina);
            respuestBean.setEstado(estado);
            respuestBean.setTipoEncuesta(tipo);
            respuestBean.setMaxCodRespuesta(arrayCodigosRespuesta[numRespOfi-1]);
            q53LogEstadisticas.printLog("Maximo: "+arrayCodigosRespuesta[numRespOfi-1]);
    		respuestBean.setMinCodRespuesta(arrayCodigosRespuesta[0]);
    		q53LogEstadisticas.printLog("Minimo: "+arrayCodigosRespuesta[0]);
        }
        return respuestBean;
    }

    /**
     * Metodo para recorer las respuestas de la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param preguntasList Lista de objetos q53PreguntaBean con los datos de
     *        las pregutnas de la encuesta
     * @param cod_respuesta String codigo de la respuesta
     *
     * @return List objeto con la lista de objetos q53RespuestaBean con los
     *         datos de las respuestas
     *
     * @throws ProcletException
     */
    public static List recorrerPreguntasRespuesta(ProcletServiceData sd,
            List preguntasList, String cod_respuesta) throws ProcletException {
            	
            	q53LogEstadisticas.printLog("q53RespuestaBean.recorrerPreguntasRespuesta()");
        List respuestasList = new ArrayList();
        
        int numPregs = preguntasList.size();
        
        for (int i = 0; i < numPregs; i++) {
            q53RespuestaBean respuestabean = new q53RespuestaBean();
            String fechaCreacion = getDateCreationEnc(sd, cod_respuesta);
            respuestabean.setFechaCreacionRespuesta(fechaCreacion);
            
            q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
            String tipo_pregunta = preguntaBean.getTipoPregunta();
            
            if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                q53RespuestaOpcionesBean resOpcionesBean = cogerPreguntaRespuestaOpciones(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setOpcionesBean(resOpcionesBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                q53RespuestaTextoBean respTextoBean = cogerPreguntaRespuestaTexto(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setTextoBean(respTextoBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                List respProcedenciaList = cogerPreguntaRespuestaProcedencia(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setProcedenciaList(respProcedenciaList);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                q53RespuestaFechaBean respFecha = cogerPreguntaRespuestaFecha(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setFechaBean(respFecha);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                q53RespuestaGruposBean respGrupoBean = cogerPreguntaRespuestaGrupos(sd,
                        "pregs", i, cod_respuesta, preguntaBean);
                respuestabean.setGruposBean(respGrupoBean);
            }
            respuestabean.setNombrePersona(buscarNombrePorCodigoRespuesta(sd,cod_respuesta));
            respuestasList.add(respuestabean);
        }
        q53RespuestaBean respuestabean = new q53RespuestaBean();
        respuestabean=meterNotificacion(sd,respuestabean,cod_respuesta);
        respuestasList.add(respuestabean);
        return respuestasList;
    }
    
    /**
     * Mtodo que nos devuelve la fecha de creacin dela respuesta
     *
     * @param sd el onjeto ProcletServiceData
     * @param codRespuesta String con el cdigo de respuesta
     *
     * @return
     *
     * @throws ProcletException
     */
    private static String getDateCreationEnc(ProcletServiceData sd,
            String codRespuesta) throws ProcletException {
        String selectDate = "selectDate[]=SELECT M0_FECHA FROM RESPUESTA WHERE M0_COD_RESPUESTA=" + codRespuesta;
        PSP.sqlProclet(sd, selectDate);
        String fechaCreacion = sd.gOS("selectDate[0].m0_fecha");
        return fechaCreacion;
    }
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo opciones
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaOpcionesBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaOpcionesBean cogerPreguntaRespuestaOpciones(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs+"_"+i+"[]=SELECT N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION, NVL(M2_COD_OPCION, -1) M2_COD_OPCION"
            + " FROM RESP_OPCIONES, PR_OPS_OPCION, PR_OPCIONES"
            + " WHERE N3_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M2_COD_RESPUESTA(+)=" + cod_respuesta
            + " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA"
            + " AND N3_COD_PREGUNTA=M2_COD_PREGUNTA(+)"
            + " AND N3_COD_OPCION=M2_COD_OPCION(+)"
            + " AND N3_ORDEN>=0"
            + " ORDER BY N3_ORDEN;";
        // nota: si la opcin no est en la respuesta, en pregs_i[j].m2_cod_opcion
        // habr un "-". si est en la respuesta tendr el cdigo de la opcion.
        // q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, select_preg);
        int numOpcion = sd.gI("pregs_" + i + ".length");
        List opcionResList = new ArrayList();
        for (int j = 0; j < numOpcion; j++) {
            String respFormato = sd.gOS("pregs_" + i + "[" + j + "].n2_formato");
            String codOpcion = sd.gOS("pregs_" + i + "[" + j + "].n3_cod_opcion");
            String descOpcion = sd.gOS("pregs_" + i + "[" + j + "].n3_descripcion");
            int valueOpcion = sd.gI("pregs_" + i + "[" + j + "].m2_cod_opcion");
            q53OpcionBean opcionBean = new q53OpcionBean();
            opcionBean.setCodOpciones(codOpcion);
            opcionBean.setDescipcionOpcion(descOpcion);
            opcionBean.setValueOpcion(valueOpcion);
            opcionResList.add(opcionBean);
        }

        q53RespuestaOpcionesBean resOpcionesBean = new q53RespuestaOpcionesBean();
        resOpcionesBean.setCodOpciones(opcionResList);
        resOpcionesBean.setFormato(sd.gOS("pregs[0].n2_formato"));

        return resOpcionesBean;
    }
    
    
    public static q53RespuestaOpcionesBean cogerPreguntaOpciones(
            ProcletServiceData sd, String codPregunta) throws ProcletException {
        String select_preg = "pregsopciones[]=SELECT N3_COD_OPCION, N3_DESCRIPCION"
            + " FROM PR_OPS_OPCION, PR_OPCIONES"
            + " WHERE N3_COD_PREGUNTA=" + codPregunta
            + " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA AND N3_ORDEN>=0"
            + " ORDER BY N3_ORDEN;";
        System.out.println(select_preg);
        // nota: si la opcin no est en la respuesta, en pregs_i[j].m2_cod_opcion
        // habr un "-". si est en la respuesta tendr el cdigo de la opcion.
        // q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, select_preg);
        int numOpcion = sd.gI("pregsopciones.length");
        List opcionResList = new ArrayList();
        for (int j = 0; j < numOpcion; j++) {
            String codOpcion = sd.gOS("pregsopciones[" + j + "].n3_cod_opcion");
            String descOpcion = sd.gOS("pregsopciones[" + j + "].n3_descripcion");
            q53OpcionBean opcionBean = new q53OpcionBean();
            opcionBean.setCodOpciones(codOpcion);
            opcionBean.setDescipcionOpcion(descOpcion);
            opcionResList.add(opcionBean);
        }

        q53RespuestaOpcionesBean resOpcionesBean = new q53RespuestaOpcionesBean();
        resOpcionesBean.setCodOpciones(opcionResList);
        resOpcionesBean.setFormato(sd.gOS("pregs[0].n2_formato"));

        return resOpcionesBean;
    }
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo texto
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaTextoBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaTextoBean cogerPreguntaRespuestaTexto(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs + "_" + i + "[]=SELECT M4_TEXTO"
            + " FROM RESP_TEXTO"
            + " WHERE M4_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M4_COD_RESPUESTA=" + cod_respuesta + ";";
        // q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, select_preg);

        String respTexto = sd.gOS("pregs_" + i + "[0].m4_texto");
        q53RespuestaTextoBean respTextoBean = new q53RespuestaTextoBean();
        respTextoBean.setTextoRespuesta(respTexto);

        return respTextoBean;
    }
    
    
    
    
    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo procedencia
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaProcedenciaBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static List cogerPreguntaRespuestaProcedencia(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
       
        List procedenciaList = new ArrayList();
        for(int j=1;j<5;j++){
            int k=j-1;
             String select_pregs = pregs + "_" + i + "[]=SELECT M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
                + " M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
                + " P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS "
                + " FROM MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA"
                + " WHERE M5_COD_PREGUNTA=" + preguntaBean.getCodPregunta() 
                + " AND M5_COD_RESPUESTA=" + cod_respuesta
                + " AND M5_COD_PROCEDENCIA="+j
                + " AND M5_COD_PAIS = P0_COD_PAIS(+)"
                + " AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
                + " AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+)"
                + " AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
                + " AND M5_COD_COMARCA=P4_COD_COMARCA(+);";
             // q53LogEstadisticas.printLog("select_pregs::::"+select_pregs);
            PSP.sqlProclet(sd, select_pregs);
            boolean local = false;

            if (sd.gOS("pregs_" + i + "[0].m5_local").equals("S")) {
                local = true;
            }

            q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
            respProcedenciaBean.setCodComunidad(sd.gOS("pregs_" + i + "[0].m5_cod_comunidad"));
            respProcedenciaBean.setCodComarca(sd.gOS("pregs_" + i + "[0].m5_cod_comarca"));
            respProcedenciaBean.setCodMunicipio(sd.gOS("pregs_" + i + "[0].m5_cod_municipio"));
            respProcedenciaBean.setCodPais(sd.gOS("pregs_" + i + "[0].m5_cod_pais"));
            respProcedenciaBean.setcLocal(sd.gOS("pregs_" + i + "[0].m5_local"));
            respProcedenciaBean.setcPos(sd.gOS("pregs_" + i + "[0].m5_cpos"));
            respProcedenciaBean.setCodTerritorio(sd.gOS("pregs_" + i + "[0].m5_cod_territorio"));
            respProcedenciaBean.setComunidadNameCas(sd.gOS("pregs_" + i + "[0].p1_nombre_cas"));
            respProcedenciaBean.setComunidadNameEus(sd.gOS("pregs_" + i + "[0].p1_nombre_eus"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("pregs_" + i + "[0].p3_nombre_cas"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("pregs_" + i + "[0].p3_nombre_eus"));
            respProcedenciaBean.setPaisNameCas(sd.gOS("pregs_" + i + "[0].p0_nombre_cas"));
            respProcedenciaBean.setPaisNameEus(sd.gOS("pregs_" + i + "[0].p0_nombre_eus"));
            respProcedenciaBean.setTerritorioNameCas(sd.gOS("pregs_" + i + "[0].p2_nombre_cas"));
            respProcedenciaBean.setTerritorioNameEus(sd.gOS("pregs_" + i + "[0].p2_nombre_eus"));
            respProcedenciaBean.setComarcaNameCas(sd.gOS("pregs_" + i + "[0].p4_nombre_cas"));
            respProcedenciaBean.setComarcaNameEus(sd.gOS("pregs_" + i + "[0].p4_nombre_eus"));
            
            if(sd.gOS("pregs_" + i + "[0].m5_num_personas") != null && !(sd.gOS("pregs_" + i + "[0].m5_num_personas").equals(""))){
                respProcedenciaBean.setNumPersonas(sd.gI("pregs_" + i + "[0].m5_num_personas"));
            }else{
                respProcedenciaBean.setNumPersonas(0);
            }
            procedenciaList.add(respProcedenciaBean);
        }

        return procedenciaList;
    }


    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo fecha
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaFechaBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaFechaBean cogerPreguntaRespuestaFecha(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String formato = q53Constantes.FORMATO_FECHA_HORA_CAS; // por defecto en castellano

        if (sd.gOS("q53_cki.q53_idioma").equals(q53Constantes.IDIOMA_EUS)) {
            formato = q53Constantes.FORMATO_FECHA_HORA_EUS;
        }

        String select_preg = pregs + "_" + i + "[]=SELECT TO_CHAR(M6_FECHA,'" + formato + "') M6_FECHA,M6_HORA,TO_CHAR(M6_FECHA_RESPUESTA,'" + formato + "') M6_FECHA_RESPUESTA"
            + " FROM RESP_FECHA"
            + " WHERE M6_COD_PREGUNTA=" + preguntaBean.getCodPregunta()
            + " AND M6_COD_RESPUESTA=" + cod_respuesta + ";";
        // q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, select_preg);

        String fechaResp = sd.gOS("pregs_" + i + "[0].m6_fecha");
        String fechaResp_RESP = sd.gOS("pregs_" + i + "[0].m6_fecha_respuesta");
        int horaResp = 0;

        if ((sd.gOS("pregs_" + i + "[0].m6_hora") != null) && !sd.gOS("pregs_" + i + "[0].m6_hora").equals("")) {
            horaResp = sd.gI("pregs_" + i + "[0].m6_hora");
        }

        q53RespuestaFechaBean respfechaBean = new q53RespuestaFechaBean();
        respfechaBean.setFecha(fechaResp);
        respfechaBean.setHora(horaResp);
        respfechaBean.setFecha_resp(fechaResp_RESP);

        return respfechaBean;
    }

    /**
     * Metodo para recorrer las respuestas de la encuesta de tipo grupos
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return q53RespuestaGruposBean objeto con los datos de la respuesta
     *
     * @throws ProcletException
     */
    private static q53RespuestaGruposBean cogerPreguntaRespuestaGrupos(
            ProcletServiceData sd, String pregs, int i, String cod_respuesta,
            q53PreguntaBean preguntaBean) throws ProcletException {
        String select_preg = pregs + "_" + i + "[]=SELECT N7_TIPO, N8_COD_GRUPO, N8_DESCRIPCION, NVL(N9_COD_GRUPO, -1) N9_COD_GRUPO,"
            + " NVL(N9_HOMBRES, -1) N9_HOMBRES, NVL(N9_MUJERES, -1) N9_MUJERES, N8_TAMANO"
            + " FROM RESP_GRUPOS, PR_GRPS_GRUPO, PR_GRUPOS"
            + " WHERE N8_COD_PREGUNTA=" + preguntaBean.getCodPregunta() 
            + " AND N9_COD_RESPUESTA(+)=" + cod_respuesta 
            + " AND N8_COD_PREGUNTA=N7_COD_PREGUNTA"
            + " AND N8_COD_PREGUNTA=N9_COD_PREGUNTA(+)"
            + " AND N8_COD_GRUPO=N9_COD_GRUPO(+)"
            + " ORDER BY N8_ORDEN;";
        q53LogEstadisticas.printLog("ESTA ES LA SELECT QUE MIRA ENTRE OTRAS COSAS EL NUMERO DE HOMBRES, ...  <-"+select_preg+"->");
        //q53LogEstadisticas.printLog("select_preg::::"+select_preg);
        PSP.sqlProclet(sd, select_preg);

        int numResp = sd.gI("pregs_" + i + ".length");
        List grupoRespList = new ArrayList();

        for (int j = 0; j < numResp; j++) {
            String codGrupo = sd.gOS("pregs_" + i + "[" + j + "].n8_cod_grupo");
            String descGrupo = sd.gOS("pregs_" + i + "[" + j + "].n8_descripcion");
            int valueCodGrupo = sd.gI("pregs_" + i + "[" + j + "].n9_cod_grupo");
            int numHombres = sd.gI("pregs_" + i + "[" + j + "].n9_hombres");
            int numMujeres = sd.gI("pregs_" + i + "[" + j + "].n9_mujeres");
            int tamano = sd.gI("pregs_" + i + "[" + j + "].n8_tamano");

            q53RespuestaGrupoBean respGrupoBean = new q53RespuestaGrupoBean();
            respGrupoBean.setCodOpcion(codGrupo);
            respGrupoBean.setNumHombres(numHombres);
            respGrupoBean.setNumMujeres(numMujeres);
            respGrupoBean.setTamano(tamano);
            respGrupoBean.setValueCodGrupo(valueCodGrupo);
            grupoRespList.add(respGrupoBean);
        }

        q53RespuestaGruposBean resGruposBean = new q53RespuestaGruposBean();
        resGruposBean.setGrupoList(grupoRespList);
        resGruposBean.setTipoGrupo(sd.gOS("pregs_" + i + "[0].n7_tipo"));

        return resGruposBean;
    }
    
    /**
     * Metodo para calcular el numero de respuestas a la encuesta durante un
     * periodo de tiempo
     *
     * @param sd el objeto ProcletServiceData
     * @param cod_respuesta String codigo de la respuesta
     * @param fechaInicio String fecha inicio del periodo
     * @param fechaFin String fecha fin del periodo
     * @param codOficina String codigo dela oficina
     * @param codEncuesta String que es el cdigo de la encuesta
     * @param codVersion String que es el cdigo de la version de la encuesta
     *
     * @return String Numero de respuestas a la encuesta en ese periodo de
     *         tiempo
     *
     * @throws ProcletException
     */
    public static String calcularNumRespuesta(ProcletServiceData sd,
            String cod_respuesta, String fechaInicio, String fechaFin,
            String codOficina, String codEncuesta, String codVersion,String tipo)
            throws ProcletException {
    	q53LogEstadisticas.printLog("cod_respuesta::::"+cod_respuesta);
    	String fechaInicioVis = sd.gOS("fechaInicioVis");
        String fechaFinVis = sd.gOS("fechaFinVis");
    	
        String num_respuesta = "";
        String select_tipo="";
        if(tipo!=null && tipo.length()>0)select_tipo=" AND M0_TIPO_ENCUESTA='"+tipo+"' "; 
        String select = "num_resp[]=SELECT NVL(COUNT(M0_COD_RESPUESTA),0) NUM_RESPUESTA"
            + " FROM RESPUESTA"
            + " WHERE M0_COD_ENCUESTA=" + codEncuesta
            + " AND M0_COD_VERSION=" + codVersion
            + " AND M0_COD_RESPUESTA<" + cod_respuesta+" "+select_tipo;
        if (!fechaInicio.equals("") && !fechaFin.equals("")) {
            select += " AND respuesta.m0_fecha >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')"
                + " AND  respuesta.m0_fecha <= TO_DATE ('" + fechaFin + "', 'DD/MM/YYYY HH24:MI:SS')";
        }else if (!fechaInicioVis.equals("") && !fechaFinVis.equals("")) {
        	select += " AND respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS')"
            + " AND  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "', 'DD/MM/YYYY HH24:MI:SS')";
        }

        if (!q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
            select += " AND M0_COD_OFICINA = '" + codOficina + "'";
        }

        select += ";";
        // q53LogEstadisticas.printLog("select::::"+select);
        PSP.sqlProclet(sd, select);
        num_respuesta = "" + (sd.gI("num_resp[0].num_respuesta") + 1);

        return num_respuesta;
    }
    
   
    
    /**
     * Metodo para calcular el codigo de respuesta que se va a mostrar por
     * panatalla (Paginacion)
     *
     * @param sd el objeto ProcletServiceData
     * @param respuestaBean q53RespuestaBean objeo que contiene los datos de la
     *        respuesta que se esta mostrando actualmente
     * @param fechaInicio String fecha inicio del periodo
     * @param fechaFin String fecha fin del periodo
     * @param codRespuesta String codigo de respuesta
     * @param codVersion String que es el cdigo de a version de la encuesta
     *
     * @return String Codigo de la respuesta que debe aparecer
     *
     * @throws ProcletException
     */
    public static String calcularCodRespuesta(ProcletServiceData sd,
            q53RespuestaBean respuestaBean, String fechaInicio, String fechaFin,
            String codRespuesta, String codVersion) throws ProcletException {
        
        String cod_respuesta = "";
        q53LogEstadisticas.printLog("codigosRespuesta=::::"+sd.gOS("codigosRespuesta"));
        if (sd.gOS("accion").equals(q53Constantes.ACCION_PRIMERA) ||
                codRespuesta.equals("")) {
            // accion es primero o cod_respuesta no viene como parmetro. se coge el cdigo mnimo de
            // las respuestas
            cod_respuesta = respuestaBean.getMinCodRespuesta();
        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ANTERIOR)) {
            // accion es anterior. Se coge el max(cod_respuesta) que sea menor
            // que el cod_respuesta actual. Si es null, se devuelve el mismo
            // cod_respuesta
        	String codigosRespuesta = sd.gOS("codigosRespuesta");
            String[]arrayCodigosRespuesta = codigosRespuesta.split(" ");
            
            for(int i = 0; i < arrayCodigosRespuesta.length; i++){
            	if(arrayCodigosRespuesta[i].equals(codRespuesta)){
            		cod_respuesta = arrayCodigosRespuesta[i-1];
            	}
            }
        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_SIGUIENTE)) {
            // accion es siguiente. Se coge el min(cod_respuesta) que sea mayor
            // que el cod_respuesta actual. Si es null, se devuelve el mismo
            // cod_respuesta
        	String codigosRespuesta = sd.gOS("codigosRespuesta");
            String[]arrayCodigosRespuesta = codigosRespuesta.split(" ");
            
            for(int i = 0; i < arrayCodigosRespuesta.length ; i++){
            	if(arrayCodigosRespuesta[i].equals(codRespuesta)){
            		cod_respuesta = arrayCodigosRespuesta[i+1];
            	}
            }
        } else if (sd.gOS("accion").equals(q53Constantes.ACCION_ULTIMA)) {
            cod_respuesta = respuestaBean.getMaxCodRespuesta();
        } else {
            // cod_respuesta viene como parmetro y no hay accion
            cod_respuesta = sd.gOS("cod_respuesta");
        }
        
        return cod_respuesta;
    }
		
		/**
     * Metodo para recorrer las respuestas de la encuesta de tipo procedencia
     *
     * @param sd el objeto ProcletServiceData
     * @param pregs String
     * @param i
     * @param cod_respuesta String codigo de la respuesta
     * @param preguntaBean Objeto q53PreguntaBean que conitene los datos de la
     *        pregunta
     *
     * @return List procedenciaList objeto con los datos de las procedencia/s
     *
     * @throws ProcletException
     */
    private static List cogerRespuestaProcedencia(
            ProcletServiceData sd, String cod_respuesta) throws ProcletException {
       
        List procedenciaList = new ArrayList();
             String select_pregs = "proc[]=SELECT M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
                + " M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
                + " P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS "
                + " FROM MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA"
                +"  WHERE"
                + " M5_COD_RESPUESTA=" + cod_respuesta
                + " AND M5_COD_PAIS = P0_COD_PAIS(+)"
                + "	AND M5_COD_PAIS = P1_COD_PAIS(+)"
                + " AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
                + " AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+)"
                + " AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
                + " AND M5_COD_COMARCA=P4_COD_COMARCA(+)"
                + "	ORDER BY M5_COD_PROCEDENCIA;";
             // q53LogEstadisticas.printLog("cogerRespuestaProcedencia()::::"+select_pregs);
            PSP.sqlProclet(sd, select_pregs);
            boolean local = false;
            int lon=sd.gI("proc.length");;
						 // q53LogEstadisticas.printLog("LONGITUD!!!!!!!!!"+lon);
					for(int i=0;i<lon;i++){
            q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
            respProcedenciaBean.setCodComunidad(sd.gOS("proc["+i+"].m5_cod_comunidad"));
            respProcedenciaBean.setCodComarca(sd.gOS("proc["+i+"].m5_cod_comarca"));
            respProcedenciaBean.setCodMunicipio(sd.gOS("proc["+i+"].m5_cod_municipio"));
            respProcedenciaBean.setCodPais(sd.gOS("proc["+i+"].m5_cod_pais"));
            respProcedenciaBean.setcLocal(sd.gOS("proc["+i+"].m5_local"));
             // q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("proc["+i+"].m5_local"));
            respProcedenciaBean.setcPos(sd.gOS("proc["+i+"].m5_cpos"));
            respProcedenciaBean.setCodTerritorio(sd.gOS("proc["+i+"].m5_cod_territorio"));
            respProcedenciaBean.setComunidadNameCas(sd.gOS("proc["+i+"].p1_nombre_cas"));
            respProcedenciaBean.setComunidadNameEus(sd.gOS("proc["+i+"].p1_nombre_eus"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("proc["+i+"].p3_nombre_cas"));
            respProcedenciaBean.setMunicipioNameCas(sd.gOS("proc["+i+"].p3_nombre_eus"));
            respProcedenciaBean.setPaisNameCas(sd.gOS("proc["+i+"].p0_nombre_cas"));
            respProcedenciaBean.setPaisNameEus(sd.gOS("proc["+i+"].p0_nombre_eus"));
            respProcedenciaBean.setTerritorioNameCas(sd.gOS("proc["+i+"].p2_nombre_cas"));
            respProcedenciaBean.setTerritorioNameEus(sd.gOS("proc["+i+"].p2_nombre_eus"));
            respProcedenciaBean.setComarcaNameCas(sd.gOS("proc["+i+"].p4_nombre_cas"));
            respProcedenciaBean.setComarcaNameEus(sd.gOS("proc["+i+"].p4_nombre_eus"));
            
            if(sd.gOS("proc[i].m5_num_personas") != null && !(sd.gOS("proc[i].m5_num_personas").equals(""))){
                respProcedenciaBean.setNumPersonas(sd.gI("proc[i].m5_num_personas"));
            }else{
                respProcedenciaBean.setNumPersonas(0);
            }
            procedenciaList.add(respProcedenciaBean);
        }
		//q53LogEstadisticas.printLog("procedenciaList.size::"+procedenciaList.size());
        return procedenciaList;
    }
    
    /**
     * Mtodo que nos devuelve el nombre y apellido de la persona que realiz la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de persona
     *
     * @return String que es el nombre y apellido de la persona
     *
     * @throws ProcletException
     */
    
    private static String buscarNombre(ProcletServiceData sd, String codPersona) throws ProcletException {
    	String respuesta="No existe";
        String selectPersona = "SELECT t03_nousu"
            + " FROM PERSONA"
            + " WHERE T03_COUSU='" + codPersona + "'";
        //q53LogEstadisticas.printLog("selectPersona::::"+selectPersona);
        PSP.sqlProclet(sd, "selectPersona[]=" + selectPersona);
        if(sd.gOS("selectPersona[0].t03_nousu")!=null)
        	respuesta= sd.gOS("selectPersona[0].t03_nousu");
        //q53LogEstadisticas.printLog("respuesta::"+respuesta);
        return respuesta;
        
    }
    
    
    /**
     * Mtodo que nos devuelve el nombre y apellido de la persona que realiz la encuesta
     *
     * @param sd el objeto ProcletServiceData
     * @param codRespuesta String que es el cdigo de la respuesta
     *
     * @return String que es el nombre y apellido de la persona
     *
     * @throws ProcletException
     */
    
    private static String buscarNombrePorCodigoRespuesta(ProcletServiceData sd, String codRespuesta) throws ProcletException {
    	String respuesta="No existe";
        String selectPersona = "SELECT m0_cod_persona"
            + " FROM RESPUESTA"
            + " WHERE m0_cod_respuesta='" + codRespuesta + "'";
        //q53LogEstadisticas.printLog("selectPersona::::"+selectPersona);
        PSP.sqlProclet(sd, "selectPersona[]=" + selectPersona);
        if(sd.gOS("selectPersona[0].m0_cod_persona")!=null){
        	respuesta= sd.gOS("selectPersona[0].m0_cod_persona");
        }else{
            return respuesta;
        }
        respuesta=buscarNombre(sd,respuesta);
        q53LogEstadisticas.printLog("nombre::"+respuesta);
        return respuesta;
        
    }
    
    
    /**
     * Metodo para encontrar todas las respuestas pendientes de respuesta de un tipo de encuesta entre unas fechas
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static List getRespuestasTipoEstadoVis(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo,String ultima,String valor) throws ProcletException {
        List encuestasList = new ArrayList();
        if(tipo.length()==0 || tipo.equals("pres"))return encuestasList;
        String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String select_procedencia="M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
       		+"M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
       		+"P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS,";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND m0_cod_respuesta=m5_cod_respuesta and M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA=P4_COD_COMARCA(+) and (m5_cpos<>0 or m5_local='S' or m5_cod_pais<>0)";
        String join_desc=" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        
        String selectEncuestas = "select M0_COD_RESPUESTA,"+select_procedencia+" to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc
            + " from "+tdesc+"respuesta"+tabla+tabla_procedencia
            + " where ";
            
        String select_oficina=  "M0_COD_OFICINA = '" + codOficina + "'";
              	
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas +=select_oficina+" and";
        }
                	 		
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS')  "
        + " AND  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        	selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";        
				}else if(valor.equals("1")){
					selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY  HH24:MI:SS') desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";   
				}else if(valor.equals("3")){
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by M0_PERSONAS desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";   
				}else{
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by m5_cod_pais desc,p1_nombre_cas desc,M5_local desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";   
				}
        //q53LogEstadisticas.printLog("selectEncuestas::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printSql(selectEncuestas);
        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

           int i=0;
            int p=0;
							List yaesta=new ArrayList();
							while(i<numEnc){
								if(yaesta.contains(new Integer(i))){
									//q53LogEstadisticas.printLog("el array tiene el indice "+i);
									i=i+1;
								}else{
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                //q53LogEstadisticas.printLog("el codigo en "+i+" es:"+sd.gOS("encuestas["+i+"].m0_cod_respuesta"));
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                respuestaBean.setEstado("P");
                respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
                List procedencias = new ArrayList();
              	q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
	            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+i+"].m5_cod_comunidad"));
	            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+i+"].m5_cod_comarca"));
	            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+i+"].m5_cod_municipio"));
	            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+i+"].m5_cod_pais"));
	            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+i+"].m5_local"));
	             		// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("encuestas["+i+"].m5_local"));
	            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+i+"].m5_cpos"));
	            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+i+"].m5_cod_territorio"));
			            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+i+"].p1_nombre_cas"));
			            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+i+"].p1_nombre_eus"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_cas"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_eus"));
			            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+i+"].p0_nombre_cas"));
			            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+i+"].p0_nombre_eus"));
			            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+i+"].p2_nombre_cas"));
			            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+i+"].p2_nombre_eus"));
			            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+i+"].p4_nombre_cas"));
			            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+i+"].p4_nombre_eus"));
            
			            if(sd.gOS("encuestas["+i+"].m5_num_personas") != null && !(sd.gOS("encuestas["+i+"].m5_num_personas").equals(""))){
			                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+i+"].m5_num_personas"));
			            }else{
			                respProcedenciaBean.setNumPersonas(0);
			            }
			            procedencias.add(p,respProcedenciaBean);
			            p++;
			            
              	for(int j=i+1;j<numEnc;j++){
			            	if(cod_respuesta.equals(sd.gOS("encuestas[" + (j) + "].m0_cod_respuesta"))){
			            		yaesta.add(new Integer(j));
			            		//q53LogEstadisticas.printLog("Ha encontrado el mismo codigo:"+sd.gOS("encuestas["+j+"].m0_cod_respuesta"));
		              	 	respProcedenciaBean = new q53RespuestaProcedenciaBean();
			            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+j+"].m5_cod_comunidad"));
			            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+j+"].m5_cod_comarca"));
			            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+j+"].m5_cod_municipio"));
			            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+j+"].m5_cod_pais"));
			            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+j+"].m5_local"));
			             		// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("encuestas["+j+"].m5_local"));
			            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+j+"].m5_cpos"));
			            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+j+"].m5_cod_territorio"));
					            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+j+"].p1_nombre_cas"));
					            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+j+"].p1_nombre_eus"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_cas"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_eus"));
					            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+j+"].p0_nombre_cas"));
					            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+j+"].p0_nombre_eus"));
					            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+j+"].p2_nombre_cas"));
					            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+j+"].p2_nombre_eus"));
					            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+j+"].p4_nombre_cas"));
					            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+j+"].p4_nombre_eus"));
		            
					            if(sd.gOS("encuestas["+j+"].m5_num_personas") != null && !(sd.gOS("encuestas["+j+"].m5_num_personas").equals(""))){
					                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+j+"].m5_num_personas"));
					            }else{
					                respProcedenciaBean.setNumPersonas(0);
					            }
					            procedencias.add(p,respProcedenciaBean);
					            p++;
			          		}
               		}
                respuestaBean.setProcedenciaList(procedencias);
             
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        }
        return encuestasList;
    }

    /**
     * Metodo para encontrar todas las respuestas pendientes de respuesta de un tipo de encuesta entre unas fechas
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static List getRespuestasTipoEstadoAsc(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion,String tipo,String ultima,String valor) throws ProcletException {
        List encuestasList = new ArrayList();
        if(tipo.length()==0 || tipo.equals("pres"))return encuestasList;
        String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String select_procedencia="M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
       		+"M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
       		+"P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS,";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND m0_cod_respuesta=m5_cod_respuesta and M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA=P4_COD_COMARCA(+) and (m5_cpos<>0 or m5_local='S' or m5_cod_pais<>0)";
        String join_desc=" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        
        String selectEncuestas = "select M0_COD_RESPUESTA,"+select_procedencia+" to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc
            + " from "+tdesc+"respuesta"+tabla+tabla_procedencia
            + " where ";
            
        String select_oficina=  "M0_COD_OFICINA = '" + codOficina + "'";
              	
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas +=select_oficina+" and";
        }
                	 		
        String select_fechas=" respuesta.m0_fecha >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS')  "
        + " AND  respuesta.m0_fecha <= TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicio==null || fechaFin==null || fechaInicio.length()==0 || fechaFin.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        	selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') asc";        
				}else if(valor.equals("1")){
					selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') asc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') asc";        
				}else  if(valor.equals("3")){
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by M0_PERSONAS asc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') asc";      
				}else{
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by m5_local desc,m5_cod_pais asc,p1_nombre_cas asc, TO_DATE(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') asc";  
				}
        q53LogEstadisticas.printLog("selectEncuestas::::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printSql(selectEncuestas);
        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            int i=0;
            int p=0;
							List yaesta=new ArrayList();
							while(i<numEnc){
								if(yaesta.contains(new Integer(i))){
									//q53LogEstadisticas.printLog("el array tiene el indice "+i);
									i=i+1;
								}else{
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
                //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
            		respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                respuestaBean.setEstado("P");
                respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
                List procedencias = new ArrayList();
              	q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
	            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+i+"].m5_cod_comunidad"));
	            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+i+"].m5_cod_comarca"));
	            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+i+"].m5_cod_municipio"));
	            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+i+"].m5_cod_pais"));
	            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+i+"].m5_local"));
	             		// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("encuestas["+i+"].m5_local"));
	            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+i+"].m5_cpos"));
	            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+i+"].m5_cod_territorio"));
			            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+i+"].p1_nombre_cas"));
			            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+i+"].p1_nombre_eus"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_cas"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_eus"));
			            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+i+"].p0_nombre_cas"));
			            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+i+"].p0_nombre_eus"));
			            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+i+"].p2_nombre_cas"));
			            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+i+"].p2_nombre_eus"));
			            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+i+"].p4_nombre_cas"));
			            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+i+"].p4_nombre_eus"));
            
			            if(sd.gOS("encuestas[i].m5_num_personas") != null && !(sd.gOS("encuestas[i].m5_num_personas").equals(""))){
			                respProcedenciaBean.setNumPersonas(sd.gI("encuestas[i].m5_num_personas"));
			            }else{
			                respProcedenciaBean.setNumPersonas(0);
			            }
			            procedencias.add(respProcedenciaBean);
			            
              	for(int j=i+1;j<numEnc;j++){
			            	if(cod_respuesta.equals(sd.gOS("encuestas[" + (j) + "].m0_cod_respuesta"))){
			            		yaesta.add(new Integer(j));
			            		respProcedenciaBean = new q53RespuestaProcedenciaBean();
			            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+j+"].m5_cod_comunidad"));
			            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+j+"].m5_cod_comarca"));
			            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+j+"].m5_cod_municipio"));
			            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+j+"].m5_cod_pais"));
			            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+j+"].m5_local"));
			            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+j+"].m5_cpos"));
			            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+j+"].m5_cod_territorio"));
					            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+j+"].p1_nombre_cas"));
					            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+j+"].p1_nombre_eus"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_cas"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_eus"));
					            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+j+"].p0_nombre_cas"));
					            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+j+"].p0_nombre_eus"));
					            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+j+"].p2_nombre_cas"));
					            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+j+"].p2_nombre_eus"));
					            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+j+"].p4_nombre_cas"));
					            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+j+"].p4_nombre_eus"));
		            
					            if(sd.gOS("encuestas["+j+"].m5_num_personas") != null && !(sd.gOS("encuestas["+j+"].m5_num_personas").equals(""))){
					                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+j+"].m5_num_personas"));
					            }else{
					                respProcedenciaBean.setNumPersonas(0);
					            }
					            procedencias.add(p,respProcedenciaBean);
					            p++;
			          		}
               		}
                respuestaBean.setProcedenciaList(procedencias);
             
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        }
        return encuestasList;
    }
    /**
     * Metodo para encontrar todas las respuestas pendientes de respuesta de un tipo de encuesta entre unas fechas
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static List getRespuestasTipoEstadoVisAsc(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo,String ultima,String valor) throws ProcletException {  
        List encuestasList = new ArrayList();
        if(tipo.length()==0 || tipo.equals("pres"))return encuestasList;
        String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String select_procedencia="M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
       		+"M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS, P2_NOMBRE_CAS, P2_NOMBRE_EUS,"
       		+"P3_NOMBRE_CAS, P3_NOMBRE_EUS, M5_NUM_PERSONAS, M5_COD_COMARCA, P4_NOMBRE_CAS, P4_NOMBRE_EUS,M5_CPOS,";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND m0_cod_respuesta=m5_cod_respuesta and M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA=P4_COD_COMARCA(+) and (m5_cpos<>0 or m5_local='S' or m5_cod_pais<>0)";
        String join_desc=" AND M0_COD_RESPUESTA=M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        
        String selectEncuestas = "select M0_COD_RESPUESTA,"+select_procedencia+" to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA "+campo_desc
            + " from "+tdesc+"respuesta"+tabla+tabla_procedencia
            + " where ";
            
        String select_oficina=  "M0_COD_OFICINA = '" + codOficina + "'";
              	
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas +=select_oficina+" and";
        }
        
        if ((ultima != null) && !ultima.equals("")) {
       	  List ultimas=getUltimaRespuestaPendiente(sd,codOficina,codEncuesta,
          codVersion, tipo); 
       	  return ultimas;
       }
                	 		
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS')  "
        + " AND  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        q53LogEstadisticas.printLog("select_fechas::::"+select_fechas);
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
         /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        
        q53LogEstadisticas.printLog("slect_fechas::::"+select_fechas);
        
        if(valor.equals("2")){
        	selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";        
				}else if(valor.equals("1")){
					selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";  
				}else  if(valor.equals("3")){
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by M0_PERSONAS asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";  
				}else{
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
                + " order by m5_local desc,m5_cod_pais asc,p1_nombre_cas asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";  
				}
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printSql(selectEncuestas);
        if (sd.gI("encuestas.length") > 0) {
            int numEnc = sd.gI("encuestas.length");

            int i=0;
            int p=0;
							List yaesta=new ArrayList();
							while(i<numEnc){
								if(yaesta.contains(new Integer(i))){
									i=i+1;
								}else{
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);         
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                respuestaBean.setEstado("P");
                respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
                List procedencias = new ArrayList();
              	q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
	            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+i+"].m5_cod_comunidad"));
	            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+i+"].m5_cod_comarca"));
	            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+i+"].m5_cod_municipio"));
	            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+i+"].m5_cod_pais"));
	            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+i+"].m5_local"));
	            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+i+"].m5_cpos"));
	            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+i+"].m5_cod_territorio"));
			            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+i+"].p1_nombre_cas"));
			            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+i+"].p1_nombre_eus"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_cas"));
			            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+i+"].p3_nombre_eus"));
			            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+i+"].p0_nombre_cas"));
			            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+i+"].p0_nombre_eus"));
			            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+i+"].p2_nombre_cas"));
			            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+i+"].p2_nombre_eus"));
			            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+i+"].p4_nombre_cas"));
			            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+i+"].p4_nombre_eus"));
            
			            if(sd.gOS("encuestas["+i+"].m5_num_personas") != null && !(sd.gOS("encuestas["+i+"].m5_num_personas").equals(""))){
			                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+i+"].m5_num_personas"));
			            }else{
			                respProcedenciaBean.setNumPersonas(0);
			            }
			            procedencias.add(p,respProcedenciaBean);
			            p++;
			            
              	for(int j=i+1;j<numEnc;j++){
			            	if(cod_respuesta.equals(sd.gOS("encuestas[" + (j) + "].m0_cod_respuesta"))){
			            		yaesta.add(new Integer(j));
   		              	 	    respProcedenciaBean = new q53RespuestaProcedenciaBean();
			            		respProcedenciaBean.setCodComunidad(sd.gOS("encuestas["+j+"].m5_cod_comunidad"));
			            		respProcedenciaBean.setCodComarca(sd.gOS("encuestas["+j+"].m5_cod_comarca"));
			            		respProcedenciaBean.setCodMunicipio(sd.gOS("encuestas["+j+"].m5_cod_municipio"));
			            		respProcedenciaBean.setCodPais(sd.gOS("encuestas["+j+"].m5_cod_pais"));
			            		respProcedenciaBean.setcLocal(sd.gOS("encuestas["+j+"].m5_local"));
			            		respProcedenciaBean.setcPos(sd.gOS("encuestas["+j+"].m5_cpos"));
			            		respProcedenciaBean.setCodTerritorio(sd.gOS("encuestas["+j+"].m5_cod_territorio"));
					            respProcedenciaBean.setComunidadNameCas(sd.gOS("encuestas["+j+"].p1_nombre_cas"));
					            respProcedenciaBean.setComunidadNameEus(sd.gOS("encuestas["+j+"].p1_nombre_eus"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_cas"));
					            respProcedenciaBean.setMunicipioNameCas(sd.gOS("encuestas["+j+"].p3_nombre_eus"));
					            respProcedenciaBean.setPaisNameCas(sd.gOS("encuestas["+j+"].p0_nombre_cas"));
					            respProcedenciaBean.setPaisNameEus(sd.gOS("encuestas["+j+"].p0_nombre_eus"));
					            respProcedenciaBean.setTerritorioNameCas(sd.gOS("encuestas["+j+"].p2_nombre_cas"));
					            respProcedenciaBean.setTerritorioNameEus(sd.gOS("encuestas["+j+"].p2_nombre_eus"));
					            respProcedenciaBean.setComarcaNameCas(sd.gOS("encuestas["+j+"].p4_nombre_cas"));
					            respProcedenciaBean.setComarcaNameEus(sd.gOS("encuestas["+j+"].p4_nombre_eus"));
		            
					            if(sd.gOS("encuestas["+j+"].m5_num_personas") != null && !(sd.gOS("encuestas["+j+"].m5_num_personas").equals(""))){
					                respProcedenciaBean.setNumPersonas(sd.gI("encuestas["+j+"].m5_num_personas"));
					            }else{
					                respProcedenciaBean.setNumPersonas(0);
					            }
					            procedencias.add(p,respProcedenciaBean);
					            p++;
			          		}
               		}
                respuestaBean.setProcedenciaList(procedencias);
             
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        }
        return encuestasList;
    }

    
    
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de introduccion ascendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static String getCodigosRespuestaEstadoAsc(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor) throws ProcletException {
				
    	if(tipo.length()==0)tipo="pres";
		q53LogEstadisticas.printLog("OFICINA:"+codOficina);
		String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND M0_COD_RESPUESTA = M5_COD_RESPUESTA AND M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA = P4_COD_COMARCA(+) AND (M5_CPOS<>0 OR M5_LOCAL='S' or M5_COD_PAIS<>0)";
        String join_desc=" AND M0_COD_RESPUESTA = M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        if(tipo.equals("pres")){tabla="";join="";join_desc="";campo_desc="";tdesc="";}
        
        if ((ultima != null) && !ultima.equals("")) {
        	String select_ultima = "select_ultima[] = SELECT MAX(M0_COD_RESPUESTA)M0_COD_RESPUESTA FROM RESP_TEXTO,respuesta"+tabla+" WHERE";
            select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
            		+ " AND M0_COD_RESPUESTA=M6_COD_RESPUESTA"
            		+ " AND M0_COD_VERSION='" + codVersion + "'" 
            		+ " AND M0_TIPO_ENCUESTA='" + tipo + "'"
            		+ " AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'"
                    + " AND M0_COD_OFICINA = '" + codOficina + "'";
            
            q53LogEstadisticas.printLog("select_ultima "+select_ultima);
            PSP.sqlProclet(sd, select_ultima);
        	
            return sd.gOS("select_ultima[0].m0_cod_respuesta");
        }
        
        String codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA, TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM "+tdesc+" RESPUESTA"+tabla+tabla_procedencia+" WHERE ";
        if ((codOficina != null) && !codOficina.equals("")) {
        	codigos_respuesta += "M0_COD_OFICINA = '" + codOficina + "' AND ";
        }            	
        int[]  codigosRespuestaAux;	
        
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        + "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicio==null || fechaFin==null || fechaInicio.length()==0 || fechaFin.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc"; 
        }else if(valor.equals("1")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";    
		}else if(valor.equals("3")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY M0_PERSONAS asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";  
		}else{
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY m5_local desc,m5_cod_pais asc,p1_nombre_cas asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc"; 
		}
        q53LogEstadisticas.printLog("codigos_respuesta "+codigos_respuesta);
        PSP.sqlProclet(sd, codigos_respuesta);
        String  codigosRespuesta = "";
        if(sd.gI("codigos_respuesta.length") > 0){
        	codigosRespuestaAux=new int[sd.gI("codigos_respuesta.length")];
        	codigosRespuestaAux[0] = sd.gI("codigos_respuesta[0].m0_cod_respuesta");
            int kont = 1;
            for(int i = 1; i < sd.gI("codigos_respuesta.length"); i++){
            	int a = 0;
            	for(int k = 0; k < kont; k++){
            		if(codigosRespuestaAux[k] ==  sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta")){
            			a = 1;
            		}
            	}
            	if(a == 0){
            		codigosRespuestaAux[kont] = sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta");
            		kont++;
            	}
            }
            for(int h = 0; h < kont; h++){
            	codigosRespuesta += codigosRespuestaAux[h]+" ";
            	q53LogEstadisticas.printLog("codigosRespuesta: "+codigosRespuesta);
            }
        }
        
        return codigosRespuesta; 
    }
    
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de introduccion descendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static String getCodigosRespuestaEstadoDesc(ProcletServiceData sd, String codOficina,
            String fechaInicio, String fechaFin, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor) throws ProcletException {
				
    	if(tipo.length()==0)tipo="pres";
		q53LogEstadisticas.printLog("OFICINA:"+codOficina);
		String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
		String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND M0_COD_RESPUESTA = M5_COD_RESPUESTA AND M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA = P4_COD_COMARCA(+) AND (M5_CPOS<>0 OR M5_LOCAL='S' or M5_COD_PAIS<>0)";
        String join_desc=" AND M0_COD_RESPUESTA = M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        if(tipo.equals("pres")){tabla="";join="";join_desc="";campo_desc="";tdesc="";}
        
        if ((ultima != null) && !ultima.equals("")) {
        	String select_ultima = "select_ultima[] = SELECT MAX(M0_COD_RESPUESTA)M0_COD_RESPUESTA FROM RESP_TEXTO,respuesta"+tabla+" WHERE";
            select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
            		+ " AND M0_COD_RESPUESTA=M6_COD_RESPUESTA"
            		+ " AND M0_COD_VERSION='" + codVersion + "'" 
            		+ " AND M0_TIPO_ENCUESTA='" + tipo + "'"
            		+ " AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'"
                    + " AND M0_COD_OFICINA = '" + codOficina + "'";
            
            q53LogEstadisticas.printLog("select_ultima "+select_ultima);
            PSP.sqlProclet(sd, select_ultima);
        	
            return sd.gOS("select_ultima[0].m0_cod_respuesta");
        }
        
        String codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA, TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM "+tdesc+" RESPUESTA"+tabla+tabla_procedencia+" WHERE ";
        if ((codOficina != null) && !codOficina.equals("")) {
        	codigos_respuesta += "M0_COD_OFICINA = '" + codOficina + "' AND ";
        }            	
        int[]  codigosRespuestaAux;	
        
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicio + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        + "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFin + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicio==null || fechaFin==null || fechaInicio.length()==0 || fechaFin.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc"; 
        }else if(valor.equals("1")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";    
		}else if(valor.equals("3")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY M0_PERSONAS desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";  
		}else{
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY m5_local desc,m5_cod_pais desc,p1_nombre_cas desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS')desc"; 
		}
        q53LogEstadisticas.printLog("codigos_respuesta = "+codigos_respuesta);
        PSP.sqlProclet(sd, codigos_respuesta);
        String  codigosRespuesta = "";
        if(sd.gI("codigos_respuesta.length") > 0){
        	codigosRespuestaAux=new int[sd.gI("codigos_respuesta.length")];
        	codigosRespuestaAux[0] = sd.gI("codigos_respuesta[0].m0_cod_respuesta");
            int kont = 1;
            for(int i = 1; i < sd.gI("codigos_respuesta.length"); i++){
            	int a = 0;
            	for(int k = 0; k < kont; k++){
            		if(codigosRespuestaAux[k] ==  sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta")){
            			a = 1;
            		}
            	}
            	if(a == 0){
            		codigosRespuestaAux[kont] = sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta");
            		kont++;
            	}
            }
            for(int h = 0; h < kont; h++){
            	codigosRespuesta += codigosRespuestaAux[h]+" ";
            	q53LogEstadisticas.printLog("codigosRespuesta: "+codigosRespuesta);
            }
        }
        
        return codigosRespuesta; 
    }
    
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de visita ascendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static String getCodigosRespuestaEstadoVisAsc(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor) throws ProcletException {
				
    	if(tipo.length()==0)tipo="pres";
		q53LogEstadisticas.printLog("OFICINA:"+codOficina);
		String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND M0_COD_RESPUESTA = M5_COD_RESPUESTA AND M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA = P4_COD_COMARCA(+) AND (M5_CPOS<>0 OR M5_LOCAL='S' or M5_COD_PAIS<>0)";
        String join_desc=" AND M0_COD_RESPUESTA = M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        if(tipo.equals("pres")){tabla="";join="";join_desc="";campo_desc="";tdesc="";}
        
        if ((ultima != null) && !ultima.equals("")) {
        	String select_ultima = "select_ultima[] = SELECT MAX(M0_COD_RESPUESTA)M0_COD_RESPUESTA FROM RESP_TEXTO,respuesta"+tabla+" WHERE";
            select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
            		+ " AND M0_COD_RESPUESTA=M6_COD_RESPUESTA"
            		+ " AND M0_COD_VERSION='" + codVersion + "'" 
            		+ " AND M0_TIPO_ENCUESTA='" + tipo + "'"
            		+ " AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'"
                    + " AND M0_COD_OFICINA = '" + codOficina + "'";
            
            q53LogEstadisticas.printLog("select_ultima "+select_ultima);
            PSP.sqlProclet(sd, select_ultima);
        	
            return sd.gOS("select_ultima[0].m0_cod_respuesta");
        }
        
        String codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA, TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM "+tdesc+" RESPUESTA"+tabla+tabla_procedencia+" WHERE ";
        if ((codOficina != null) && !codOficina.equals("")) {
        	codigos_respuesta += "M0_COD_OFICINA = '" + codOficina + "' AND ";
        }            	
        int[]  codigosRespuestaAux;	
        
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        + "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc"; 
        }else if(valor.equals("1")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";    
		}else if(valor.equals("3")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY M0_PERSONAS asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc";  
		}else{
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY m5_local desc,m5_cod_pais asc,p1_nombre_cas asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') asc"; 
		}
        q53LogEstadisticas.printLog("codigos_respuesta "+codigos_respuesta);
        PSP.sqlProclet(sd, codigos_respuesta);
        String  codigosRespuesta = "";
        if(sd.gI("codigos_respuesta.length") > 0){
        	codigosRespuestaAux=new int[sd.gI("codigos_respuesta.length")];
        	codigosRespuestaAux[0] = sd.gI("codigos_respuesta[0].m0_cod_respuesta");
            int kont = 1;
            for(int i = 1; i < sd.gI("codigos_respuesta.length"); i++){
            	int a = 0;
            	for(int k = 0; k < kont; k++){
            		if(codigosRespuestaAux[k] ==  sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta")){
            			a = 1;
            		}
            	}
            	if(a == 0){
            		codigosRespuestaAux[kont] = sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta");
            		kont++;
            	}
            }
            for(int h = 0; h < kont; h++){ 
            	codigosRespuesta += codigosRespuestaAux[h]+" ";
            	q53LogEstadisticas.printLog("codigosRespuesta: "+codigosRespuesta);
            }
        }
        
        return codigosRespuesta; 
    }
    
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de visita descendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    
    public static String getCodigosRespuestaEstadoVisDesc(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor) throws ProcletException {
				
    	if(tipo.length()==0)tipo="pres";
		q53LogEstadisticas.printLog("OFICINA:"+codOficina);
		String select_estado=" AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'";
        String tabla=",resp_fecha";
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA";
        String join=" AND M0_COD_RESPUESTA=M6_COD_RESPUESTA";
        String join_procedencia=" AND M0_COD_RESPUESTA = M5_COD_RESPUESTA AND M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA = P4_COD_COMARCA(+) AND (M5_CPOS<>0 OR M5_LOCAL='S' or M5_COD_PAIS<>0)";
        String join_desc=" AND M0_COD_RESPUESTA = M4_COD_RESPUESTA(+) ";
        String campo_desc=",NVL(M4_TEXTO,'') M4_TEXTO ";
        String tdesc="( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+") RESP_TEXTO,";
        if(tipo.equals("pres")){tabla="";join="";join_desc="";campo_desc="";tdesc="";}
        
        if ((ultima != null) && !ultima.equals("")) {
        	String select_ultima = "select_ultima[] = SELECT MAX(M0_COD_RESPUESTA)M0_COD_RESPUESTA FROM RESP_TEXTO,respuesta"+tabla+" WHERE";
            select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
            		+ " AND M0_COD_RESPUESTA=M6_COD_RESPUESTA"
            		+ " AND M0_COD_VERSION='" + codVersion + "'" 
            		+ " AND M0_TIPO_ENCUESTA='" + tipo + "'"
            		+ " AND DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R')='P'"
                    + " AND M0_COD_OFICINA = '" + codOficina + "'";
            
            q53LogEstadisticas.printLog("select_ultima "+select_ultima);
            PSP.sqlProclet(sd, select_ultima);
        	
            return sd.gOS("select_ultima[0].m0_cod_respuesta");
        }
        
        String codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA, TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM "+tdesc+" RESPUESTA"+tabla+tabla_procedencia+" WHERE ";
        if ((codOficina != null) && !codOficina.equals("")) {
        	codigos_respuesta += "M0_COD_OFICINA = '" + codOficina + "' AND ";
        }            	
        int[]  codigosRespuestaAux;	
        
        String select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        + "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc"; 
        }else if(valor.equals("1")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + select_estado + tipo + "' "+join+" "+join_desc+" "+join_procedencia
		+ " ORDER BY TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";    
		}else if(valor.equals("3")){
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY M0_PERSONAS desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') desc";  
		}else{
		codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "'"+select_estado+join+join_desc+" "+join_procedencia
		+ " ORDER BY m5_local desc,m5_cod_pais desc,p1_nombre_cas desc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS')desc"; 
		}
        q53LogEstadisticas.printLog("codigos_respuesta "+codigos_respuesta);
        PSP.sqlProclet(sd, codigos_respuesta);
        String  codigosRespuesta = "";
        if(sd.gI("codigos_respuesta.length") > 0){
        	codigosRespuestaAux=new int[sd.gI("codigos_respuesta.length")];
        	codigosRespuestaAux[0] = sd.gI("codigos_respuesta[0].m0_cod_respuesta");
            int kont = 1;
            for(int i = 1; i < sd.gI("codigos_respuesta.length"); i++){
            	int a = 0;
            	for(int k = 0; k < kont; k++){
            		if(codigosRespuestaAux[k] ==  sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta")){
            			a = 1;
            		}
            	}
            	if(a == 0){
            		codigosRespuestaAux[kont] = sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta");
            		kont++;
            	}
            }
            for(int h = 0; h < kont; h++){
            	codigosRespuesta += codigosRespuestaAux[h]+" ";
            	q53LogEstadisticas.printLog("codigosRespuesta: "+codigosRespuesta);
            }
        }
        
        return codigosRespuesta; 
    }
  
    
    
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de visita ascendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    //Funcion para mantener la compatibilidad hacia atras
    public static String getCodigosRespuestaGlobal(ProcletServiceData sd, String codOficina,
													            String fechaInicioVis, String fechaFinVis, String codEncuesta,
													            String codVersion,String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario) throws ProcletException {						    
   	return getCodigosRespuestaGlobal(sd, codOficina,fechaInicioVis, fechaFinVis, codEncuesta, codVersion,  tipo, ultima, valor, orden, tipo_respuesta,usuario, "");
    } 
    //Funcion para mantener la compatibilidad hacia atras, con 2 parametros menos que antes siempre eran 0 y 1...
    public static String getCodigosRespuestaGlobal(ProcletServiceData sd, String codOficina,
													            String fechaInicioVis, String fechaFinVis, 
																	String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario, String cp) throws ProcletException {
    	return getCodigosRespuestaGlobal(sd, codOficina,fechaInicioVis, fechaFinVis, "0", "1",  tipo, ultima, valor, orden, tipo_respuesta,usuario, cp);
    }
   
    /**
     * Metodo para encontrar todos los codigos de respuestas de un tipo de encuesta entre unas fechas de visita ascendentemente
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     * @param cp
     *
     * @return List objeto con la lista de codigos de respuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
     public static String getCodigosRespuestaGlobal(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario, String cp) throws ProcletException {
    	if(tipo.length()==0)tipo="pres";		
    	// Busqueda por codigo postal
    	String[] codigopostal = new String[] {"",""};
    	if (("nopres".equals(tipo))) codigopostal = getSelectBusquedaCP(sd.gOS("cp"));
    	// busqueda por codigo postal
		q53LogEstadisticas.printLog("OFICINA:"+codOficina);
		String codUsuario=null;
    	if(!usuario.equals("0")){
    	   //String selectUsuario="select t03_cousu from PERSONA where t03_nousu='"+usuario+"'";
    	   //PSP.sqlProclet(sd, "usuario[]=" + selectUsuario);
    	   codUsuario=usuario;
    	}
        String tabla_procedencia=",MUNICIPIO, TERRITORIO, COMUNIDAD, PAIS, RESP_PROCEDENCIA,COMARCA " + codigopostal[0].toString();
        String join_procedencia=" AND M0_COD_RESPUESTA = M5_COD_RESPUESTA AND M5_COD_PAIS = P0_COD_PAIS(+)"
					+"AND M5_COD_PAIS = P1_COD_PAIS(+) AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+)"
					+"AND M5_COD_TERRITORIO = P2_COD_TERRITORIO(+) AND M5_COD_MUNICIPIO = P3_COD_MUNICIPIO(+)"
					+"AND M5_COD_COMARCA = P4_COD_COMARCA(+) AND (M5_CPOS<>0 OR M5_LOCAL='S' or M5_COD_PAIS<>0)" + codigopostal[1];
        String join="";
		  String tabla="";
		  String join_desc="";
		  String campo_desc="";
		  String tdesc="";
        //if(tipo.equals("pres")){tabla="";join="";join_desc="";campo_desc="";tdesc="";}//ya estan vacias...
        if(valor.equals("4")){
        	tabla_procedencia="";
        	join_procedencia="";
        }
        if ((ultima != null) && !ultima.equals("")) {
        	String select_ultima = "select_ultima[] = SELECT MAX(M0_COD_RESPUESTA)M0_COD_RESPUESTA FROM RESPUESTA  WHERE";
            select_ultima+=" M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                    + " AND M0_COD_VERSION='" + codVersion + "'" 
                    + " AND M0_TIPO_ENCUESTA='" + tipo + "'"
                    + " AND M0_COD_OFICINA = '" + codOficina + "'";
            if(!usuario.equals("0")){
                    select_ultima+= " AND M0_COD_PERSONA='"+codUsuario+"'";
            }
            q53LogEstadisticas.printLog("select_ultima "+select_ultima);
            PSP.sqlProclet(sd, select_ultima);
        	
            return sd.gOS("select_ultima[0].m0_cod_respuesta");
        }
        String codigos_respuesta=null;
        if(!usuario.equals("0")){
        	codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA,t03_nousu,TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM PERSONA, "+tdesc+" RESPUESTA"+tabla+tabla_procedencia+" WHERE M0_COD_PERSONA=t03_cousu(+) AND M0_COD_PERSONA='"+codUsuario+"' AND ";
        }else{
        	codigos_respuesta = "codigos_respuesta[] = SELECT M0_COD_RESPUESTA,t03_nousu,TO_CHAR(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA, TO_CHAR(M0_FECHA_RESP,'DD/MM/YYYY HH24:MI:SS') M0_FECHA_RESP FROM PERSONA, "+tdesc+  " RESPUESTA"+tabla+tabla_procedencia+" WHERE M0_COD_PERSONA=t03_cousu(+) AND ";
        }
        if ((codOficina != null) && !codOficina.equals("")) {
        	codigos_respuesta += "M0_COD_OFICINA = '" + codOficina + "' AND ";
        }            	
        int[]  codigosRespuestaAux;	
        
        String select_fechas="";
        if(!(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0))
        		if(tipo_respuesta.equals("vis")){
        				select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
							+ "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        // }else{ Cambio por si se busca solo por provincia en pres
        		}else if (tipo_respuesta.equals("gra")){
        				select_fechas=" respuesta.m0_fecha >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
							+ "  respuesta.m0_fecha <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        		}
        codigos_respuesta += select_fechas
        + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
        + " AND M0_COD_VERSION='" + codVersion + "'"
        + " AND M0_TIPO_ENCUESTA='" + tipo + "' "+join+" "+join_desc+" "+join_procedencia;
		  /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        if(valor.equals("2")){
        	  	codigos_respuesta +=" ORDER BY TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden; 
        }else if(valor.equals("1")){
        		codigos_respuesta +=" ORDER BY TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
        }else if(valor.equals("3")){
				codigos_respuesta +=" ORDER BY M0_PERSONAS asc, TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;  
			}else if(valor.equals("4")){
				codigos_respuesta +=" order by t03_nousu "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
			}
        q53LogEstadisticas.printLog("codigos_respuesta consulta "+codigos_respuesta);
        PSP.sqlProclet(sd, codigos_respuesta);
        q53LogEstadisticas.printLog("despues de la consulta, longitud= "+sd.gI("codigos_respuesta.length"));
        String  codigosRespuesta = "";
        if(sd.gI("codigos_respuesta.length") > 0){
        	codigosRespuestaAux= new int[sd.gI("codigos_respuesta.length")];	
        	codigosRespuestaAux[0] = sd.gI("codigos_respuesta[0].m0_cod_respuesta");
            int kont = 1;
            for(int i = 1; i < sd.gI("codigos_respuesta.length"); i++){
            	int a = 0;
            	for(int k = 0; k < kont; k++){
            		if(codigosRespuestaAux[k] ==  sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta")){
            			a = 1;
            		}
            	}
            	if(a == 0){
            		codigosRespuestaAux[kont] = sd.gI("codigos_respuesta["+i+"].m0_cod_respuesta");
            		kont++;
            	}
            }
            for(int h = 0; h < kont; h++){
            	codigosRespuesta += codigosRespuestaAux[h]+" ";
            }
        }
        q53LogEstadisticas.printLog("codigos_respuesta "+codigosRespuesta);
        //SI LA OPCION ELEGIDA ES LA DE ORDENAR POR PROCEDENCIA
        if(valor.equals("5")){
        //PARTE DE LA ORDENACION POR PROCEDENCIA DE LOS CODIGOS DE RESPUESTA       
	        String [] campos = codigosRespuesta.split("\\s+");  
	        List encuestasList=new ArrayList();
	        q53RespuestaBean respuestaBean;
	        for(int j=0;j<campos.length;j++){  
	        	respuestaBean = new q53RespuestaBean();
	        	List procedencias=cogerRespuestaProcedencia(sd,campos[j]);
	        	respuestaBean.setCodRespuesta(campos[j]);
	        	respuestaBean.setProcedenciaList(procedencias);
	            encuestasList.add(respuestaBean);             
	        }
	        q53LogEstadisticas.printLog("antes de ordenar por procedencia codrespuestaglobal");
        	  String nombre1,nombre2;
	        int EncSizeMenosUno=encuestasList.size()-1;
	        int EncSize=encuestasList.size();
	    	for(int k=0;k<EncSize;k++){
	    		for(int w=0;w<EncSizeMenosUno;w++){
	    			nombre1=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w),q53Util.getIdioma(sd));
	    			nombre2=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w+1),q53Util.getIdioma(sd));
	    			int comparacion=nombre1.compareTo(nombre2);
	    			if(orden.equals("asc")){
	        			if(comparacion>0){
	        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
	        				encuestasList.remove(w+2);	        	  
	        			}  	  
	    			}else{
	    				if(comparacion<0){
	        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
	        				encuestasList.remove(w+2);	        	  
	        			}  	  
	    			}
	    		}
	    	}
	    	q53RespuestaBean r;
	        codigosRespuesta="";
	        q53LogEstadisticas.printLog("despues de ordenar por procedencia codrespuestaglobal");
	        for(int l=0;l<encuestasList.size();l++){
	        	r=(q53RespuestaBean)encuestasList.get(l);
	        	codigosRespuesta+=r.getCodRespuesta()+" ";
	        }
		//FIN PARTE DE LA ORDENACION POR PROCEDENCIA DE LOS CODIGOS DE RESPUESTA
        }     
       
        return codigosRespuesta; 
    }      
    
    
    
    /**
     * Metodo para encontrar todas las respuestas de un tipo de encuesta entre unas fechas pero haciendolo por partes (en varias select)
     * para intentar decrementar el tiempo de ejecucion de la consulta
     *
     * @param sd
     * @param codOficina Codigo de la oficina
     * @param fechaInicio Fecha Inicio
     * @param fechaFin Fecha Fin
     * @param codEncuesta
     * @param codVersion
     * @param tipo
     *
     * @return List objeto con la lista de encuestas que estan en ese periodo
     *
     * @throws ProcletException
     */
    
    /*
    public static List getRespuestasNuevo(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis, String codEncuesta,
            String codVersion,String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario) throws ProcletException {
    	long milisegundos;
    	String codUsuario=null;
    	if(!usuario.equals("0")){
    	   //String selectUsuario="select t03_cousu from PERSONA where t03_nousu='"+usuario+"'";
    	   //PSP.sqlProclet(sd, "usuario[]=" + selectUsuario);
    	   codUsuario=usuario;
    	}
		if(tipo.length()==0)tipo="pres";
        String selectEncuestas = "select M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA,t03_nousu";
            selectEncuestas+=" from respuesta,respuesta_pregunta,PERSONA";  
            q53LogEstadisticas.printLog("usuario:"+usuario);
            if(!usuario.equals("0")){
            	selectEncuestas+=" where M0_COD_RESPUESTA=M1_COD_RESPUESTA AND M1_COD_PREGUNTA='3200' AND M0_COD_PERSONA=t03_cousu(+)AND M0_COD_PERSONA='"+codUsuario+"'";
            }else{
            	selectEncuestas+=" where M0_COD_RESPUESTA=M1_COD_RESPUESTA AND M1_COD_PREGUNTA='3200' AND M0_COD_PERSONA=t03_cousu(+)";
            }
            q53LogEstadisticas.printLog("selectEncuestasantes:"+selectEncuestas);       	
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += " AND M0_COD_OFICINA = '" + codOficina + "' and ";
        }            	
        if ((ultima != null) && !ultima.equals("")) {
         	  List ultimas=getUltimaRespuesta(sd,codOficina,codEncuesta,
            codVersion, tipo,codUsuario,usuario); 
         	  return ultimas;
         }
        List  encuestasList=new ArrayList();	
        String select_fechas="";
        if(tipo_respuesta.equals("vis")){
        	select_fechas=" respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        	+ "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        }else{
        	select_fechas=" respuesta.m0_fecha >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        	+ "  respuesta.m0_fecha <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS') AND ";
        }
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
        
        if(valor.equals("2")){
        	selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "' "
					+ " order by TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;       
				}else if(valor.equals("1")){
					selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "' "
					+ " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}else if(valor.equals("3")){
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "' "
					+ " order by M0_PERSONAS "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}else if(valor.equals("4")){
					selectEncuestas += select_fechas
	                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
	                + " AND M0_COD_VERSION='" + codVersion + "'"
	                + " AND M0_TIPO_ENCUESTA='" + tipo + "' "
						+ " order by t03_nousu "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}else{
				selectEncuestas += select_fechas
                + " M0_COD_ENCUESTA = '" + codEncuesta  + "'"
                + " AND M0_COD_VERSION='" + codVersion + "'"
                + " AND M0_TIPO_ENCUESTA='" + tipo + "' ";
					//+ " order by m5_local desc,m5_cod_pais "+orden+",p1_nombre_cas "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden+"";    
				}
        q53LogEstadisticas.printLog("selectEncuestas::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printLog("despues de selectEncuestas");
        if (sd.gI("encuestas.length") > 0) {
	            int numEnc = sd.gI("encuestas.length");
	            int i=0;
	            int p=0;
				List yaesta=new ArrayList();
				while(i<numEnc){
					if(yaesta.contains(new Integer(i))){
					i=i+1;
					}else{				
                q53RespuestaBean respuestaBean = new q53RespuestaBean();
                respuestaBean.setCodEncuesta(codEncuesta);                                
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                //q53LogEstadisticas.printLog("el codigo en "+i+" es:"+sd.gOS("encuestas["+i+"].m0_cod_respuesta"));
                respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                respuestaBean.setCodRespuesta(cod_respuesta);
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	            	respuestaBean.setNombrePersona(sd.gOS("encuestas[" + i + "].t03_nousu"));
	            	//q53LogEstadisticas.printLog("el nombre es:"+buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
	            	
                respuestaBean.setCodVersion(codVersion);
                respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3");
                String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");
                respuestaBean.setMedioRecepEnc(medioRecepcion);
                respuestaBean.setIdiomaEnc(idiomaResp);
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                if(tipo.equals("pres")){
                	respuestaBean.setEstado("R");
                	respuestaBean.setDescripcion("");
              	}else{
              		//meter select para comprobar el estado de la encuesta con ese codigo de respuesta
              		selectEncuestas = "SELECT DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R') estado FROM RESP_FECHA WHERE M6_COD_RESPUESTA='"+cod_respuesta+"'";
                    PSP.sqlProclet(sd, "estado[]=" + selectEncuestas);
              		respuestaBean.setEstado(sd.gOS("estado[0].estado"));    
              	    //meter select para coger el texto de la descripcion con ese codigo de respuesta
              		selectEncuestas = "SELECT NVL(M4_TEXTO,'') M4_TEXTO FROM ( SELECT NVL(M4_TEXTO,'') M4_TEXTO ,M4_COD_RESPUESTA FROM RESP_TEXTO WHERE M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+")RESP_TEXTO WHERE M4_COD_RESPUESTA='"+cod_respuesta+"' ";
                    PSP.sqlProclet(sd, "descripcion[]=" + selectEncuestas);
              		respuestaBean.setDescripcion(sd.gOS("descripcion[0].m4_texto"));
              	}
              //meter select para coger las procedencias con ese codigo de respuesta (convendria meter las p ya de paso, es decir, hacer un join)
                List procedencias=cogerRespuestaProcedencia(sd,cod_respuesta);
                respuestaBean.setProcedenciaList(procedencias);
             	//q53LogEstadisticas.printLog("la list tiene: "+respuestaBean.getProcedenciaList().size());
                //q53LogEstadisticas.printLog("en el bean el nombre es:"+respuestaBean.getNombrePersona());
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        } 
        //SI LA OPCION ELEGIDA ES LA DE ORDENAR POR PROCEDENCIA
        if(valor.equals("5")){
        	//q53LogEstadisticas.printLog("antes de ordenar por procedencia");
	        //PARTE DEL ORDENAMIENTO POR PROCEDENCIAS POR EL METODO DE LA BURBUJA
	            String nombre1,nombre2;
	            int EncSizeMenosUno=encuestasList.size()-1;
	            int EncSize=encuestasList.size();
	        	for(int k=0;k<EncSize;k++){
	        		for(int w=0;w<EncSizeMenosUno;w++){
	        			nombre1=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w),q53Util.getIdioma(sd));
	        			nombre2=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w+1),q53Util.getIdioma(sd));
	        			int comparacion=nombre1.compareTo(nombre2);
	        			if(orden.equals("asc")){
		        			if(comparacion>0){
		        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
		        				encuestasList.remove(w+2);	        	  
		        			}  	  
	        			}else{
	        				if(comparacion<0){
		        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
		        				encuestasList.remove(w+2);	        	  
		        			}  	  
	        			}
	        		}
	        	}
	        //FIN PARTE DEL ORDENAMIENTO POR PROCEDENCIAS POR EL METODO DE LA BURBUJA
        }
        return encuestasList;
    }
    
    */
    public static List getRespuestasNuevo(ProcletServiceData sd, String codOficina,
											            String fechaInicioVis, String fechaFinVis, String codEncuesta,
											            String codVersion,String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario) throws ProcletException {
     	return getRespuestasNuevo(sd,codOficina, fechaInicioVis, fechaFinVis, tipo, ultima, valor, orden, tipo_respuesta, usuario);
     }
     
    public static List getRespuestasNuevo(ProcletServiceData sd, String codOficina,
            String fechaInicioVis, String fechaFinVis,String tipo, String ultima,String valor,String orden,String tipo_respuesta,String usuario) throws ProcletException {
            	q53LogEstadisticas.printLog("---------getRespuestasNuevo-----------");
            	q53LogEstadisticas.printLog("codOficina:"+codOficina);
            	q53LogEstadisticas.printLog("fechaInicioVis:"+fechaInicioVis);
            	q53LogEstadisticas.printLog("fechaFinVis:"+fechaFinVis);
            	q53LogEstadisticas.printLog("tipo:"+tipo);
            	q53LogEstadisticas.printLog("ultima:"+ultima);
            	q53LogEstadisticas.printLog("valor:"+valor);
            	q53LogEstadisticas.printLog("orden:"+orden);
            	q53LogEstadisticas.printLog("tipo_respuesta:"+tipo_respuesta);
            	q53LogEstadisticas.printLog("usuario:"+usuario);
    	String codUsuario=null;
    	if(!usuario.equals("0")){
    	   //String selectUsuario="select t03_cousu from PERSONA where t03_nousu='"+usuario+"'";
    	   //PSP.sqlProclet(sd, "usuario[]=" + selectUsuario);
    	   codUsuario=usuario;
    	}
    	String codEncuesta = "0";
    	String codVersion="1";
    	// Busqueda por codigo postal
    	String[] codigopostal = new String[] {"",""};
    	if (("nopres".equals(tipo))) codigopostal = getSelectBusquedaCP(sd.gOS("cp"));
    	// busqueda por codigo postal
		if(tipo.length()==0)tipo="pres";
        String selectEncuestas = "select M0_COD_RESPUESTA,to_char(M0_FECHA,'DD/MM/YYYY HH24:MI:SS') M0_FECHA,"
            +" M0_COD_PERSONA, to_char(M0_FECHA_resp,'DD/MM/YYYY HH24:MI:SS') m0_fecha_resp, M0_PERSONAS, M0_TIPO_ENCUESTA," +
            		"t03_nousu ";
            selectEncuestas+=" from respuesta,respuesta_pregunta,PERSONA " + codigopostal[0];  
            q53LogEstadisticas.printLog("usuario:"+usuario);
            if(!usuario.equals("0")){
            	selectEncuestas+=" where M0_COD_RESPUESTA=M1_COD_RESPUESTA AND M1_COD_PREGUNTA='3200' AND M0_COD_PERSONA=t03_cousu(+)AND M0_COD_PERSONA='"+codUsuario+"'";
            }else{
            	selectEncuestas+=" where M0_COD_RESPUESTA=M1_COD_RESPUESTA AND M1_COD_PREGUNTA='3200' AND M0_COD_PERSONA=t03_cousu(+)";
            }
            q53LogEstadisticas.printLog("selectEncuestasantes:"+selectEncuestas);
        if ((codOficina != null) && !codOficina.equals("")) {
            selectEncuestas += " AND M0_COD_OFICINA = '" + codOficina + "'";
        }            	
        if ((ultima != null) && !ultima.equals("")) {
         	  List ultimas=getUltimaRespuesta(sd,codOficina,codEncuesta,
            codVersion, tipo,codUsuario,usuario); 
         	  return ultimas;
         }
        List  encuestasList=new ArrayList();	
        String select_fechas="";
        if(tipo_respuesta.equals("vis")){
        	select_fechas=" and respuesta.m0_fecha_resp >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        	+ "  respuesta.m0_fecha_resp <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS')";
        //}else{ Ahi que cmbiar esto por que se puede buscar por provincia y no por fecha
        }else if(tipo_respuesta.equals("gra")){
        	select_fechas=" and respuesta.m0_fecha >= TO_DATE ('" + fechaInicioVis + "', 'DD/MM/YYYY HH24:MI:SS') AND "
        	+ "  respuesta.m0_fecha <= TO_DATE ('" + fechaFinVis + "','DD/MM/YYYY HH24:MI:SS')";
        }
        
        if(fechaInicioVis==null || fechaFinVis==null || fechaInicioVis.length()==0 || fechaFinVis.length()==0)select_fechas="";
        /*dependiendo del orden pulsado, se ordena de una forma u otra*/
        selectEncuestas += select_fechas
        					+ " AND M0_COD_ENCUESTA = '" + codEncuesta  + "'"
							+ " AND M0_COD_VERSION='" + codVersion + "'"
							+ " AND M0_TIPO_ENCUESTA='" + tipo + "' ";
        selectEncuestas += codigopostal[1]; // busqueda por provincia
        if(valor.equals("2")){
		  		selectEncuestas += " order by TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;       
		  }else if(valor.equals("1")){
		  		selectEncuestas += " order by TO_DATE(m0_fecha_resp,'DD/MM/YYYY HH24:MI:SS') "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}else if(valor.equals("3")){
					selectEncuestas += " order by M0_PERSONAS "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}else if(valor.equals("4")){
					selectEncuestas += " order by t03_nousu "+orden+", TO_DATE(m0_fecha,'DD/MM/YYYY HH24:MI:SS') "+orden;    
				}
        q53LogEstadisticas.printLog("selectEncuestas::"+selectEncuestas);
        PSP.sqlProclet(sd, "encuestas[]=" + selectEncuestas);
        q53LogEstadisticas.printLog("despues de selectEncuestas");
        if (sd.gI("encuestas.length") > 0) {
	            int numEnc = sd.gI("encuestas.length");
	            q53LogEstadisticas.printLog("numEnc:"+numEnc);
	            int i=0;
	            int p=0;
				List yaesta=new ArrayList();
				while(i<numEnc){
					if(yaesta.contains(new Integer(i))){
						i=i+1;
					}else{
						q53RespuestaBean respuestaBean = new q53RespuestaBean();
	                		String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
		                respuestaBean.rellenarBeanParaBusquedas(sd, "encuestas[" + i + "]", codOficina, tipo);
		                if(tipo.equals("pres")){
				                	respuestaBean.setEstado("R");
				                	respuestaBean.setDescripcion("");
		              	}else{
		              		selectEncuestas = "SELECT NVL(M4_TEXTO,'') M4_TEXTO, DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R') estado FROM RESP_FECHA, RESP_TEXTO WHERE M6_COD_RESPUESTA='"+cod_respuesta+"' AND M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+" AND M4_COD_RESPUESTA='"+cod_respuesta+"' ";
		                 		 PSP.sqlProclet(sd, "estado[]=" + selectEncuestas);//OPTM6 esto no es necesario pq no se muestra
		                  	respuestaBean.setEstado(sd.gOS("estado[0].estado"));    
		                  	respuestaBean.setDescripcion(sd.gOS("estado[0].m4_texto"));
		              	}
                /**
                 * 
                 respuestaBean.setCodEncuesta(codEncuesta);                                
                String cod_respuesta=sd.gOS("encuestas[" + i + "].m0_cod_respuesta");
                //q53LogEstadisticas.printLog("el codigo en "+i+" es:"+sd.gOS("encuestas["+i+"].m0_cod_respuesta"));
                respuestaBean.setCodRespuesta(cod_respuesta);
                respuestaBean.setCodOficina(codOficina);
                respuestaBean.setFechaCreacionRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha"));
                respuestaBean.setCodPersona(sd.gOS("encuestas[" + i + "].m0_cod_persona"));
	            //Aqui buscamos el nombre que le corresponde al codigo de persona en la BBDD mediante la funcion buscarNombre()
	             * 
	            	respuestaBean.setNombrePersona(sd.gOS("encuestas[" + i + "].t03_nousu"));
	            	//q53LogEstadisticas.printLog("el nombre es:"+buscarNombre(sd,sd.gOS("encuestas[" + i + "].m0_cod_persona")));
	            	
                respuestaBean.setCodVersion(codVersion);
                //respuestaBean = getOptionsAndGroupsResponse(sd, sd.gOS("encuestas[" + i + "].m0_cod_respuesta"), "2", respuestaBean);
                respuestaBean.setFechaRespuesta(sd.gOS("encuestas[" + i + "].m0_fecha_resp"));
                //String idiomaResp = getOpcionName(sd, respuestaBean.getCodRespuesta(), "4");//////////////////OPT2
                //respuestaBean.setIdiomaEnc(idiomaResp);//////////////////OPT2
                respuestaBean.setTipoEncuesta(sd.gOS("encuestas[" + i + "].m0_tipo_encuesta"));
                respuestaBean.setNumPersonas(sd.gOS("encuestas[" + i + "].m0_personas"));
                if(tipo.equals("pres")){
                	respuestaBean.setEstado("R");
                	respuestaBean.setDescripcion("");
              	}else{
//              	 SOLO NO PRESENCIAL
                  String medioRecepcion = getOpcionName(sd, respuestaBean.getCodRespuesta(), "3"); //////////////////OPT2
                  respuestaBean.setMedioRecepEnc(medioRecepcion);//////////////////OPT2
                  respuestaBean=meterNotificacion(sd,respuestaBean,cod_respuesta);
                  //SOLO NO PRESENCIAL
                  //respuestaBean.setEstado(sd.gOS("encuestas[" + i + "].estado"));
                  //respuestaBean.setDescripcion(sd.gOS("encuestas[" + i + "].m4_texto"));
                  selectEncuestas = "SELECT NVL(M4_TEXTO,'') M4_TEXTO, DECODE((NVL(TO_CHAR(M6_FECHA_RESPUESTA,'DD/MM/YYYY HH24:MI:SS'),'P')),'P','P','R') estado FROM RESP_FECHA, RESP_TEXTO WHERE M6_COD_RESPUESTA='"+cod_respuesta+"' AND M4_COD_PREGUNTA="+q53Util.getLiteral(sd,"PREG_DESC","C")+" AND M4_COD_RESPUESTA='"+cod_respuesta+"' ";
                  PSP.sqlProclet(sd, "estado[]=" + selectEncuestas);//OPTM6 esto no es necesario pq no se muestra
                  respuestaBean.setEstado(sd.gOS("estado[0].estado"));    
                  respuestaBean.setDescripcion(sd.gOS("estado[0].m4_texto"));
                  
          	}*/
                respuestaBean.setProcedenciaList(getProcedenciaParaTablaBusqueda(sd,cod_respuesta)); ////////////////////////////PQ?
             	//q53LogEstadisticas.printLog("la list tiene: "+respuestaBean.getProcedenciaList().size());
                //q53LogEstadisticas.printLog("en el bean el nombre es:"+respuestaBean.getNombrePersona());
                encuestasList.add(respuestaBean);
                i=i+1;
                p=0;
              }
            }
        } 
        q53LogEstadisticas.printLog("rellenadas las respuestas");
        //SI LA OPCION ELEGIDA ES LA DE ORDENAR POR PROCEDENCIA
        if(valor.equals("5")){
        	  q53LogEstadisticas.printLog("antes de ordenar por procedencia");
        	  //Debiera ser quicksort pero como no tarda apenas no lo cambio. 
	        //PARTE DEL ORDENAMIENTO POR PROCEDENCIAS POR EL METODO DE LA BURBUJA
	            String nombre1,nombre2;
	            int EncSizeMenosUno=encuestasList.size()-1;
	            int EncSize=encuestasList.size();
	        	for(int k=0;k<EncSize;k++){
	        		for(int w=0;w<EncSizeMenosUno;w++){
	        			nombre1=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w),q53Util.getIdioma(sd));
	        			nombre2=sacarProcedencia(sd,(q53RespuestaBean)encuestasList.get(w+1),q53Util.getIdioma(sd));
	        			int comparacion=nombre1.compareTo(nombre2);
	        			if(orden.equals("asc")){
		        			if(comparacion>0){
		        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
		        				encuestasList.remove(w+2);	        	  
		        			}  	  
	        			}else{
	        				if(comparacion<0){
		        				encuestasList.add(w,(q53RespuestaBean)encuestasList.get(w+1));
		        				encuestasList.remove(w+2);	        	  
		        			}  	  
	        			}
	        		}
	        	}
	        //FIN PARTE DEL ORDENAMIENTO POR PROCEDENCIAS POR EL METODO DE LA BURBUJA
	        q53LogEstadisticas.printLog("ordenado por preferencias");
        }
        q53LogEstadisticas.printLog("sale");
        return encuestasList;
    }
    
    private static List getProcedenciaParaTablaBusqueda(ProcletServiceData sd, String cod_respuesta) throws ProcletException {

		List procedenciaList = new ArrayList();
		String select_pregs = "proc[]=SELECT M5_LOCAL, M5_COD_PAIS, M5_COD_COMUNIDAD, M5_COD_TERRITORIO,"
				+ " M5_COD_MUNICIPIO, P0_NOMBRE_CAS, P0_NOMBRE_EUS, P1_NOMBRE_CAS, P1_NOMBRE_EUS,"
				+ " M5_NUM_PERSONAS, M5_COD_COMARCA,M5_CPOS FROM COMUNIDAD, PAIS, RESP_PROCEDENCIA WHERE M5_COD_RESPUESTA="
				+ cod_respuesta + " AND M5_COD_PAIS = P0_COD_PAIS(+) AND M5_COD_PAIS = P1_COD_PAIS(+)"
				+ " AND M5_COD_COMUNIDAD = P1_COD_COMUNIDAD(+) ORDER BY M5_COD_PROCEDENCIA;";
		// q53LogEstadisticas.printLog("cogerRespuestaProcedencia()::::"+select_pregs);
		PSP.sqlProclet(sd, select_pregs);
		int lon = sd.gI("proc.length");
		// q53LogEstadisticas.printLog("LONGITUD!!!!!!!!!"+lon);
		for (int i = 0; i < lon; i++) {
			q53RespuestaProcedenciaBean respProcedenciaBean = new q53RespuestaProcedenciaBean();
			respProcedenciaBean.setCodComunidad(sd.gOS("proc[" + i + "].m5_cod_comunidad"));
			respProcedenciaBean.setCodPais(sd.gOS("proc[" + i + "].m5_cod_pais"));
			respProcedenciaBean.setcLocal(sd.gOS("proc[" + i + "].m5_local"));
			// q53LogEstadisticas.printLog("LOCAL!!!!"+sd.gOS("proc["+i+"].m5_local"));
			respProcedenciaBean.setcPos(sd.gOS("proc[" + i + "].m5_cpos"));
			respProcedenciaBean.setCodTerritorio(sd.gOS("proc[" + i + "].m5_cod_territorio"));
			respProcedenciaBean.setComunidadNameCas(sd.gOS("proc[" + i + "].p1_nombre_cas"));
			respProcedenciaBean.setComunidadNameEus(sd.gOS("proc[" + i + "].p1_nombre_eus"));
			respProcedenciaBean.setPaisNameCas(sd.gOS("proc[" + i + "].p0_nombre_cas"));
			respProcedenciaBean.setPaisNameEus(sd.gOS("proc[" + i + "].p0_nombre_eus"));
			procedenciaList.add(respProcedenciaBean);
		}
		//q53LogEstadisticas.printLog("procedenciaList.size::"+procedenciaList.size());
		return procedenciaList;
	}
    
    
    public static String sacarProcedencia(ProcletServiceData sd, q53RespuestaBean respuestaBean,String q53_idioma){ 	
            //q53LogEstadisticas.printLog("entra en sacarProcedencia ");
        	List procs=respuestaBean.getProcedenciaList();
		    String nproc="";
		    if(procs!=null){
			    int lon =procs.size();
			    for(int p=0;p<lon;p++){
		        	q53RespuestaProcedenciaBean proc=(q53RespuestaProcedenciaBean)procs.get(p);
					if(proc.getcLocal().equalsIgnoreCase("S")){
						if(nproc.length()>0)
							{nproc+="-";}
						nproc+="local";
					}else if(proc.getCodPais().length()>0 && proc.getCodPais().equals("10") && proc.getcPos().equals("999")){
						 if(nproc.length()>0){nproc+="-";}
						 nproc+="("+proc.getcPos()+")";
						 if(q53_idioma.equals("C")){nproc+=proc.getPaisNameCas();}else{nproc+=proc.getPaisNameEus();} 
					}else if (proc.getcPos().length()>0 && !proc.getcPos().equals("0")){
						 if(nproc.length()>0){nproc+="-";}
						 nproc+="("+proc.getcPos()+")";
						 if(q53_idioma.equals("C")){nproc+=proc.getComunidadNameCas();}else{nproc+=proc.getComunidadNameEus();}
					}else if(proc.getCodPais().length()>0 && !proc.getCodPais().equals("0") && !proc.getCodPais().equals("10")){
						 if(nproc.length()>0){nproc+="-";}
						 if(!proc.getcPos().equals("0")){nproc+="("+proc.getcPos()+")";}
						 if(q53_idioma.equals("C")){nproc+=proc.getPaisNameCas();}else{nproc+=proc.getPaisNameEus();} 
					}        	
			    }
		    }
		    //q53LogEstadisticas.printLog("devuelve de sacarProcedencia "+nproc);
		    return nproc;
    }
    
    
}
