package itourbaskClases;

import itourbaskBeans.q53ComarcaBean;
import itourbaskBeans.q53ComunidadBean;
import itourbaskBeans.q53MunicipioBean;
import itourbaskBeans.q53OficinaBean;
import itourbaskBeans.q53PaisBean;
import itourbaskBeans.q53TerritorioHistoricoBean;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53LogEstadisticas;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;



public class q53ProcedenciaClass {
    /**
     * Metodo que nos devuelve la lista de los municipios
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
	

    public static List getMunicipiosList(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException{
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";

        // Sacar solo los municipios que tengan oficinas de turismo
        String sel_municipio = "SELECT   p3_cod_municipio, p3_nombre_cas, p3_nombre_eus, p3_cod_territorio, p3_cod_comarca"
                            + " FROM municipio "
                            + " WHERE p3_cod_municipio IN ( "
                                + " SELECT    TO_CHAR (t02_codprovinc, 'FM00') || '_' || TO_CHAR (t02_codmunicip, 'FM0000') cod_municipio "
                                + " FROM oficina "
                                + " WHERE t02_inesta = 'S') "
                            + "ORDER BY p3_cod_territorio, p3_cod_comarca, "+order_by;
        // q53Estlog.log(sd.getLogFilePath(),fileName,"q53estProcedenciaClass:getMunicipiosList()::::"+sel_municipio);
        PSP.sqlProclet(sd, "sel_municipio[]=" + sel_municipio);

        if (sd.gI("sel_municipio.length") > 0) {
            int numMunicipios = sd.gI("sel_municipio.length");

            for (int i = 0; i < numMunicipios; i++) {
                q53MunicipioBean municipioBean = new q53MunicipioBean();
                String codMunicipio = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_municipio");
                String nombreMunicipioCas = sd.gOS("sel_municipio[" + i +
                        "].p3_nombre_cas");
                String nombreMunicipioEus = sd.gOS("sel_municipio[" + i +
                        "].p3_nombre_eus");
                String codTerritorioHist = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_territorio");
                String codComarca = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_comarca");

                municipioBean.setCodMunicipio(codMunicipio);
                municipioBean.setNombreMuniCas(nombreMunicipioCas);
                municipioBean.setNombreMuniEus(nombreMunicipioEus);
                municipioBean.setCodTerritorioHist(codTerritorioHist);
                municipioBean.setCodComarca(codComarca);

                municipiosList.add(municipioBean);
            }
        }

        return municipiosList;
    }

	/**
     * Metodo que nos devuelve la lista de los municipios
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
/* DEPRECATED 22.11.2006 */
    public static List getMunicipiosList(ProcletServiceData sd) throws ProcletException{
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";
        String sel_municipio = "SELECT p3_cod_municipio, p3_nombre_cas,p3_nombre_eus , p3_cod_territorio, p3_cod_comarca FROM municipio ORDER BY p3_cod_territorio, p3_cod_comarca, "+order_by;
		
        PSP.sqlProclet(sd, "sel_municipio[]=" + sel_municipio);

        if (sd.gI("sel_municipio.length") > 0) {
            int numMunicipios = sd.gI("sel_municipio.length");

            for (int i = 0; i < numMunicipios; i++) {
                q53MunicipioBean municipioBean = new q53MunicipioBean();
                String codMunicipio = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_municipio");
                String nombreMunicipioCas = sd.gOS("sel_municipio[" + i +
                        "].p3_nombre_cas");
                String nombreMunicipioEus = sd.gOS("sel_municipio[" + i +
                        "].p3_nombre_eus");
                String codTerritorioHist = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_territorio");
                String codComarca = sd.gOS("sel_municipio[" + i +
                        "].p3_cod_comarca");

                municipioBean.setCodMunicipio(codMunicipio);
                municipioBean.setNombreMuniCas(nombreMunicipioCas);
                municipioBean.setNombreMuniEus(nombreMunicipioEus);
                municipioBean.setCodTerritorioHist(codTerritorioHist);
                municipioBean.setCodComarca(codComarca);

                municipiosList.add(municipioBean);
            }
        }

        return municipiosList;
    }

    /**
     * Mtodo que nos devuelve la lista de Comunidades
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getComunidadesList(ProcletServiceData sd)
        throws ProcletException {
        List comunidadesList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
		String order_by = "p1_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p1_nombre_eus";
		}
        
        if (q53_idioma.equals("E")) order_by = "p1_nombre_eus";
        String sel_comunidad = "SELECT p1_cod_comunidad , p1_nombre_cas ,p1_nombre_eus FROM comunidad ORDER BY p1_cod_comunidad, "+order_by;
        PSP.sqlProclet(sd, "sel_comunidad[]=" + sel_comunidad);

        if (sd.gI("sel_comunidad.length") > 0) {
            int numComunidades = sd.gI("sel_comunidad.length");

            for (int i = 0; i < numComunidades; i++) {
                q53ComunidadBean comunidadBean = new q53ComunidadBean();
                String codComunidad = sd.gOS("sel_comunidad[" + i +
                        "].p1_cod_comunidad");
                String nombreComunidadCas = sd.gOS("sel_comunidad[" + i +
                        "].p1_nombre_cas");
                String nombreComunidadEus = sd.gOS("sel_comunidad[" + i +
                        "].p1_nombre_eus");
                comunidadBean.setCodComunidad(codComunidad);
                comunidadBean.setNombreComunidadCas(nombreComunidadCas);
                comunidadBean.setNombreComunidadEus(nombreComunidadEus);

                comunidadesList.add(comunidadBean);
            }
        }

        return comunidadesList;
    }

    /**
     * Mtodo que nos devuelve la lsita de Territorios histricos
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getTerritorioHistList(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException{
        List territoriosHistList = new ArrayList();
		String q53_idioma = sd.gOS("q53_cki.q53_idioma");
		String order_by = "p2_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p2_nombre_eus";
		}
        String sel_territorio = "SELECT p2_cod_territorio , p2_nombre_cas ,p2_nombre_eus FROM territorio p2_cod_territorio ORDER BY "+order_by;
		// q53Estlog.log(sd.getLogFilePath(),fileName,"q53estProcedenciaClass:getTerritorioHistList()::::"+sel_territorio);
        PSP.sqlProclet(sd, "sel_territorio[]=" + sel_territorio);

        if (sd.gI("sel_territorio.length") > 0) {
            int numMunicipios = sd.gI("sel_territorio.length");

            for (int i = 0; i < numMunicipios; i++) {
                q53TerritorioHistoricoBean territorioHistBean = new q53TerritorioHistoricoBean();
                String codTerritorioHist = sd.gOS("sel_territorio[" + i +
                        "].p2_cod_territorio");
                String nombreTerritorioHistCas = sd.gOS("sel_territorio[" + i +
                        "].p2_nombre_cas");
                String nombreTerritorioHistEus = sd.gOS("sel_territorio[" + i +
                        "].p2_nombre_eus");
                territorioHistBean.setCodTerritorioHist(codTerritorioHist);
                territorioHistBean.setNombreTerritorioHistCas(nombreTerritorioHistCas);
                territorioHistBean.setNombreTerritorioHistEus(nombreTerritorioHistEus);

                territoriosHistList.add(territorioHistBean);
            }
        }

        return territoriosHistList;
    }

	 /**
     * Mtodo que nos devuelve la lsita de Territorios histricos
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getTerritorioHistList(ProcletServiceData sd) throws ProcletException{
        List territoriosHistList = new ArrayList();
		String q53_idioma = sd.gOS("q53_cki.q53_idioma");
		String order_by = "p2_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p2_nombre_eus";
		}
        String sel_territorio = "SELECT p2_cod_territorio , p2_nombre_cas ,p2_nombre_eus FROM territorio p2_cod_territorio ORDER BY "+order_by;
		
        PSP.sqlProclet(sd, "sel_territorio[]=" + sel_territorio);

        if (sd.gI("sel_territorio.length") > 0) {
            int numMunicipios = sd.gI("sel_territorio.length");

            for (int i = 0; i < numMunicipios; i++) {
                q53TerritorioHistoricoBean territorioHistBean = new q53TerritorioHistoricoBean();
                String codTerritorioHist = sd.gOS("sel_territorio[" + i +
                        "].p2_cod_territorio");
                String nombreTerritorioHistCas = sd.gOS("sel_territorio[" + i +
                        "].p2_nombre_cas");
                String nombreTerritorioHistEus = sd.gOS("sel_territorio[" + i +
                        "].p2_nombre_eus");
                territorioHistBean.setCodTerritorioHist(codTerritorioHist);
                territorioHistBean.setNombreTerritorioHistCas(nombreTerritorioHistCas);
                territorioHistBean.setNombreTerritorioHistEus(nombreTerritorioHistEus);

                territoriosHistList.add(territorioHistBean);
            }
        }

        return territoriosHistList;
    }

    /**
     * Mtodo que nos devuelve la lista de Paises
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getPaisesList(ProcletServiceData sd)
        throws ProcletException {
        List paisesList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");

		String order_by = "p0_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p0_nombre_eus";
		}
        
        if (q53_idioma.equals("E")) order_by = "p0_nombre_eus";
        String sel_pais = "SELECT p0_cod_pais, p0_nombre_cas, p0_nombre_eus FROM pais ORDER BY "+order_by;
        PSP.sqlProclet(sd, "sel_pais[]=" + sel_pais);

        if (sd.gI("sel_pais.length") > 0) {
            int numPaises = sd.gI("sel_pais.length");

            for (int i = 0; i < numPaises; i++) {
                q53PaisBean paisBean = new q53PaisBean();
                String codPais = sd.gOS("sel_pais[" + i + "].p0_cod_pais");
                String nombrePaisCas = sd.gOS("sel_pais[" + i +
                        "].p0_nombre_cas");
                String nombrePaisEus = sd.gOS("sel_pais[" + i +
                        "].p0_nombre_eus");

                paisBean.setCodPais(codPais);
                paisBean.setNombrePaisCas(nombrePaisCas);
                paisBean.setNombrePaisEus(nombrePaisEus);

                paisesList.add(paisBean);
            }
        }

        return paisesList;
    }

    /**
     * Mtodo que nos devuelve la lista de Comarcas
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getComarcaList(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException{ 
        List comarcaList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
        String order_by = "p4_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p4_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p4_nombre_eus";
        String sel_comarca = "SELECT   p4_cod_comarca, p4_nombre_cas, p4_nombre_eus, p4_cod_territorio "
                            + " FROM comarca "
                            + " WHERE p4_cod_comarca IN ( "
                                + " SELECT p3_cod_comarca "
                                + " FROM municipio "
                                + " WHERE p3_cod_municipio IN ( "
                                    + " SELECT    TO_CHAR (t02_codprovinc, 'FM00') || '_' || TO_CHAR (t02_codmunicip, 'FM0000') cod_municipio " 
                                    + " FROM oficina " 
                                    + " WHERE t02_inesta = 'S')) " 
                            + " ORDER BY p4_cod_territorio, "+order_by;

		// q53Estlog.log(sd.getLogFilePath(),fileName,"q53estProcedenciaClass:getComarcaList()::::"+sel_comarca);
        PSP.sqlProclet(sd, "sel_comarca[]=" + sel_comarca);

        if (sd.gI("sel_comarca.length") > 0) {
            int numComarcas = sd.gI("sel_comarca.length");

            for (int i = 0; i < numComarcas; i++) {
                q53ComarcaBean comarcaBean = new q53ComarcaBean();
                String codComrca = sd.gOS("sel_comarca[" + i + "].p4_cod_comarca");
                String nombreComarcaCas = sd.gOS("sel_comarca[" + i +
                        "].p4_nombre_cas");
                String nombreComarcaEus = sd.gOS("sel_comarca[" + i +
                        "].p4_nombre_eus");
                
                String codTerritorioHist = sd.gOS("sel_comarca[" + i +
                        "].p4_cod_territorio");

                comarcaBean.setCodComarca(codComrca);
                comarcaBean.setNombreComarcaCas(nombreComarcaCas);
                comarcaBean.setNombreComarcaEus(nombreComarcaEus);
                comarcaBean.setCodTerritorioHist(codTerritorioHist);

                comarcaList.add(comarcaBean);
            }
        }

        return comarcaList;
    }
    

	/**
     * Mtodo que nos devuelve la lista de Comarcas
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getComarcaList(ProcletServiceData sd) throws ProcletException{ 
        List comarcaList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
        String order_by = "p4_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p4_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p4_nombre_eus";
        String sel_comarca = "SELECT p4_cod_comarca ,p4_nombre_cas , p4_nombre_eus, p4_cod_territorio FROM comarca ORDER BY p4_cod_territorio, "+order_by;
		
        PSP.sqlProclet(sd, "sel_comarca[]=" + sel_comarca);

        if (sd.gI("sel_comarca.length") > 0) {
            int numComarcas = sd.gI("sel_comarca.length");

            for (int i = 0; i < numComarcas; i++) {
                q53ComarcaBean comarcaBean = new q53ComarcaBean();
                String codComrca = sd.gOS("sel_comarca[" + i + "].p4_cod_comarca");
                String nombreComarcaCas = sd.gOS("sel_comarca[" + i +
                        "].p4_nombre_cas");
                String nombreComarcaEus = sd.gOS("sel_comarca[" + i +
                        "].p4_nombre_eus");
                
                String codTerritorioHist = sd.gOS("sel_comarca[" + i +
                        "].p4_cod_territorio");

                comarcaBean.setCodComarca(codComrca);
                comarcaBean.setNombreComarcaCas(nombreComarcaCas);
                comarcaBean.setNombreComarcaEus(nombreComarcaEus);
                comarcaBean.setCodTerritorioHist(codTerritorioHist);

                comarcaList.add(comarcaBean);
            }
        }

        return comarcaList;
    }
    
    /**
     * Mtodo que nos devuelve la lista de municipios de una comarca
     *
     * @param sd 
     * @param codComarca
     *
     * @return 
     *
     * @throws ProcletException 
     */
    public static List getMunicipiosByComarca(ProcletServiceData sd,
        String codComarca) throws ProcletException {
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
       
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";
        String select_municipios =
            "SELECT p3_cod_municipio, p3_nombre_cas, p3_nombre_eus" +
            " FROM municipio " + 
            " WHERE p3_cod_comarca ='" + codComarca + "'"+
            " ORDER BY "+order_by;
        PSP.sqlProclet(sd, "municipios[]=" + select_municipios);

        if (sd.gI("municipios.length") > 0) {
            int numMuni = sd.gI("municipios.length");

            for (int i = 0; i < numMuni; i++) {
                q53MunicipioBean municipio = new q53MunicipioBean();
                municipio.setCodComarca(codComarca);
                municipio.setCodMunicipio(sd.gOS("municipios[" + i +
                        "].p3_cod_municipio"));
                municipio.setNombreMuniCas(sd.gOS("municipios[" + i +
                        "].p3_nombre_cas"));
                municipio.setNombreMuniEus(sd.gOS("municipios[" + i +
                        "].p3_nombre_eus"));
                municipiosList.add(municipio);
            }
        }
        return municipiosList;
    }

	 /**
     * Mtodo que nos devuelve la lista de municipios de una comarca
     *
     * @param sd 
     * @param codComarca
     *
     * @return 
     *
     * @throws ProcletException 
     */
    public static List getMunicipiosByComarca(ProcletServiceData sd,
        String codComarca,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException {
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
       
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";
        String select_municipios =
            "SELECT p3_cod_municipio, p3_nombre_cas, p3_nombre_eus" +
            " FROM municipio " + 
            " WHERE p3_cod_comarca ='" + codComarca + "'"+
            " ORDER BY "+order_by;
		// q53Estlog.log(sd.getLogFilePath(),fileName,"q53ProcedenciaClass:getMunicipiosByComarca()::::"+select_municipios);
        PSP.sqlProclet(sd, "municipios[]=" + select_municipios);

        if (sd.gI("municipios.length") > 0) {
            int numMuni = sd.gI("municipios.length");

            for (int i = 0; i < numMuni; i++) {
                q53MunicipioBean municipio = new q53MunicipioBean();
                municipio.setCodComarca(codComarca);
                municipio.setCodMunicipio(sd.gOS("municipios[" + i +
                        "].p3_cod_municipio"));
                municipio.setNombreMuniCas(sd.gOS("municipios[" + i +
                        "].p3_nombre_cas"));
                municipio.setNombreMuniEus(sd.gOS("municipios[" + i +
                        "].p3_nombre_eus"));
                municipiosList.add(municipio);
            }
        }
        return municipiosList;
    }
    
    
    /**
     * Mtodo que nos devuelve la lista de municipios de un territorio
     *
     * @param sd 
     * @param codComarca
     *
     * @return 
     *
     * @throws ProcletException 
     */
    public static List getMunicipiosByTerritorio(ProcletServiceData sd,
        String codTerritorio) throws ProcletException {
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
        
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";
        String select_municipios =
            "SELECT p3_cod_municipio, p3_nombre_cas, p3_nombre_eus" +
            " FROM municipio " + 
            " WHERE p3_cod_territorio ='" + codTerritorio + "'"+
            " ORDER BY "+order_by;
        PSP.sqlProclet(sd, "municipios[]=" + select_municipios);

        if (sd.gI("municipios.length") > 0) {
            int numMuni = sd.gI("municipios.length");

            for (int i = 0; i < numMuni; i++) {
                q53MunicipioBean municipio = new q53MunicipioBean();
                municipio.setCodTerritorioHist(codTerritorio);
                municipio.setCodMunicipio(sd.gOS("municipios[" + i +
                        "].p3_cod_municipio"));
                municipio.setNombreMuniCas(sd.gOS("municipios[" + i +
                        "].p3_nombre_cas"));
                municipio.setNombreMuniEus(sd.gOS("municipios[" + i +
                        "].p3_nombre_eus"));
                municipiosList.add(municipio);
            }
        }
        return municipiosList;
    }
     /**
     * Mtodo que nos devuelve la lista de municipios de un territorio
     *
     * @param sd 
     * @param codComarca
     *
     * @return 
     *
     * @throws ProcletException 
     */
    public static List getMunicipiosByTerritorio(ProcletServiceData sd,
        String codTerritorio,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException {
        List municipiosList = new ArrayList();
        String q53_idioma = sd.gOS("q53_cki.q53_idioma");
        
		String order_by = "p3_nombre_cas";
		if(q53_idioma.equals("E")){
			 order_by = "p3_nombre_eus";
		}
        if (q53_idioma.equals("E")) order_by = "p3_nombre_eus";
        String select_municipios =
            "SELECT p3_cod_municipio, p3_nombre_cas, p3_nombre_eus" +
            " FROM municipio " + 
            " WHERE p3_cod_territorio ='" + codTerritorio + "'"+
            " ORDER BY "+order_by;
		// q53Estlog.log(sd.getLogFilePath(),fileName,"q53estProcedenciaClass:getMunicipiosByTerritorio()::::"+select_municipios);
        PSP.sqlProclet(sd, "municipios[]=" + select_municipios);

        if (sd.gI("municipios.length") > 0) {
            int numMuni = sd.gI("municipios.length");

            for (int i = 0; i < numMuni; i++) {
                q53MunicipioBean municipio = new q53MunicipioBean();
                municipio.setCodTerritorioHist(codTerritorio);
                municipio.setCodMunicipio(sd.gOS("municipios[" + i +
                        "].p3_cod_municipio"));
                municipio.setNombreMuniCas(sd.gOS("municipios[" + i +
                        "].p3_nombre_cas"));
                municipio.setNombreMuniEus(sd.gOS("municipios[" + i +
                        "].p3_nombre_eus"));
                municipiosList.add(municipio);
            }
        }
        return municipiosList;
    }
    
    /**
     * Metodo que nos devuelve la lista de las oficinas
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getOficinasList(ProcletServiceData sd,q53LogEstadisticas q53Estlog,String fileName) throws ProcletException{ 
        List oficinasList = new ArrayList();
        String sel_oficina = "SELECT t02_coor, t02_noofi, TO_CHAR(t02_codprovinc,'FM00')||'_'||TO_CHAR(t02_codmunicip,'FM0000') cod_municipio "
            + " FROM oficina WHERE t02_inesta = 'S' ORDER BY cod_municipio, t02_noofi";
		// q53Estlog.log(sd.getLogFilePath(),fileName,"q53estProcedenciaClass:getOficinasList()::::"+sel_oficina);
        PSP.sqlProclet(sd, "sel_oficina[]=" + sel_oficina);

        if (sd.gI("sel_oficina.length") > 0) {
            int numOficinas = sd.gI("sel_oficina.length");

            for (int i = 0; i < numOficinas; i++) {
                q53OficinaBean oficinaBean = new q53OficinaBean();
                String codOficina = sd.gOS("sel_oficina["+i+"].t02_coor");
                String nombreOficina = sd.gOS("sel_oficina["+i+"].t02_noofi");
                String codMunicipio = sd.gOS("sel_oficina["+i+"].cod_municipio");

                oficinaBean.setCodigoOficina(codOficina);
                oficinaBean.setNombreOficina(nombreOficina);
                oficinaBean.setCodMunicipio(codMunicipio);

                oficinasList.add(oficinaBean);
            }
        }

        return oficinasList;
    }
    /**
     * Metodo que nos devuelve la lista de las oficinas por nombre
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
     public static List getOficinasListNombre(ProcletServiceData sd) throws ProcletException{ 
     	 List oficinasList = new ArrayList();
     	 String sel_oficina = "SELECT t02_coor, t02_noofi, TO_CHAR(t02_codprovinc,'FM00')||'_'||TO_CHAR(t02_codmunicip,'FM0000') cod_municipio "
     	 + " FROM oficina WHERE t02_inesta = 'S' and T02_FEBAJA IS NULL ORDER BY t02_noofi";
     	 
     	 PSP.sqlProclet(sd, "sel_oficina[]=" + sel_oficina);
     	 if (sd.gI("sel_oficina.length") > 0) {
     	 	int numOficinas = sd.gI("sel_oficina.length");
     	 	for (int i = 0; i < numOficinas; i++) {
     	 		q53OficinaBean oficinaBean = new q53OficinaBean();
     	 		String codOficina = sd.gOS("sel_oficina["+i+"].t02_coor");
     	 		String nombreOficina = sd.gOS("sel_oficina["+i+"].t02_noofi");
     	 		String codMunicipio = sd.gOS("sel_oficina["+i+"].cod_municipio");
     	 		oficinaBean.setCodigoOficina(codOficina);
     	 		oficinaBean.setNombreOficina(nombreOficina);
     	 		oficinaBean.setCodMunicipio(codMunicipio);
     	 		oficinasList.add(oficinaBean);
     	 	}
     	 }
     	 return oficinasList;
     }
	 /**
     * Metodo que nos devuelve la lista de las oficinas
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getOficinasList(ProcletServiceData sd) throws ProcletException{ 
        List oficinasList = new ArrayList();
        String sel_oficina = "SELECT t02_coor, t02_noofi, TO_CHAR(t02_codprovinc,'FM00')||'_'||TO_CHAR(t02_codmunicip,'FM0000') cod_municipio "
            + " FROM oficina WHERE t02_inesta = 'S' ORDER BY cod_municipio, t02_noofi";
		
        PSP.sqlProclet(sd, "sel_oficina[]=" + sel_oficina);

        if (sd.gI("sel_oficina.length") > 0) {
            int numOficinas = sd.gI("sel_oficina.length");

            for (int i = 0; i < numOficinas; i++) {
                q53OficinaBean oficinaBean = new q53OficinaBean();
                String codOficina = sd.gOS("sel_oficina["+i+"].t02_coor");
                String nombreOficina = sd.gOS("sel_oficina["+i+"].t02_noofi");
                String codMunicipio = sd.gOS("sel_oficina["+i+"].cod_municipio");

                oficinaBean.setCodigoOficina(codOficina);
                oficinaBean.setNombreOficina(nombreOficina);
                oficinaBean.setCodMunicipio(codMunicipio);

                oficinasList.add(oficinaBean);
            }
        }

        return oficinasList;
    }
    
    /**
     * Metodo que nos devuelve la lista de nombres de las personas
     *
     * @param sd
     *
     * @return
     *
     * @throws ProcletException
     */
    public static List getNombresList(ProcletServiceData sd,String codOficina) throws ProcletException{ 
        List NombresList = new ArrayList();
        String sel_nombres;
        if(codOficina!=null){
        sel_nombres = "SELECT t03_nousu, t03_cousu FROM PERSONA where t03_coofi='"+codOficina+"' order by t03_nousu ASC";	
        }else{
        sel_nombres = "SELECT t03_nousu, t03_cousu FROM PERSONA, oficina where t03_coofi=t02_coor and t02_febaja is null order by t03_nousu ASC";	
        }
        //q53Estlog.log(sd.getLogFilePath(),fileName,"q53ProcedenciaClass:getNombresList()::select_nombres"+sel_nombres);
        PSP.sqlProclet(sd, "sel_nombres[]=" + sel_nombres);

        if (sd.gI("sel_nombres.length") > 0) {
            int numNombres = sd.gI("sel_nombres.length");

            for (int i = 0; i < numNombres; i++) {
                String nombre = sd.gOS("sel_nombres["+i+"].t03_nousu"); 
                String codigo_persona = sd.gOS("sel_nombres["+i+"].t03_cousu"); 
                nombre=nombre+"##"+codigo_persona;
                NombresList.add(nombre);
            }
        }
        return NombresList;
    }
    

}
