package itourbaskClases;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

import org.w3c.dom.Node;

import q53_util.q53LogEstadisticas;

public class q53NotificacionesClass {
	
	//------------------------------generar_etiquetas_rollo-----------------------------------
	//funcion que genera un rtf con las etiquetas para mandar por correo en formato impresora rollo
	//int num_etiquetas=>numero de etiquetas que se van a escribir en el rtf
	//Hastable datos=>datos correspondientes a la direccion, nombre, etc ...
	//String posicion=>numero del 1 a 7 que corresponde con la posicion que ocupara la etiqueta
	public static void generar_etiquetas_rollo(int num_etiquetas,Hashtable datos,String posicion,String oficina){
		try{
			int num_paginas=1;
			int num_etiquetas_en_pagina=1;
			String fin="}";
			q53LogEstadisticas.printLog("Entra en la funcion generar_etiquetas_rollo");
			String pathPlantillaRTF = "/datos/q53/file/notificaciones/plantillaRollo.rtf";
			String rtfGenerado = "/datos/q53/file/notificaciones/Etiquetas"+oficina+".rtf";
			//Me aseguro de que este cerrado el stream
			FileOutputStream fout = new FileOutputStream(new File(rtfGenerado));
			fout.close();
			fout = new FileOutputStream(new File(rtfGenerado));
			StringBuffer documentoOrigen = null;
			documentoOrigen = new StringBuffer(new String(leer_archivo_origen(pathPlantillaRTF)));
			int basta=0;			
			int contador=0;
			StringBuffer documentoOrigenAux=null;
			if(num_etiquetas % num_etiquetas_en_pagina == 0){
				num_paginas=num_etiquetas/num_etiquetas_en_pagina;
			}else{
				num_paginas=(num_etiquetas/num_etiquetas_en_pagina)+1;
			}
			q53LogEstadisticas.printLog("Numero de etiquetas = "+num_etiquetas);
			q53LogEstadisticas.printLog("Numero de paginas = "+num_paginas);
			if(num_paginas>1){					
				documentoOrigenAux=new StringBuffer(new String(leer_archivo_origen(pathPlantillaRTF)));
			}
			for(int m=1;m<=num_paginas;m++){
				basta=0;
				for(int i=1;i<=num_etiquetas_en_pagina;i++){
					if(basta==0){
						documentoOrigen.replace(documentoOrigen.indexOf("#CP"+i+"#"), documentoOrigen.indexOf("#CP"+i+"#")+5,(String)datos.get("codPostal_"+contador));
						documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+"#"), documentoOrigen.indexOf("#NOMBRE"+i+"#")+9,(String)datos.get("nombre_"+contador));
						documentoOrigen.replace(documentoOrigen.indexOf("#DIRECCION"+i+"#"), documentoOrigen.indexOf("#DIRECCION"+i+"#")+12,(String)datos.get("direccion_"+contador));	
						documentoOrigen.replace(documentoOrigen.indexOf("#LOCALIDAD"+i+"#"), documentoOrigen.indexOf("#LOCALIDAD"+i+"#")+12,(String)datos.get("localidad_"+contador));
					}else{
						documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+"#"), documentoOrigen.indexOf("#CP"+i+"#")+5,"");	
					}
					contador+=1;
					if(contador==num_etiquetas)
						basta=1;
				}
				if(num_paginas>1 && !(m==num_paginas)){	
					documentoOrigen.append(documentoOrigenAux);
				}
			}
			fout.write(documentoOrigen.toString().getBytes());	
			for(int x=1;x<=num_paginas;x++)
				fout.write(fin.getBytes());
			fout.close();
		}catch(Exception e){
			q53LogEstadisticas.printWarning("Ha saltado una excepcion ", e);
		}
	}
	
	//---------------------------------generar_fax--------------------------------------------
	//funcion que genera un rtf con la informacion para mandar un fax
	//Hashtable datos=>datos correspondientes a el numero de fax, fecha , etc...
	public static void generar_fax(Hashtable datos,String oficina){
		try{
			q53LogEstadisticas.printLog("Entra en la funcion generar_fax");
			String pathPlantillaRTF = "/datos/q53/file/notificaciones/plantilla"+oficina+".rtf";
			String rtfGenerado = "/datos/q53/file/notificaciones/Fax"+oficina+".rtf";
			//Seleccionamos la plantilla correspondiente a su oficina, si no seleccionamos la generica
			File plantilla = new File(pathPlantillaRTF);
			if(!plantilla.exists())
				pathPlantillaRTF="/datos/q53/file/notificaciones/plantillaFax.rtf";
			//Me aseguro de que este cerrado el stream
			FileOutputStream fout = new FileOutputStream(new File(rtfGenerado));
			fout.close();
			fout = new FileOutputStream(new File(rtfGenerado));
			StringBuffer documentoOrigen = null;
			documentoOrigen = new StringBuffer(new String(leer_archivo_origen(pathPlantillaRTF)));
			String campo="";
			//Escibimos todos los campos que hay en datos, y si no estan en el documento no los sustituye
			for(Enumeration e = datos.keys();e.hasMoreElements();){
				campo=(String)e.nextElement();
				if(documentoOrigen.indexOf("#"+campo+"#")!=-1)
					documentoOrigen.replace(documentoOrigen.indexOf("#"+campo+"#"), documentoOrigen.indexOf("#"+campo+"#")+campo.length()+2,(String)datos.get(campo));
			}
			//FIN Escibimos todos los campos que hay en datos, y si no estan en el documento no los sustituye
			fout.write(documentoOrigen.toString().getBytes());	
			fout.close();
		}catch(Exception e){
			q53LogEstadisticas.printWarning("Ha saltado una excepcion ", e);
		}
	}
	
	//---------------------------------generar_etiquetas-----------------------------------
	//funcion que genera un rtf con las etiquetas para mandar por correo
	//int num_etiquetas=>numero de etiquetas que se van a escribir en el rtf
	//Hastable datos=>datos correspondientes a la direccion, nombre, etc...
	//String posicion=>lugar en la cuadricula de 7x2 en la que se guardar la etiqueta
	public static void generar_etiquetas(int num_etiquetas,Hashtable datos,String posicion,String oficina){
		try{
			int num_paginas=1;
			q53LogEstadisticas.printLog("Entra en la funcion generar_etiquetas");
			String pathPlantillaRTF = "/datos/q53/file/notificaciones/plantilla.rtf";
		    String rtfGenerado = "/datos/q53/file/notificaciones/Etiquetas"+oficina+".rtf";
			String fin="}";
			//Me aseguro de que este cerrado el stream
		    FileOutputStream fout = new FileOutputStream(new File(rtfGenerado));
			fout.close();
			fout = new FileOutputStream(new File(rtfGenerado));
			StringBuffer documentoOrigen=null;
			documentoOrigen=new StringBuffer(new String(leer_archivo_origen(pathPlantillaRTF)));
			String posx = ""+posicion.charAt(0);
			String posy = ""+posicion.charAt(1);
			//Si num_etiquetas es 0 quiere decir que el usuario ha pulsado "Guardar y generar etiqueta" y solamente hay una etiqueta
			//Esto hay que mejorarlo cuando tenga tiempo y hacer que con lo de abajo baste
			if(num_etiquetas==0){
				for(int i=1;i<=7;i++){
					for(int j=1;j<=2;j++){
						if((Integer.parseInt(posx)==i)&&(Integer.parseInt(posy)==j)){
							documentoOrigen.replace(documentoOrigen.indexOf("#CP"+i+j+"#"), documentoOrigen.indexOf("#CP"+i+j+"#")+6,(String)datos.get("codPostal"));
							documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+j+"#"), documentoOrigen.indexOf("#NOMBRE"+i+j+"#")+10,(String)datos.get("nombre"));;
							documentoOrigen.replace(documentoOrigen.indexOf("#DIRECCION"+i+j+"#"), documentoOrigen.indexOf("#DIRECCION"+i+j+"#")+13,(String)datos.get("direccion"));	
							documentoOrigen.replace(documentoOrigen.indexOf("#LOCALIDAD"+i+j+"#"), documentoOrigen.indexOf("#LOCALIDAD"+i+j+"#")+13,(String)datos.get("localidad"));	
						}else{
							documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+j+"#"), documentoOrigen.indexOf("#CP"+i+j+"#")+6,"");	
						}
					}
				}
			}else{
				//Si num_etiquetas es distinto de 0 estamos en generacion batch de etiquetas
				int basta=0;
				int valor_maximo_x=0;
				int valor_maximo_y=0;				
				int contador=0;
				int cont_relleno=0;
				float f_y;
				StringBuffer documentoOrigenAux=null;
				//Tenemos en cuenta la posicion inicial elegida para sumar cont_relleno al numero de etiquetas total
			    if(posy.equals("1"))
			    	cont_relleno=2*(Integer.parseInt(posx)-1);
			    else
			    	cont_relleno=2*Integer.parseInt(posx)-1;		
			    num_etiquetas=num_etiquetas+cont_relleno;
				if(num_etiquetas % 14 == 0){
					num_paginas=num_etiquetas/14;
				}else{
					num_paginas=(num_etiquetas/14)+1;
				}
				q53LogEstadisticas.printLog("Numero de etiquetas = "+num_etiquetas);
				q53LogEstadisticas.printLog("Numero de etiquetas de relleno= "+cont_relleno);
				q53LogEstadisticas.printLog("Numero de paginas = "+num_paginas);
				if(num_paginas>1){					
					documentoOrigenAux=new StringBuffer(new String(leer_archivo_origen(pathPlantillaRTF)));
				}
				for(int m=1;m<=num_paginas;m++){
					basta=0;
					if(m==num_paginas && num_paginas>1){
						num_etiquetas=num_etiquetas %(14*(num_paginas-1));
					}
					f_y=num_etiquetas;
					valor_maximo_y=Math.round((f_y/2));
					if(num_etiquetas % 2 == 0)
						valor_maximo_x=2;
					else
						valor_maximo_x=1;
					for(int i=1;i<=7;i++){
						for(int j=1;j<=2;j++){
							//Si esta en la primera pagina rellena en blanco hasta llegar a la posicion inicial
							if(cont_relleno>0 && m==1){
								documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+j+"#"), documentoOrigen.indexOf("#CP"+i+j+"#")+6,"");
								cont_relleno-=1;
							}else{
								if(basta==0){
									documentoOrigen.replace(documentoOrigen.indexOf("#CP"+i+j+"#"), documentoOrigen.indexOf("#CP"+i+j+"#")+6,(String)datos.get("codPostal_"+contador));
									documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+j+"#"), documentoOrigen.indexOf("#NOMBRE"+i+j+"#")+10,(String)datos.get("nombre_"+contador));
									documentoOrigen.replace(documentoOrigen.indexOf("#DIRECCION"+i+j+"#"), documentoOrigen.indexOf("#DIRECCION"+i+j+"#")+13,(String)datos.get("direccion_"+contador));
									documentoOrigen.replace(documentoOrigen.indexOf("#LOCALIDAD"+i+j+"#"), documentoOrigen.indexOf("#LOCALIDAD"+i+j+"#")+13,(String)datos.get("localidad_"+contador));	
								}else{
									documentoOrigen.replace(documentoOrigen.indexOf("#NOMBRE"+i+j+"#"), documentoOrigen.indexOf("#CP"+i+j+"#")+6,"");	
								}
								contador+=1;
								if(i==valor_maximo_y && j==valor_maximo_x)
									basta=1;
							}
						}
					}
					if(num_paginas>1 && !(m==num_paginas)){	
						documentoOrigen.append(documentoOrigenAux);
					}
				}
			}	
			fout.write(documentoOrigen.toString().getBytes());
			for(int x=1;x<=num_paginas;x++)
				fout.write(fin.getBytes());
			fout.close();
		}catch(Exception e){
			q53LogEstadisticas.printWarning("Ha saltado una excepcion ", e);
		}
	}
	
	//----------------leer_archivo_origen----------------
	//funcion que lee un archivo por bytes y lo devuelve en bytes		
	//String path=>ruta en la que se encuentra el archivo
	public static byte [] leer_archivo_origen(String pathPlantillaRTF) throws Exception {
        q53LogEstadisticas.printLog("Entra en la funcion leer_archivo_origen" );
	  	Node nodoValor=null;
        byte[] fileBytes = null;
        File elFicheroRTF = new File(pathPlantillaRTF);
  		FileInputStream fis = new FileInputStream(elFicheroRTF);
  		long length = elFicheroRTF.length();
  		q53LogEstadisticas.printLog("Longitud del fichero = "+length );
  		fileBytes= new byte[(int)length];
  	    int offset = 0;
  	    int numRead = 0;
  	    while (offset < fileBytes.length && (numRead=fis.read(fileBytes, offset, fileBytes.length-offset)) >= 0) {
  	        offset += numRead;
  	    }
  		fis.close();
        return fileBytes;
      } 
}