package itourbaskClases;

import itourbaskBeans.q53PreguntaBean;

import java.util.Calendar;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53ModificarRespuestasClass {
    /**
     * Mtodo para modificar la oficina y la fecha de visita de una respuesta en la BBDD
     *
     * @param sd El objeto ProcletServiceData
     * @param codRespuesta
     * @param fecha
     * @param ofi
     *
     * @throws ProcletException
     */
	public static int modificarRespuestaFechayOfi(ProcletServiceData sd,String codRespuesta,String fecha, String ofi){
		try{
			String query="=UPDATE Q53M0T00 SET M0_COD_OFICINA ='"+ofi+"', M0_FECHA_RESP =TO_DATE('"+fecha+"','DD/MM/YYYY HH24:MI:SS') WHERE M0_COD_RESPUESTA="+codRespuesta;
			q53LogEstadisticas.printLog("Query update ->"+query);
			PSP.sqlProclet(sd, query);	
			return 0;
		}catch(Exception e){
			q53LogEstadisticas.printLog("Ha saltado una excepcion cuando se ejecutaba una sentencia sql");
			q53LogEstadisticas.printLog("Mensaje -> "+e.getMessage());
			return 1;
		}
	}
	
	
	/**
	 * Mtodo para modificar las respuesta de las preguntas de tipo notificacion
	 *
	 * @param sd El objeto ProcletServiceData
	 * @param cod_respuesta 
	 *
	 * @throws ProcletException
	 */
	private static void modificarRptaNotificacionInigo(ProcletServiceData sd,String codRespuesta)throws ProcletException{
		PSP.paramProclet(sd, "check_envio(),tipo_envio(),nombre(),direccion(),localidad(),codPostal(),email(),fax(),fecha(),hojas(),remitente(),destinatario(),informacion_envio()");
		String query_select="existe=SELECT count(*) as resultado FROM Q53M7T00 WHERE M7_COD_RESPUESTA ="+ codRespuesta;
		q53LogEstadisticas.printSql(" buscando si hay datos en m7_:" + query_select);
		PSP.sqlProclet(sd, query_select);	
   	if(sd.gOS("check_envio").equals("on")){
      	if(sd.gI("existe.resultado")!=0)
      		q53RespuestaClass.updateNotificaciones(sd,codRespuesta);
   		else 
   	      q53RespuestaClass.guardarNotificaciones(sd,codRespuesta);
		}
		else
			q53RespuestaClass.deleteNotificaciones(sd,codRespuesta);  
   }
	/**
	 * Mtodo para modificar las respuesta de las preguntas de tipo notificacion
	 *
	 * @param sd El objeto ProcletServiceData
	 * @param cod_respuesta 
	 *
	 * @throws ProcletException
	 */
	private static void modificarRptaNotificacion(ProcletServiceData sd,String codRespuesta)throws ProcletException{
		q53LogEstadisticas.printSql("modificarRptaNotificacion");
		PSP.paramProclet(sd, "check_envio(),tipo_envio(),nombre(),direccion(),localidad(),codPostal(),email(),fax(),fecha(),hojas(),remitente(),destinatario()");
        String query_select="existe=SELECT count(*) as resultado FROM Q53M7T00 WHERE M7_COD_RESPUESTA ="+ codRespuesta;
        q53LogEstadisticas.printSql(query_select);
        PSP.sqlProclet(sd, query_select);	
        if(sd.gI("existe.resultado")!=0){
        	q53RespuestaClass.deleteNotificaciones(sd,codRespuesta);
			//String deleteNotificacion ="=DELETE FROM Q53M7T00 WHERE M7_COD_RESPUESTA =" + codRespuesta;
	      //  PSP.sqlProclet(sd, deleteNotificacion);	
        }
		//String query=" ";
	    if(sd.gOS("check_envio").equals("on")){
	    	q53RespuestaClass.guardarNotificaciones(sd, codRespuesta);
			/*if(sd.gOS("tipo_envio").equals("1")){
				query="=INSERT INTO Q53M7T00 (m7_cod_respuesta,m7_tipo_envio,m7_nombre,m7_direccion," +
				"m7_localidad,m7_codpostal) VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+","+
				"'"+sd.gOS("nombre")+"','"+sd.gOS("direccion")+"',"+
				"'"+sd.gOS("localidad")+"','"+sd.gOS("codPostal")+"');";
			}else if(sd.gOS("tipo_envio").equals("2")){
				query="=INSERT INTO Q53M7T00 (M7_COD_RESPUESTA,M7_TIPO_ENVIO,M7_EMAIL) VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+",'"+sd.gOS("email")+"');";
			}else if(sd.gOS("tipo_envio").equals("3")){
				String q53Idioma = q53Util.getIdioma(sd);
				String fecha=sd.gOS("fecha");
				if(!q53Idioma.equals("C")){
					fecha=q53Util.convertirFechaIdioma(fecha,"EC");
				}
				query="=INSERT INTO Q53M7T00 (M7_COD_RESPUESTA,M7_TIPO_ENVIO,M7_FAX,M7_FECHA,M7_NHOJAS,M7_REMITENTE,M7_DESTINATARIO)" +
				" VALUES ("+codRespuesta+","+sd.gOS("tipo_envio")+",'"+sd.gOS("fax")+"',"+
				"'"+fecha+"','"+sd.gOS("hojas")+"','"+sd.gOS("remitente")+"','"+sd.gOS("destinatario")+"');";
			}
	        PSP.sqlProclet(sd, query);*/
	    }
	}
	
	
    public static void modificarRespuestasEncGV(ProcletServiceData sd,
        String gvCodEncuesta, String gvCodVersion, String codRespuesta)
        throws ProcletException {
    	q53LogEstadisticas.printLog("GOBIERNO VASCO CLASE "+gvCodEncuesta+" "+gvCodVersion+" "+codRespuesta);
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                gvCodEncuesta, gvCodVersion);
        modificarRptaNotificacion(sd,codRespuesta);
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();

            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
                String tipo_pregunta = preguntaBean.getTipoPregunta();
                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                    modificarRptaOpciones(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                    modificarRptaTexto(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                    modificarRptaProcedencia(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                    modificarRptaFecha(sd, preguntaBean, i, codRespuesta);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                    modificarRptaGrupos(sd, preguntaBean, i, codRespuesta);
                }
            }
        }
    }

    /**
     * Mtodo para insertar las respuestas de la encuesta de oficina en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param codEncuestaOfi
     * @param codVersionEncOfi
     * @param codRespOfi
     *
     * @throws ProcletException
     */
    public static void modificarRespuestasEncOfi(ProcletServiceData sd,
        String codEncuestaOfi, String codVersionEncOfi, String codRespOfi)
        throws ProcletException {
    	q53LogEstadisticas.printLog("OFICINA CLASE"+codEncuestaOfi+" "+codVersionEncOfi+" "+codRespOfi);
        List preguntasList = q53EncuestaClass.getPreguntasEncOfiData(sd,
                codEncuestaOfi, codVersionEncOfi);
        if ((preguntasList != null) && !preguntasList.isEmpty()) {
            int numPregs = preguntasList.size();
            //q53LogEstadisticas.printLog("OFICINA IF "+numPregs);
            for (int i = 0; i < numPregs; i++) {
                q53PreguntaBean preguntaBean = (q53PreguntaBean) preguntasList.get(i);
                String tipo_pregunta = preguntaBean.getTipoPregunta();
                q53LogEstadisticas.printLog("OFICINA FOR "+preguntaBean+" "+tipo_pregunta);

                if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                	//q53LogEstadisticas.printLog("OFICINA OPCIONES "+preguntaBean+" "+tipo_pregunta+" "+codRespOfi);
                    modificarRptaOpciones(sd, preguntaBean, i, codRespOfi);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                    modificarRptaTexto(sd, preguntaBean, i, codRespOfi);
                } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                    modificarRptaFecha(sd, preguntaBean, i, codRespOfi);
                }
            }
        }
        //Con esta parte actualizamos la fecha de respuesta
        String cod_pregunta = "0";
        String updatem0="=UPDATE RESPUESTA SET M0_FECHA_RESP=TO_DATE('${fech_" + cod_pregunta + "_dia}"
        + "${fech_" + cod_pregunta + "_mes}${fech_" + cod_pregunta + "_anio} "
        + "${fech_" + cod_pregunta +"_hora}:00:00','DDMMYYYY HH24:MI:SS') " 
        + "WHERE M0_COD_RESPUESTA=" + codRespOfi +";";
        PSP.sqlProclet(sd,updatem0);
        q53LogEstadisticas.printLog("update de la fecha de respuesta en la respuesta de oficina ::::"+updatem0);
        //FIN Con esta parte actualizamos la fecha de respuesta
    }

    /**
     * Mtodo para modificar las respuesta de las preguntas de tipo opcion en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean
     * @param i
     * @param cod_respuesta
     *
     * @throws ProcletException
     */
    private static void modificarRptaOpciones(ProcletServiceData sd,
        q53PreguntaBean preguntaBean, int i, String cod_respuesta)
        throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();

        // mirar que formato tiene la pregunta: combobox, check, radio button
        PSP.sqlProclet(sd,
            "formato_tmp=SELECT n2_formato formato FROM q53n2t00 WHERE n2_cod_pregunta=" +
            cod_pregunta);

        //Priemro borramos las respuestas de tipo opcion que habia en B.D. y despues insertamos 
        //las nuevas resouestas
        String deleteOptions =
            "=DELETE FROM RESP_OPCIONES WHERE M2_COD_RESPUESTA =" +
            cod_respuesta + "" + " AND M2_COD_PREGUNTA=" + cod_pregunta + ";";
        // q53LogEstadisticas.printLog("deleteOptions::::"+deleteOptions);
        PSP.sqlProclet(sd, deleteOptions);

        //dependiendo del tipo actualizamos los datos en ls BD
        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_RADIO)) {
            // Pregunta de opciones con formato radio button.
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");

            if (!sd.gOS("opt_" + cod_pregunta).equals("")) {
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)";
                insert_pregunta_tipo += (" VALUES (" + cod_respuesta + "," +
                cod_pregunta + ",${opt_" + cod_pregunta + "})");
                q53LogEstadisticas.printLog("RADIO ->"+insert_pregunta_tipo+"<-");
                PSP.sqlProclet(sd, "=" + insert_pregunta_tipo);
            }
        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_CHECK)) {
            // Pregunta de opciones de formato check (multiple respuestas!!)
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");
            String opt = sd.gOS("opt_" + cod_pregunta);
            String cadenaUpdate = "";
            String cadena_insert = "";
            while (opt.length() != 0) {
                int indice = opt.indexOf("#");
                String opt_tmp = "";
                if (indice != -1) {
                    opt_tmp = opt.substring(0, indice);
                    opt = opt.substring(indice + 1, opt.length());
                } else {
                    opt_tmp = opt;
                    opt = "";
                }
                cadena_insert = "=INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)";
                cadena_insert += (" VALUES (" + cod_respuesta + "," +
                cod_pregunta + "," + opt_tmp + ");");
                //q53LogEstadisticas.printLog("cadena_insert::::"+cadena_insert);
                PSP.sqlProclet(sd, cadena_insert);
            }
        } else if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_SELECT)) {
            // Pregunta de opciones con formato select 
            PSP.paramProclet(sd, "opt_" + cod_pregunta + "()");

            if (!sd.gOS("opt_" + cod_pregunta).equals("")) {
                String insert_pregunta_tipo = "INSERT INTO RESP_OPCIONES (M2_COD_RESPUESTA,M2_COD_PREGUNTA,M2_COD_OPCION)";
                insert_pregunta_tipo += (" VALUES (" + cod_respuesta + "," +
                cod_pregunta + "," + sd.gOS("opt_" + cod_pregunta) + ")");
                // q53LogEstadisticas.printLog("insert_pregunta_tipo ::::"+insert_pregunta_tipo);
                PSP.sqlProclet(sd, "=" + insert_pregunta_tipo);
            }
        }
    }

    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo texto en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean
     * @param i
     * @param cod_respuesta
     *
     * @throws ProcletException
     */
    private static void modificarRptaTexto(ProcletServiceData sd,
        q53PreguntaBean preguntaBean, int i, String cod_respuesta)
        throws ProcletException {
        //String cod_respuesta = sd.gOS(pregs + "_cod_rpta.cod_respuesta");
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();

        PSP.paramProclet(sd, "txt_" + cod_pregunta + "()");

        String texto = sd.gOS("txt_" + cod_pregunta);

        //Enumerationeste acaso solo modificamos el texto que se ha insertado ..no tenemos que borrar
        String deleteTextQuestion =
            "DELETE FROM RESP_TEXTO  WHERE M4_COD_RESPUESTA=" +
            cod_respuesta + "" + " AND M4_COD_PREGUNTA=" + cod_pregunta + ";";

        // q53LogEstadisticas.printLog("deleteTextQuestion ::::"+deleteTextQuestion);
        PSP.sqlProclet(sd, "=" + deleteTextQuestion);

        //Enumerationeste acaso solo modificamos el texto que se ha insertado ..no tenemos que borrar
        String insert_pregunta = "INSERT INTO RESP_TEXTO (M4_COD_PREGUNTA,M4_COD_RESPUESTA,M4_TEXTO)";
        insert_pregunta += (" VALUES (" + cod_pregunta + "," + cod_respuesta +
        ",'${txt_" + cod_pregunta + "}')");
        // q53LogEstadisticas.printLog("insert_pregunta ::::"+insert_pregunta);
        PSP.sqlProclet(sd, "=" + insert_pregunta);
    }

    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Procedencia
     * en B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean
     * @param i
     * @param cod_respuesta
     *
     * @throws ProcletException
     */
    private static void modificarRptaProcedencia(ProcletServiceData sd,
        q53PreguntaBean preguntaBean, int i, String cod_respuesta)
        throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();

        PSP.paramProclet(sd,
            "proc_local_" + cod_pregunta + "(), proc_pais_" + cod_pregunta + "_1()," +
                "proc_pais_" + cod_pregunta +"_2(),proc_pais_" + cod_pregunta +"_3(), " +
                "proc_ccaa_" + cod_pregunta + "_1(),proc_ccaa_" + cod_pregunta + "_2()," +
                "proc_ccaa_" + cod_pregunta + "_3(), proc_territorio_"+ cod_pregunta + "_1()," +
                "proc_territorio_"+ cod_pregunta + "_2(),proc_territorio_"+ cod_pregunta + "_3()," +
                "nPersonasProcedencia_6_1(),nPersonasProcedencia_6_2()," +
                "nPersonasProcedencia_6_3(),cpos1(),cpos2(),cpos3(),local()");

				//int local = 0;
        //if(!sd.gOS("local").equals("")){
        //    local = sd.gI("local");
        //}
           
        int numLocales = 0;
        int numProc1=0;
        if(!sd.gOS("local").equals("")){
 	        if(!sd.gOS("nPersonasProcedencia_6_1").equals("")){
 	            numLocales = sd.gI("nPersonasProcedencia_6_1");
 	        }
         } else {
 	        if(!sd.gOS("nPersonasProcedencia_6_1").equals("")){
 	            numProc1 = sd.gI("nPersonasProcedencia_6_1");
 	        }
       	}
        int numProc2=0;
        if(!sd.gOS("nPersonasProcedencia_6_2").equals("")){
            numProc2 = sd.gI("nPersonasProcedencia_6_2");
        }
        int numProc3=0;
        if(!sd.gOS("nPersonasProcedencia_6_3").equals("")){
            numProc3 = sd.gI("nPersonasProcedencia_6_3");
        }
        String territorio1="";
        String territorio2="";
        String territorio3="";
        String prov1="0";
        String prov2="0";
        String prov3="0";
        String cpos1="0";
        String pais1=sd.gOS("proc_pais_" + cod_pregunta + "_1");
        String pais2=sd.gOS("proc_pais_" + cod_pregunta + "_2");
        String pais3=sd.gOS("proc_pais_" + cod_pregunta + "_3");
        
         //q53LogEstadisticas.printLog("Paises::::-"+pais1+"-"+pais2+"-"+pais3+"-");
 //q53LogEstadisticas.printLog("Valor del parmetro sd.gOS(cpos1)::::" + sd.gOS("cpos1"));        
        if(!sd.gOS("cpos1").equals("")){
            cpos1 = sd.gOS("cpos1");
            q53LogEstadisticas.printLog("Valor del parmetro cpos1::::" + cpos1);                	
            q53LogEstadisticas.printLog("longitud del parmetro cpos1::::" + cpos1.length());
						if(pais1.equals("0")) {
            if(cpos1.length()==5){
            	prov1=cpos1.substring(0,2);
            	if(prov1.equals("01") || prov1.equals("1")){
            		territorio1="0";
            	}else if (prov1.equals("20")){
            		territorio1="2";
            	}else if (prov1.equals("48")){
            		territorio1="1";
            	}
            }
          } 
        }   
        q53LogEstadisticas.printLog("Valor del parmetro prov1::::" + prov1);
        q53LogEstadisticas.printLog("Valor del parmetro territorio1::::" + territorio1);
        String cpos2="0";
        if(!sd.gOS("cpos2").equals("")){
            cpos2 = sd.gOS("cpos2");
            if(pais2.equals("0")) {
            if(cpos2.length()==5){
            	prov2=cpos2.substring(0,2);
            }
            	if(prov2.equals("01") || prov2.equals("1")){
            		territorio2="0";
            	}else if (prov2.equals("20")){
            		territorio2="2";
            	}else if (prov2.equals("48")){
            		territorio2="1";
            	}
           } 		
        }    
        q53LogEstadisticas.printLog("Valor del parmetro prov2::::" + prov2);
        q53LogEstadisticas.printLog("Valor del parmetro territorio2::::" + territorio2);
        String cpos3="0";
        if(!sd.gOS("cpos3").equals("")){
            cpos3 = sd.gOS("cpos3");
            if(pais3.equals("0")) {
            if(cpos3.length()==5){
            	prov3=cpos3.substring(0,2);
            }
            	if(prov3.equals("01") || prov3.equals("1")){
            		territorio3="0";
            	}else if (prov3.equals("20")){
            		territorio3="2";
            	}else if (prov3.equals("48")){
            		territorio3="1";
            	}
           } 
        }
        if(pais1.equals("10") && (cpos1.equals("")||cpos1.equals("0")))cpos1="999";
        if(pais2.equals("10") && (cpos2.equals("")||cpos2.equals("0")))cpos2="999";
        if(pais3.equals("10") && (cpos3.equals("")||cpos3.equals("0")))cpos3="999";
         //q53LogEstadisticas.printLog("Valor del parmetro prov3::::" + prov3);
         //q53LogEstadisticas.printLog("Valor del parmetro territorio3::::" + territorio3);
     
        String codOficina = sd.gOS("q53_cki.q53_oficina");
        String codMunicipioOfi = "";
        String selectMuni = "SELECT TO_CHAR(T02_CODPROVINC,'FM09') T02_CODPROVINC," +
                "TO_CHAR(T02_CODMUNICIP,'FM0999') T02_CODMUNICIP FROM OFICINA WHERE T02_COOR='" +codOficina + "';";
        q53LogEstadisticas.printLog("selectMuni::::"+selectMuni);
        PSP.sqlProclet(sd, "selectMuni[]=" + selectMuni );
        codMunicipioOfi = sd.gOS("selectMuni[0].t02_codprovinc")+"_"+sd.gOS("selectMuni[0].t02_codmunicip");
        
        //BUSCAMOS LA COMARCA A LA QUE PERTENECE EL MUNICIPIO
        String selectComarca = "SELECT P3_COD_COMARCA, P3_COD_TERRITORIO FROM MUNICIPIO WHERE P3_COD_MUNICIPIO='"+codMunicipioOfi+"';";
        q53LogEstadisticas.printLog("selectComarca ->"+selectComarca+"<-");
        PSP.sqlProclet(sd, "selectComarca[]=" + selectComarca );
        String codComarca = sd.gOS("selectComarca[0].p3_cod_comarca");
        String codTerritorio =  sd.gOS("selectComarca[0].p3_cod_territorio");
        
        //BUSCAMOS LA COMUNIDAD AUTONOMA A LA QUE PERTENECE LA PROVINCIA
        String codCCAA1="0";
        if(!sd.gOS("cpos1").equals("")){
        	if(pais1.equals("0")) {        	
        	String selectCCAA1 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov1+"'";
        	// q53LogEstadisticas.printLog("selectCCAA1 ::::"+selectCCAA1);
        	PSP.sqlProclet(sd, "selectCCAA1[]=" + selectCCAA1 );
        	codCCAA1 = sd.gOS("selectCCAA1[0].cod_ccaa");
        }
        }
        String codCCAA2="0";
        if(!sd.gOS("cpos2").equals("")){
        	if(pais2.equals("0")) { 
        	String selectCCAA2 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov2+"'";
        	// q53LogEstadisticas.printLog("selectCCAA2 ::::"+selectCCAA2);
        	PSP.sqlProclet(sd, "selectCCAA2[]=" + selectCCAA2 );
        	codCCAA2 = sd.gOS("selectCCAA2[0].cod_ccaa");
        }
        }
        String codCCAA3="0";
        if(!sd.gOS("cpos3").equals("")){
        	if(pais3.equals("0")) {
        	String selectCCAA3 = "SELECT COD_CCAA"
            + " FROM Q53P5T00"
            + " WHERE COD_PROV='"+prov3+"'";
        	// q53LogEstadisticas.printLog("selectCCAA3 :::: "+selectCCAA3);
        	PSP.sqlProclet(sd, "selectCCAA3[]=" + selectCCAA3 );
        	codCCAA3 = sd.gOS("selectCCAA3[0].cod_ccaa");
        	}
        }
        
        if(pais1.equals("10"))codCCAA1=cpos1;
        if(pais2.equals("10"))codCCAA2=cpos2;
        if(pais3.equals("10"))codCCAA3=cpos3;
        if(!sd.gOS("local").equals("")){            
        	q53LogEstadisticas.printLog("Es local");
            // q53LogEstadisticas.printLog("Numero de locales: ${proc_local_" + cod_pregunta + "}'");
            // q53LogEstadisticas.printLog("Numero de locales: numProc1:-"+ numProc1+ "-");
            String update_proc_local = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='S', M5_COD_PAIS=0, M5_COD_COMUNIDAD=0, M5_COD_TERRITORIO='"+codTerritorio+"', M5_COD_MUNICIPIO='" + codMunicipioOfi + 
            "', M5_COD_COMARCA='" + codComarca + "', M5_NUM_PERSONAS=" + numLocales +
            " WHERE M5_COD_RESPUESTA=" + cod_respuesta +
            " AND M5_COD_PREGUNTA=" + cod_pregunta + " AND M5_COD_PROCEDENCIA=1";
            // q53LogEstadisticas.printLog("update_proc_local ->"+update_proc_local+"<-");
            PSP.sqlProclet(sd, "=" + update_proc_local);
            
 		        String update_proc1="";
 		       if(pais1.equals(""))pais1="0";
		        update_proc1 = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='N', M5_COD_PAIS='"+pais1+"', "+
		            "M5_COD_COMUNIDAD='0', " + "M5_COD_TERRITORIO='', M5_COD_MUNICIPIO='0',"+
		            "M5_COD_COMARCA='0',M5_CPOS=0, M5_NUM_PERSONAS=0"+
		           " WHERE M5_COD_RESPUESTA="+cod_respuesta+" AND M5_COD_PREGUNTA="+cod_pregunta+" AND M5_COD_PROCEDENCIA=2";
		        // q53LogEstadisticas.printLog("update_proc1 :::: ->"+update_proc1+"<-");
		        PSP.sqlProclet(sd, "=" + update_proc1);
        }else{
        	if(pais1.equals(""))pais1="0";
        	q53LogEstadisticas.printLog("No es local");
            String update_proc_local = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='N',M5_COD_PAIS="+pais1+",M5_COD_COMUNIDAD=0,M5_COD_TERRITORIO=''" +
                    ",M5_COD_MUNICIPIO='',M5_COD_COMARCA='',M5_NUM_PERSONAS=0,M5_CPOS=0 WHERE " +
                     "M5_COD_RESPUESTA="+cod_respuesta+" AND M5_COD_PREGUNTA="+cod_pregunta+" AND M5_COD_PROCEDENCIA=1";
            // q53LogEstadisticas.printLog("update_proc_local ->"+update_proc_local+"<-);
            PSP.sqlProclet(sd, "=" + update_proc_local);
            String mun1="";   
           
            if(pais1.equals("0")){mun1=q53Util.getMunicipio(sd,cpos1);}
                
		        String update_proc1="";
		        if(pais1.equals(""))pais1="0";
		        update_proc1 = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='N', M5_COD_PAIS='"+pais1+"', "+
		            "M5_COD_COMUNIDAD='"+codCCAA1+"', " + "M5_COD_TERRITORIO='"+territorio1+"', M5_COD_MUNICIPIO='"+mun1+"',"+
		            "M5_COD_COMARCA='', M5_NUM_PERSONAS="+numProc1+", M5_CPOS="+ cpos1 +
		           " WHERE M5_COD_RESPUESTA="+cod_respuesta+" AND M5_COD_PREGUNTA="+cod_pregunta+" AND M5_COD_PROCEDENCIA=2";
		        // q53LogEstadisticas.printLog("update_proc1 :::: ->"+update_proc1+"<-");
		        PSP.sqlProclet(sd, "=" + update_proc1);
        } 

        String mun2="";
        String mun3="";
      
        if(pais2.equals("0")){mun2=q53Util.getMunicipio(sd,cpos2);}
        if(pais3.equals("0")){mun3=q53Util.getMunicipio(sd,cpos3);}
        

        String update_proc2="";
        if(pais2.equals(""))pais2="0";
        
        update_proc2 = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='N', M5_COD_PAIS='"+pais2+"', "+
            "M5_COD_COMUNIDAD='"+codCCAA2+"', M5_COD_TERRITORIO='"+territorio2+"', M5_COD_MUNICIPIO='"+mun2+"', "+
            "M5_COD_COMARCA='', M5_NUM_PERSONAS="+numProc2+",M5_CPOS="+ cpos2 +
            " WHERE M5_COD_RESPUESTA="+cod_respuesta+" AND M5_COD_PREGUNTA="+cod_pregunta+" AND M5_COD_PROCEDENCIA=3";
        // q53LogEstadisticas.printLog("update_proc2 ::::"+update_proc2);
        PSP.sqlProclet(sd, "=" + update_proc2);

        
        String update_proc3="";
        if(pais3.equals(""))pais3="0";
        update_proc3 = "UPDATE RESP_PROCEDENCIA SET M5_LOCAL='N', M5_COD_PAIS='"+pais3+"',"+
            "M5_COD_COMUNIDAD='"+codCCAA3+"', M5_COD_TERRITORIO='"+territorio3+"', M5_COD_MUNICIPIO='"+mun3+"', "+
            "M5_COD_COMARCA='', M5_NUM_PERSONAS="+numProc3+",M5_CPOS="+ cpos3 +
            " WHERE M5_COD_RESPUESTA="+cod_respuesta+" AND M5_COD_PREGUNTA="+cod_pregunta+" AND M5_COD_PROCEDENCIA=4";
        // q53LogEstadisticas.printLog("update_proc3 ::::"+update_proc3);
        PSP.sqlProclet(sd, "=" + update_proc3);
        
        
       
    }

    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Fecha en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean
     * @param i
     * @param cod_respuesta
     *
     * @throws ProcletException
     */
    private static void modificarRptaFecha(ProcletServiceData sd,
        q53PreguntaBean preguntaBean, int i, String cod_respuesta)
        throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();
        PSP.paramProclet(sd,
            "fech_" + cod_pregunta + "_dia(),fech_" + cod_pregunta +
            "_mes(),fech_" + cod_pregunta + "_anio(),fech_" + cod_pregunta +
            "_hora("+Calendar.getInstance().get(Calendar.HOUR_OF_DAY)+"),chkHabilitar(),"+
            "fech_10_dia2(),fech_10_mes2(),fech_10_anio2()");
        //Modificamos la hora y fecha 
        String updatePreguntaTipo="";
        if(sd.gOS("chkHabilitar").length()>0){
        	    q53LogEstadisticas.printLog("Si hay Fecha Resp");
        		updatePreguntaTipo =
            "UPDATE RESP_FECHA SET M6_FECHA=TO_DATE('${fech_" + cod_pregunta +
            "_dia}${fech_" + cod_pregunta + "_mes}${fech_" + cod_pregunta +
            "_anio} ${fech_" + cod_pregunta +
            "_hora}:00:00','DDMMYYYY HH24:MI:SS')" + ",M6_HORA='${fech_" +
            cod_pregunta + "_hora}',M6_FECHA_RESPUESTA=TO_DATE('${fech_10_dia2}${fech_10_mes2}${fech_10_anio2} "+Calendar.getInstance().get(Calendar.HOUR_OF_DAY)+":00:00','DDMMYYYY HH24:MI:SS')" +
            " WHERE M6_COD_RESPUESTA=" + cod_respuesta +
            " AND M6_COD_PREGUNTA=" + cod_pregunta;
        }else{
        	    q53LogEstadisticas.printLog("No hay Fecha Resp");
        		updatePreguntaTipo =
            "UPDATE RESP_FECHA SET M6_FECHA=TO_DATE('${fech_" + cod_pregunta +
            "_dia}${fech_" + cod_pregunta + "_mes}${fech_" + cod_pregunta +
            "_anio} ${fech_" + cod_pregunta +
            "_hora}:00:00','DDMMYYYY HH24:MI:SS')" + ",M6_HORA='${fech_" +
            cod_pregunta + "_hora}' WHERE M6_COD_RESPUESTA=" + cod_respuesta +
            " AND M6_COD_PREGUNTA=" + cod_pregunta;
				}
        q53LogEstadisticas.printLog("updatePregutaTipo ::::"+updatePreguntaTipo);
        PSP.sqlProclet(sd, "=" + updatePreguntaTipo);
	
			  

        //07.05.2007 Modificar la fecha en q53m0t00
        if (cod_pregunta.equals("0"))
        {
            String updatem0="=UPDATE RESPUESTA SET M0_FECHA_RESP=TO_DATE('${fech_" + cod_pregunta + "_dia}"
            + "${fech_" + cod_pregunta + "_mes}${fech_" + cod_pregunta + "_anio} "
            + "${fech_" + cod_pregunta +"_hora}:00:00','DDMMYYYY HH24:MI:SS') " 
            + "WHERE M0_COD_RESPUESTA=" + cod_respuesta +";";
            PSP.sqlProclet(sd,updatem0);
            q53LogEstadisticas.printLog("updatem0 ::::"+updatem0);
        }
        //07.05.2007 FIN Modificar la fecha en q53m0t00
    }

    /**
     * Mtodo para insertar las respuesta de las preguntas de tipo Grupos en
     * B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param preguntaBean
     * @param i
     * @param cod_respuesta
     *
     * @throws ProcletException
     */
    private static void modificarRptaGrupos(ProcletServiceData sd,
        q53PreguntaBean preguntaBean, int i, String cod_respuesta)
        throws ProcletException {
        String cod_pregunta = preguntaBean.getCodPregunta();
        String tipo_pregunta = preguntaBean.getTipoPregunta();

        PSP.sqlProclet(sd,
            "formato_tmp=SELECT n7_tipo formato FROM q53n7t00 WHERE n7_cod_pregunta=" +
            cod_pregunta);
        if (sd.gOS("formato_tmp.formato").equals(q53Constantes.FORMATO_GRUPO_2)) {
            // Pregunta de grupos con formato de dos campos, 'Numero de personas'.
            String cadena_insert = "";
            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_1()");

            String grp1 = sd.gOS("grp_" + cod_pregunta + "_2_1");

            if (grp1.equals("")) {
                grp1 = "0";
            }

            //Actualizamos lso registros
/* 20.04.2007 */
                String cadena_insertHombres = ("=UPDATE RESP_GRUPOS SET N9_HOMBRES=" +
                    grp1 + ",N9_MUJERES=0 WHERE " + "N9_COD_RESPUESTA=" +
                    cod_respuesta + " AND N9_COD_PREGUNTA=" + cod_pregunta +
                    " AND N9_COD_GRUPO=1;");
                // q53LogEstadisticas.printLog("insertHombres :::: "+cadena_insertHombres);
                PSP.sqlProclet(sd, cadena_insertHombres);

            PSP.paramProclet(sd, "grp_" + cod_pregunta + "_2_2()");

            String grp2 = sd.gOS("grp_" + cod_pregunta + "_2_2");

            if (grp2.equals("")) {
                grp2 = "0";
            }

                String cadena_insertMujeres = ("=UPDATE RESP_GRUPOS SET N9_HOMBRES=0,N9_MUJERES=" +
                    grp2 + " WHERE " + "N9_COD_RESPUESTA=" + cod_respuesta +
                    " AND N9_COD_PREGUNTA=" + cod_pregunta +
                    " AND N9_COD_GRUPO=2;");
                // q53LogEstadisticas.printLog("cadena_insertMujeres ::::"+cadena_insertMujeres);
                PSP.sqlProclet(sd, cadena_insertMujeres);
/**/
            //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin 
            //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
            int intGrp1 = Integer.valueOf(grp1).intValue();
            int intGrp2 = Integer.valueOf(grp2).intValue();
            int totalPersonas = intGrp1 + intGrp2;

            //Aadimos en la tabla RESPUESTA el nmero de personas que han contestado a esta encuesta
            //para disponer de esta informacion mas facilmente a la hora de realizar las estadisticas
            String cadenaUpdate = "=UPDATE RESPUESTA SET M0_PERSONAS = " + totalPersonas
                                + " WHERE M0_COD_RESPUESTA=" + cod_respuesta + ";";
            // q53LogEstadisticas.printLog("cadenaUpdate ::::"+cadenaUpdate);
            PSP.sqlProclet(sd, cadenaUpdate);
        }
        //else if (sd.gOS("formato_tmp.formato").equals(q53Util.FORMATO_GRUPO_5)) {
        else if (sd.gOS("formato_tmp.formato").equals("5")) {
            // Pregunta de grupos con formato de cuatro campos, 'Grupos de edad'.
            String cadena_insert = "";

            String grpH = "";
            String grpM = "";
            boolean bMostrador = true;

            //Ahora insertamos los nuevos registros 
            for (int j = 1; j < 6; j++) {
                cadena_insert = "";
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j +
                    "_H()");
                grpH = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_H");
                PSP.paramProclet(sd, "grp_" + cod_pregunta + "_4_" + j +
                    "_M()");
                grpM = sd.gOS("grp_" + cod_pregunta + "_4_" + j + "_M");
                if (grpH.equals("")) {
                    grpH = "0";
                }

                if (grpM.equals("")) {
                    grpM = "0";
                }
//02.10.2006 Comentado para actualizar las edades correctamente.
//02.10.2006                if (!(grpH.equals("0") && grpM.equals("0"))) {
                    cadena_insert = ("=UPDATE RESP_GRUPOS set N9_HOMBRES=" +
                        grpH + ",N9_MUJERES=" + grpM +
                        " WHERE N9_COD_RESPUESTA=" + cod_respuesta +
                        " AND N9_COD_PREGUNTA=" + cod_pregunta +
                        " AND N9_COD_GRUPO=" + j + ";");
//02.10.2006                }
                // q53LogEstadisticas.printLog("cadena_insert ::::"+cadena_insert);
                PSP.sqlProclet(sd, cadena_insert);

                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin 
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();
                int total = intGrpH + intGrpM;
/* NUEVO 20.12.2006 */
    String cadena_delete =
                    "=delete from RESP_OPCIONES where M2_COD_OPCION=" + j +
                    " and" + " M2_COD_RESPUESTA=" + cod_respuesta +
                    " AND M2_COD_PREGUNTA=" + cod_pregunta + ";";
                // q53LogEstadisticas.printLog("cadena_delete ::::"+cadena_delete);
                PSP.sqlProclet(sd, cadena_delete);

                if (total > 0) {
                    String cadena_TotalPersonas = "=INSERT INTO RESP_OPCIONES (m2_cod_respuesta, m2_cod_pregunta, m2_cod_opcion) "
                            + " VALUES ("+cod_respuesta+", "+cod_pregunta+", "+j+")";
                    // q53LogEstadisticas.printLog("cadena_TotalPersonas ::::" +cadena_TotalPersonas);
                    PSP.sqlProclet(sd, cadena_TotalPersonas);
                }
/* FIN NUEVO */


                String cadena_insert2 = "";

                if (total > 0) {
                    bMostrador = false;
                }
            }
            if (bMostrador) {
                grpH = sd.gOS("grp_2_2_1");

                grpM = sd.gOS("grp_2_2_2");

                if (grpH.equals("")) {
                    grpH = "0";
                }

                if (grpM.equals("")) {
                    grpM = "0";
                }

                String cadenaUpdate2 = ("=UPDATE RESP_GRUPOS SET N9_HOMBRES=" +
                    grpH + ",N9_MUJERES=" + grpM + " WHERE " +
                    " N9_COD_RESPUESTA=" + cod_respuesta +
                    " AND N9_COD_PREGUNTA=" + cod_pregunta +
                    " AND N9_COD_GRUPO =5;");
                // q53LogEstadisticas.printLog("cadenaUpdate2 ::::"+cadenaUpdate2);
                PSP.sqlProclet(sd, cadenaUpdate2);

                //Tb modificamos la tabla RESP_OPCIONES para mantener la estructura de la informacin 
                //que nos permitira obtener correctamente la hoja excel a la hora de realizar la estadistica
                int intGrpH = Integer.valueOf(grpH).intValue();
                int intGrpM = Integer.valueOf(grpM).intValue();

                int total = intGrpH + intGrpM;
                if (total > 0) {
                    String cadena_TotalPersonas = ("=UPDATE RESP_OPCIONES SET M2_COD_OPCION=5 WHERE " +
                        " M2_COD_RESPUESTA=" + cod_respuesta +
                        " AND M2_COD_PREGUNTA=" + cod_pregunta);
                    bMostrador = false;
                    //q53LogEstadisticas.printLog("cadena_TotalPersonas ::::" +cadena_TotalPersonas);
                    PSP.sqlProclet(sd, cadena_TotalPersonas);
                }
            } // fin if bMostrador
        } // fin if formato_tmp.formato == 5
    }
}
