package itourbaskClases;

import itourbaskBeans.q53EncuestaBean;
import itourbaskBeans.q53FechaBean;
import itourbaskBeans.q53GrupoBean;
import itourbaskBeans.q53GruposBean;
import itourbaskBeans.q53OpcionBean;
import itourbaskBeans.q53OpcionesBean;
import itourbaskBeans.q53PreguntaBean;
import itourbaskBeans.q53TempNoPresencialBean;
import itourbaskBeans.q53TempPresencialBean;
import itourbaskBeans.q53TextoBean;

import java.util.ArrayList;
import java.util.List;

import q53_util.q53Constantes;
import q53_util.q53LogEstadisticas;
import q53_util.q53Util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53EncuestaClass {
    

    /**
     * Recorre las preguntas de una encuesta .
     *
     * @param sd El objeto ProcletServiceData
     *
     * @return
     *
     * @throws ProcletException
     */


    public static List generarEncuestas(ProcletServiceData sd)
        throws ProcletException {
        List pregOficinaList = recorrerPreguntas(sd, "preg_ofi");

        return pregOficinaList;
    }

    
    
    /**
     * 15/01/2009 Agregado por Alexeiw Martinez
     * Mira si la respuesta de GV contiene respuestas de oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param cod_respuesta El codigo univoco de la respuesta
     *
     * @return boolean true si hay respuestas de oficina
     *
     * @throws ProcletException
     */
    public static boolean tieneRespOfi(ProcletServiceData sd,String cod_respuesta)
        throws ProcletException {
        boolean hayRespOficina = false;

        String select_resp_ofi =
            "SELECT count(*) RESPUESTAS FROM Q53M0T00 WHERE M0_COD_RESPUESTA_RD<>M0_COD_RESPUESTA AND M0_COD_RESPUESTA_RD='"+cod_respuesta+"'";
         //q53LogEstadisticas.printLog("select_resp_ofi::::"+select_resp_ofi);
        PSP.sqlProclet(sd, "numRespOfi[]=" + select_resp_ofi);
         //q53LogEstadisticas.printLog("DESPUES DEL SQLPROCLET");
        int numRespOfi = sd.gI("numRespOfi[0].respuestas");
         //q53LogEstadisticas.printLog("NUMRESPOFI"+numRespOfi);
        if (numRespOfi > 0) {
        	hayRespOficina = true;
        }
        q53LogEstadisticas.printLog("HAYRESPOFICINA "+hayRespOficina);
        return hayRespOficina;
    }
    
    
    /**
     * 21/01/2009 
     * Coge el codigo de la respuesta de oficina asociada a la respuesta de gv
     *
     * @param sd El objeto ProcletServiceData
     * @param cod_respuesta El codigo univoco de la respuesta de gv
     *
     * @return string cod_respuesta_ofi
     *
     * @throws ProcletException
     */
    public static String coger_cod_ofi(ProcletServiceData sd,String cod_respuesta)
        throws ProcletException {
        String cod_respuesta_ofi = "";

        String select_resp_ofi =
            "SELECT M0_COD_RESPUESTA RESPUESTAS FROM Q53M0T00 WHERE M0_COD_RESPUESTA_RD<>M0_COD_RESPUESTA AND M0_COD_RESPUESTA_RD='"+cod_respuesta+"'";
        q53LogEstadisticas.printSql(select_resp_ofi);
        PSP.sqlProclet(sd, "codOfi[]=" + select_resp_ofi);
        cod_respuesta_ofi = sd.gS("codOfi[0].respuestas");
        q53LogEstadisticas.printLog("cod_respuesta_ofi: "+cod_respuesta_ofi);
        return cod_respuesta_ofi;
    }
    
    
      
    /**
     * 16/01/2009 Agregado por Alexeiw Martinez
     * Devuelve la encuesta de oficina que le pidamos mediante cod_encuesta y cod_version
     *
     * @param sd El objeto ProcletServiceData
     * @param cod_respuesta El codigo de la respuesta de la que queremos sacar las respuestas de oficina
     *
     * @return encuestaBean La encuesta de oficina correspondiente a esa respuesta
     * 
     * @throws ProcletException
     */
    public static q53EncuestaBean getEncuesta(ProcletServiceData sd,
        String cod_respuesta) throws ProcletException {   
    	
    	
    	
    	String cod_encuesta,cod_version;
    	q53LogEstadisticas.printLog("VALOR DE COD_RESPUESTA"+cod_respuesta);
    	q53EncuestaBean encuestaBean = new q53EncuestaBean();
    	
    	String select_cod_encuesta= "SELECT M0_COD_ENCUESTA,M0_COD_VERSION FROM Q53M0T00 WHERE M0_COD_RESPUESTA='"+cod_respuesta+"'";
    	q53LogEstadisticas.printSql("SELECT DE BUSQUEDA DEL CODIGO DE ENCUESTA"+select_cod_encuesta);
    	PSP.sqlProclet(sd, "cod_enc=" + select_cod_encuesta);
    	cod_encuesta=sd.gS("cod_enc.m0_cod_encuesta");
    	cod_version=sd.gS("cod_enc.m0_cod_version");
    	
    	
    	
  
        String select_encuesta = "SELECT " +
            "N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_RECOGIDA_DATOS, N0_TIPO_ENCUESTA " +
            " FROM ENCUESTA WHERE N0_COD_ENCUESTA='"+cod_encuesta+"' AND N0_COD_VERSION='"+cod_version+"'";
        
        q53LogEstadisticas.printSql("SELECT DE LA ENCUESTA DE OFICINA"+select_encuesta);
        PSP.sqlProclet(sd, "enc_ofi[]=" + select_encuesta);
        q53LogEstadisticas.printSql(select_encuesta);
        
			encuestaBean.setCodEncuesta(sd.gS("enc_ofi[0].n0_cod_encuesta"));
			

			//encuestaBean.setCodPersona(sd.gOS("q53_cki.q53_oficina"));
			encuestaBean.setCodVersion(sd.gS("enc_ofi[0].n0_cod_version"));

			encuestaBean.setDescripcionEncuesta(sd.gS("enc_ofi[0].n0_descripcion"));
			encuestaBean.setEncuestaTexto(sd.gS("enc_ofi[0].n0_texto"));
        return encuestaBean;
    }
    
    
    /**
     * Recorre las preguntas de una encuesta .
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     *
     * @return List con las pregunta de la encuesta
     *
     * @throws ProcletException
     */
    public static List recorrerPreguntas(ProcletServiceData sd, String pregs)
        throws ProcletException {
        List pregOficinaList = new ArrayList();

        String select_preg_ofi = "SELECT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA";
        select_preg_ofi += " FROM PREGUNTA, ENCUESTA_PREGUNTA";
        select_preg_ofi += (" WHERE NZ_COD_ENCUESTA=" +
        sd.gS("enc_visible[0].n0_cod_encuesta") + " AND NZ_COD_VERSION=" +
        sd.gS("enc_visible[0].n0_cod_version"));
        select_preg_ofi += " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA";
        select_preg_ofi += " ORDER BY NZ_ORDEN";

        q53LogEstadisticas.printSql(select_preg_ofi);
        PSP.sqlProclet(sd, "preg_ofi[]=" + select_preg_ofi);

        for (int i = 0; i < sd.gI(pregs + ".length"); i++) {
            q53PreguntaBean preguntaBean = new q53PreguntaBean();
            String tipo_pregunta = sd.gOS(pregs + "[" + i +
                    "].n1_tipo_pregunta");

            String cod_pregunta = sd.gOS(pregs + "[" + i + "].n1_cod_pregunta");

            String descripcion = sd.gOS(pregs + "[" + i + "].n1_descripcion");

            preguntaBean.setTipoPregunta(tipo_pregunta);
            preguntaBean.setCodPregunta(cod_pregunta);
            preguntaBean.setDescripcionPregunta(descripcion);

            boolean obligatoria = false;
            String pregObligatoria = sd.gOS(pregs + "[" + i +
                    "].nz_obligatoria");

            if (pregObligatoria.equals("S")) {
                obligatoria = true;
            }

            preguntaBean.setObligatoria(obligatoria);

            if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                q53OpcionesBean opcionesbean = cogerPreguntaOpciones(sd, pregs,
                        i);
                preguntaBean.setPreguntaOpciones(opcionesbean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                q53TextoBean textoBean = cogerPreguntaTexto(sd, pregs, i);
                preguntaBean.setPreguntaTexto(textoBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                q53FechaBean fechaBean = cogerPreguntaFecha(sd, pregs, i);
                preguntaBean.setPreguntaFecha(fechaBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                q53GruposBean gruposBean = cogerPreguntaGrupos(sd, pregs, i);
                preguntaBean.setPreguntaGrupos(gruposBean);
            }

            pregOficinaList.add(preguntaBean);
        }

        return pregOficinaList;
    }

	  /**
     * Recorre las preguntas de una encuesta .
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     *
     * @return List con las pregunta de la encuesta
     *
     * @throws ProcletException
     */
    public static List recorrerPreguntas(ProcletServiceData sd, String pregs,String codEncuesta,String codVersion)
        throws ProcletException {
        List pregOficinaList = new ArrayList();

        String select_preg_ofi = "SELECT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA";
        select_preg_ofi += " FROM PREGUNTA, ENCUESTA_PREGUNTA";
        select_preg_ofi += (" WHERE NZ_COD_ENCUESTA=" +
        codEncuesta + " AND NZ_COD_VERSION=" +
        codVersion);
        select_preg_ofi += " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA";
        select_preg_ofi += " ORDER BY NZ_ORDEN";

        // q53LogEstadisticas.printLog("select_preg_ofi::::"+select_preg_ofi);
		PSP.sqlProclet(sd, "preg[]=" + select_preg_ofi);

        for (int i = 0; i < sd.gI(pregs + ".length"); i++) {
            q53PreguntaBean preguntaBean = new q53PreguntaBean();
            String tipo_pregunta = sd.gOS(pregs + "[" + i +
                    "].n1_tipo_pregunta");

            String cod_pregunta = sd.gOS(pregs + "[" + i + "].n1_cod_pregunta");

            String descripcion = sd.gOS(pregs + "[" + i + "].n1_descripcion");

            preguntaBean.setTipoPregunta(tipo_pregunta);
            preguntaBean.setCodPregunta(cod_pregunta);
            preguntaBean.setDescripcionPregunta(descripcion);

            boolean obligatoria = false;
            String pregObligatoria = sd.gOS(pregs + "[" + i +
                    "].nz_obligatoria");

            if (pregObligatoria.equals("S")) {
                obligatoria = true;
            }

            preguntaBean.setObligatoria(obligatoria);

            if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                q53OpcionesBean opcionesbean = cogerPreguntaOpciones(sd, pregs,
                        i);
                preguntaBean.setPreguntaOpciones(opcionesbean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                q53TextoBean textoBean = cogerPreguntaTexto(sd, pregs, i);
                preguntaBean.setPreguntaTexto(textoBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                q53FechaBean fechaBean = cogerPreguntaFecha(sd, pregs, i);
                preguntaBean.setPreguntaFecha(fechaBean);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                q53GruposBean gruposBean = cogerPreguntaGrupos(sd, pregs, i);
                preguntaBean.setPreguntaGrupos(gruposBean);
            }

            pregOficinaList.add(preguntaBean);
        }

        return pregOficinaList;
    }

    /**
     * Recoje las preguntas de tipo Fecha de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @return q53FechaBean objeto que contiene los datos de la pregunta de
     *         tipo Fecha
     *
     * @throws ProcletException
     */
    public static q53FechaBean cogerPreguntaFecha(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        String formato_fecha = q53Constantes.FORMATO_FECHA_CAS; // por defecto en castellano.

        if (sd.gOS("q53_cki.q53_idioma").equals(q53Constantes.IDIOMA_EUS)) {
            // si el idioma es euskera, muestra la fecha en formato de euskera
            formato_fecha = q53Constantes.FORMATO_FECHA_EUS;
        }

        String select_preg = "SELECT TO_CHAR(N6_FECHA_MIN,'" + formato_fecha +
            "') N6_FECHA_MIN, TO_CHAR(N6_FECHA_MAX,'" + formato_fecha +
            "') N6_FECHA_MAX";
        select_preg += " FROM PR_FECHA ";
        select_preg += (" WHERE N6_COD_PREGUNTA=${" + pregs + "[" + i +
        "].n1_cod_pregunta}");

        // q53LogEstadisticas.printLog("select_preg ::::"+select_preg);
        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);

        q53FechaBean fechaBean = new q53FechaBean();

        String fecha_min = sd.gOS(pregs + "_" + i + "[0].n6_fecha_min");
        String fecha_max = sd.gOS(pregs + "_" + i + "[0].n6_fecha_max");

        fechaBean.setFechaMax(fecha_max);
        fechaBean.setFechaMin(fecha_min);

        return fechaBean;
    }

    /**
     * Recoje las preguntas de tipo texto de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @return q53TextoBean objeto que contiene los datos de la pregutna de
     *         tipo texto
     *
     * @throws ProcletException
     */
    public static q53TextoBean cogerPreguntaTexto(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        q53TextoBean textoBean = new q53TextoBean();

        try {
            String select_preg = "SELECT N4_TAMANO";
            select_preg += " FROM PR_TEXTO";
            select_preg += (" WHERE N4_COD_PREGUNTA=${" + pregs + "[" + i +
            "].n1_cod_pregunta}");
            //q53LogEstadisticas.printLog("select_preg ::::"+select_preg);
            PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);

            String tamano = sd.gOS(pregs + "_" + i + "[0].n4_tamano");
            textoBean.setTamaoTexto((new Integer(tamano)).intValue());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return textoBean;
    }

    /**
     * Recoje las preguntas de tipo grupo grupos de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @return q53GruposBean objeto que cntien los datos de la pregunta de tipo
     *         grupos
     *
     * @throws ProcletException
     */
    public static q53GruposBean cogerPreguntaGrupos(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        String select_preg = "SELECT N7_TIPO, N8_COD_GRUPO, N8_DESCRIPCION, N8_TAMANO";
        select_preg += " FROM PR_GRPS_GRUPO, PR_GRUPOS";
        select_preg += (" WHERE N8_COD_PREGUNTA=${" + pregs + "[" + i +
        "].n1_cod_pregunta}");
        select_preg += " AND N8_COD_PREGUNTA=N7_COD_PREGUNTA";
        select_preg += " ORDER BY N8_ORDEN";

        // q53LogEstadisticas.printLog("select_preg ::::"+select_preg);
        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);

        q53GruposBean gruposBean = new q53GruposBean();
        String cod_pregunta = sd.gOS(pregs + "[" + i + "].n1_cod_pregunta");
        String q53_idioma = q53Util.getIdioma(sd);

        String tipo = sd.gOS(pregs + "_" + i + "[0].n7_tipo");
        gruposBean.setTipoGrupo(tipo);

        if (tipo.equals(q53Constantes.FORMATO_GRUPO_2)) {
            List gruposList = new ArrayList();

            for (int j = 0; j < sd.gI(pregs + "_" + i + ".length"); j++) {
                q53GrupoBean grupoBean = new q53GrupoBean();
                String cod_grupo = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n8_cod_grupo");
                grupoBean.setCodGrupo(cod_grupo);

                String descrip_grupo = q53Util.getLiteral(sd,
                        "N8_" + cod_pregunta + "_" + cod_grupo, q53_idioma);
                grupoBean.setDescGrupo(descrip_grupo);

                String tamano = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n8_tamano");
                grupoBean.setTamaoGrupo((new Integer(tamano)).intValue());
                grupoBean.setOrdenGrupo(j);
                gruposList.add(grupoBean);
            }

            gruposBean.setGrupoBean(gruposList);
        } else if (tipo.equals(q53Constantes.FORMATO_GRUPO_4)) {
            List gruposList = new ArrayList();

            for (int j = 0; j < sd.gI(pregs + "_" + i + ".length"); j++) {
                q53GrupoBean grupoBean = new q53GrupoBean();
                String cod_grupo = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n8_cod_grupo");
                grupoBean.setCodGrupo(cod_grupo);

                String descrip_grupo = q53Util.getLiteral(sd,
                        "N8_" + cod_pregunta + "_" + cod_grupo, q53_idioma);
                grupoBean.setDescGrupo(descrip_grupo);

                String tamano = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n8_tamano");
                grupoBean.setTamaoGrupo((new Integer(tamano)).intValue());
                grupoBean.setOrdenGrupo(j);
                gruposList.add(grupoBean);
            }

            gruposBean.setGrupoBean(gruposList);
        }

        return gruposBean;
    }

    /**
     * Recoje las preguntas de tipo grupo opciones de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @return q53OpcionesBean Objeto que contiene los datos de la pregutna de
     *         tipo Opciones
     *
     * @throws ProcletException
     */
    public static q53OpcionesBean cogerPreguntaOpciones(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        String select_preg = "SELECT N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION ";
        select_preg += " FROM PR_OPS_OPCION, PR_OPCIONES ";
        select_preg += (" WHERE N3_COD_PREGUNTA = ${" + pregs + "[" + i +
        "].n1_cod_pregunta} ");
        select_preg += " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA";
        select_preg += " ORDER BY N3_ORDEN";

        // q53LogEstadisticas.printLog("select_preg ::::"+select_preg);
        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);

        q53OpcionesBean opcionesBean = new q53OpcionesBean();

        String formato = sd.gOS(pregs + "_" + i + "[0].n2_formato");
        opcionesBean.setFormato(formato);

        if (formato.equals(q53Constantes.FORMATO_SELECT)) {
            List opcionesList = new ArrayList();

            for (int j = 0; j < sd.gI(pregs + "_" + i + ".length"); j++) {
                q53OpcionBean opcionBean = new q53OpcionBean();
                String cod_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_cod_opcion");
                opcionBean.setCodOpciones(cod_opcion);

                String descripcion_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_descripcion");
                opcionBean.setDescipcionOpcion(descripcion_opcion);
                opcionBean.setOrdenOpciones(j);
                opcionesList.add(opcionBean);
            }

            opcionesBean.setOpcionList(opcionesList);
        } else if (formato.equals(q53Constantes.FORMATO_CHECK)) {
            List opcionesList = new ArrayList();

            for (int j = 0; j < sd.gI(pregs + "_" + i + ".length"); j++) {
                q53OpcionBean opcionBean = new q53OpcionBean();
                String cod_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_cod_opcion");
                opcionBean.setCodOpciones(cod_opcion);

                String descripcion_opcion = "";
                descripcion_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_descripcion");
                opcionBean.setDescipcionOpcion(descripcion_opcion);
                opcionBean.setOrdenOpciones(j);
                opcionesList.add(opcionBean);
            }

            opcionesBean.setOpcionList(opcionesList);
        } else if (formato.equals(q53Constantes.FORMATO_RADIO)) {
            List opcionesList = new ArrayList();

            for (int j = 0; j < sd.gI(pregs + "_" + i + ".length"); j++) {
                q53OpcionBean opcionBean = new q53OpcionBean();
                String cod_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_cod_opcion");
                opcionBean.setCodOpciones(cod_opcion);

                String descripcion_opcion = "";
                descripcion_opcion = sd.gOS(pregs + "_" + i + "[" + j +
                        "].n3_descripcion");
                opcionBean.setDescipcionOpcion(descripcion_opcion);
                opcionBean.setOrdenOpciones(j);
                opcionesList.add(opcionBean);
            }

            opcionesBean.setOpcionList(opcionesList);
        }

        return opcionesBean;
    }

    /**
     * Mira si ha alguna encuesta propia de la oficina visible.
     *
     * @param sd El objeto ProcletServiceData
     *
     * @return boolean true si hay encuesta propia de la oficina visible y
     *         false en caso contrario
     *
     * @throws ProcletException
     */
    public static boolean isEncuestaOficinaVisible(ProcletServiceData sd)
        throws ProcletException {
        boolean hayEncVisible = false;
        int num_enc_visible_propio = 0;
        int num_enc_visible_padre = 0;
        
        String ofiPadre = "ofiPadre[] = SELECT NVL(T02_COPADRE,'NADA')T02_COPADRE FROM OFICINA WHERE T02_COOR = '" + sd.gOS("q53_cki.q53_oficina") + "';";
        q53LogEstadisticas.printSql("ofiPadre:"+ofiPadre);
        PSP.sqlProclet(sd, ofiPadre);

        if(sd.gOS("ofiPadre[0].t02_copadre").equals("NADA")){ 
            num_enc_visible_padre = 0;
        }else{
            String select_num_enc_visible_padre = "SELECT count(*) NUMENC_VISIBLES FROM ENCUESTA WHERE N0_COD_OFICINA = '" +sd.gOS("ofiPadre[0].t02_copadre") +
            "' AND N0_VISIBLE ='S' AND N0_COD_ENCUESTA != 0 AND N0_VERSION_ANTIGUA='N'";
           q53LogEstadisticas.printSql("select_num_enc_visible_padre "+select_num_enc_visible_padre);
            PSP.sqlProclet(sd, "num_enc_visible_padre[]=" + select_num_enc_visible_padre);

            num_enc_visible_padre = sd.gI("num_enc_visible_padre[0].numenc_visibles");
        }
        
        String select_num_enc_visible_propio = "SELECT count(*) NUMENC_VISIBLES FROM ENCUESTA WHERE N0_COD_OFICINA = '" +sd.gOS("q53_cki.q53_oficina") +
            "' AND N0_VISIBLE ='S' AND N0_COD_ENCUESTA != 0 AND N0_VERSION_ANTIGUA='N'";
        q53LogEstadisticas.printSql("select_num_enc_visible_propio "+select_num_enc_visible_propio);
        PSP.sqlProclet(sd, "num_enc_visible_propio[]=" + select_num_enc_visible_propio);

        num_enc_visible_propio = sd.gI("num_enc_visible_propio[0].numenc_visibles");

        if ((num_enc_visible_propio > 0)||(num_enc_visible_padre > 0)) {
            hayEncVisible = true;
        }

        return hayEncVisible;
    }
    
 

    /**
     * Mira si ha alguna encuesta propia de la oficina visible.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina
     *
     * @return boolean true si hay encuesta propia de la oficina visible y
     *         false en caso contrario
     *
     * @throws ProcletException
     */
    public static q53EncuestaBean getEncuestaVisible(ProcletServiceData sd,
        String codOficina) throws ProcletException {
        q53EncuestaBean encuestaBean = new q53EncuestaBean();
        String select_visible = "SELECT " +
            "N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_RECOGIDA_DATOS, N0_TIPO_ENCUESTA " +
            " FROM ENCUESTA WHERE N0_COD_OFICINA = '" + codOficina +
            "' AND N0_VISIBLE ='S' AND N0_VERSION_ANTIGUA='N'";

        q53LogEstadisticas.printDebug(select_visible);
        PSP.sqlProclet(sd, "enc_visible[]=" + select_visible);
        q53LogEstadisticas.printSql("Escribo la query encuestaBean: " + select_visible);
        
		if(sd.gI("enc_visible.length") >0){
			encuestaBean.setCodEncuesta(sd.gS("enc_visible[0].n0_cod_encuesta"));
			
			
			encuestaBean.setCodOficina(codOficina);

			//encuestaBean.setCodPersona(sd.gOS("q53_cki.q53_oficina"));
			encuestaBean.setCodVersion(sd.gS("enc_visible[0].n0_cod_version"));

			encuestaBean.setDescripcionEncuesta(sd.gS("enc_visible[0].n0_descripcion"));
			encuestaBean.setEncuestaTexto(sd.gS("enc_visible[0].n0_texto"));
			
						
			boolean esRecogidaDatos = false;

			if (sd.gS("enc_visible[0].n0_recogida_datos").equals("S")) {
				esRecogidaDatos = true;
			}

			encuestaBean.setEncuestaVisible(true);
			encuestaBean.setRecogidaDatos(esRecogidaDatos);
		}
		

        

        return encuestaBean;
    }
    
    public static q53EncuestaBean getEncuestaVisiblePres(ProcletServiceData sd,
            String codOficina) throws ProcletException {
            q53EncuestaBean encuestaBean = new q53EncuestaBean();
            String select_visible = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_RECOGIDA_DATOS, N0_TIPO_ENCUESTA FROM ENCUESTA WHERE";
            
            select_visible += " N0_COD_OFICINA = '" + codOficina +
            "' AND N0_VISIBLE ='S' AND N0_VERSION_ANTIGUA='N' AND (N0_TIPO_ENCUESTA='pres' or N0_TIPO_ENCUESTA IS NULL)";
         
            q53LogEstadisticas.printDebug(select_visible);
            PSP.sqlProclet(sd, "enc_visible[]=" + select_visible);
            q53LogEstadisticas.printSql("Escribo la query encuestaBean VisiblePres: " + select_visible);
            
            if(sd.gI("enc_visible.length") >0){
                encuestaBean.setCodEncuesta(sd.gS("enc_visible[0].n0_cod_encuesta"));
                
                
                encuestaBean.setCodOficina(codOficina);

                //encuestaBean.setCodPersona(sd.gOS("q53_cki.q53_oficina"));
                encuestaBean.setCodVersion(sd.gS("enc_visible[0].n0_cod_version"));

                encuestaBean.setDescripcionEncuesta(sd.gS("enc_visible[0].n0_descripcion"));
                encuestaBean.setEncuestaTexto(sd.gS("enc_visible[0].n0_texto"));
                
                            
                boolean esRecogidaDatos = false;

                if (sd.gS("enc_visible[0].n0_recogida_datos").equals("S")) {
                    esRecogidaDatos = true;
                }

                encuestaBean.setEncuestaVisible(true);
                encuestaBean.setRecogidaDatos(esRecogidaDatos);
            }
            return encuestaBean;
        }
    
    public static q53EncuestaBean getEncuestaVisibleNoPres(ProcletServiceData sd,
            String codOficina) throws ProcletException {
            q53EncuestaBean encuestaBean = new q53EncuestaBean();
            String select_visible = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_TEXTO, N0_RECOGIDA_DATOS, N0_TIPO_ENCUESTA FROM ENCUESTA WHERE";
                    
            select_visible += " N0_COD_OFICINA = '" + codOficina +
            "' AND N0_VISIBLE ='S' AND N0_VERSION_ANTIGUA='N' AND (N0_TIPO_ENCUESTA='nopres' or N0_TIPO_ENCUESTA IS NULL)";    

            q53LogEstadisticas.printDebug(select_visible);
            PSP.sqlProclet(sd, "enc_visible[]=" + select_visible);
            q53LogEstadisticas.printSql("Escribo la query encuestaBean VisibleNoPres: " + select_visible);
            
            if(sd.gI("enc_visible.length") >0){
                encuestaBean.setCodEncuesta(sd.gS("enc_visible[0].n0_cod_encuesta"));
                
                
                encuestaBean.setCodOficina(codOficina);

                //encuestaBean.setCodPersona(sd.gOS("q53_cki.q53_oficina"));
                encuestaBean.setCodVersion(sd.gS("enc_visible[0].n0_cod_version"));

                encuestaBean.setDescripcionEncuesta(sd.gS("enc_visible[0].n0_descripcion"));
                encuestaBean.setEncuestaTexto(sd.gS("enc_visible[0].n0_texto"));
                
                            
                boolean esRecogidaDatos = false;

                if (sd.gS("enc_visible[0].n0_recogida_datos").equals("S")) {
                    esRecogidaDatos = true;
                }

                encuestaBean.setEncuestaVisible(true);
                encuestaBean.setRecogidaDatos(esRecogidaDatos);
            }
            

            

            return encuestaBean;
        }
    
    
 

    /**
     * Mira si hay encuestas propias de la oficina visible.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina
     *
     * @return boolean true si hay encuesta propia de la oficina y false en
     *         caso contrario.
     *
     * @throws ProcletException
     */
    public static boolean isEncuestaOficina(ProcletServiceData sd,
        String codOficina,String codPadre) throws ProcletException {
        boolean hayEncuestasOficina = false;

        
        String select_enc_ofi = "SELECT COUNT(*) NUM_ENC";
        select_enc_ofi += " FROM ENCUESTA";

        if ((codPadre != null) && !codPadre.equals("")) {
            select_enc_ofi += (" WHERE N0_COD_OFICINA='" + codPadre +
            "' AND N0_VERSION_ANTIGUA='N'");
        } else {
            select_enc_ofi += (" WHERE N0_COD_OFICINA='" + codOficina +
            "' AND N0_VERSION_ANTIGUA='N'");
        }

        //q53LogEstadisticas.printLog("select_enc_ofi ::::"+select_enc_ofi);
        PSP.sqlProclet(sd, "num_enc[]=" + select_enc_ofi);

        int numEnc = sd.gI("num_enc[0].num_enc");

        if (numEnc > 0) {
            hayEncuestasOficina = true;
        }

        return hayEncuestasOficina;
    }

    /**
     * Mira si hay encuestas propias de la oficina visible.
     *
     * @param sd El objeto ProcletServiceData
     * @param codOficina String codigo de la oficina
     *
     * @return String con el codigo de la oficina padre si es que de verdad es
     *         una oficina hijo o un string vacio en caso contrario
     *
     * @throws ProcletException
     */
    public static String getCodOfiPadre(ProcletServiceData sd, String codOficina)
        throws ProcletException {
        String codPadre = "";

        String select_enc_ofi = "SELECT T02_COPADRE";
        select_enc_ofi += " FROM OFICINA";
        select_enc_ofi += (" WHERE T02_COOR='" + codOficina+"'");

        //q53LogEstadisticas.printLog("select_enc_ofi ::::"+select_enc_ofi);
        PSP.sqlProclet(sd, "ofiHija[]=" + select_enc_ofi);

        String ofiHija = sd.gOS("ofiHija[0].t02_copadre");

        if ((ofiHija != null) && !ofiHija.equals("")) {
            codPadre = sd.gOS("ofiHija[0].t02_copadre");
        }

        return codPadre;
    }

    /**
     * Mtodo para saber la fecha maxima y mnima de la encuesta del g.v.
     *
     * @param sd El objeto ProcletServiceData
     *
     * @return q53FechaBean Objeto que contiene la fecha mxima y mnima.
     *
     * @throws ProcletException
     */
    public static q53FechaBean getGVDate(ProcletServiceData sd)
        throws ProcletException {
        q53FechaBean fechaBean = new q53FechaBean();
        String select_enc_ofi = "SELECT N6_FECHA_MIN, N6_FECHA_MAX";
        select_enc_ofi += " FROM PR_FECHA";
        select_enc_ofi += (" WHERE N6_COD_PREGUNTA='0'");

        //q53LogEstadisticas.printLog("select_enc_ofi ::::"+select_enc_ofi);
        PSP.sqlProclet(sd, "fechas[]=" + select_enc_ofi);

        fechaBean.setFechaMax(sd.gOS("fechas[0].n6_fecha_max"));
        fechaBean.setFechaMin(sd.gOS("fechas[0].n6_fecha_min"));

        return fechaBean;
    }

    /**
     * Mtodo para saber el nmero de encuestas que se han realizado en ese
     * dia.
     *
     * @param sd El objeto ProcletServiceData
     *
     * @return String Nmero de encuestas realizadas.
     *
     * @throws ProcletException
     */
    public static String getNumEncuestasHoy(ProcletServiceData sd)
        throws ProcletException {
        String numEncHoy = "0";
        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(
                "dd/MM/yyyy");
        String fechaActual = sdf.format(new java.util.Date());
        String select_num_enc_hoy =
            "SELECT COUNT(*) NUM_ENC FROM RESPUESTA WHERE M0_COD_OFICINA = '" +
            sd.gOS("q53_cki.q53_oficina") + "' AND TO_CHAR(M0_FECHA ,'" +
            q53Constantes.FORMATO_FECHA_CAS + "') ='" + fechaActual +
            "' AND M0_COD_ENCUESTA='0'";

        //q53LogEstadisticas.printLog("select_num_enc_hoy ::::"+select_num_enc_hoy);
        PSP.sqlProclet(sd, "select_num_enc_hoy[]=" + select_num_enc_hoy);
        numEncHoy = sd.gOS("select_num_enc_hoy[0].num_enc");

        return numEncHoy;
    }

    /**
     * Mtodo que nos devuelve los datos de la encuesta del gv filtrada por
     * fechas
     *
     * @param sd el objeto ProcletServiceData
     * @param codOficina String cdigo de la oficina
     * @param codEncuesta String codigo de la encuesta (como es la del g.v. es
     *        0)
     * @param codVersion String cdigo de la version de la encuesta
     * @param fechaInicio String Fecha inicio (rellenada en la pgina de
     *        bsquedas)
     * @param fechaFin String  Fecha fin (rellenada en la pgina de bsquedas)
     *
     * @return q53EncuestaBean objeto que contiene todos los datos de la
     *         encuesta
     *
     * @throws ProcletException
     */
    public static q53EncuestaBean getEncByDate(ProcletServiceData sd,
        String codOficina, String codEncuesta, String codVersion,
        String fechaInicio, String fechaFin) throws ProcletException {
        q53EncuestaBean encuestaBean = null;
        String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, N0_TEXTO";
        select_enc += " FROM ENCUESTA";
        
        String fechaInicioVis = sd.gOS("fechaInicioVis");
        String fechaFinVis = sd.gOS("fechaFinVis");

        /*Miramos si lo que quiere ver son todas las respuestas de la encuesta de la oficina
        o si lo que quiere ver son todas las respuestas de la encuesta del g.v.*/
// 26.09.2006        if (codEncuesta.equals("")) {
        if (codEncuesta.equals("") || codEncuesta.equals("0")) {
            // no hay cod_encuesta. Hay que sacar la encuesta de recogida de datos del g.v.
            //con filtro de fechas
            if (!fechaInicio.equals("") && !fechaFin.equals("")) {
            	q53LogEstadisticas.printLog("fechaInicio: "+fechaInicio);
            	//q53LogEstadisticas.printLog("fechaFin: "+fechaFin);
                select_enc += (", RESPUESTA WHERE M0_COD_OFICINA='" +
                codOficina +
                "' AND N0_RECOGIDA_DATOS='S' AND N0_VERSION_ANTIGUA='N' AND M0_COD_ENCUESTA = N0_COD_ENCUESTA AND M0_COD_VERSION = N0_COD_VERSION AND M0_COD_ENCUESTA = " +
                q53Constantes.COD_ENCUESTA_PPAL +
                " AND respuesta.m0_fecha BETWEEN TO_DATE ('" +
                fechaInicio +
                "', 'DD/MM/YYYY HH24:MI:SS') AND TO_DATE ('" +
                fechaFin + "', 'DD/MM/YYYY HH24:MI:SS')+1  ORDER BY M0_FECHA DESC");
            }else if (!fechaInicioVis.equals("") && !fechaFinVis.equals("")) {
            	q53LogEstadisticas.printLog("fechaInicioVis: "+fechaInicioVis);
            	//q53LogEstadisticas.printLog("fechaFinVis: "+fechaFinVis);
                    select_enc += (", RESPUESTA WHERE M0_COD_OFICINA='" +
                    codOficina +
                    "' AND N0_RECOGIDA_DATOS='S' AND N0_VERSION_ANTIGUA='N' AND M0_COD_ENCUESTA = N0_COD_ENCUESTA AND M0_COD_VERSION = N0_COD_VERSION AND M0_COD_ENCUESTA = " +
                    q53Constantes.COD_ENCUESTA_PPAL +
                    " AND respuesta.m0_fecha_resp BETWEEN TO_DATE ('" +
                    fechaInicioVis +
                    "', 'DD/MM/YYYY HH24:MI:SS') AND TO_DATE ('" +
                    fechaFinVis + "', 'DD/MM/YYYY HH24:MI:SS')+1  ORDER BY M0_FECHA_RESP DESC");
                }

            sd.setVal("pagina", "recogida_de_datos");
        }
        q53LogEstadisticas.printSql(select_enc);
        PSP.sqlProclet(sd, "enc[]=" + select_enc);
        if (sd.gI("enc.length") > 0) {
            encuestaBean = new q53EncuestaBean();
            encuestaBean.setCodEncuesta("0");
            encuestaBean.setCodOficina(codOficina);
            encuestaBean.setCodVersion("1");

            encuestaBean.setDescripcionEncuesta(sd.gOS("enc[0].no_descripcion"));

            boolean recogidaDatos = false;

            if (sd.gOS("enc[0].n0_recogida_datos").equals("S")) {
                recogidaDatos = true;
            }

            encuestaBean.setRecogidaDatos(recogidaDatos);
            encuestaBean.setEncuestaTexto(sd.gOS("enc[0].n0_texto"));
        }

        return encuestaBean;
    }

    /**
     * Mtodo que nos devuelve los datos de la encuesta del gv
     *
     * @param sd el objeto ProcletServiceData
     * @param codEncuesta String codigo de la encuesta (como es la del g.v. es
     *        0)
     * @param codVersion String cdigo de la version de la encuesta
     *
     * @return q53EncuestaBean objeto que contiene todos los datos de la
     *         encuesta
     *
     * @throws ProcletException
     */
    public static q53EncuestaBean getGVEncData(ProcletServiceData sd,
        String codEncuesta, String codVersion) throws ProcletException {
        q53EncuestaBean encuestaBean = null;

		q53LogEstadisticas.printLog("q53EncuestaBean obtener Encuentas GV");  
		/*Miramos si lo que quiere ver son todas las respuestas de la encuesta de la oficina
        o si lo que quiere ver son todas las respuestas de la encuesta del g.v.*/
        if (codEncuesta.equals("")) {
            codEncuesta = "0";
            codVersion = "1";
        }

        String select_enc = "SELECT N0_COD_ENCUESTA, N0_COD_VERSION, N0_DESCRIPCION, N0_RECOGIDA_DATOS, N0_TEXTO";
        select_enc += (" FROM ENCUESTA WHERE  N0_VERSION_ANTIGUA='N' AND N0_COD_ENCUESTA = " +
        q53Constantes.COD_ENCUESTA_PPAL + " AND N0_COD_VERSION=1");

        sd.setVal("pagina", "recogida_de_datos");

		q53LogEstadisticas.printLog("q53EncuestaBean select_enc: <" + select_enc + ">");  
        PSP.sqlProclet(sd, "enc[]=" + select_enc);

        if (sd.gI("enc.length") > 0) {
			q53LogEstadisticas.printLog("q53EncuestaBean encuentra numero de registros: <" + sd.gI("enc.length") + ">");  
            encuestaBean = new q53EncuestaBean();
            encuestaBean.setCodEncuesta("0");

            //encuestaBean.setCodOficina(codOficina);
            encuestaBean.setCodVersion("1");

            encuestaBean.setDescripcionEncuesta(sd.gOS("enc[0].no_descripcion"));

            boolean recogidaDatos = false;

			q53LogEstadisticas.printLog("q53Encuentabean sd.gOS(enc[0].n0_recogida_datos): <" + sd.gOS("enc[0].n0_recogida_datos") + ">");  
            if (sd.gOS("enc[0].n0_recogida_datos").equals("S")) {
                recogidaDatos = true;
            }

            encuestaBean.setRecogidaDatos(recogidaDatos);
            encuestaBean.setEncuestaTexto(sd.gOS("enc[0].n0_texto"));
        }

        return encuestaBean;
    }

    /**
     * Mtodo que nos devuelve los datos de las preguntas de la encuesta propia
     * de la oficina y del g.v.
     *
     * @param sd El objeto ProcletServiceData
     * @param codEncuestaOfi String que es el codigo de la encuesta propia de
     *        la oficina.
     * @param codVersionEncOfi String que es el codigo de la version de la
     *        encuesta propia de la oficina.
     *
     * @return List lista con los datos de las preguntas de la encuesta propia
     *         de la oficina
     *
     * @throws ProcletException
     */
    public static List getPreguntasEncOfiData(ProcletServiceData sd, String codEncuestaOfi, String codVersionEncOfi) throws ProcletException {
        List preguntasEncOfiList = new ArrayList();
        String select_preg_ofi = "SELECT N1_COD_PREGUNTA, N1_DESCRIPCION, N1_TIPO_PREGUNTA, NZ_ORDEN, NZ_OBLIGATORIA"
                    + " FROM PREGUNTA, ENCUESTA_PREGUNTA"
                    + " WHERE NZ_COD_ENCUESTA=" + codEncuestaOfi 
                    + " AND NZ_COD_VERSION=" + codVersionEncOfi
                    + " AND NZ_COD_PREGUNTA=N1_COD_PREGUNTA"
                    + " ORDER BY NZ_ORDEN";

        PSP.sqlProclet(sd, "preg_ofi[]=" + select_preg_ofi);
        q53LogEstadisticas.printDebug("preg_ofi[]=" + select_preg_ofi);

        for (int i = 0; i < sd.gI("preg_ofi.length"); i++) {
            q53PreguntaBean preguntaBean = new q53PreguntaBean();
            preguntaBean.setCodPregunta(sd.gOS("preg_ofi[" + i +
                    "].n1_cod_pregunta"));
            preguntaBean.setDescripcionPregunta(sd.gOS("preg_ofi[" + i +
                    "].n1_descripcion"));
            preguntaBean.setTipoPregunta(sd.gOS("preg_ofi[" + i +
                    "].n1_tipo_pregunta"));
			q53LogEstadisticas.printDebug("contador i -: "  + i + "-");
			q53LogEstadisticas.printDebug("n1_descripcion: "  + sd.gOS("preg_ofi[" + i +
                    "].n1_descripcion"));
			q53LogEstadisticas.printDebug("n1_cod_pregunta: "  + sd.gOS("preg_ofi[" + i +
                    "].n1_cod_pregunta"));
			q53LogEstadisticas.printDebug("n1_tipo_pregunta: "  + sd.gOS("preg_ofi[" + i +
                    "].n1_tipo_pregunta"));

            boolean obligatoria = false;

            if (sd.gOS("preg_ofi[" + i + "].nz_obligatoria").equals("S")) {
                obligatoria = true;
				q53LogEstadisticas.printDebug("Obligatoria: TRUE");
           }

            preguntaBean.setObligatoria(obligatoria);
						
			preguntaBean.setOrden(sd.gOS("preg_ofi[" + i + "].nz_orden"));
			q53LogEstadisticas.printDebug("sd.gOS(preg_ofi[" + i + "].nz_orden) : -" + sd.gOS("preg_ofi[" + i + "].nz_orden"));
						
            if (preguntaBean.getTipoPregunta().equals(q53Constantes.TIPO_FECHA)) {
                q53FechaBean fechaBean = getDateMinMax(sd,
                        preguntaBean.getCodPregunta());
                preguntaBean.setPreguntaFecha(fechaBean);
            } else if (preguntaBean.getTipoPregunta().equals(q53Constantes.TIPO_OPCIONES)) {
                q53OpcionesBean opcionesBean = getFormatoPregunta(sd,
                        preguntaBean.getCodPregunta());
                preguntaBean.setPreguntaOpciones(opcionesBean);
            }
            preguntasEncOfiList.add(preguntaBean);
        }

        return preguntasEncOfiList;
    }

    /**
     * Mtodo para saber la fecha maxima y mnima de la pregutna de tipo fecha
     * para la encuesta propia de la oficina.
     *
     * @param sd El objeto ProcletServiceData
     * @param codPregunta codigo de la pregunta de tipo fecha de la encuesta
     *        propia de la oficina
     *
     * @return q53FechaBean Objeto que contiene la fecha mxima y mnima.
     *
     * @throws ProcletException
     */
    private static q53FechaBean getDateMinMax(ProcletServiceData sd,
        String codPregunta) throws ProcletException {
        q53FechaBean fechaBean = new q53FechaBean();
        String select_enc_ofi = "SELECT TO_CHAR(N6_FECHA_MIN,'DD/MM/YYYY HH24:MI:SS') FECHA_MIN, TO_CHAR(N6_FECHA_MAX,'DD/MM/YYYY HH24:MI:SS') FECHA_MAX";
        select_enc_ofi += " FROM PR_FECHA";
        select_enc_ofi += (" WHERE N6_COD_PREGUNTA=" + codPregunta);

        PSP.sqlProclet(sd, "fechas[]=" + select_enc_ofi);

        fechaBean.setFechaMax(sd.gOS("fechas[0].fecha_max"));
        fechaBean.setFechaMin(sd.gOS("fechas[0].fecha_min"));
        return fechaBean;
    }

    /**
     * Mtodo para saber el formato de la pregutna de tipo opciones de la
     * encuesta propia de la oficina.
     *
     * @param sd El objeto ProcletServiceData
     * @param codPregunta codigo de la pregunta de tipo opciones de la encuesta
     *        propia de la oficina
     *
     * @return q53OpcionesBean Objeto que contiene el formato de la pregutna de
     *         tipo opciones.
     *
     * @throws ProcletException
     */
    private static q53OpcionesBean getFormatoPregunta(ProcletServiceData sd,
        String codPregunta) throws ProcletException {
        String select_preg = "SELECT N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION ";
        select_preg += " FROM PR_OPS_OPCION, PR_OPCIONES ";
        select_preg += (" WHERE N3_COD_PREGUNTA = " + codPregunta);
        select_preg += " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA";
        select_preg += " ORDER BY N3_ORDEN";

        PSP.sqlProclet(sd, "pregs[]=" + select_preg);

        String formato = sd.gOS("pregs[0].n2_formato");
        q53OpcionesBean opcionesBean = new q53OpcionesBean();

        opcionesBean.setFormato(formato);

        return opcionesBean;
    }
    
    public static boolean hayEncuestaTempPresencial(ProcletServiceData sd) throws ProcletException {
        boolean hayEncuesta = false;

        
        String select_enc_temp = "SELECT COUNT(*) NUM_ENC";
        select_enc_temp += " FROM PRESENCIAL WHERE T1_COD_USUARIO ="+sd.gOS("q53_cki.q53_usuario");

        PSP.sqlProclet(sd, "num_enc[]=" + select_enc_temp);

        int numEnc = sd.gI("num_enc[0].num_enc");

        if (numEnc > 0) {
            hayEncuesta = true;
        }

        return hayEncuesta;
    }
    
    public static List getEncuestasTempPresencial(ProcletServiceData sd) throws ProcletException {
        List encuestasTempList = new ArrayList();

        String select_preg_temp = "SELECT T1_ID, T1_FECH_0_DIA, T1_FECH_0_MES, T1_FECH_0_ANIO, T1_FECH_0_HORA,T1_TOTVIS,T1_GRP_2_2_1,T1_GRP_2_2_2,T1_GRP_5_4_1,T1_GRP_5_4_2,T1_GRP_5_4_3,T1_GRP_5_4_4,T1_TOTALPERSONASPROC,T1_OPT_LOCAL,T1_CPOSPROC,T1_PROC_PAIS_6,T1_OPT_CHECK_7,T1_OPT_CHECK_8, T1_COD_USUARIO,T1_VALORACION_ESTANCIA";
        for(int j=1;j<36;j++){
        	select_preg_temp += ",T1_ACTIVADA_"+j;
        }
        select_preg_temp += " FROM PRESENCIAL WHERE T1_COD_USUARIO ="+sd.gOS("q53_cki.q53_usuario")+"  ORDER BY T1_ID";
        
        PSP.sqlProclet(sd, "preg_temp[]=" + select_preg_temp);

       for (int i = 0; i < sd.gI("preg_temp.length"); i++) {
            q53TempPresencialBean tempPresencialBean = new q53TempPresencialBean();
            List listaActiva=new ArrayList();
            int id = Integer.valueOf(sd.gOS("preg_temp[" + i +"].t1_id")).intValue();
            String dia = (new Integer(sd.gI("preg_temp[" + i + "].t1_fech_0_dia"))).toString();
            String mes = (new Integer(sd.gI("preg_temp[" + i + "].t1_fech_0_mes"))).toString();
            String anio = (new Integer(sd.gI("preg_temp[" + i + "].t1_fech_0_anio"))).toString();
            String hora = (new Integer(sd.gI("preg_temp[" + i + "].t1_fech_0_hora"))).toString();
            int totvis = sd.gI("preg_temp[" + i + "].t1_totvis");
						int grp_2_2_1 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_2_2_1")).intValue();
						int grp_2_2_2 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_2_2_2")).intValue();
						int grp_5_4_1 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_5_4_1")).intValue();
						int grp_5_4_2 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_5_4_2")).intValue();
						int grp_5_4_3 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_5_4_3")).intValue();
						int grp_5_4_4 = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_grp_5_4_4")).intValue();
						int totalpersonasproc = Integer.valueOf(sd.gOS("preg_temp[" + i + "].t1_totalpersonasproc")).intValue();
						String local= sd.gOS("preg_temp[" + i +"].t1_opt_local");
						String cpos=sd.gOS("preg_temp[" + i +"].t1_cposproc");
						String pais=sd.gOS("preg_temp[" + i +"].t1_proc_pais_6");
						String opt_check_7=sd.gOS("preg_temp[" + i +"].t1_opt_check_7");
						String opt_check_8=sd.gOS("preg_temp[" + i +"].t1_opt_check_8");
						String cod_usu=sd.gOS("preg_temp[" + i +"].t1_cod_usuario"); 
						String valoracion_estancia=sd.gOS("preg_temp[" + i +"].t1_valoracion_estancia");
						for(int j=1;j<36;j++){
								String activa=sd.gOS("preg_temp[" + i +"].t1_activada_"+j); 
								if(!activa.equals("")){
									listaActiva.add(activa);
								}
						}
						
            tempPresencialBean.setId(id);
            tempPresencialBean.setDia(dia);
            tempPresencialBean.setMes(mes);
						tempPresencialBean.setAnio(anio);
						tempPresencialBean.setHora(hora);
						tempPresencialBean.setTotalvis(totvis);
						tempPresencialBean.setHombres(grp_2_2_1);
						tempPresencialBean.setMujeres(grp_2_2_2);
						tempPresencialBean.setNinos(grp_5_4_1);
            tempPresencialBean.setJovenes(grp_5_4_2);
            tempPresencialBean.setAdultos(grp_5_4_3);
            tempPresencialBean.setJubilados(grp_5_4_4);
            tempPresencialBean.setTotalpersonas(totalpersonasproc);
            tempPresencialBean.setLocal(local);
            tempPresencialBean.setCpos(cpos);
            tempPresencialBean.setPais(pais);
            tempPresencialBean.setInfo(opt_check_7);
            tempPresencialBean.setTipoinfo(opt_check_8);
            tempPresencialBean.setCodofi(cod_usu);
            tempPresencialBean.setValoracionEstancia(valoracion_estancia);
            tempPresencialBean.setActiva(listaActiva);
            encuestasTempList.add(tempPresencialBean);
        }

        return encuestasTempList;
    }
    public static boolean hayEncuestaTempNoPresencial(ProcletServiceData sd) throws ProcletException {
        boolean hayEncuesta = false;

        
        String select_enc_temp = "SELECT COUNT(*) NUM_ENC";
        select_enc_temp += " FROM NO_PRESENCIAL WHERE T2_COD_USUARIO ="+sd.gOS("q53_cki.q53_usuario");

        PSP.sqlProclet(sd, "num_enc[]=" + select_enc_temp);

        int numEnc = sd.gI("num_enc[0].num_enc");

        if (numEnc > 0) {
            hayEncuesta = true;
        }

        return hayEncuesta;
    }
    public static List getEncuestasTempNoPresencial(ProcletServiceData sd) throws ProcletException {
        List encuestasTempList = new ArrayList();

        String select_preg_temp = "SELECT T2_ID, T2_FECH_0_DIA, T2_FECH_0_MES, T2_FECH_0_ANIO, T2_FECH_0_HORA, T2_OPT_3,T2_CHKHABILITAR,T2_FECH_10_DIA,T2_FECH_10_MES,T2_FECH_10_ANIO,T2_OPT_9,T2_OPT_LOCAL,T2_CPOSPROC,T2_PROC_PAIS_6,T2_OPT_CHECK_8,T2_TXT,T2_COD_USUARIO";
        for(int j=1;j<36;j++){
        	select_preg_temp += ",T2_ACTIVADA_"+j;
        }
        select_preg_temp += " FROM NO_PRESENCIAL WHERE T2_COD_USUARIO ="+sd.gOS("q53_cki.q53_usuario")+" ORDER BY T2_ID";
        
        PSP.sqlProclet(sd, "preg_temp[]=" + select_preg_temp);

       for (int i = 0; i < sd.gI("preg_temp.length"); i++) {
            q53TempNoPresencialBean tempNoPresencialBean = new q53TempNoPresencialBean();           
            List listaActiva=new ArrayList();
            int id = Integer.valueOf(sd.gOS("preg_temp[" + i +"].t2_id")).intValue();
            String dia = (new Integer(sd.gI("preg_temp[" + i + "].t2_fech_0_dia"))).toString();
            String mes = (new Integer(sd.gI("preg_temp[" + i + "].t2_fech_0_mes"))).toString();
            String anio = (new Integer(sd.gI("preg_temp[" + i + "].t2_fech_0_anio"))).toString();
            String hora = (new Integer(sd.gI("preg_temp[" + i + "].t2_fech_0_hora"))).toString();
            int opt_3 = sd.gI("preg_temp[" + i + "].t2_opt_3");
            String chkhabilitar = sd.gOS("preg_temp[" + i + "].t2_chkhabilitar");
						String dia2 = sd.gOS("preg_temp[" + i + "].t2_fech_10_dia");
						String mes2 = sd.gOS("preg_temp[" + i + "].t2_fech_10_mes");
						String anio2 = sd.gOS("preg_temp[" + i + "].t2_fech_10_anio");
						int opt_9 = sd.gI("preg_temp[" + i + "].t2_opt_9");
						String local= sd.gOS("preg_temp[" + i +"].t2_opt_local");
						String cpos=sd.gOS("preg_temp[" + i +"].t2_cposproc");
						String pais=sd.gOS("preg_temp[" + i +"].t2_proc_pais_6");
						String opt_check_8=sd.gOS("preg_temp[" + i +"].t2_opt_check_8");
						String txt=sd.gOS("preg_temp[" + i +"].t2_txt");
						String cod_usu=sd.gOS("preg_temp[" + i +"].t2_cod_usuario");
						 
						for(int j=1;j<36;j++){
								String activa=sd.gOS("preg_temp[" + i +"].t2_activada_"+j); 
								if(!activa.equals("")){
									listaActiva.add(activa);
								}
						} 
						 
            tempNoPresencialBean.setId(id);
            tempNoPresencialBean.setDiarec(dia);
            tempNoPresencialBean.setMesrec(mes);
			tempNoPresencialBean.setAniorec(anio);
			tempNoPresencialBean.setHorarec(hora);
			tempNoPresencialBean.setRecepcion(opt_3);
			tempNoPresencialBean.setHabilitar(chkhabilitar);
            tempNoPresencialBean.setDiares(dia2);
            tempNoPresencialBean.setMesres(mes2);
            tempNoPresencialBean.setAniores(anio2);
            tempNoPresencialBean.setRespuesta(opt_9);
            tempNoPresencialBean.setLocal(local);
            tempNoPresencialBean.setCpos(cpos);
            tempNoPresencialBean.setPais(pais);
           	tempNoPresencialBean.setTipoinfo(opt_check_8);
           	tempNoPresencialBean.setTexto(txt);
           	tempNoPresencialBean.setCodofi(cod_usu);
            tempNoPresencialBean.setActiva(listaActiva);
            encuestasTempList.add(tempNoPresencialBean);
        }

        return encuestasTempList;
    }
}
