package q53_util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;



public class q53Util {
	
	/**Actualiza las variables de sesion de perfil con los datos de las cookies...
	 * Imagino que lo hara en muchos servlets asi que lo saco aqui, codigo feo.
	 * @param sd
	 */
	public static void setPerfilInSession(ProcletServiceData sd){
		String perfilUser = "NO";
      if (q53Util.esPerfil(sd, q53Constantes.PERFIL_USRO)) {
          perfilUser = "SI";
      }
      String perfilCoord = "NO";
      if (q53Util.esPerfil(sd, q53Constantes.PERFIL_COOR)) {
          perfilCoord = "SI";
      }
      String perfilAdmin = "NO";
      if (q53Util.esPerfil(sd, q53Constantes.PERFIL_ADMO)) {
          perfilAdmin = "SI";
      }
      sd.setVal("perfilUser", perfilUser);
      sd.setVal("perfilCoord", perfilCoord);
      sd.setVal("perfilAdmin", perfilAdmin);
	}
	/**Obtiene el valor de un parametro del request como string y ademas lo mete en la response
	 * de modo que permanecera en el sd.
	 * ATENCION: Utiliza siempre gOS, de modo que GUARDA SIEMPRE STRINGS si se va a usar 
	 * gI o algo diferente hay que usar otra funcion. 
	 * @param sd 
	 * @param key 
	 * @return
	 */
	public static String getStringAndSetItInResponse(ProcletServiceData sd, String key){
		sd.setVal(key , sd.gOS(key));
		return sd.gOS(key);
	}
	/**
	 * Pasa las variables de sesion al objeto ProcletServiceData para que no haya problemas con las cookies
	 */
	public static void pasar_a_sd(ProcletServiceData sd){
		String nombre_v = "";
		try {
			Enumeration e = sd.req.getSession(true).getAttributeNames();
			q53LogEstadisticas.printLog("VARIABLES DE SESION ACTIVAS");
			
			while (e.hasMoreElements()) {
				nombre_v = (String) e.nextElement();
				q53LogEstadisticas.printLog("NOMBRE = " + nombre_v);
				q53LogEstadisticas.printLog(" VALOR = " + sd.req.getSession(true).getAttribute(nombre_v).toString() + " tiene mas elementos? " + e.hasMoreElements());
				sd.setVal(nombre_v, sd.req.getSession(true).getAttribute(nombre_v).toString());
			}
		} catch (Exception e) {
			q53LogEstadisticas.printLog("_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\");
			q53LogEstadisticas.printLog("HA FALLADO EN: " + nombre_v);
			q53LogEstadisticas.printLog("HA FALLADO EN VALUE: " + sd.req.getSession(true).getAttribute(nombre_v));
			q53LogEstadisticas.printLog("Es importante analizar pq se ha dado este error");
			q53LogEstadisticas.printError("ERROR GRAVE: MURIO " + nombre_v, e);
			q53LogEstadisticas.printLog("_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\");
		}
	}
	 /**
	 * Envia un correo y devuelve un entero
	 */
	public static int enviaCorreo (ProcletServiceData sd, String SMTPServer, String deQuien, String aQuien, String aQuienCC, String aQuienBCC,
	  		String elTema, String elMensaje, String Errores[], String Anexo, String Anexo2)  throws ProcletException {
			
			//Variable de error
			int errorCorreo=0;

			//Objeto properties para poner el host
			Properties props=new Properties();
			props.put("mail.smtp.host", SMTPServer);

			//Objeto sesin de correo
			javax.mail.Session mailSession=javax.mail.Session.getInstance(props,null);
			//Debug
			mailSession.setDebug(true);

			try {
				//Crear objeto del mensaje
				Message msg=new MimeMessage(mailSession);
				//Remitente
				InternetAddress[] remitente={new InternetAddress(deQuien)};
				msg.addFrom(remitente);
				q53LogEstadisticas.printLog("email remitente->"+deQuien);
				//Destinatarios
				InternetAddress[] destinatarios={new InternetAddress(aQuien)};
				msg.setRecipients(Message.RecipientType.TO,destinatarios);
				q53LogEstadisticas.printLog("email destinatario->"+aQuien);
				//Destinatarios CC-Si hay
				if(aQuienCC!=null) {
					InternetAddress[] destinatariosCC={new InternetAddress(aQuienCC)};
					msg.setRecipients(Message.RecipientType.CC,destinatariosCC);
				}
				//Destinatarios BCC-Si hay
				if(aQuienBCC!=null) {
					InternetAddress[] destinatariosBCC={new InternetAddress(aQuienBCC)};
					msg.setRecipients(Message.RecipientType.BCC,destinatariosBCC);
				}
				//El Asunto
				String asunto=q53Util.eliminarCRLF(elTema);
				msg.setSubject(MimeUtility.encodeText(asunto,"ISO-8859-1",null));
				q53LogEstadisticas.printLog("email asunto->"+asunto);
				//Crear el Multipart
				Multipart mp=new MimeMultipart();
	                        {
				//Crear y rellenar la primara parte del mensaje
				String mensaje=q53Util.eliminarCRLF(elMensaje);
				MimeBodyPart mbp=new MimeBodyPart();
				mbp.setText(mensaje);     //Esto no va--MimeUtility.encodeText(mensaje,"ISO-8859-1",null));
	                        mbp.setContent(mensaje,"text/html");
	                        mp.addBodyPart(mbp);
	                        }

				//Proceso para aadir el anexo al mensaje
				if(Anexo!=null) {
					int StartIndex=0, PosIndex=0;
					if(StartIndex < Anexo.length()) {
						MimeBodyPart mbp=new MimeBodyPart();
						FileDataSource fds=new FileDataSource(Anexo.substring(StartIndex));
						mbp.setDataHandler(new DataHandler(fds));
						mbp.setFileName(fds.getName());
						mp.addBodyPart(mbp);
					}
				}
				
				//Proceso para aadir el segundo anexo al mensaje
				if(Anexo2!=null) {
					int StartIndex=0, PosIndex=0;
					if(StartIndex < Anexo2.length()) {
						MimeBodyPart mbp=new MimeBodyPart();
						FileDataSource fds=new FileDataSource(Anexo2.substring(StartIndex));
						mbp.setDataHandler(new DataHandler(fds));
						mbp.setFileName(fds.getName());
						mp.addBodyPart(mbp);
					}
				}

				//Aadimos el multipart al mensaje
				msg.setContent(mp);
				//Poner la fecha;
				msg.setSentDate(new Date());

				//Envo del mail
				Transport.send(msg);

				return errorCorreo;
			}
			catch (MessagingException MsgException) {
				q53LogEstadisticas.printLog("Ha saltado una excepcion : "+MsgException.toString());
				errorCorreo = 1;
			}
			catch (IOException IOException) {
				q53LogEstadisticas.printLog("Ha saltado una excepcion : "+IOException.toString());
				errorCorreo = 1;
			}
			finally{
				return errorCorreo;
			}
	}
	
	public static String eliminarCRLF(String cadena) {
		while('\n' == cadena.substring(cadena.length()-1).charAt(0)
			|| '\r' == cadena.substring(cadena.length()-1).charAt(0)) {
			cadena = cadena.substring(0, cadena.length()-1);
		}
		return cadena;
	}
	
	
    /**
	 * Devuelve un string con un codigo aleatorio (fecha en milisegundos + un numero aleatorio del 0 al 100)
	 */
	public static String obtener_cod_aleatorio(){
		String str = Long.toString(new Date().getTime())+Integer.toString((int)(Math.random()*100));
		return str;
	}
    	
    /**
     * 	Devuelve los datos necesarios para la notificacion de tipo Fax
     * @param sd
     * @param String cod_ofi => El codigo de la oficina de la que queremos saber datos
     * @return Hashtable resultado con el nombre,cp,telefono,fax y direccion
     */
    public static Hashtable getDatosFax(ProcletServiceData sd, String cod_ofi) throws ProcletException{
    	Hashtable rtdo = new Hashtable();
    	q53LogEstadisticas.printLog("Entra");
    	String select ="datos[]=SELECT T02_NOOFI,T02_COCP,T02_NUTLF,T02_NUFAX,T02_NODIR FROM OFICINA WHERE T02_COOR='" + cod_ofi + "'";
        PSP.sqlProclet(sd, select);
        if (sd.gI("datos.length") > 0) {
            rtdo.put("nombre",sd.gOS("datos[0].t02_noofi"));
            rtdo.put("cod_postal", sd.gOS("datos[0].t02_cocp"));
            rtdo.put("telefono", sd.gOS("datos[0].t02_nutlf"));
            rtdo.put("fax", sd.gOS("datos[0].t02_nufax"));
            rtdo.put("direccion", sd.gOS("datos[0].t02_nodir"));
        } else {
        	rtdo.put("nombre"," ");
            rtdo.put("cod_postal"," ");
            rtdo.put("telefono"," ");
            rtdo.put("fax"," ");
            rtdo.put("direccion"," ");
        }
        return rtdo; 	
    }
       
    /**
     * 	Convierte un string que contiene elementos separados por un simbolo en una lista con esos elementos
     * @param String elementos
     * @param String simbolo
     * @return List resultado
     */
    public static List convertir_en_lista(String elementos,String simbolo){
    	q53LogEstadisticas.printLog("Entra");
    	List resultado = new ArrayList();
    	String str;
    	StringTokenizer tokens=new StringTokenizer(elementos, simbolo);
		int nDatos=tokens.countTokens();
		try{
        while(tokens.hasMoreTokens()){
            str=tokens.nextToken();
            resultado.add(str);
    	}
		}catch(Exception e){
			q53LogEstadisticas.printLog("Problemas, la excepcion es = "+e.getMessage());
		}
        return resultado;
    }
      
    /**
     * 	Convierte la fecha a formato euskera o castellano, la fecha tiene ke estar en formato dd/mm/yyyy o yyyy/mm/dd
     * @param String fecha
     * @param String tipo
     * @return String fecha
     */
    public static String convertirFechaIdioma(String fecha,String tipo){
    	try{
	    	String fechaAux="";
	    	q53LogEstadisticas.printLog("FECHA= "+fecha);
	    	if(tipo.equals("EC")){
		    	fechaAux=fecha.substring(8)+"/";
				fechaAux=fechaAux+fecha.substring(5,7)+"/";
				fechaAux=fechaAux+fecha.substring(0,4);
				fecha=fechaAux;
	    	}else if(tipo.equals("CE")){
	    		fechaAux=fecha.substring(6)+"/";
	    		fechaAux=fechaAux+fecha.substring(3,5)+"/";
				fechaAux=fechaAux+fecha.substring(0,2);			
				fecha=fechaAux;
	    	}
			return fecha;
    	}catch(Exception e){
    		return "";
    	}
    }
    
    /**
     *  Convierte la fecha al formato deseado
     */ 
    public static String convertirFecha(String fecha){
    	String pat="(\\d{4})-(\\d{2})-(\\d{2})";
    	Pattern patron = Pattern.compile(pat);
    	Matcher mat=patron.matcher(fecha);
    	if (mat.find()) { 
    		for (int i=0; i<=mat.groupCount(); i++)
    		{ 
    			q53LogEstadisticas.printLog("grupo"+i+"="+mat.group(i));
    		} 
    	} 
    	String resultado=mat.group(3)+"/"+mat.group(2)+"/"+mat.group(1);
    	return resultado;
    }
    
     /**
      * Convertir un texto a una anchura determinada aadiendo el caracter especificado por la izquierda
      */
     public static String padL(String texto, int ancho, char c) {
       StringBuffer sb = new StringBuffer();
       for(int i=0; i<(ancho-texto.length()); i++) {
         sb.append(c);
       }
       sb.append(texto);
       return sb.toString();
     }

    
      /**
     * Limpia el estrin de caracteres invlidos para los nombres de los arrays de las sqlProclet
     *
     * @param String sucio
     * @return String limpio
     *
     **/	
    public static String limpiarCabecerasParaProclets(String cab){
    			char [] especiales={'\'','','*','','-','-','','','?','','!','/','(',')','[',']','<','>','$','%','@','&','=','+','\\',' ',
    													'','','','','','','','','','','','','','','','','','','',''};
    			String limpio=cab.toUpperCase();
    			limpio=limpio.trim();
    			for(int i=0;i<especiales.length;i++){
    					limpio=limpio.replace(especiales[i],'_');
    			}    			  
    			return limpio;
    	}
    public static String rellenarEspacios(String texto, int tam) {
        String rpta = "";
        rpta = texto;

        int tmp = texto.length();

        if (tmp > tam) {
            if (tam > 3) {
                rpta = rpta.substring(0, (tam - 3)) + "...";
            } else {
                rpta = rpta.substring(0, tam);
            }
        } else {
            for (int j = tmp; j < tam; j++)
                rpta += "&nbsp;";
        }

        return rpta;
    }

    /**
     * Me recupera el Municipio de la FCA11t00 a partir del CP
     * vaco.
     *
     * @param sd El objeto ProcletServiceData
     * @param cp String Nombre de la variable
     *
     **/
    public static String getMunicipio(ProcletServiceData sd, String cp)  throws ProcletException {
        String rtdo = "";
        String mun="";
        String prov="";
        String select ="q53_municipio[]=SELECT CODMUNICIP,CODPROVINC FROM MUNICIPIO11 WHERE CODPOSTNUM='"+cp+"'";
        q53LogEstadisticas.printLog("Select->"+select);
        System.out.println(select);
        if (cp.length()<5)return "";
        PSP.sqlProclet(sd, select);

        if (sd.gI("q53_municipio.length") > 0) {
            // hay oficina
            mun = sd.gOS("q53_municipio[0].codmunicip");
            prov=sd.gOS("q53_municipio[0].codprovinc");
            int lm= mun.length();
            int lp=prov.length();
            if(lm==0)return "";
            else if(lm==1)mun="000"+mun;
            else if(lm==2)mun="00"+mun;
            else if(lm==3)mun="0"+mun;
            if(lp==0)return "";
            else if(lp==1)prov="0"+prov;
            rtdo=prov+"_"+mun;
        } 
        q53LogEstadisticas.printLog("select ->"+select+"<-");
        return rtdo;
    }
    
    /**
     * Sustituye el valor del objeto en el sd, ponindolo como "null" si es
     * vaco.
     *
     * @param sd El objeto ProcletServiceData
     * @param nomVar String Nombre de la variable
     *
     **/
    public static void numNulos(ProcletServiceData sd, String nomVar) {
        if ((sd.gOS(nomVar)).equalsIgnoreCase("")) {
            sd.setVal(nomVar, "null");
        }
    }

    /**
     * Devuelve el valor de la property, segn el fichero:
     *      /config/q53/q53.properties
     *
     * @param property String con el nombre de la propiedad
     *
     * @return String El valor de la propiedad
     **/
    public static String getQ53Property(String property) {
        Properties props = new Properties();

        try {
            props.load(new FileInputStream(q53Constantes.PATH_PROPERTIES_FILE));
        } catch (FileNotFoundException e) {
            System.err.println(q53Constantes.E_PATH_PROPERTIES_FILE + " " +
                e.getMessage());
        } catch (IOException e) {
            System.err.println(q53Constantes.E_PATH_PROPERTIES_FILE + " " +
                e.getMessage());
        }

        return props.getProperty(property, "");
    }

    /**
     * Devuelve el nombre del usuario a partir de su cdigo de usuario
     * @param sd El objeto ProcletServiceData
     * @param codigo String cone l cdigo de usuario
     *
     * @return String el nombre del usuario
     **/
    public static String getNombreUsuario(ProcletServiceData sd, String codigo)
        throws ProcletException {
        String rtdo = "";

        String select =
            "q53_nombre_usuario[]=SELECT T03_NOUSU FROM PERSONA WHERE T03_COUSU='" +
            codigo + "'";

        PSP.sqlProclet(sd, select);

        if (sd.gI("q53_nombre_usuario.length") > 0) {
            // hay oficina
            rtdo = sd.gOS("q53_nombre_usuario[0].t03_nousu");
        } else {
            // no existe la oficina (??)
            rtdo = "-";
        }

        return rtdo;
    }

    /**
     * Devuelve el padre de la oficina a partir del cdigo de oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el cdigo de la oficina
     *
     * @return String Nombre de la oficina
     **/
    public static String getPadreOficina(ProcletServiceData sd, String codigo)
        throws ProcletException {
        String rtdo = "";

        String select =
            "q53_padre_oficina[]=SELECT  NVL(T02_COPADRE,T02_COOR) PADRE FROM OFICINA WHERE  T02_COOR='" +
            codigo + "'";

        PSP.sqlProclet(sd, select);

        if (sd.gI("q53_padre_oficina.length") > 0) {
            // hay oficina
            rtdo = sd.gOS("q53_padre_oficina[0].padre");
        } else {
            // no existe la oficina (??)
            rtdo ="-" ;
        }

        return rtdo;
    }
    /**
     * Devuelve el nombre de la oficina a partir del cdigo de oficina
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el cdigo de la oficina
     *
     * @return String Nombre de la oficina
     **/
    public static String getNombreOficina(ProcletServiceData sd, String codigo)
        throws ProcletException {
        String rtdo = "";

        String select =
            "q53_nombre_oficina[]=SELECT T02_NOOFI FROM OFICINA WHERE T02_COOR='" +
            codigo + "'";

        PSP.sqlProclet(sd, select);

        if (sd.gI("q53_nombre_oficina.length") > 0) {
            // hay oficina
            rtdo = sd.gOS("q53_nombre_oficina[0].t02_noofi");
        } else {
            // no existe la oficina (??)
            rtdo = "-";
        }

        return rtdo;
    }

    /**
     * Devuelve el valor de un literal segn el cdigo del literal y el idioma
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el cdigo del literal
     * @param idioma String con el idioma en el que se esta trbajando ("C" si se trabaja en castellano o "E" si se trabaja en Euskera)
     *
     * @return String El valor del literal en el idioma
     **/
    public static String getLiteral2(ProcletServiceData sd, String codigo,
        String idioma) throws ProcletException {
        String rtdo = "";

        if ((sd != null) && (codigo != null) && (idioma != null)) {
            // por defecto en castellano
            //String campo_literal = (idioma.equals("E")?"ZZ_EUSK":"ZZ_CAST");
            String campo_literal = (idioma.equals(q53Constantes.IDIOMA_EUS)
                ? "ZZ_EUSK" : "ZZ_CAST");

            String select = "q53_lit[]=SELECT " + campo_literal +
                " CAMPO_LITERAL FROM LITERAL WHERE ZZ_CODIGO='" + codigo + "'";
            PSP.sqlProclet(sd, select);

            if (sd.gI("q53_lit.length") > 0) {
                // hay literal
                rtdo = sd.gOS("q53_lit[0].campo_literal");
           } else {
                // no existe el literal
                rtdo = "ERROR: [" + codigo + "] NO_ENCONTRADO";
            }
        } else {
            // codigo o idioma son null
            rtdo = q53Constantes.E_WRONG_PARAMS;
        }

        return rtdo;
    }
    
    public static String getLiteral2OpcionesTipoInfo(ProcletServiceData sd, String codigo,
            String idioma) throws ProcletException {
            String rtdo = "";

            if ((sd != null) && (codigo != null) && (idioma != null)) {
                // por defecto en castellano
                //String campo_literal = (idioma.equals("E")?"ZZ_EUSK":"ZZ_CAST");
                String campo_literal = (idioma.equals(q53Constantes.IDIOMA_EUS)
                    ? "ZZ_EUSK" : "ZZ_CAST");

                String select = "q53_lit[]=SELECT " + campo_literal +
                    " CAMPO_LITERAL FROM LITERAL WHERE ZZ_CODIGO='" + codigo + "'";
                PSP.sqlProclet(sd, select);

                if (sd.gI("q53_lit.length") > 0) {
                    // hay literal
                    rtdo = sd.gOS("q53_lit[0].campo_literal");
               } else {
                    // no existe el literal
                    rtdo = "";
                }
            } else {
                // codigo o idioma son null
                rtdo = "";
            }

            return rtdo;
        }
    
    
    
    /**
     * NO USAR NUNCA, usar 'getLiteral' en su lugar, esto solo fue un esbozo
     * 
     * Devuelve un hashmap con todos los literales de la BBDD con codigo que empiece
     * con 'codigo'.
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el prefijo del literal
     * @param idioma String con el idioma en el que se esta trabajando ("C" si se trabaja en castellano o "E" si se trabaja en Euskera)
     *
     * @return HashMap con los codigos como keys y los valores en el idioma seleccionado como values
     **/
    private static HashMap getLiterales(ProcletServiceData sd, String codigo,
											        String idioma) throws ProcletException{
    	return getLiterales(sd, new String[] {codigo},idioma); 
    }
    
    /**
     * NO USAR NUNCA, usar 'getLiteral' en su lugar, esto solo fue un esbozo
     * 
     * Devuelve un hashmap con todos los literales de la BBDD con codigo que empiece
     * con 'codigo'.
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el prefijo del literal
     * @param idioma String con el idioma en el que se esta trabajando ("C" si se trabaja en castellano o "E" si se trabaja en Euskera)
     *
     * @return HashMap con los codigos como keys y los valores en el idioma seleccionado como values
     **/private static HashMap getLiterales(ProcletServiceData sd, String[] codigos,
											        String idioma) throws ProcletException {
    		q53BundleLiterales.setLanguaje(idioma);
 			String codes = "'" + codigos[0] + "%'";
         for (int i = 1; i< codigos.length; i++){
         	codes += " or zz_codigo like '" + codigos[i] + "%'";
         }
         String campo_literal = (idioma.equals(q53Constantes.IDIOMA_EUS) ? "ZZ_EUSK" : "ZZ_CAST");
         String select = "q53_litxpag[]=SELECT ZZ_CODIGO, " + campo_literal + " CAMPO_LITERAL FROM LITERAL WHERE ZZ_CODIGO LIKE " + codes;
         PSP.sqlProclet(sd, select);
         int t = sd.gI("q53_litxpag.length");
         if (t > 0) 
          	for (int i = 0; i < t; i++)
          		q53BundleLiterales.put(sd.gOS("q53_litxpag[" + i + "].zz_codigo"),sd.gOS("q53_litxpag[" + i + "].campo_literal"));
         return null;//q53BundleLiterales.getHashMapIdioma();
    }
    
    /**
     * Devuelve el valor de un literal segn el cdigo del literal y el idioma
     *
     * @param sd El objeto ProcletServiceData
     * @param codigo String con el cdigo del literal
     * @param idioma String con el idioma en el que se esta trbajando ("C" si se trabaja en castellano o "E" si se trabaja en Euskera)
     *
     * @return String El valor del literal en el idioma
     **/
    public static String getLiteral(ProcletServiceData sd, String codigo,
										        String idioma) throws ProcletException{
    	//TODO:Quitar esto acabadas las pruebas (la llamada a getLiteral2)
    	//String BORRAME = getLiteral2(sd, codigo, idioma);
		try {
			q53BundleLiterales.setLanguaje(idioma);
				if (!q53BundleLiterales.containsKey(codigo)){
					//StringTokenizer st = new StringTokenizer(codigo, "_");
					//getLiterales(sd, st.nextToken(), idioma);
					q53BundleLiterales.put(codigo, getLiteral2(sd, codigo, idioma));
				}
				/*if (!BORRAME.equals(q53BundleLiterales.get(codigo))){
					String res = "ERROR: [" + codigo + "] NO_ENCONTRADO";
					if (!res.equals(BORRAME))
						q53LogEstadisticas.printWarning("CAMBIO---- ERROR!!!!!: etiquetas diferentes!!!! |" + BORRAME +"| vs |" + q53BundleLiterales.get(codigo) + "|");
				}*/
				return q53BundleLiterales.get(codigo);
		} catch (ProcletException e) {
			e.printStackTrace();
			return "";			
		} catch (NullPointerException e){
			q53LogEstadisticas.printWarning("Hash de idiomas nulo... Tratando de recuperarlo del contexto de aplicacion ");
			q53BundleLiterales.setHashMapFromContext(sd.req.getSession().getServletContext());
			return "";		
		}
    }
    
	public static String getLiteralOpcionesTipoInfo(ProcletServiceData sd,
			String codigo, String idioma) throws ProcletException {
		// TODO:Quitar esto acabadas las pruebas (la llamada a getLiteral2)
		// String BORRAME = getLiteral2(sd, codigo, idioma);
		try {
			q53BundleLiterales.setLanguaje(idioma);
			if (!q53BundleLiterales.containsKey(codigo)) {
				// StringTokenizer st = new StringTokenizer(codigo, "_");
				// getLiterales(sd, st.nextToken(), idioma);
				q53BundleLiterales.put(codigo, getLiteral2OpcionesTipoInfo(sd, codigo, idioma));
			}
			/*
			 * if (!BORRAME.equals(q53BundleLiterales.get(codigo))){ String res
			 * = "ERROR: [" + codigo + "] NO_ENCONTRADO"; if
			 * (!res.equals(BORRAME)) q53LogEstadisticas.printWarning(
			 * "CAMBIO---- ERROR!!!!!: etiquetas diferentes!!!! |" + BORRAME
			 * +"| vs |" + q53BundleLiterales.get(codigo) + "|"); }
			 */
			return q53BundleLiterales.get(codigo);
		} catch (ProcletException e) {
			e.printStackTrace();
			return "";
		} catch (NullPointerException e) {
			q53LogEstadisticas
					.printWarning("Hash de idiomas nulo... Tratando de recuperarlo del contexto de aplicacion ");
			q53BundleLiterales.setHashMapFromContext(sd.req.getSession()
					.getServletContext());
			return "";
		}
	}
    
    public static void resetLiterales(){
    	q53BundleLiterales.reset();
    }
    
    /**
     * Devuelve el cdigo del idioma que hay en el sd - q53_cki.q53_idioma, que
     * a su vez se ha obtenido a partir de la cookie q53_idioma.
     *
     * @param sd El objeto ProcletServiceData
     *
     * @return String El idioma en el que se trabaja("C" si es en castellano o "E" si es en euskera)
     **/
    public static String getIdioma(ProcletServiceData sd)
        throws ProcletException {
        String rtdo;

        // la cookie se ha tenido que guardar previamente en el sd utilizando
        // el mtodo de q53Servlet.q53_tratarCookies(sd);
        rtdo = sd.gOS("q53_cki.q53_idioma");

        // por defecto, en castellano
        if (rtdo.equals("")) {
            rtdo = q53Constantes.IDIOMA_CAS;
        }

        return rtdo;
    }

    /**
     * Devuelve true si el cod_perfil est dentro del String q53cki.q53_perfil,
     * que es de la forma [cod_perfil_1]#[cod_perfil_2]#[cod_perfil_3]#...
     *
     * @param sd El objeto ProcletServiceData
     * @param cod_Perfil String con l codigo del perfil en el que se esta trabajando
     *
     * @return boolean ....
     **/
    public static boolean esPerfil(ProcletServiceData sd, String cod_perfil) {
        boolean rtdo = false;
        String q53_perfil = sd.gOS("q53_cki.q53_perfil");

        StringTokenizer tk = new StringTokenizer(q53_perfil, "#");

        while (tk.hasMoreTokens() && !rtdo) {
            String tmp = tk.nextToken();
            rtdo = cod_perfil.equals(tmp);
        }

        return rtdo;
    }

    /**
     * Devuelve true si el cod_perfil est dentro del String q53cki.q53_perfil,
     * que es de la forma [cod_perfil_1]#[cod_perfil_2]#[cod_perfil_3]#...
     *
     * @param sd El objeto ProcletServiceData
     * @param cod_Perfil String con l codigo del perfil en el que se esta trabajando
     *
     * @return boolean ....
     **/
    public static boolean isPerfil(String codPerfil, String cod_perfil) {
        boolean rtdo = false;

        //String q53_perfil = sd.gOS("q53_cki.q53_perfil");
        StringTokenizer tk = new StringTokenizer(codPerfil, "#");

        while (tk.hasMoreTokens() && !rtdo) {
            String tmp = tk.nextToken();
            rtdo = cod_perfil.equals(tmp);
        }

        return rtdo;
    }

    /**
     * Devuelve el dominio de la url pasada como parmetro.
     *
     * @param requestUrl StringBuffer con la uRL....
     *
     * @return String Dominio de la Url que se pasa por parametro
     **/
   /* public static String getDominio(StringBuffer requestUrl) {
        String url = new String(requestUrl);
        String rtdo = "";
        
        url = url.replaceAll("http://", "");
        if (url.indexOf(':') != -1 ) {
           url = url.substring(0, url.indexOf(':'));
        }
        if (url.indexOf('/') != -1 ) {
           url = url.substring(0, url.indexOf('/'));
        }
        rtdo = url;
        System.out.println("Entramos a la funcin getDominio. requestUrl-" + url);

//        int index_ini = -1;
//        int index_fin = -1;
//System.out.println("Entramos a la funcin getDominio. requestUrl-"+requestUrl);
//        // se supone que url tendr la forma:
//        //  "http://servidor.dominio.do:puerto/path"
//        index_ini = url.indexOf(".");
//System.out.println("Valor de la variable index_ini-"+index_ini);
//        if (index_ini != -1) {
//            //url = url.substring(url.indexOf(".") + 1);
//            url = url.substring(url.indexOf(".") + 15);
//System.out.println("Valor de la variable url-"+url);            
//            // ahora url es de la forma "dominio.do:puerto/path"
//            index_fin = url.indexOf(":");
//System.out.println("Valor de la variable index_fin-"+index_fin);
//            url = url.substring(0, url.indexOf(":"));
//System.out.println("Valor de la variable url-"+url);            
//            // y ya tienes slo "dominio.do", que es justamente lo que queremos...
//            rtdo = url;
//         // Trapi para que funcione en local
//            rtdo = ".eus";
//System.out.println("dominio getDominio:" + rtdo) ;           
//        }

        return rtdo;
    }*/
    
    public static String getDominio(StringBuffer requestUrl) {
        String url = new String(requestUrl);
        String rtdo = "";
        
        if ("LOCAL".equalsIgnoreCase(q53Util.getQ53Property("ENTORNO"))){ // para trabajar en local
        	url = url.replaceAll("http://", "");
            if (url.indexOf(':') != -1 ) {
               url = url.substring(0, url.indexOf(':'));
            }
            if (url.indexOf('/') != -1 ) {
               url = url.substring(0, url.indexOf('/'));
            }
            rtdo = url;
  //System.out.println("Entramos a la funcin getDominio. requestUrl-" + url);
        } 
        else {
        int index_ini = -1;
        int index_fin = -1;
  //System.out.println("Entramos a la funcin getDominio. requestUrl-"+requestUrl);
        // se supone que url tendr la forma:
        //  "http://servidor.dominio.do:puerto/path"
        index_ini = url.indexOf(".");
  //System.out.println("Valor de la variable index_ini-"+index_ini);
        if (index_ini != -1) {
            //url = url.substring(url.indexOf(".") + 1);
            url = url.substring(url.indexOf(".") + 15);
  //System.out.println("Valor de la variable url-"+url);            
            // ahora url es de la forma "dominio.do:puerto/path"
            index_fin = url.indexOf(":");
  //System.out.println("Valor de la variable index_fin-"+index_fin);
            url = url.substring(0, url.indexOf(":"));
  //System.out.println("Valor de la variable url-"+url);            
            // y ya tienes slo "dominio.do", que es justamente lo que queremos...
            rtdo = url;
  //System.out.println("dominio getDominio:" + rtdo) ;           
          }
        }

        return rtdo;
    }
      /**
     * Listas codigos de opcion para una pregunta.
     *
     * @param ProcletServiceData sd 
     * @param cogigo de la pregunta....
     *
     * @return lista de codigos para esa pregunta
     **/
    public static List getCodigosOpciones(ProcletServiceData sd, String codPregunta) throws ProcletException{
			List codigos = new ArrayList();
			q53LogEstadisticas.printLog("Recuperando codigos");
			if(codPregunta!= null && codPregunta.equals("")){
				return codigos;	
			}
			try{
				int cod=Integer.parseInt(codPregunta);
			}catch(NumberFormatException ex){
				return codigos;	
			}
			String select = "SELECT PR_OPS_OPCION.N3_COD_OPCION FROM PR_OPS_OPCION WHERE PR_OPS_OPCION.N3_COD_PREGUNTA="+codPregunta;
			q53LogEstadisticas.printLog("select::::"+select);									
			PSP.sqlProclet(sd, "codigos[]="+ select);
			if (sd.gI("codigos.length") > 0) {
				int lon=sd.gI("codigos.length");
				for(int i=0;i<lon;i++){
					int micod=sd.gI("codigos[" + i + "].n3_cod_opcion");
					codigos.add(new Integer(micod));
					q53LogEstadisticas.printLog("codigo::::"+micod);										
				}
			}
			q53LogEstadisticas.printLog("codigo::::Finalizado");										
			return codigos;								
		}
		
		
    public static String rutaEntrada(String app) {
    	
    	String ruta = "";
    	
    	if (q53Constantes.DESTINO_FOLLETOS.equals(app)) {
    		ruta = "itourbaskJSP/q53_dispatcher.jsp";
    	} else if (q53Constantes.DESTINO_ESTADISTICAS.equals(app)) {
    		ruta = "itourbaskJSP/q53_dispatcher.jsp";
    	} else { // if (q53Constantes.DESTINO_ENCUESTAS.equals(app)) {
    		ruta = "/q53ItourbaskWar/q53usrEncuestaPresencialServlet";
    	}
    	
    	return ruta;
    }
		
}