package q53_util;

import com.cidat.proclets.PSP;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;


/**
 * DOCUMENT ME!
 *
 *  
 * @version $Revision$
 */
public class q53RecorrerPreguntas {
    /**
     * Recoje las preguntas de tipo Opciones de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @throws ProcletException
     */
    public static void cogerPreguntaOpciones(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        String select_preg = "SELECT N2_FORMATO, N3_COD_OPCION, N3_DESCRIPCION ";
        select_preg += " FROM PR_OPS_OPCION, PR_OPCIONES ";
        select_preg += (" WHERE N3_COD_PREGUNTA = ${" + pregs + "[" + i +
        "].n1_cod_pregunta} ");
        select_preg += " AND N3_COD_PREGUNTA=N2_COD_PREGUNTA";
        select_preg += " ORDER BY N3_ORDEN";

        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);
    }

    /**
     * Recoje las preguntas de tipo texto de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @throws ProcletException
     */
    public static void cogerPreguntaTexto(ProcletServiceData sd, String pregs,
        int i) throws ProcletException {
        String select_preg = "SELECT N4_TAMANO";
        select_preg += " FROM PR_TEXTO";
        select_preg += (" WHERE N4_COD_PREGUNTA=${" + pregs + "[" + i +
        "].n1_cod_pregunta}");

        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);
    }

    /**
     * Recoje las preguntas de tipo Procedencia de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @throws ProcletException
     */
    public static void cogerPreguntaProcedencia(ProcletServiceData sd,
        String pregs, int i) throws ProcletException {
        // las preguntas de tipo procedencia no tienen datos "extra", pero
        // hay que recoger los datos de pases, comunidades y territorios.
        //
        // slo hay que recoger estos datos una vez, no importa cuntas preguntas
        // de procedencia haya
        //if (sd.gOS("proc_pais[0]").equals("")) {
        // es la primera pregunta de procedencia, as que recogemos los
        // datos de paises
        // cogemos todos los paises menos espaa (cdigo 0)

        /*Hay que distinguir en que idioma estamos para sacar los nombres de los
         paises,territorios,comunidades,y municipios en el idioma adecuado*/
        if (sd.gOS("q53_cki.q53_idioma").equals(q53Constantes.IDIOMA_CAS)) {
			String select_pais = "proc_pais[]=SELECT P0_COD_PAIS, P0_NOMBRE_CAS AS P0_NOMBRE FROM PAIS ORDER BY P0_NOMBRE_CAS;";
            // cogemos todas las comunidades menos la del pas vasco (cdigo 0)
		    String select_comunidad = "proc_comunidad[]=SELECT P1_COD_COMUNIDAD, P1_NOMBRE_CAS AS P1_NOMBRE, P1_COD_PAIS FROM COMUNIDAD ORDER BY P1_NOMBRE_CAS;";
            String select_territorio = "proc_territorio[]=SELECT P2_COD_TERRITORIO, P2_NOMBRE_CAS AS P2_NOMBRE, P2_COD_COMUNIDAD FROM TERRITORIO ORDER BY P2_NOMBRE_CAS;";
            String select_municipio = "proc_municipio[]=SELECT P3_COD_MUNICIPIO, P3_NOMBRE_CAS AS P3_NOMBRE, P3_COD_TERRITORIO FROM MUNICIPIO ORDER BY P3_NOMBRE_CAS;";


            // cogemos la provincia & municipio de la oficina
            String select_oficina = "proc_oficina[]=SELECT TO_CHAR(T02_CODPROVINC,'FM09') T02_CODPROVINC,TO_CHAR(T02_CODMUNICIP,'FM0999') T02_CODMUNICIP FROM OFICINA WHERE T02_COOR='${q53_cki.q53_oficina}';";

            PSP.sqlProclet(sd,
                select_pais + select_comunidad + select_territorio +
                select_municipio + select_oficina);
        } else {
			String select_pais = "proc_pais[]=SELECT P0_COD_PAIS, P0_NOMBRE_EUS AS P0_NOMBRE FROM PAIS ORDER BY P0_NOMBRE_EUS;";

            // cogemos todas las comunidades menos la del pas vasco (cdigo 0)
            String select_comunidad = "proc_comunidad[]=SELECT P1_COD_COMUNIDAD, P1_NOMBRE_EUS AS P1_NOMBRE, P1_COD_PAIS FROM COMUNIDAD ORDER BY P1_NOMBRE_EUS;";
            String select_territorio = "proc_territorio[]=SELECT P2_COD_TERRITORIO, P2_NOMBRE_EUS AS P2_NOMBRE, P2_COD_COMUNIDAD FROM TERRITORIO ORDER BY P2_NOMBRE_EUS;";
            String select_municipio = "proc_municipio[]=SELECT P3_COD_MUNICIPIO, P3_NOMBRE_EUS AS P3_NOMBRE, P3_COD_TERRITORIO FROM MUNICIPIO ORDER BY P3_NOMBRE;";

            // cogemos la provincia & municipio de la oficina
            String select_oficina = "proc_oficina[]=SELECT TO_CHAR(T02_CODPROVINC,'FM09') T02_CODPROVINC,TO_CHAR(T02_CODMUNICIP,'FM0999') T02_CODMUNICIP FROM OFICINA WHERE T02_COOR='${q53_cki.q53_oficina}';";

            PSP.sqlProclet(sd,
                select_pais + select_comunidad + select_territorio +
                select_municipio + select_oficina);
        }
    }

    /**
     * Recoje las preguntas de tipo Fecha de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @throws ProcletException
     */
    public static void cogerPreguntaFecha(ProcletServiceData sd, String pregs,
        int i) throws ProcletException {
        String formato_fecha = q53Constantes.FORMATO_FECHA_CAS; // por defecto en castellano.

        if (sd.gOS("q53_cki.q53_idioma").equals(q53Constantes.IDIOMA_EUS)) {
            // si el idioma es euskera, muestra la fecha en formato de euskera
            formato_fecha = q53Constantes.FORMATO_FECHA_EUS;
        }

        String select_preg = "SELECT TO_CHAR(N6_FECHA_MIN,'" + formato_fecha +
            "') N6_FECHA_MIN, TO_CHAR(N6_FECHA_MAX,'" + formato_fecha +
            "') N6_FECHA_MAX";
        select_preg += " FROM PR_FECHA ";
        select_preg += (" WHERE N6_COD_PREGUNTA=${" + pregs + "[" + i +
        "].n1_cod_pregunta}");

        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);
    }

    /**
     * Recoje las preguntas de tipo Fecha de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param i int
     *
     * @throws ProcletException DOCUMENT ME!
     */
    public static void cogerPreguntaFecha(ProcletServiceData sd, int i)
        throws ProcletException {
        String select_preg = "SELECT TO_CHAR(N6_FECHA_MIN,'DD/MM/YYYY') N6_FECHA_MIN, TO_CHAR(N6_FECHA_MAX,'DD/MM/YYYY') N6_FECHA_MAX";
        select_preg += " FROM PR_FECHA";
        select_preg += (" WHERE N6_COD_PREGUNTA=" + i);

        PSP.sqlProclet(sd, "preg_gv_" + i + "[]=" + select_preg);
    }

    /**
     * Recoje las preguntas de tipo grupo opciones de la B.D.
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     * @param i int
     *
     * @throws ProcletException
     */
    public static void cogerPreguntaGrupos(ProcletServiceData sd, String pregs,
        int i) throws ProcletException {
        String select_preg = "SELECT N7_TIPO, N8_COD_GRUPO, N8_DESCRIPCION, N8_TAMANO";
        select_preg += " FROM PR_GRPS_GRUPO, PR_GRUPOS";
        select_preg += (" WHERE N8_COD_PREGUNTA=${" + pregs + "[" + i +
        "].n1_cod_pregunta}");
        select_preg += " AND N8_COD_PREGUNTA=N7_COD_PREGUNTA";
        select_preg += " ORDER BY N8_ORDEN";

        PSP.sqlProclet(sd, pregs + "_" + i + "[]=" + select_preg);
    }

    /**
     * Recorre las preguntas de una encuesta .
     *
     * @param sd El objeto ProcletServiceData
     * @param pregs String
     *
     * @throws ProcletException
     */
    public static void recorrerPreguntas(ProcletServiceData sd, String pregs)
        throws ProcletException {
        for (int i = 0; i < sd.gI(pregs + ".length"); i++) {
            String tipo_pregunta = sd.gOS(pregs + "[" + i +
                    "].n1_tipo_pregunta");

            if (tipo_pregunta.equals(q53Constantes.TIPO_OPCIONES)) {
                cogerPreguntaOpciones(sd, pregs, i);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_TEXTO)) {
                cogerPreguntaTexto(sd, pregs, i);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_PROCEDENCIA)) {
                cogerPreguntaProcedencia(sd, pregs, i);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_FECHA)) {
                cogerPreguntaFecha(sd, pregs, i);
            } else if (tipo_pregunta.equals(q53Constantes.TIPO_GRUPOS)) {
                cogerPreguntaGrupos(sd, pregs, i);
            }
        }
    }
}
