package q53_util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * 
 */

/**
 *  
 *
 */
public class q53PrintStreamWrapper{

	private PrintStream ps = null;
	
	private String         directorioLog = "/datos/q53/log/";
	private String         raizNombreArchivo = "Logs_q53_";
	private String         formatoFechaEnNombreDeArchivo = "dd_H";
	private String         formatoFechaEnComienzoDeArchivo = "MM";
	// Inherit Constructores------------------------------------------------------------------------------------

	/**
	 * @param out
	 */
	public q53PrintStreamWrapper() {		
		try{
			setPrintStream();
		}catch(Exception e){
			System.out.println("Q53: ATENCION! No ha sido posible redirigir la salida estandar");
		}
		// TODO Auto-generated constructor stub
	}
	
	public void println(String str){
		try{
			setPrintStream();
			ps.println(str);
			ps.close();
			ps = null;
		}catch (Exception e){
		 	System.out.println("Error al escribir en archivo de log en q53: " + e.getMessage());
		    System.out.println(str);
		}
	}
	
	
	public void println(Object obj){
		this.println(String.valueOf(obj));
	}
	
	public void print(String str){
		try{
			setPrintStream();
			ps.print(str);
			ps.close();
			ps = null;
		}catch (Exception e){
			System.out.println("Error al escribir en archivo de log en q53: " + e.getMessage());
			System.out.println(str);
		}
	}
	
	public void print(Object obj){
		this.print(String.valueOf(obj));
	}
	
	/**
	* Establece el printstream que va a utilizarse para realizar el loggeo, sera un archivo especificado por
	* el directorio de 'directorioLog' y con el nombre especificado en 'nombreArchivo' unido a un identificador temporal
	* especificado en 'formatoFechaEnNombreDeArchivo' y con extension 'log'
	* Adems introduce el mes de creacin en la primera linea para compararlo con el actual y asi saber si tiene que borrar el archivo o no
	* Si no puede establecerse el printstream se le asigna el valor system.out
	*/
	private void setPrintStream() throws Exception{
		 if (ps == null){
		    SimpleDateFormat sdf3= new SimpleDateFormat(formatoFechaEnComienzoDeArchivo);	   
	     	sdf3.setTimeZone(TimeZone.getTimeZone("ECT"));
	     	SimpleDateFormat sdf2= new SimpleDateFormat(formatoFechaEnNombreDeArchivo);
	     	sdf2.setTimeZone(TimeZone.getTimeZone("ECT"));
	     	String dat = sdf2.format(new Date());
	       	String nombreArchivo = directorioLog + raizNombreArchivo + dat + ".log";
	       	boolean existe = (new File(nombreArchivo)).exists(); 
	       	boolean tengo_el_mes = false;
	       	String mes ="";	
	       	File archivo = new File(nombreArchivo);
	       	//Si existe intenta coger el mes en el que se creo
	       	if(existe){
		       	BufferedReader fileIn = new BufferedReader(new FileReader(archivo));
		       	String texto = "nada";	       	
		       	int indice;
		       	do{
		       		texto = fileIn.readLine();
		       		indice = texto.indexOf("##SE CREA EL FICHERO. MES DE CREACION=");
		       		if(indice!=-1){
		       			mes=texto.split("=")[1];
		       			tengo_el_mes=true;
		       		}
		       	}while(texto!=null && !tengo_el_mes);
		       	fileIn.close();
	       	}
	       	//Si tiene el mes y es diferente del actual se borra y crea otra vez el fichero
	       	if(tengo_el_mes)
	     		if(!(mes.equals(sdf3.format(new Date())))){
	     			archivo.delete();
	     			archivo = new File(nombreArchivo);
	     			existe = false;
	     		}
	     	ps = new PrintStream(new FileOutputStream(archivo, true));
	     	if(!existe){
	     		ps.println("##SE CREA EL FICHERO. MES DE CREACION="+sdf3.format(new Date()));
	     	}
		 }
	}
	

	
}
