package q53_util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import com.bea.xml.XmlException;
import com.bea.xml.XmlOptions;
import com.cidat.proclets.ProcletException;
import com.cidat.proclets.ProcletServiceData;

import encuestas.PreguntaDocument.Pregunta;
import encuestas.RespuestaDocument.Respuesta;
import encuestas.RespuestasDocument;
import encuestas.RespuestasDocument.Respuestas;

public class q53ParserXMLPlanos {
	
	 public boolean validado;
	 public String mensaje_respuesta;
	 public Respuestas resp;
	 public Respuesta[] respuesta;
	 
	 public void q53ParserXMLPlanos(){
		this.validado=true;
		this.mensaje_respuesta="";
	 }
	//parsearRespuesta
	//Recoge los datos del xml y los valida
	//Devuelve un string con el mensaje de que todo ha ido bien o el mensaje de el error de validacin correspondiente
	 public boolean parsearRespuesta (ProcletServiceData sd,InputStream is) throws XmlException, IOException, ProcletException {
	    q53LogEstadisticas.printLog("ENTRA");	
	    String codRespuestaValidada;
        int hayError=0;
        mensaje_respuesta="";
        validado = true;
        int j;
        Pregunta[] pregunta;
        String[] valores;
        String[] opciones;
        Calendar fecha;
        ArrayList lista=new ArrayList();	        
        XmlOptions opts = new XmlOptions();
        Map ns = new HashMap();
        ns.put("", "encuestas");
        opts.setLoadSubstituteNamespaces(ns);  		    
        RespuestasDocument respDoc = RespuestasDocument.Factory.parse(is,opts); 
        resp = respDoc.getRespuestas();
        respuesta = resp.getRespuestaArray();
        validado=validar_valor("nonulo","claveFichero",resp.getClaveFichero(),"","");
        validado=validar_valor("nonulo","codOficina",resp.getCodOficina(),"","");
        q53LogEstadisticas.printLog("CLAVE DEL FICHERO : "+resp.getClaveFichero());	      
        q53LogEstadisticas.printLog("COD_OFICINA : "+resp.getCodOficina());	 
        q53LogEstadisticas.printLog("SE HAN ENCONTRADO "+respuesta.length+" respuestas");	
        for(int i=0;i<respuesta.length;i++){
        	
        	q53LogEstadisticas.printLog("*****************************************RESPUESTAPV***************************************");	

        	validado=validar_valor("nonulo","claveRespuesta",respuesta[i].getClaveRespuesta(),"","");
           	if(!validado)break;
        	validado=validar_valor("nonulo","fechaVersionSoftwarePlanos",respuesta[i].getFechaVersionSoftwarePlanos(),"","");
           	if(!validado)break;
        	validado=validar_valor("nonulo","codEncuesta",respuesta[i].getRespuestaPV().getCodEncuesta(),"","");
           	if(!validado)break;
        	validado=validar_valor("nonulo","fechaVisita",respuesta[i].getRespuestaPV().getFechaVisita(),"","");
           	if(!validado)break;
        	validado=validar_valor("nonulo","local",respuesta[i].getRespuestaPV().getProcedencia().getLocal(),"","");
        	if(respuesta[i].getRespuestaPV().getProcedencia().getLocal().toString().equals("N")){ 		
	        	validado=validar_valor("nonulo","codPais",String.valueOf(respuesta[i].getRespuestaPV().getProcedencia().getCodPais()),"","");
	           	if(!validado)break;
		        if(String.valueOf(respuesta[i].getRespuestaPV().getProcedencia().getCodPais()).equals("0")){
		        	validado=validar_valor("nonulo","codPostal",respuesta[i].getRespuestaPV().getProcedencia().getCodPostal(),"","");
		           	if(!validado)break;
	           	}
        	}
        	if(!validado)break;
        	q53LogEstadisticas.printLog("CLAVE DE LA RESPUESTA : "+respuesta[i].getClaveRespuesta());	    	
            q53LogEstadisticas.printLog("FECHA VERSION  : "+respuesta[i].getFechaVersionSoftwarePlanos());	            
	        q53LogEstadisticas.printLog("COD_ENCUESTAPV : "+respuesta[i].getRespuestaPV().getCodEncuesta());	 	        
	        q53LogEstadisticas.printLog("FECHA_VISITA : "+respuesta[i].getRespuestaPV().getFechaVisita());	 
        	q53LogEstadisticas.printLog("LOCAL = "+respuesta[i].getRespuestaPV().getProcedencia().getLocal().toString());
        	if(respuesta[i].getRespuestaPV().getProcedencia().getLocal().toString().equals("N")){ 
		        q53LogEstadisticas.printLog("PROCEDENCIA -> PAIS : "+respuesta[i].getRespuestaPV().getProcedencia().getCodPais()); 
		        q53LogEstadisticas.printLog("PROCEDENCIA -> COD_POSTAL : "+respuesta[i].getRespuestaPV().getProcedencia().getCodPostal());
        	}    
	        valores=respuesta[i].getRespuestaPV().getTipoInformacion().getDemandada().getOpcionArray();  
	        q53LogEstadisticas.printLog("INFORMACION DEMANDADA LENGTH->"+valores.length);		        
	        for(j=0;j<valores.length;j++){
	        	validado=validar_valor("nonulo,numerico,entre1y100","Informacion demandada -> opcion:"+j,valores[j],"","");
	        	if(!validado)break;
		        q53LogEstadisticas.printLog("INFORMACION DEMANDADA -> OPCION NUMERO "+j+": "+valores[j]);	
	        }
	        if(!validado)break;
	        valores=respuesta[i].getRespuestaPV().getTipoInformacion().getSolicitada().getOpcionArray();
	        q53LogEstadisticas.printLog("INFORMACION SOLICITADA LENGTH->"+valores.length);		
	        for(j=0;j<valores.length;j++){
	        	validado=validar_valor("nonulo,numerico,entre1y100","Informacion solicitada -> opcion:"+j,valores[j],"","");
	        	if(!validado)break;
		        q53LogEstadisticas.printLog("INFORMACION SOLICITADA -> OPCION NUMERO "+j+": "+valores[j]);
        	}
	        if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","total",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getTotal()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","adultos",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getAdultos()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","jovenes",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJovenes()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","jubilados",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJubilados()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","nios",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getNinos()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","sin concretar",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getEdad().getSinConcretar()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","hombres",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getSexo().getHombres()),"","");
	       	if(!validado)break;
	        validado=validar_valor("nonulo,entre0y100","mujeres",String.valueOf(respuesta[i].getRespuestaPV().getVisitantes().getSexo().getMujeres()),"","");
	        if(!validado)break;
	        q53LogEstadisticas.printLog("VISITANTES -> TOTAL : "+respuesta[i].getRespuestaPV().getVisitantes().getTotal());
	        q53LogEstadisticas.printLog("VISITANTES -> ADULTOS : "+respuesta[i].getRespuestaPV().getVisitantes().getEdad().getAdultos());
	        q53LogEstadisticas.printLog("VISITANTES -> JOVENES : "+respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJovenes());
	        q53LogEstadisticas.printLog("VISITANTES -> JUBILADOS : "+respuesta[i].getRespuestaPV().getVisitantes().getEdad().getJubilados());
	        q53LogEstadisticas.printLog("VISITANTES -> NIOS : "+respuesta[i].getRespuestaPV().getVisitantes().getEdad().getNinos());
	        q53LogEstadisticas.printLog("VISITANTES -> SIN CONCRETAR : "+respuesta[i].getRespuestaPV().getVisitantes().getEdad().getSinConcretar());
	        q53LogEstadisticas.printLog("VISITANTES -> HOMBRES : "+respuesta[i].getRespuestaPV().getVisitantes().getSexo().getHombres());
	        q53LogEstadisticas.printLog("VISITANTES -> MUJERES : "+respuesta[i].getRespuestaPV().getVisitantes().getSexo().getMujeres());
			
			//IGC 20150519 INICIO INCLUIR PREGUNTA VALIDACION ESTANCIA
			////////PONGO LOS de la valoracion de la estancia/.   No se activa, ya que la mquina de planos no se modifica
			//      	validado=validar_valor("entre1y5","ValoracionEstancia",String.valueOf(respuesta[i].getRespuestaPV().getValoracionEstancia()),"","");
			//			sd.setVal("opt_12",String.valueOf(respuesta[i].getRespuestaPV().getValoracionEstancia(0)));
			//       	q53LogEstadisticas.printLog("VALORACION_ESTANCIA ->: "+respuesta[i].getRespuestaPV().getValoracionEstancia());
			//      	if(!validado)break;
			//IGC 20150519 FIN INCLUIR PREGUNTA VALIDACION ESTANCIA

	        
	        q53LogEstadisticas.printLog("*****************************************FIN RESPUESTAPV***************************************");	
	        
	        if(respuesta[i].getRespuestaOFI()!=null){
		        q53LogEstadisticas.printLog("*****************************************RESPUESTAOFI***************************************");	
		        
		        validado=validar_valor("nonulo","codEncuesta",String.valueOf(respuesta[i].getRespuestaOFI().getCodEncuesta()),"","");
		       	if(!validado)break;
		        validado=validar_valor("nonulo","codVersionEncuesta",String.valueOf(respuesta[i].getRespuestaOFI().getCodVersionEncuesta()),"","");
		        if(!validado)break;
		        q53LogEstadisticas.printLog("COD_ENCUESTAOFI : "+respuesta[i].getRespuestaOFI().getCodEncuesta());	
	        	q53LogEstadisticas.printLog("COD_VERSION_ENCUESTAOFI : "+respuesta[i].getRespuestaOFI().getCodVersionEncuesta());
	        	pregunta=respuesta[i].getRespuestaOFI().getPreguntaArray();
	        	q53LogEstadisticas.printLog("NUMERO DE PREGUNTAS : "+pregunta.length);
	        	for(j=0;j<pregunta.length;j++){
			        validado=validar_valor("nonulo,numerico","orden",pregunta[j].getOrden(),"","");
			        if(!validado)break;
			        q53LogEstadisticas.printLog("PREGUNTA "+j+" ORDEN -> "+pregunta[j].getOrden());	
			        if(pregunta[j].getNumero()!=null){
			        	validado=validar_valor("numerico","pregunta ofi tipo numero "+j,pregunta[j].getNumero().toString(),"","");
				        if(!validado)break;
			        	q53LogEstadisticas.printLog("PREGUNTA "+j+" NUMERO -> "+pregunta[j].getNumero());		    
			        }
			       	if(!validado)break;
			        if(pregunta[j].getOpcionesMultiples()!=null){
			        	opciones=pregunta[j].getOpcionesMultiples().getOpcionArray();
		        		for(int k=0;k<opciones.length;k++){
		        			validado=validar_valor("numerico,entre1y100","pregunta ofi tipo opciones multiples "+j,opciones[k],"","");
					        if(!validado)break;
		        			q53LogEstadisticas.printLog("PREGUNTA "+j+" OPCIONES MULTIPLES -> "+opciones[k]);
		        		}
			        }
			       	if(!validado)break;
			        if(pregunta[j].getOpcionUnica()!=null){
			        	validado=validar_valor("numerico,entre1y100","pregunta ofi tipo opcion unica "+j,pregunta[j].getOpcionUnica(),"","");
				        if(!validado)break;
			        	q53LogEstadisticas.printLog("PREGUNTA "+j+" OPCION UNICA -> "+pregunta[j].getOpcionUnica());	
			        }
			       	if(!validado)break;
			        if(pregunta[j].getTexto()!=null){
			        	//validado=validar_valor("nonulo","pregunta ofi tipo texto "+j,pregunta[j].getTexto(),"","");
				        //if(!validado)break;
			        	q53LogEstadisticas.printLog("PREGUNTA "+j+" TEXTO -> "+pregunta[j].getTexto());	
			        }
			        if(pregunta[j].getFecha()!=null){
			        	fecha=pregunta[j].getFecha();
			        	q53LogEstadisticas.printLog("PREGUNTA "+j+" FECHA AO/MES/DIA HORA -> "
			        			+fecha.get(Calendar.YEAR)+"/"+(fecha.get(Calendar.MONTH)+1)+"/"+fecha.get(Calendar.DAY_OF_MONTH)
			        			+" "+fecha.get(Calendar.HOUR_OF_DAY));		
			        }
	        	}
	        	if(!validado)break;
        	
	        	q53LogEstadisticas.printLog("*****************************************FIN RESPUESTAOFI***************************************");	 
	        }
	        
	    }	        	
        return validado;
	 }
	 
	 
	 
	 
	 
	 
	 //public boolean validar_valor
	 //valida un objeto perteneciente a un elemento del xml
	 //Parametros :
	 //	String tipos_string = cadena de texto explicando el tipo de validaciones que se van a realizar separadas por comas
	 //	String nombre_elemento =	nombre informativo del elemento que vamos a validar
	 //	Object valor = objeto que contiene el valor 
	 //	String expresion_regular = tambien se puede introducir una expresion regular para que valide el objeto contra ella
	 //	String descripcion_expresion = descripcion de la expresion regular utilizada para validar
	
	 public boolean validar_valor(String tipos_string,String nombre_elemento,Object valor,String expresion_regular,String descripcion_expresion){
		 boolean resul = true;
		 String valor_elemento = valor.toString();
		 String[] tipos = tipos_string.split(",");
		 Pattern p;
		 Matcher m;
		 for(int i=0;i<tipos.length;i++){
			 if(tipos[i].equals("nonulo")){
				 if(valor_elemento=="" || valor==null){
					 resul = false;
					 mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' no puede estar vacio";					 
				 }
			 }else if(tipos[i].equals("entre0y100")){
				 p = Pattern.compile("^(([0-9]?[0-9])|(100))$");
				 m = p.matcher(valor_elemento);
			     if (!m.find()){
			     	 resul = false;
			     	 mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' no tiene un rango de valores entre 0 y 100";	
				}
			 }else if(tipos[i].equals("entre1y5")){
				p = Pattern.compile("^([1-5]?)$");
				m = p.matcher(valor_elemento);
				if (!m.find()){
					resul = false;
					mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' no tiene un rango de valores entre 1 y 5";	
				}
			 }else if(tipos[i].equals("numerico")){
				 p = Pattern.compile("^(?:\\+)?\\d+$");
				 m = p.matcher(valor_elemento);
			     if (!m.find()){
			     	 resul = false;
			     	 mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' tiene un valor no numerico";	
			     }
			 }else if(tipos[i].equals("entre1y100")){
			     if (!(Integer.parseInt(valor_elemento)>0 && Integer.parseInt(valor_elemento)<=100)){
			     	 resul = false;
			     	 mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' no tiene un rango de valores entre 1 y 100";	
			     }
			 }
		 }
		 if(!expresion_regular.equals("")){
			 p = Pattern.compile(expresion_regular);
		     m = p.matcher(valor_elemento);
		     if (!m.find()){
		    	 q53LogEstadisticas.printLog("No ha validado la expresion regular");
		     	 resul = false;
		     	 mensaje_respuesta += "\nEl elemento '"+nombre_elemento+"' no cumple el siguiente requisito : "+descripcion_expresion;	
		     }
		 }
			 
		 return resul;
	 } 
	 
	 public boolean validar_contra_xsd(InputStream is) throws SAXException, IOException{	
	    this.validado = true;
	    Document document;
	    q53LogEstadisticas.printLog("control"); 
	    DocumentBuilderFactory factory =
	    	DocumentBuilderFactory.newInstance();
	    q53LogEstadisticas.printLog("control"); 
	    factory.setValidating(true);
	    factory.setNamespaceAware(true);
	    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");  
 	    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new File("/datos/q53/file/maquina_planos/planos_v4.xsd"));
 	    try {
          DocumentBuilder builder =factory.newDocumentBuilder();
          builder.setErrorHandler(new MyErrorHandler());
          document = builder.parse(is);
          return validado;
        } catch (SAXException sxe) {
	        Exception  x = sxe;
	        if (sxe.getException() != null)
 	           x = sxe.getException();
     	    q53LogEstadisticas.printLog(x.getMessage());
	        return false;
        } catch (ParserConfigurationException pce) {
    	    q53LogEstadisticas.printLog(pce.getMessage());
    	    return false;
        } catch (IOException ioe) {
		    q53LogEstadisticas.printLog(ioe.getMessage());
		    return false;
        }
	 }
	 
	 private class MyErrorHandler extends DefaultHandler {
	   public void warning(SAXParseException e) throws SAXException {
		  q53LogEstadisticas.printLog("Warning: "); 
		  mensaje_respuesta += "\nWarning: "; 
	      printInfo(e);
	   }
	   public void error(SAXParseException e) throws SAXException {
		  q53LogEstadisticas.printLog("Error: "); 
		  mensaje_respuesta += "\nError: "; 
	      printInfo(e);
	   }
	   public void fatalError(SAXParseException e) throws SAXException {
		  q53LogEstadisticas.printLog("Fatal error: ");
		  mensaje_respuesta += "\nFatal error: ";
	      printInfo(e);
	   }
	   private void printInfo(SAXParseException e) {
		  q53LogEstadisticas.printLog("   Numero de linea: "+e.getLineNumber());
		  q53LogEstadisticas.printLog("   Numero de columna: "+e.getColumnNumber());
		  q53LogEstadisticas.printLog("   Mensaje: "+e.getMessage());
		  mensaje_respuesta += "\n	 Numero de linea: "+(e.getLineNumber()+1);
		  mensaje_respuesta += "\n 	 Numero de columna: "+(e.getColumnNumber()+1);	
		  mensaje_respuesta += "\n	 Mensaje: "+e.getMessage();	  
		  validado = false;
	  }
	 }
	    
}