/*
 * Created on 24-feb-2011
 *
 */
package q53_util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Context Listener que inicializa el blunde de literales.
 * 
 * El nombre no es bueno, ademas no deberia hacer de fachada de el blunde
 * sino ser algo mas generico con todo lo que se tenga que inicializar en un
 * hash... tipo hm.put("CTX_LITERALES", hmLiterales)...
 * 
 * En cuanto haya algo mas para ser inicializado con el contexto seria bueno
 * generalizar aqui de ese modo.
 * 
 */

public class q53BundleLiterales implements ServletContextListener {
	private static BundleLiterales hmLiterales = null;
	/** Establece el idioma en el que se van a buscar los tirales a partir de este momento
	 * @param lang
	 */
	public static void setLanguaje(String lang){
		hmLiterales.setLanguaje(lang);
	}
	
	public static synchronized void reset(){
		hmLiterales.reset();
	}
	
	/** Obtiene el literal que corresponde a key en el idioma actual
	 * @param key
	 * @return
	 */
	public static String get(Object key){
		return hmLiterales.get(key);
	}
	
	public static void setHashMapFromContext(ServletContext ctx){
		hmLiterales = BundleLiterales.getBL();
		if (hmLiterales == null)
			hmLiterales = ((BundleLiterales)(ctx.getAttribute(BundleLiterales.key)));
	}
	
	/**Establece el valor de key para el actual idioma
	 * @param key
	 * @param value
	 */
	public static void put(Object key, String value){
		hmLiterales.put(key, value);
	}
	
	/** Devuelve true si el idioma actual contiene un valor para key
	 * @param codigo
	 * @return
	 */
	public static boolean containsKey(Object codigo){
		return hmLiterales.containsKey(codigo);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
	 */
	public void contextInitialized(ServletContextEvent event) {
		final ServletContext context = event.getServletContext();
		q53LogEstadisticas.printLog("Starting context");
		hmLiterales = BundleLiterales.getInstance(
										new String[]{q53Constantes.IDIOMA_CAS, q53Constantes.IDIOMA_EUS}
							);
		context.setAttribute(BundleLiterales.key, hmLiterales);								
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	public void contextDestroyed(ServletContextEvent arg0) {
		q53LogEstadisticas.printLog("Destroying context");
	}
}
/**
 * Clase para mantener los literales en castellano y euskera.
 *
 */
class BundleLiterales{
	private HashMap activeLanguaje = null;
	private HashMap languajes = new HashMap();
	private static BundleLiterales bl = null;
	public static String key = BundleLiterales.class.getName();
	
	public static BundleLiterales getInstance(String[] keysLanguajes){
		if (bl != null)
			q53LogEstadisticas.printLog("Returning common languaje blunde");
		else
			bl = new BundleLiterales(keysLanguajes);
		return bl;
		
		
	}
	
	public static BundleLiterales getBL(){
		return bl;
	}
	/**
	 *Inicia el bundle de literales para los idiomas cuyos keys se le pasan
	 *en como parametros
	 *
	 * @param keysLanguajes Array con los keys que se van a utilizar para identificar
	 * a cada idioma.
	 *
	 */
	private BundleLiterales(String[] keysLanguajes){
		q53LogEstadisticas.printLog("Creating a new languaje blunde");
		for (int i = 0; i < keysLanguajes.length; i++)
			languajes.put(keysLanguajes[i], new HashMap());
	}
	
	/** Establece el idioma en el que se van a buscar los tirales a partir de este momento
	 * @param lang
	 */
	public void setLanguaje(String lang){
		activeLanguaje = (HashMap)languajes.get(lang);
	}
	
	/** Obtiene el literal que corresponde a key en el idioma actual
	 * @param key
	 * @return
	 */
	public String get(Object key){
		return (String)activeLanguaje.get(key);
	}
	
	/**Establece el valor de key para el actual idioma
	 * @param key
	 * @param value
	 */
	public void put(Object key, String value){
		activeLanguaje.put(key, value);
	}
	
	/** Devuelve true si el idioma actual contiene un valor para key
	 * @param codigo
	 * @return
	 */
	public boolean containsKey(Object codigo){
		return activeLanguaje.containsKey(codigo);
	}
	
	/** Backward compatibility only. Do not use NEVER!!!!
	 * @return a private object... you dont care!!!
	 */
	public HashMap getHashMapIdioma(){
		return activeLanguaje;
	}
	
	public void reset(){
		Iterator it = languajes.entrySet().iterator();
		while (it.hasNext()) {
			  Entry thisEntry = (Entry) it.next();
			  String key = (String) thisEntry.getKey();
			  languajes.put(key, new HashMap());;
		}
	}
}
