package com.cidat.proclets;

import javax.servlet.http.Cookie;

public class SetCookieProclet implements Proclet {
	String cookieNameExpr;
	int maxAge;
	String[] exprs;

	public SetCookieProclet(String cookieNameExpr, int maxAge,
			String expressions) {
		this.cookieNameExpr = cookieNameExpr;
		this.maxAge = maxAge;
		this.exprs = ProcletServiceData.valListToArr(expressions);
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		StringBuffer cookieVal = new StringBuffer();
		for (int n = 0; n < this.exprs.length; n++) {
			if (n > 0)
				cookieVal.append('-');
			cookieVal.append(sd.evalExpr(this.exprs[n]));
		}
		String cookieName = sd.evalExpr(this.cookieNameExpr);
		Cookie cookie = new Cookie(cookieName, cookieVal.toString());
		cookie.setMaxAge(this.maxAge);
		sd.res.addCookie(cookie);
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.SetCookieProclet
 * JD-Core Version: 0.6.0
 */