package com.cidat.proclets;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;

public class PropertiesProclet implements Proclet {
	String filenameExpr;
	String valNamePrefix;
	String[] propNames;
	String[] defPropVals;
	static Hashtable filenameToProperties = new Hashtable();

	static RE propDefFormat = null;

	public PropertiesProclet(String filenameExpr, String valNamePrefix,
			String propertiesDefs) {
		this.filenameExpr = filenameExpr;
		this.valNamePrefix = valNamePrefix;

		String[] propDefs = ProcletServiceData.valListToArr(propertiesDefs);

		this.propNames = new String[propDefs.length];
		this.defPropVals = new String[propDefs.length];

		for (int n = 0; n < propDefs.length; n++) {
			if (!propDefFormat.isMatch(propDefs[n])) {
				throw new ValException(
						"Formato de la definición del property errónea: \""
								+ propDefs[n] + "\"");
			}
			REMatch reM = propDefFormat.getMatch(propDefs[n]);
			this.propNames[n] = reM.toString(1);
			this.defPropVals[n] = (reM.toString(2).length() > 0 ? reM
					.toString(3) : null);
		}
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String filename = null;
		if ((this.filenameExpr == null) || (this.filenameExpr.length() == 0)) {
			filename = sd.appPropertiesFilePath;
			if (filename == null)
				throw new ProcletException(
						sd,
						"PropertiesProclet: filenameExpr es null, y no hay fichero de aplicacion de ProcletProperties");
		} else {
			filename = sd.evalExpr(this.filenameExpr);
		}
		Properties props = getProperties(sd, filename);

		for (int n = 0; n < this.propNames.length; n++) {
			String propVal = props == null ? null : (String) props
					.get(this.propNames[n]);

			if (propVal == null) {
				propVal = this.defPropVals[n];
			}
			if (propVal == null) {
				throw new ProcletException(sd,
						"Propiedad no encontrada, ni valor por defecto: \""
								+ this.propNames[n] + "\"");
			}

			sd.sS(this.valNamePrefix + this.propNames[n], propVal);
		}
	}

	Properties getProperties(ProcletServiceData sd, String filename) {
		File changedFile = new File(filename + ".changed");
		Properties props = (Properties) filenameToProperties.get(filename);
		boolean changedFileExists = changedFile.exists();

		if ((!changedFileExists) && (props != null)) {
			return props;
		}
		props = loadProperties(sd, filename);
		if (changedFileExists) {
			changedFile.delete();
		}
		if (props == null)
			filenameToProperties.remove(filename);
		else
			filenameToProperties.put(filename, props);
		return props;
	}

	Properties loadProperties(ProcletServiceData sd, String filename) {
		Properties prop = new Properties();
		try {
			prop.load(new FileInputStream(new File(filename)));
		} catch (Exception e) {
			prop = null;
		}

		if ((sd.debugVersion) && (prop != null)) {
			System.out.println("PropertiesProclet: fichero \"" + filename
					+ "\" leido");
		}
		return prop;
	}

	static {
		try {
			propDefFormat = new RE(
					"\\s*([a-z\\.A-Z0-9_]+)\\s*(\\((.*?)\\))?\\s*");
		} catch (REException e) {
			System.out.println("Error en propDefFormat: \"" + e.toString()
					+ "\"");
		}
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.PropertiesProclet
 * JD-Core Version: 0.6.0
 */