package com.cidat.proclets;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class ProcletProperties extends Properties {
	String iniError = null;
	static final String CFG_DIR = "cfg";
	String dataSourceName;
	String errorTemplatePage;
	String logFilePath;
	boolean debugVersion;
	File appPropertiesFile = null;

	public ProcletProperties(String dataSourceName, String errorTemplatePage,
			String logFilePath, boolean debugVersion) {
		this.dataSourceName = dataSourceName;

		this.errorTemplatePage = errorTemplatePage;
		this.debugVersion = debugVersion;
		this.logFilePath = logFilePath;
	}

	public ProcletProperties(String appName) {
		this(new File("cfg" + File.separator + appName + ".properties"));
	}

	public ProcletProperties(File appPropertiesFile) {
		this.appPropertiesFile = appPropertiesFile;
		try {
			loadData(new FileInputStream(appPropertiesFile));
		} catch (Exception e) {
			this.iniError = ("ProcletProperties: no se pudo cargar '"
					+ appPropertiesFile.getAbsolutePath() + "' " + e
					.getMessage());
			System.out.println(this.iniError);
			return;
		}
	}

	public ProcletProperties(InputStream is) {
		loadData(is);
	}

	void testNewVersion() {
		if ((this.appPropertiesFile != null) && (this.iniError != null)) {
			try {
				loadData(new FileInputStream(this.appPropertiesFile));
			} catch (Exception e) {
				this.iniError = ("ProcletProperties: no se pudo cargar '"
						+ this.appPropertiesFile.getAbsolutePath() + "' " + e
						.getMessage());
				System.out.println(this.iniError);
				return;
			}
		}
	}

	protected void loadData(InputStream is) {
		try {
			load(is);
		} catch (Exception e) {
			this.iniError = ("ProcletProperties: no se pudo cargar " + e
					.getMessage());
			System.out.println(this.iniError);
			return;
		}

		this.dataSourceName = getProperty("DataSource", null);
		this.debugVersion = getProperty("DebugVersion", "false").equals("true");

		this.logFilePath = getProperty("LogFilePath", "logs");
		this.errorTemplatePage = getProperty("ErrorTemplatePage",
				"/tmpl/error.jsp");

		if (this.debugVersion) {
			System.out
					.println("************************************************");
			if (this.appPropertiesFile != null) {
				System.out
						.println("Fichero de propiedades de aplicacion \""
								+ this.appPropertiesFile.getAbsolutePath()
								+ "\" leido");
			} else {
				System.out
						.println("Fichero de propiedades de aplicación leido a partir de un getResourceAsStream");
			}
			System.out.println("DataSource " + this.dataSourceName);
			System.out.println("DebugVersion " + this.debugVersion);

			System.out.println("LogFilePath " + this.logFilePath);
			System.out.println("ErrorTemplatePage " + this.errorTemplatePage);
			System.out
					.println("************************************************");
		}
		this.iniError = null;
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.ProcletProperties
 * JD-Core Version: 0.6.0
 */