package com.cidat.proclets;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ProcletException extends Exception {
	boolean hardException = false;

	public ProcletException(ProcletServiceData sd, Exception e) {
		super(e.toString());
		sd.setVal("com.cidat.proclets.error", e.toString());
		sd.templatePageExpr = sd.errorPage;
		saveStackVal(sd, e);
		this.hardException = true;
	}

	public ProcletException(ProcletServiceData sd) {
		if (!sd.exists("com.cidat.proclets.error")) {
			sd.setVal("com.cidat.proclets.error", "");
		}
		sd.templatePageExpr = sd.errorPage;
		this.hardException = true;
	}

	public ProcletException(ProcletServiceData sd, String name, String value) {
		if (!sd.exists("com.cidat.proclets.error")) {
			sd.setVal("com.cidat.proclets.error", "");
		}
		if (name != null)
			sd.setVal(name, sd.evalExpr(value));
		this.hardException = false;
	}

	public ProcletException(ProcletServiceData sd, String errorExpr) {
		super(sd.evalExpr(errorExpr));
		sd.templatePageExpr = sd.errorPage;
		sd.setVal("com.cidat.proclets.error", sd.evalExpr(errorExpr));
		this.hardException = true;
	}

	public static void saveStackVal(ProcletServiceData sd, Exception e) {
		CharArrayWriter ca = new CharArrayWriter();
		e.printStackTrace(new PrintWriter(ca));
		sd.setVal("com.cidat.proclets.stack", ca.toString());
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.ProcletException
 * JD-Core Version: 0.6.0
 */