package com.cidat.proclets;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class PSPServlet extends HttpServlet {
	protected ProcletProperties procletProperties = null;
	protected boolean bIsInner = false;

	public abstract ProcletProperties getProcletProperties();

	public boolean bInner() {
		return false;
	}

	public abstract void pspProcess(ProcletServiceData paramProcletServiceData)
			throws ProcletException;

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		this.procletProperties = getProcletProperties();
		this.bIsInner = bInner();
	}

	protected void service(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		ProcletServiceData sd = ProcletServiceData.getPageProcletServiceData(
				req, res, getServletConfig(), this.bIsInner,
				this.procletProperties);
		try {
			sd.pageProcletIni();
			pspProcess(sd);
		} catch (Exception e) {
			sd.setException(e);
		} finally {
			sd.pageProcletEnd();
		}
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.PSPServlet JD-Core
 * Version: 0.6.0
 */