package com.cidat.proclets;

public class PSP {
	public static void callProclet(ProcletServiceData sd, String procletPathExpr)
			throws ProcletException {
		new CallProclet(procletPathExpr).process(sd);
	}

	public static void downloadProclet(ProcletServiceData sd,
			String pathFichExpr, String nameExpr) throws ProcletException {
		new DownloadProclet(pathFichExpr, nameExpr).process(sd);
	}

	public static void downloadProclet(ProcletServiceData sd,
			String pathFichExpr, String nameExpr, String saveWindowExpr,
			String mimeTypeExpr) throws ProcletException {
		new DownloadProclet(pathFichExpr, nameExpr, saveWindowExpr,
				mimeTypeExpr).process(sd);
	}

	public static void fileUploadProclet(ProcletServiceData sd,
			String inputName, String extensionVal, String fileSavePathExpr,
			String allowedExtensions, String allowedContents, int maxSize,
			String filenameVal) throws ProcletException {
		new FileUploadProclet(inputName, extensionVal, fileSavePathExpr,
				allowedExtensions, allowedContents, maxSize, filenameVal)
				.process(sd);
	}

	public static void fileUploadProclet(ProcletServiceData sd,
			String[] inputName, String[] extensionVal,
			String[] fileSavePathExpr, String allowedExtensions,
			String allowedContents, int maxSize, String[] filenameVal)
			throws ProcletException {
		new FileUploadProclet(inputName, extensionVal, fileSavePathExpr,
				allowedExtensions, allowedContents, maxSize, filenameVal)
				.process(sd);
	}

	public static void getCookieProclet(ProcletServiceData sd,
			String cookieNameExpr, String vals, Proclet ifCookieProclet,
			Proclet ifNoCookieProclet) throws ProcletException {
		new GetCookieProclet(cookieNameExpr, vals, ifCookieProclet,
				ifNoCookieProclet).process(sd);
	}

	public static void listJoinProclet(ProcletServiceData sd,
			String listValName, String loopValName, String loopNumberExpr,
			String addExpr, String separatorExpr) throws ProcletException {
		new ListJoinProclet(listValName, loopValName, loopNumberExpr, addExpr,
				separatorExpr).process(sd);
	}

	public static void loginProclet(ProcletServiceData sd, String realm,
			String loginValName, String passwordValName, Proclet getPassword,
			String password2ValName) throws ProcletException {
		new LoginProclet(realm, loginValName, passwordValName, getPassword,
				password2ValName).process(sd);
	}

	public static void logProclet(ProcletServiceData sd, String filenameExpr,
			String logLineExpr) throws ProcletException {
		new LogProclet(filenameExpr, logLineExpr).process(sd);
	}

	public static void paramProclet(ProcletServiceData sd, String paramDefsList)
			throws ProcletException {
		new ParamProclet(paramDefsList).process(sd);
	}

	public static void paramProclet(ProcletServiceData sd, String paramDef,
			Proclet procletBeforeIni) throws ProcletException {
		new ParamProclet(paramDef, procletBeforeIni).process(sd);
	}

	public static void redirectProclet(ProcletServiceData sd,
			String servletPath, String addParamsExpr) throws ProcletException {
		new RedirectProclet(servletPath, addParamsExpr).process(sd);
	}

	public static void redirectProclet(ProcletServiceData sd,
			String servletPath, String addParamsExpr, String anchorExpr)
			throws ProcletException {
		new RedirectProclet(servletPath, addParamsExpr, anchorExpr).process(sd);
	}

	public static void redirectProclet(ProcletServiceData sd,
			String absoluteUrlExpr) throws ProcletException {
		new RedirectProclet(absoluteUrlExpr).process(sd);
	}

	public static void setCookieProclet(ProcletServiceData sd,
			String cookieNameExpr, int maxAge, String expressions)
			throws ProcletException {
		new SetCookieProclet(cookieNameExpr, maxAge, expressions).process(sd);
	}

	public static void setSessionValProclet(ProcletServiceData sd,
			String valNameExpr, String valueExpr) throws ProcletException {
		new SetValInSessionProclet(valNameExpr, valueExpr, true).process(sd);
	}

	public static void setValInSessionProclet(ProcletServiceData sd,
			String valNameExpr, String valueExpr) throws ProcletException {
		new SetValInSessionProclet(valNameExpr, valueExpr).process(sd);
	}

	public static void setValInSessionProclet(ProcletServiceData sd,
			String valNameExpr, String valueExpr, boolean boCrearSesion)
			throws ProcletException {
		new SetValInSessionProclet(valNameExpr, valueExpr, boCrearSesion)
				.process(sd);
	}

	public static void getValFromSessionProclet(ProcletServiceData sd,
			String valNameExpr) throws ProcletException {
		new GetValFromSessionProclet(valNameExpr).process(sd);
	}

	public static void setTemplatePageProclet(ProcletServiceData sd,
			String templatePathExpr) throws ProcletException {
		new SetTemplatePageProclet(templatePathExpr).process(sd);
	}

	public static void setValProclet(ProcletServiceData sd, String valName,
			String valueExpr) throws ProcletException {
		new SetValProclet(valName, valueExpr).process(sd);
	}

	public static void setValProclet(ProcletServiceData sd, String valName,
			String valueExpr, String valName2, String valueExpr2)
			throws ProcletException {
		new SetValProclet(valName, valueExpr, valName2, valueExpr2).process(sd);
	}

	public static void sqlProclet(ProcletServiceData sd, String querysDefs)
			throws ProcletException {
		new SqlProclet(querysDefs).process(sd);
	}

	public static void sqlProclet(ProcletServiceData sd, String querysDefs,
			Proclet procletBeforeCommit) throws ProcletException {
		new SqlProclet(querysDefs, procletBeforeCommit).process(sd);
	}

	public static void propertiesProclet(ProcletServiceData sd,
			String filenameExpr, String valNamePrefix, String propertiesDefs)
			throws ProcletException {
		new PropertiesProclet(filenameExpr, valNamePrefix, propertiesDefs)
				.process(sd);
	}

	public static boolean existsSession(ProcletServiceData sd) {
		return sd.req.getSession(false) != null;
	}

	public static boolean existsVal(ProcletServiceData sd, String valNameExpr) {
		return sd.exists(sd.evalExpr(valNameExpr));
	}

	public static boolean equals(ProcletServiceData sd, String expr1,
			String expr2) {
		return sd.evalExpr(expr1).equals(sd.evalExpr(expr2));
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.PSP JD-Core Version:
 * 0.6.0
 */