package com.cidat.proclets;

import java.util.Hashtable;

final class MimeTypes {
	private static Hashtable htMimes = new Hashtable();

	public static String getMime(String pNomFic) {
		pNomFic = pNomFic.substring(pNomFic.indexOf(".") + 1);
		if (htMimes.containsKey(pNomFic))
			return (String) htMimes.get(pNomFic);
		return "application/octet-stream";
	}

	static {
		htMimes.put("hqx", "application/mac-binhex40");
		htMimes.put("cpt", "application/mac-compactpro");
		htMimes.put("doc", "application/msword");
		htMimes.put("bin", "application/octet-stream");
		htMimes.put("dms", "application/octet-stream");
		htMimes.put("lha", "application/octet-stream");
		htMimes.put("lzh", "application/octet-stream");
		htMimes.put("exe", "application/octet-stream");
		htMimes.put("class", "application/octet-stream");
		htMimes.put("oda", "application/oda");
		htMimes.put("pdf", "application/pdf");
		htMimes.put("ai", "application/postscript");
		htMimes.put("eps", "application/postscript");
		htMimes.put("ps", "application/postscript");
		htMimes.put("ppt", "application/powerpoint");
		htMimes.put("rtf", "application/rtf");
		htMimes.put("smi", "application/smil");
		htMimes.put("smil", "application/smil");
		htMimes.put("sml", "application/smil");
		htMimes.put("bcpio", "application/x-bcpio");
		htMimes.put("vcd", "application/x-cdlink");
		htMimes.put("cpio", "application/x-cpio");
		htMimes.put("csh", "application/x-csh");
		htMimes.put("dcr", "application/x-director");
		htMimes.put("dir", "application/x-director");
		htMimes.put("dxr", "application/x-director");
		htMimes.put("dvi", "application/x-dvi");
		htMimes.put("gtar", "application/x-gtar");
		htMimes.put("hdf", "application/x-hdf");
		htMimes.put("js", "application/x-javascript");
		htMimes.put("skp", "application/x-koan");
		htMimes.put("skd", "application/x-koan");
		htMimes.put("skt", "application/x-koan");
		htMimes.put("skm", "application/x-koan");
		htMimes.put("latex", "application/x-latex");
		htMimes.put("mif", "application/x-mif");
		htMimes.put("nc", "application/x-netcdf");
		htMimes.put("cdf", "application/x-netcdf");
		htMimes.put("sh", "application/x-sh");
		htMimes.put("shar", "application/x-shar");
		htMimes.put("sit", "application/x-stuffit");
		htMimes.put("sv4cpio", "application/x-sv4cpio");
		htMimes.put("sv4crc", "application/x-sv4crc");
		htMimes.put("tar", "application/x-tar");
		htMimes.put("tcl", "application/x-tcl");
		htMimes.put("tex", "application/x-tex");
		htMimes.put("texinfo", "application/x-texinfo");
		htMimes.put("texi", "application/x-texinfo");
		htMimes.put("t", "application/x-troff");
		htMimes.put("tr", "application/x-troff");
		htMimes.put("roff", "application/x-troff");
		htMimes.put("man", "application/x-troff-man");
		htMimes.put("me", "application/x-troff-me");
		htMimes.put("ms", "application/x-troff-ms");
		htMimes.put("ustar", "application/x-ustar");
		htMimes.put("src", "application/x-wais-source");
		htMimes.put("zip", "application/zip");
		htMimes.put("au", "audio/basic");
		htMimes.put("snd", "audio/basic");
		htMimes.put("mid", "audio/midi");
		htMimes.put("midi", "audio/midi");
		htMimes.put("kar", "audio/midi");
		htMimes.put("mpga", "audio/mpeg");
		htMimes.put("mp2", "audio/mpeg");
		htMimes.put("mp3", "audio/mpeg");
		htMimes.put("aif", "audio/x-aiff");
		htMimes.put("aiff", "audio/x-aiff");
		htMimes.put("aifc", "audio/x-aiff");
		htMimes.put("ram", "audio/x-pn-realaudio");
		htMimes.put("rpm", "audio/x-pn-realaudio-plugin");
		htMimes.put("ra", "audio/x-realaudio");
		htMimes.put("wav", "audio/x-wav");
		htMimes.put("pdb", "chemical/x-pdb");
		htMimes.put("xyz", "chemical/x-pdb");
		htMimes.put("gif", "image/gif");
		htMimes.put("ief", "image/ief");
		htMimes.put("jpeg", "image/jpeg");
		htMimes.put("jpg", "image/jpeg");
		htMimes.put("jpe", "image/jpeg");
		htMimes.put("png", "image/png");
		htMimes.put("tiff", "image/tiff");
		htMimes.put("tif", "image/tiff");
		htMimes.put("ras", "image/x-cmu-raster");
		htMimes.put("pnm", "image/x-portable-anymap");
		htMimes.put("pbm", "image/x-portable-bitmap");
		htMimes.put("pgm", "image/x-portable-graymap");
		htMimes.put("ppm", "image/x-portable-pixmap");
		htMimes.put("rgb", "image/x-rgb");
		htMimes.put("xbm", "image/x-xbitmap");
		htMimes.put("xpm", "image/x-xpixmap");
		htMimes.put("xwd", "image/x-xwindowdump");
		htMimes.put("igs", "model/iges");
		htMimes.put("iges", "model/iges");
		htMimes.put("wrl", "model/vrml");
		htMimes.put("vrml", "model/vrml");
		htMimes.put("msh", "model/mesh");
		htMimes.put("mesh", "model/mesh");
		htMimes.put("silo", "model/mesh");
		htMimes.put("css", "text/css");
		htMimes.put("html", "text/html");
		htMimes.put("htm", "text/html");
		htMimes.put("txt", "text/plain");
		htMimes.put("rtx", "text/richtext");
		htMimes.put("tsv", "text/tab-separated-values");
		htMimes.put("etx", "text/x-setext");
		htMimes.put("sgml", "text/x-sgml");
		htMimes.put("sgm", "text/x-sgml");
		htMimes.put("xml", "text/xml");
		htMimes.put("dtd", "text/xml");
		htMimes.put("mpeg", "video/mpeg");
		htMimes.put("mpg", "video/mpeg");
		htMimes.put("mpe", "video/mpeg");
		htMimes.put("qt", "video/quicktime");
		htMimes.put("mov", "video/quicktime");
		htMimes.put("avi", "video/x-msvideo");
		htMimes.put("movie", "video/x-sgi-movie");
		htMimes.put("ice", "x-conference/x-cooltalk");
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.MimeTypes JD-Core
 * Version: 0.6.0
 */