package com.cidat.proclets;

import javax.servlet.http.HttpServletRequest;

public class LoginProclet implements Proclet {
	String realm;
	String loginValName;
	String passwordValName;
	Proclet getPasswordProclet;
	String password2ValName;
	protected final String AUTHOR_HEADER_INI = "basic ";

	static final char[] b2c = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
			'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V',
			'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
			'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
			'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8',
			'9', '+', '/' };
	static final char pad = '=';
	static byte[] c2b = null;

	public LoginProclet(String realm, String loginValName,
			String passwordValName, Proclet getPassword, String password2ValName) {
		this.realm = realm;
		this.loginValName = loginValName;
		this.passwordValName = passwordValName;
		this.getPasswordProclet = getPassword;
		this.password2ValName = password2ValName;
	}

	public LoginProclet(String loginValName, String passwordValName,
			Proclet getPassword, String password2ValName) {
		this.realm = "ECE";
		this.loginValName = loginValName;
		this.passwordValName = passwordValName;
		this.getPasswordProclet = getPassword;
		this.password2ValName = password2ValName;
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String login = null;
		String password = null;

		String[] loginInfo = new String[2];
		loginInfo[1] = null;
		loginInfo[0] = null;
		getLoginInfo(sd.req, loginInfo);
		login = loginInfo[0];
		password = loginInfo[1];

		if ((login == null) || (password == null)) {
			sd.res.setHeader("WWW-Authenticate", "basic realm=\"" + this.realm
					+ "\"");
			sd.res.setStatus(401);
			throw new ProcletException(sd, "noLogin", "true");
		}

		sd.setVal(this.loginValName, login);
		sd.setVal(this.passwordValName, password);
		try {
			if (this.getPasswordProclet != null)
				this.getPasswordProclet.process(sd);
		} catch (ProcletException e) {
			sd.res.setHeader("WWW-Authenticate", "basic realm=\"" + this.realm
					+ "\"");
			sd.res.setStatus(401);
			throw e;
		}

		String password2 = sd.gS(this.password2ValName);
		if (!password.equals(password2)) {
			sd.res.setHeader("WWW-Authenticate", "basic realm=\"" + this.realm
					+ "\"");
			sd.res.setStatus(401);
			throw new ProcletException(sd, "noLogin", "true");
		}
	}

	protected void getLoginInfo(HttpServletRequest req, String[] loginInfo) {
		String header = req.getHeader("Authorization");
		if ((header == null)
				|| (header.length() < "basic ".length())
				|| (!"basic ".equalsIgnoreCase(header.substring(0,
						"basic ".length())))) {
			return;
		}
		String toDecode = header.substring("basic ".length());
		String decoded = decode(toDecode);
		int sep = decoded.indexOf(':');
		if (sep < 0)
			return;
		loginInfo[0] = decoded.substring(0, sep);
		loginInfo[1] = decoded.substring(sep + 1);
	}

	public static String decode(String s) {
		if (c2b == null) {
			c2b = new byte[256];
			for (byte b = 0; b < 64; b = (byte) (b + 1))
				c2b[(byte) b2c[b]] = b;
		}

		byte[] nibble = new byte[4];
		char[] decode = new char[s.length()];
		int d = 0;
		int n = 0;

		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			nibble[n] = c2b[c];

			if (c == '=')
				break;
			byte b;
			switch (n) {
			case 0:
				n++;
				break;
			case 1:
				b = (byte) (nibble[0] * 4 + nibble[1] / 16);
				decode[(d++)] = (char) b;
				n++;
				break;
			case 2:
				b = (byte) ((nibble[1] & 0xF) * 16 + nibble[2] / 4);
				decode[(d++)] = (char) b;
				n++;
				break;
			default:
				b = (byte) ((nibble[2] & 0x3) * 64 + nibble[3]);
				decode[(d++)] = (char) b;
				n = 0;
			}

		}

		String decoded = new String(decode, 0, d);
		return decoded;
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.LoginProclet JD-Core
 * Version: 0.6.0
 */