package com.cidat.proclets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class LogProclet implements Proclet {
	String filenameExpr;
	String logLineExpr;
	public static final String DEF_LOG_DIR = "logs";

	public LogProclet(String filenameExpr, String logLineExpr) {
		this.filenameExpr = filenameExpr;
		this.logLineExpr = logLineExpr;
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String filename = sd.evalExpr(this.filenameExpr);
		String logLine = sd.evalExpr(this.logLineExpr);
		log(sd.logFilePath, filename, logLine);
	}

	public static void log(String logFilePath, String filename, String logLine) {
		if (logFilePath == null) {
			logFilePath = "logs";
		}
		if ((!filename.startsWith(File.separator))
				&& (!filename.startsWith("/"))) {
			filename = logFilePath + File.separator + filename;
		}
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SS ");
		sdf.setTimeZone(TimeZone.getTimeZone("ECT"));

		String date = sdf.format(new Date());
		try {
			PrintWriter logFile = new PrintWriter(new FileOutputStream(
					filename, true));
			logFile.println(date + logLine);
			logFile.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.LogProclet JD-Core
 * Version: 0.6.0
 */