package com.cidat.proclets;

import javax.servlet.http.Cookie;

public class GetCookieProclet implements Proclet {
	String cookieNameExpr;
	String[] vals;
	Proclet ifCookieProclet;
	Proclet ifNoCookieProclet;

	public GetCookieProclet(String cookieNameExpr, String vals,
			Proclet ifCookieProclet, Proclet ifNoCookieProclet) {
		this.cookieNameExpr = cookieNameExpr;
		this.vals = ProcletServiceData.valListToArr(vals);
		this.ifCookieProclet = ifCookieProclet;
		this.ifNoCookieProclet = ifNoCookieProclet;
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String cookieName = sd.evalExpr(this.cookieNameExpr);
		Cookie[] cookies = sd.req.getCookies();
		int n = 0;
		for (n = 0; n < cookies.length; n++) {
			if (cookies[n].getName().equals(cookieName)) {
				break;
			}
		}
		if (n >= cookies.length) {
			if (this.ifNoCookieProclet != null)
				this.ifNoCookieProclet.process(sd);
			return;
		}

		String[] values = null;
		if (n < cookies.length) {
			values = ProcletServiceData
					.valListToArr(cookies[n].getValue(), "-");
		}
		if ((n >= cookies.length) || (values.length != this.vals.length)) {
			if (this.ifNoCookieProclet != null)
				this.ifNoCookieProclet.process(sd);
			return;
		}

		for (n = 0; n < values.length; n++) {
			sd.setVal(sd.evalExpr(this.vals[n]), values[n]);
		}
		if (this.ifCookieProclet != null)
			this.ifCookieProclet.process(sd);
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.GetCookieProclet
 * JD-Core Version: 0.6.0
 */