package com.cidat.proclets;

import gnu.regexp.RE;
import gnu.regexp.REException;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public class DownloadProclet implements Proclet {
	String pathFichExpr;
	String nameExpr;
	String saveWindowExpr;
	String strContentTypeExpr;
	RE securityCheck = null;

	public DownloadProclet(String pathFichExpr, String nameExpr) {
		try {
			this.securityCheck = new RE("[\\\\/]\\.(\\.)+[\\\\/]");
		} catch (REException e) {
			this.securityCheck = null;
			System.out.println("Error instanciando securityCheck: "
					+ e.toString());
		}

		this.pathFichExpr = pathFichExpr;
		this.nameExpr = (nameExpr != null ? nameExpr : "");
		this.saveWindowExpr = "1";
		this.strContentTypeExpr = "application/octect-stream";
	}

	public DownloadProclet(String pathFichExpr, String nameExpr,
			String saveWindowExpr, String mimeTypeExpr) {
		try {
			this.securityCheck = new RE("[\\\\/]\\.(\\.)+[\\\\/]");
		} catch (REException e) {
			this.securityCheck = null;
			System.out.println("Error instanciando securityCheck: "
					+ e.toString());
		}

		this.pathFichExpr = pathFichExpr;
		this.nameExpr = (nameExpr != null ? nameExpr : "");
		this.saveWindowExpr = saveWindowExpr;

		this.strContentTypeExpr = mimeTypeExpr;
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String pathFich = sd.evalExpr(this.pathFichExpr);
		if ((this.securityCheck == null)
				|| (this.securityCheck.getMatch(pathFich) != null)) {
			throw ((sd.templatePageExpr != null)
					&& (sd.templatePageExpr.length() > 0) ? new ProcletException(
					sd, "error", "security") : new ProcletException(sd,
					"Fichero no encontrado"));
		}

		try {
			FileInputStream obj = new FileInputStream(pathFich);
			OutputStream out = new BufferedOutputStream(
					sd.res.getOutputStream());

			sd.templatePageExpr = null;

			String name = sd.evalExpr(this.nameExpr);
			String strContentType = this.strContentTypeExpr == null ? MimeTypes
					.getMime(name) : sd.evalExpr(this.strContentTypeExpr);

			sd.res.setContentType(sd.evalExpr(strContentType));
			String contentDisposition = sd.evalExpr(this.saveWindowExpr)
					.equals("1") ? "attachment" : "inline";
			sd.res.setHeader("Content-Disposition", contentDisposition
					+ "; filename=" + sd.evalExpr(this.nameExpr));

			sd.res.setHeader("Expires", "0");

			byte[] datos = new byte[1024];
			int cant;
			while ((cant = obj.read(datos)) != -1) {
				int i = 0;
				out.write(datos, 0, i);
			}
			out.close();
			obj.close();
		} catch (FileNotFoundException f) {
			throw ((sd.templatePageExpr != null)
					&& (sd.templatePageExpr.length() > 0) ? new ProcletException(
					sd, "error", "file_not_found") : new ProcletException(sd,
					"Fichero no encontrado"));
		} catch (Exception ioe) {
			new LogProclet("logs/downloadproclet.txt",
					"Error en download de fichero " + pathFich).process(sd);
			throw new ProcletException(sd, "error", "download");
		}
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.DownloadProclet
 * JD-Core Version: 0.6.0
 */