package com.cidat.proclets;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

public class CallProclet implements Proclet {
	String procletNameExpr;

	public CallProclet(String procletPathExpr) {
		this.procletNameExpr = procletPathExpr;
	}

	public void process(ProcletServiceData sd) throws ProcletException {
		String procletName = sd.getAbsoluteUrlPath(sd
				.evalExpr(this.procletNameExpr));
		try {
			sd.nCallLevel += 1;
			RequestDispatcher rd = sd.servletConfig.getServletContext()
					.getRequestDispatcher(procletName);
			if (rd == null) {
				throw new ProcletException(sd,
						"CallProclet: No se ha podido redirigir a \""
								+ procletName + "\". Página no encontrada.");
			}
			rd.include(sd.req, sd.res);
		} catch (IOException ioe) {
			throw new ProcletException(sd, "error", "CallProclet:: "
					+ ioe.getMessage());
		} catch (ServletException se) {
			throw new ProcletException(sd, "error", "CallProclet:: "
					+ se.getMessage());
		} finally {
			sd.nCallLevel -= 1;
		}
		if (sd.forwardException == null) {
			return;
		}
		if ((sd.forwardException != null)
				&& ((sd.forwardException instanceof ProcletException))) {
			throw ((ProcletException) sd.forwardException);
		}
		throw new ProcletException(sd, "CallProclet:: [" + procletName + "] "
				+ sd.forwardException.toString());
	}
}

/*
 * Location:
 * D:\svn\ejie\q53.trunk\codigo\q53\q53ItourbaskWar\WebContent\WEB-INF\
 * lib\proclets_wl81.jar Qualified Name: com.cidat.proclets.CallProclet JD-Core
 * Version: 0.6.0
 */