/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

class RETokenPOSIX
extends REToken {
    int m_type;
    boolean m_insens;
    boolean m_negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;

    RETokenPOSIX(int n, boolean bl, boolean bl2) {
        this.m_type = n;
        this.m_insens = bl;
        this.m_negated = bl2;
    }

    int match(CharIndexed charIndexed, int n, int n2, REMatch rEMatch) {
        char c = charIndexed.charAt(n);
        if (c == '\uffff') {
            return -1;
        }
        boolean bl = false;
        switch (this.m_type) {
            case 0: {
                bl = Character.isLetterOrDigit(c);
                break;
            }
            case 1: {
                bl = Character.isLetter(c);
                break;
            }
            case 2: {
                bl = c == ' ' || c == '\t';
                break;
            }
            case 3: {
                bl = Character.isISOControl(c);
                break;
            }
            case 4: {
                bl = Character.isDigit(c);
                break;
            }
            case 5: {
                bl = !Character.isWhitespace(c) && !Character.isISOControl(c);
                break;
            }
            case 6: {
                bl = this.m_insens && Character.isLetter(c) || Character.isLowerCase(c);
                break;
            }
            case 7: {
                bl = Character.isLetterOrDigit(c);
                break;
            }
            case 8: {
                bl = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(c) != -1;
                break;
            }
            case 9: {
                bl = Character.isWhitespace(c);
                break;
            }
            case 10: {
                bl = this.m_insens && Character.isLetter(c) || Character.isUpperCase(c);
                break;
            }
            case 11: {
                boolean bl2 = bl = Character.isDigit(c) || "abcdefABCDEF".indexOf(c) != -1;
            }
        }
        if (this.m_negated) {
            boolean bl3 = bl = !bl;
        }
        if (bl) {
            return this.next(charIndexed, n + 1, n2, rEMatch);
        }
        return -1;
    }

    public String toString() {
        String string = "[" + (this.m_negated ? "^" : "") + ":";
        switch (this.m_type) {
            case 0: {
                string = String.valueOf(string) + "alnum";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "alpha";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "blank";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "cntrl";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "digit";
                break;
            }
            case 5: {
                string = String.valueOf(string) + "graph";
                break;
            }
            case 6: {
                string = String.valueOf(string) + "lower";
                break;
            }
            case 7: {
                string = String.valueOf(string) + "print";
                break;
            }
            case 8: {
                string = String.valueOf(string) + "punct";
                break;
            }
            case 9: {
                string = String.valueOf(string) + "space";
                break;
            }
            case 10: {
                string = String.valueOf(string) + "upper";
                break;
            }
            case 11: {
                string = String.valueOf(string) + "xdigit";
                break;
            }
            default: {
                string = String.valueOf(string) + "unknown";
            }
        }
        return String.valueOf(string) + ":]";
    }
}

