/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import gnu.regexp.RETokenStingifiable;
import gnu.regexp.RETokenSubMarker;
import java.io.InputStream;
import java.util.Vector;

public class RE
extends REToken {
    private static final String version = "1.0.3";
    private REToken firstToken;
    private REToken lastToken;
    private Vector branches;
    private int numSubs;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;

    public static final String version() {
        return version;
    }

    public RE(Object object) throws REException {
        this(object, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n) throws REException {
        this(object, n, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n, RESyntax rESyntax) throws REException {
        this(object, n, rESyntax, 0, 0);
    }

    private RE(REToken rEToken, REToken rEToken2, int n) {
        this.firstToken = rEToken;
        this.lastToken = rEToken2;
        this.numSubs = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RE(Object object, int n, RESyntax rESyntax, int n2, int n3) throws REException {
        char[] cArray;
        if (object instanceof String) {
            cArray = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            cArray = (char[])object;
        } else {
            if (!(object instanceof StringBuffer)) throw new IllegalArgumentException("Invalid class for pattern");
            cArray = new char[((StringBuffer)object).length()];
            ((StringBuffer)object).getChars(0, cArray.length, cArray, 0);
        }
        int n4 = n3;
        this.numSubs = 0;
        this.setLevel(n2);
        this.lastToken = null;
        this.firstToken = null;
        boolean bl = (n & 2) > 0;
        int n5 = 0;
        CharUnit charUnit = new CharUnit();
        IntPair intPair = new IntPair();
        REToken rEToken = null;
        while (n5 < cArray.length) {
            Object object2;
            int n6;
            int n7;
            n5 = RE.getCharUnit(cArray, n5, charUnit);
            if ((charUnit.ch == '|' && rESyntax.get(14) ^ charUnit.bk || rESyntax.get(10) && charUnit.ch == '\n' && !charUnit.bk) && !rESyntax.get(9)) {
                if (this.branches == null) {
                    this.branches = new Vector();
                }
                this.addToken(rEToken);
                this.branches.addElement(new RE(this.firstToken, this.lastToken, this.numSubs));
                rEToken = null;
                this.lastToken = null;
                this.firstToken = null;
                continue;
            }
            if (charUnit.ch == '{' && rESyntax.get(8) && rESyntax.get(11) ^ charUnit.bk) {
                if (rEToken == null) {
                    throw new REException("{ without preceding token", 3, n5);
                }
                n5 = this.getMinMax(cArray, n5, intPair, rESyntax);
                rEToken = this.setRepeated(rEToken, intPair.first, intPair.second, n5);
                continue;
            }
            if (charUnit.ch == '[' && !charUnit.bk) {
                Vector<REToken> vector = new Vector<REToken>();
                if (n5 == cArray.length) {
                    throw new REException("unmatched [", 4, n5);
                }
                int n8 = cArray[n5];
                int n9 = n7 = n8 != 94 ? 0 : 1;
                if (n7 != 0) {
                    n8 = cArray[++n5];
                }
                n6 = 0;
                if (n8 == 93 || n8 == 45) {
                    n6 = n8;
                    ++n5;
                }
                while ((n8 = cArray[n5]) != 93) {
                    if (n8 == 45) {
                        if (n6 == 0) throw new REException("- indeterminate", 5, n5);
                        n8 = cArray[++n5];
                        vector.addElement(new RETokenRange((char)n6, (char)n8, bl));
                        n6 = 0;
                    } else if (n8 == 92 && rESyntax.get(0)) {
                        n8 = cArray[++n5];
                        if (n6 != 0) {
                            vector.addElement(new RETokenChar((char)n6, bl));
                        }
                        n6 = n8;
                    } else if (n8 == 91) {
                        if (rESyntax.get(2) && cArray[n5 + '\u0001'] == ':') {
                            StringBuffer stringBuffer = new StringBuffer();
                            n5 = RE.getPosixSet(cArray, n5 + 2, stringBuffer);
                            object2 = stringBuffer.toString();
                            if (((String)object2).equals("alnum")) {
                                vector.addElement(new RETokenPOSIX(0, bl, false));
                            } else if (((String)object2).equals("alpha")) {
                                vector.addElement(new RETokenPOSIX(1, bl, false));
                            } else if (((String)object2).equals("blank")) {
                                vector.addElement(new RETokenPOSIX(2, bl, false));
                            } else if (((String)object2).equals("cntrl")) {
                                vector.addElement(new RETokenPOSIX(3, bl, false));
                            } else if (((String)object2).equals("digit")) {
                                vector.addElement(new RETokenPOSIX(4, bl, false));
                            } else if (((String)object2).equals("graph")) {
                                vector.addElement(new RETokenPOSIX(5, bl, false));
                            } else if (((String)object2).equals("lower")) {
                                vector.addElement(new RETokenPOSIX(6, bl, false));
                            } else if (((String)object2).equals("print")) {
                                vector.addElement(new RETokenPOSIX(7, bl, false));
                            } else if (((String)object2).equals("punct")) {
                                vector.addElement(new RETokenPOSIX(8, bl, false));
                            } else if (((String)object2).equals("space")) {
                                vector.addElement(new RETokenPOSIX(9, bl, false));
                            } else if (((String)object2).equals("upper")) {
                                vector.addElement(new RETokenPOSIX(10, bl, false));
                            } else if (((String)object2).equals("xdigit")) {
                                vector.addElement(new RETokenPOSIX(11, bl, false));
                            }
                        }
                    } else {
                        if (n6 != 0) {
                            vector.addElement(new RETokenChar((char)n6, bl));
                        }
                        n6 = n8;
                    }
                    ++n5;
                }
                ++n5;
                if (n6 != 0) {
                    vector.addElement(new RETokenChar((char)n6, bl));
                }
                this.addToken(rEToken);
                vector.trimToSize();
                rEToken = new RETokenOneOf(vector, n7 != 0);
                continue;
            }
            if (charUnit.ch == '(' && rESyntax.get(12) ^ charUnit.bk) {
                boolean bl2;
                boolean bl3 = bl2 = n5 + 1 < cArray.length && cArray[n5] == '?' && cArray[n5 + 1] == ':';
                if (bl2) {
                    n5 += 2;
                }
                n7 = n5;
                n6 = n5;
                int n10 = 0;
                while (!((n6 = RE.getCharUnit(cArray, n7, charUnit)) <= 0 || n10 == 0 && charUnit.ch == ')' && rESyntax.get(12) ^ charUnit.bk)) {
                    n7 = n6;
                    if (n7 >= cArray.length) {
                        throw new REException("no end of subexpression", 8, n5 - 1);
                    }
                    if (charUnit.ch == '(' && rESyntax.get(12) ^ charUnit.bk) {
                        ++n10;
                        continue;
                    }
                    if (charUnit.ch != ')' || !(rESyntax.get(12) ^ charUnit.bk)) continue;
                    --n10;
                }
                this.addToken(rEToken);
                rEToken = null;
                if (!bl2) {
                    ++n4;
                    ++this.numSubs;
                }
                object2 = new RE(String.valueOf(cArray, n5, n7 - n5).toCharArray(), n, rESyntax, this.level() + 1, n4);
                this.numSubs += ((RE)object2).numSubs;
                n5 = n6;
                if (n5 == cArray.length) {
                    this.addToken(new RETokenSubMarker((RE)object2, n4, 1, 1));
                } else {
                    n6 = RE.getCharUnit(cArray, n5, charUnit);
                    if (charUnit.ch == '{' && rESyntax.get(8) && rESyntax.get(11) ^ charUnit.bk) {
                        n5 = this.getMinMax(cArray, n6, intPair, rESyntax);
                        rEToken = new RETokenSubMarker((RE)object2, n4, intPair.first, intPair.second);
                    } else if (charUnit.ch == '*' && !charUnit.bk) {
                        rEToken = new RETokenSubMarker((RE)object2, n4, 0, Integer.MAX_VALUE);
                        n5 = n6;
                    } else if (charUnit.ch == '+' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                        rEToken = new RETokenSubMarker((RE)object2, n4, 1, Integer.MAX_VALUE);
                        n5 = n6;
                    } else if (charUnit.ch == '?' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                        rEToken = new RETokenSubMarker((RE)object2, n4, 0, 1);
                        n5 = n6;
                    } else {
                        this.addToken(new RETokenSubMarker((RE)object2, n4, 1, 1));
                    }
                }
                n4 += ((RE)object2).numSubs;
                continue;
            }
            if (!rESyntax.get(16) && charUnit.ch == ')' && rESyntax.get(12) ^ charUnit.bk) {
                throw new REException("unmatched right paren", 7, n5);
            }
            if (charUnit.ch == '^' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenStart((n & 8) > 0));
                continue;
            }
            if (charUnit.ch == '$' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = null;
                this.addToken(new RETokenEnd((n & 8) > 0));
                continue;
            }
            if (charUnit.ch == '.' && !charUnit.bk) {
                this.addToken(rEToken);
                rEToken = new RETokenAny(rESyntax.get(6) || (n & 4) > 0, rESyntax.get(7));
                continue;
            }
            if (charUnit.ch == '*' && !charUnit.bk) {
                rEToken = this.setRepeated(rEToken, 0, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '+' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                rEToken = this.setRepeated(rEToken, 1, Integer.MAX_VALUE, n5);
                continue;
            }
            if (charUnit.ch == '?' && !rESyntax.get(9) && !rESyntax.get(1) ^ charUnit.bk) {
                if (rEToken == null) {
                    throw new REException("? without preceding token", 1, n5);
                }
                if (rEToken instanceof RETokenStingifiable && rESyntax.get(18)) {
                    ((RETokenStingifiable)rEToken).makeStingy();
                    continue;
                }
                rEToken = this.setRepeated(rEToken, 0, 1, n5);
                continue;
            }
            if (charUnit.bk && Character.isDigit(charUnit.ch) && !rESyntax.get(13)) {
                this.addToken(rEToken);
                rEToken = new RETokenBackRef(Character.digit(charUnit.ch, 10), bl);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'A' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenStart(false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'd' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(4, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'D' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(4, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'n') {
                this.addToken(rEToken);
                rEToken = new RETokenChar('\n', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'r') {
                this.addToken(rEToken);
                rEToken = new RETokenChar('\r', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 's' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(9, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'S' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(9, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 't') {
                this.addToken(rEToken);
                rEToken = new RETokenChar('\t', false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'w' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(0, bl, false);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'W' && rESyntax.get(19)) {
                this.addToken(rEToken);
                rEToken = new RETokenPOSIX(0, bl, true);
                continue;
            }
            if (charUnit.bk && charUnit.ch == 'Z' && rESyntax.get(22)) {
                this.addToken(rEToken);
                rEToken = new RETokenEnd(false);
                continue;
            }
            this.addToken(rEToken);
            rEToken = new RETokenChar(charUnit.ch, bl);
        }
        this.addToken(rEToken);
        if (this.branches == null) return;
        this.branches.addElement(new RE(this.firstToken, this.lastToken, this.numSubs));
        rEToken = null;
        this.lastToken = null;
        this.firstToken = null;
        this.branches.trimToSize();
    }

    private static int getCharUnit(char[] cArray, int n, CharUnit charUnit) throws REException {
        charUnit.ch = cArray[n++];
        charUnit.bk = charUnit.ch == '\\';
        if (charUnit.bk) {
            if (n < cArray.length) {
                charUnit.ch = cArray[n++];
            } else {
                throw new REException("\\ at end of pattern.", 10, n);
            }
        }
        return n;
    }

    public boolean isMatch(Object object) {
        return this.isMatch(object, 0, 0);
    }

    public boolean isMatch(Object object, int n) {
        return this.isMatch(object, n, 0);
    }

    public boolean isMatch(Object object, int n, int n2) {
        return this.isMatchImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private boolean isMatchImpl(CharIndexed charIndexed, int n, int n2) {
        if (this.branches != null) {
            int n3 = 0;
            while (n3 < this.branches.size()) {
                if (((RE)this.branches.elementAt(n3)).isMatchImpl(charIndexed, 0, n2)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        int n4 = this.firstToken.match(charIndexed, 0, n2, new REMatch(this.numSubs, n));
        return n4 != -1 && charIndexed.charAt(n4) == '\uffff';
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public REMatch[] getAllMatches(Object object) {
        return this.getAllMatches(object, 0, 0);
    }

    public REMatch[] getAllMatches(Object object, int n) {
        return this.getAllMatches(object, n, 0);
    }

    public REMatch[] getAllMatches(Object object, int n, int n2) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private REMatch[] getAllMatchesImpl(CharIndexed charIndexed, int n, int n2) {
        Vector<REMatch> vector = new Vector<REMatch>();
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, null)) != null) {
            vector.addElement(rEMatch);
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                ++n;
                charIndexed.move(1);
                continue;
            }
            charIndexed.move(rEMatch.end[0]);
        }
        Object[] objectArray = new REMatch[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int match(CharIndexed charIndexed, int n, int n2, REMatch rEMatch) {
        if (this.branches != null) {
            int n3 = 0;
            while (n3 < this.branches.size()) {
                int n4 = ((REToken)this.branches.elementAt(n3)).match(charIndexed, n, n2, rEMatch);
                if (n4 != -1) {
                    return n4;
                }
                ++n3;
            }
            return -1;
        }
        return this.firstToken.match(charIndexed, n, n2, rEMatch);
    }

    public REMatch getMatch(Object object) {
        return this.getMatch(object, 0, 0);
    }

    public REMatch getMatch(Object object, int n) {
        return this.getMatch(object, n, 0);
    }

    public REMatch getMatch(Object object, int n, int n2) {
        return this.getMatch(object, n, n2, null);
    }

    public REMatch getMatch(Object object, int n, int n2, StringBuffer stringBuffer) {
        CharIndexed charIndexed = RE.makeCharIndexed(object, n);
        return this.getMatchImpl(charIndexed, n, n2, stringBuffer);
    }

    REMatch getMatchImpl(CharIndexed charIndexed, int n, int n2, StringBuffer stringBuffer) {
        if (!charIndexed.isValid()) {
            return null;
        }
        REMatch rEMatch = new REMatch(this.numSubs, n);
        do {
            if ((rEMatch.end[0] = this.match(charIndexed, 0, n2, rEMatch)) != -1) {
                rEMatch.finish(charIndexed);
                return rEMatch;
            }
            rEMatch.clear(++n);
            if (stringBuffer == null) continue;
            stringBuffer.append(charIndexed.charAt(0));
        } while (charIndexed.move(1));
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object object) {
        return this.getMatchEnumeration(object, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n) {
        return this.getMatchEnumeration(object, n, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n, int n2) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(object, n), n, n2);
    }

    public String substitute(Object object, String string) {
        return this.substitute(object, string, 0, 0);
    }

    public String substitute(Object object, String string, int n) {
        return this.substitute(object, string, n, 0);
    }

    public String substitute(Object object, String string, int n, int n2) {
        return this.substituteImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteImpl(CharIndexed charIndexed, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        REMatch rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer);
        if (rEMatch == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(rEMatch.substituteInto(string));
        if (charIndexed.move(rEMatch.end[0])) {
            do {
                stringBuffer.append(charIndexed.charAt(0));
            } while (charIndexed.move(1));
        }
        return stringBuffer.toString();
    }

    public String substituteAll(Object object, String string) {
        return this.substituteAll(object, string, 0, 0);
    }

    public String substituteAll(Object object, String string, int n) {
        return this.substituteAll(object, string, n, 0);
    }

    public String substituteAll(Object object, String string, int n, int n2) {
        return this.substituteAllImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private String substituteAllImpl(CharIndexed charIndexed, String string, int n, int n2) {
        REMatch rEMatch;
        StringBuffer stringBuffer = new StringBuffer();
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer)) != null) {
            stringBuffer.append(rEMatch.substituteInto(string));
            n = rEMatch.getEndIndex();
            charIndexed.move(rEMatch.end[0] > 0 ? rEMatch.end[0] : 1);
        }
        return stringBuffer.toString();
    }

    private void addToken(REToken rEToken) {
        if (rEToken == null) {
            return;
        }
        rEToken.setLevel(this.level());
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
            return;
        }
        if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    void addLoop(REToken rEToken) {
        if (this.branches != null) {
            int n = 0;
            while (n < this.branches.size()) {
                ((RE)this.branches.elementAt(n)).addLoop(rEToken);
                ++n;
            }
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
            return;
        }
        if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    REToken setRepeated(REToken rEToken, int n, int n2, int n3) throws REException {
        if (rEToken == null) {
            throw new REException("repeat preceding token", 1, n3);
        }
        rEToken.setLevel(this.level());
        return new RETokenRepeated(rEToken, n, n2);
    }

    private static int getPosixSet(char[] cArray, int n, StringBuffer stringBuffer) {
        int n2 = n;
        while (n2 < cArray.length - 1) {
            if (cArray[n2] == ':' && cArray[n2 + 1] == ']') {
                return n2 + 1;
            }
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        return n;
    }

    private int getMinMax(char[] cArray, int n, IntPair intPair, RESyntax rESyntax) throws REException {
        if (n == cArray.length) {
            throw new REException("no matching brace", 3, n);
        }
        int n2 = 0;
        CharUnit charUnit = new CharUnit();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
            stringBuffer.append(charUnit.ch);
        }
        if (stringBuffer.length() == 0) {
            throw new REException("bad brace construct", 3, n);
        }
        int n3 = Integer.parseInt(stringBuffer.toString());
        if (charUnit.ch == '}' && rESyntax.get(11) ^ charUnit.bk) {
            n2 = n3;
        } else if (charUnit.ch == ',' && !charUnit.bk) {
            stringBuffer = new StringBuffer();
            while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
                stringBuffer.append(charUnit.ch);
            }
            if (charUnit.ch != '}' || !(rESyntax.get(11) ^ charUnit.bk)) {
                throw new REException("expected end of interval", 3, n);
            }
            n2 = stringBuffer.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(stringBuffer.toString());
        } else {
            throw new REException("invalid character in brace expression", 3, n);
        }
        intPair.first = n3;
        intPair.second = n2;
        return n;
    }

    public String toString() {
        String string = new String();
        if (this.branches == null) {
            if (this.level() == 0) {
                string = String.valueOf(string) + this.indentLine();
            }
            string = String.valueOf(string) + this.firstToken.toList();
        } else {
            string = String.valueOf(string) + this.indentLine() + "(";
            int n = 0;
            while (n < this.branches.size()) {
                if (n > 0) {
                    string = String.valueOf(string) + this.indentLine() + "| ";
                }
                string = String.valueOf(string) + ((RE)this.branches.elementAt(n)).toList();
                ++n;
            }
            string = String.valueOf(string) + this.indentLine() + ")";
        }
        return string;
    }

    boolean grouped() {
        return true;
    }

    private static CharIndexed makeCharIndexed(Object object, int n) {
        if (object instanceof String) {
            return new CharIndexedString((String)object, n);
        }
        if (object instanceof char[]) {
            return new CharIndexedCharArray((char[])object, n);
        }
        if (object instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)object, n);
        }
        if (object instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)object, n);
        }
        throw new IllegalArgumentException("Invalid class for input text");
    }

    private class IntPair {
        public int first;
        public int second;

        public IntPair() {
            RE.this = RE.this;
        }
    }

    private class CharUnit {
        public char ch;
        public boolean bk;

        CharUnit() {
            RE.this = RE.this;
        }
    }
}

