/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CharIndexedInputStream
implements CharIndexed {
    private static final int BUFFER_INCREMENT = 1024;
    private BufferedInputStream br;
    private int m_index;
    private int m_end;
    private int m_bufsize;
    private char cached;

    CharIndexedInputStream(InputStream inputStream, int n) {
        this.br = new BufferedInputStream(inputStream, 1024);
        this.m_bufsize = 1024;
        this.m_index = -1;
        this.m_end = Integer.MAX_VALUE;
        this.next();
        if (n > 0) {
            this.move(n);
        }
    }

    private boolean next() {
        if (this.m_end == 1) {
            return false;
        }
        --this.m_end;
        try {
            if (this.m_index != -1) {
                this.br.reset();
            }
            int n = this.br.read();
            this.br.mark(this.m_bufsize);
            if (n == -1) {
                this.m_end = 1;
                return false;
            }
            this.cached = (char)n;
            this.m_index = 1;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public char charAt(int n) {
        if (n == 0) {
            return this.cached;
        }
        if (n >= this.m_end) {
            return '\uffff';
        }
        if (n >= this.m_bufsize) {
            try {
                while (this.m_bufsize <= n) {
                    this.m_bufsize += 1024;
                }
                this.br.reset();
                this.br.mark(this.m_bufsize);
                this.br.skip(n - 1);
            }
            catch (IOException iOException) {}
        } else if (this.m_index != n) {
            try {
                this.br.reset();
                this.br.skip(n - 1);
            }
            catch (IOException iOException) {}
        }
        char c = '\uffff';
        try {
            int n2 = this.br.read();
            this.m_index = n + 1;
            if (n2 == -1) {
                this.m_end = n;
                return c;
            }
            c = (char)n2;
        }
        catch (IOException iOException) {}
        return c;
    }

    public boolean move(int n) {
        boolean bl = true;
        while (bl && n-- > 0) {
            bl = this.next();
        }
        return bl;
    }

    public boolean isValid() {
        return this.cached != '\uffff';
    }
}

