/*
 * Decompiled with CFR 0.152.
 */
package xmlext.xml;

import com.bea.compiler.feature.IStructureFeature;
import com.bea.language.ILangToken;
import com.bea.language.feature.ILangFeature;
import com.bea.language.feature.ILangStructureFeature;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlObject;
import com.bea.xml.streamImpl.JavelinAnnotation;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import xmlext.xml.XmlParseNode;
import xmlext.xmlstruct.XmlStructure;

public class XmlStructureFeature
implements ILangStructureFeature {
    private static final int INDENT_SIZE = 4;
    private static final String INDENT_STRING = "    ";
    private static final ThreadLocal _threadLocalEltCache;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$xmlext$xml$XmlStructureFeature;
    static /* synthetic */ Class class$com$bea$xml$streamImpl$JavelinAnnotation;

    private static boolean isWhitespace(String chars) {
        int i = 0;
        while (i < chars.length()) {
            switch (chars.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static String findPriorCommentText(XmlCursor cur) {
        cur = cur.newCursor();
        while (cur.toPrevToken() != XmlCursor.TokenType.COMMENT) {
            if (cur.currentTokenType() == XmlCursor.TokenType.TEXT && XmlStructureFeature.isWhitespace(cur.getChars()) && cur.hasPrevToken()) continue;
            return null;
        }
        return cur.getTextValue();
    }

    /*
     * Unable to fully structure code
     */
    public IStructureFeature.IStructureNode createStructure(IStructureFeature.IStructureBuilder builder) {
        obj = (XmlObject)ILangFeature.Context.get().getParseTree();
        cur = obj.newCursor();
        parent = builder.createNode((IStructureFeature.StructureCode)XmlStructure.DOCUMENT, (Object)new XmlParseNode(cur, XmlStructure.DOCUMENT));
        if (!cur.toFirstChild()) {
            return parent;
        }
        nodestack = new Stack<IStructureFeature.IStructureNode>();
        block0: while (true) {
            child = builder.createNode((IStructureFeature.StructureCode)XmlStructure.ELEMENT, (Object)new XmlParseNode(cur, XmlStructure.ELEMENT));
            builder.setProperty(child, (IStructureFeature.StructureCode)XmlStructure.NAMEPROP, (Object)cur.getName());
            builder.setProperty(child, (IStructureFeature.StructureCode)XmlStructure.COMMENTPROP, (Object)XmlStructureFeature.findPriorCommentText(cur));
            builder.addChild(parent, child);
            nodestack.push(parent);
            parent = child;
            attrCur = cur.newCursor();
            more = attrCur.toFirstAttribute();
            while (more) {
                child = builder.createNode((IStructureFeature.StructureCode)XmlStructure.ATTRIBUTE, (Object)new XmlParseNode(attrCur, XmlStructure.ATTRIBUTE));
                builder.setProperty(child, (IStructureFeature.StructureCode)XmlStructure.NAMEPROP, (Object)attrCur.getName());
                builder.setProperty(child, (IStructureFeature.StructureCode)XmlStructure.TEXTPROP, (Object)attrCur.getTextValue());
                builder.addChild(parent, child);
                more = attrCur.toNextAttribute();
            }
            if (cur.toFirstChild()) continue;
            builder.setProperty(parent, (IStructureFeature.StructureCode)XmlStructure.TEXTPROP, (Object)cur.getTextValue());
            while (true) {
                if (nodestack.isEmpty()) {
                    return parent;
                }
                parent = (IStructureFeature.IStructureNode)nodestack.pop();
                if (!cur.toNextSibling()) ** break;
                continue block0;
                cur.toParent();
            }
            break;
        }
    }

    public IStructureFeature.Range[] getRangeInSource(IStructureFeature.IStructureNode node) {
        XmlParseNode xpn = (XmlParseNode)node.getCookie();
        if (xpn.getFirstToken() == null || xpn.getLastToken() == null) {
            return new IStructureFeature.Range[]{new IStructureFeature.Range(0, 0)};
        }
        return new IStructureFeature.Range[]{new IStructureFeature.Range(xpn.getFirstToken().getStart(), xpn.getLastToken().getEnd())};
    }

    public IStructureFeature.Range[] getRangeInSource(IStructureFeature.IStructureNode node, IStructureFeature.StructureCode propCode) {
        throw new RuntimeException("Not Yet Implemented");
    }

    public Object getSourceValue(IStructureFeature.IStructureNode node, IStructureFeature.StructureCode propCode) {
        XmlCursor cursor = ((XmlParseNode)node.getCookie()).getCursor();
        IStructureFeature.StructureCode code = node.getTypeCode();
        if (code == XmlStructure.ATTRIBUTE) {
            switch (propCode.getCode()) {
                case 6: {
                    return cursor.getTextValue();
                }
                case 5: {
                    return cursor.getName();
                }
            }
        } else if (code == XmlStructure.ELEMENT) {
            switch (propCode.getCode()) {
                case 6: {
                    cursor = cursor.newCursor();
                    if (cursor.toFirstChild()) {
                        return null;
                    }
                    return cursor.getTextValue();
                }
                case 5: {
                    return cursor.getName();
                }
                case 7: {
                    return XmlStructureFeature.findPriorCommentText(cursor);
                }
            }
            return null;
        }
        return null;
    }

    public void replaceNode(IStructureFeature.IStructureNode oldNode, IStructureFeature.IAuthorNode newNode) {
        if (!$assertionsDisabled && newNode.getTypeCode() == XmlStructure.DOCUMENT) {
            throw new AssertionError((Object)"Trying to Replace the docunment ??");
        }
        if (!$assertionsDisabled && newNode.getTypeCode() != oldNode.getTypeCode()) {
            throw new AssertionError((Object)"Trying to replace two different nodes");
        }
        if (!$assertionsDisabled && newNode.getChildren().size() != 0) {
            throw new AssertionError((Object)"Trying to replace by a complex element");
        }
        XmlParseNode old = (XmlParseNode)oldNode.getCookie();
        String oldText = ILangFeature.Context.get().getText(old.getFirstToken().getStart(), old.getLastToken().getEnd());
        boolean attribute = newNode.getTypeCode() == XmlStructure.ATTRIBUTE;
        QName qname = (QName)newNode.getProperties().get((Object)XmlStructure.NAMEPROP);
        int start = oldText.indexOf(qname.getLocalPart());
        start = oldText.indexOf(attribute ? 34 : 62, start) + 1;
        int end = oldText.indexOf(attribute ? 34 : 60, start);
        start += old.getFirstToken().getStart();
        end += old.getFirstToken().getStart();
        String value = (String)newNode.getProperties().get((Object)XmlStructure.TEXTPROP);
        if (value.trim().length() > 0) {
            value = this.format(value, attribute);
        }
        ILangFeature.Context.get().replaceText(value, start, end);
    }

    public void removeChild(IStructureFeature.IStructureNode child) {
        if (!$assertionsDisabled && child.getTypeCode() == XmlStructure.DOCUMENT) {
            throw new AssertionError((Object)"Trying to Replace the docunment ??");
        }
        XmlParseNode cookie = (XmlParseNode)child.getCookie();
        int start = cookie.getFirstToken().getStart();
        int end = cookie.getLastToken().getEnd();
        IStructureFeature.Range range = child.getTypeCode() == XmlStructure.ATTRIBUTE ? this.getAttributeRemoveRange(start, end) : this.getElementRemoveRange(start, end);
        ILangFeature.Context.get().replaceText("", range.start, range.end);
    }

    private IStructureFeature.Range getAttributeRemoveRange(int start, int end) {
        String before = ILangFeature.Context.get().getText(start - 1, start);
        String after = ILangFeature.Context.get().getText(end, end + 1);
        if (before.charAt(0) == ' ' && after.charAt(0) == ' ') {
            ++end;
        }
        return new IStructureFeature.Range(start, end);
    }

    private IStructureFeature.Range getElementRemoveRange(int start, int end) {
        ILangFeature.IContext ctx = ILangFeature.Context.get();
        int offset = ctx.toLineColumn(start).getColumn() - 1;
        String text = ctx.getText(offset = start - offset, start);
        if (XmlStructureFeature.isWhitespace(text)) {
            start = offset;
        }
        end = this.toNewLine(end);
        return new IStructureFeature.Range(start, end);
    }

    public void addChild(IStructureFeature.IStructureNode parent, IStructureFeature.IAuthorNode child) {
        String newText;
        InsertionInfo info;
        int idx;
        if (!$assertionsDisabled && child.getTypeCode() == XmlStructure.DOCUMENT) {
            throw new AssertionError((Object)"Trying to Replace the docunment ??");
        }
        if (!($assertionsDisabled || child.getTypeCode() == XmlStructure.ATTRIBUTE && parent.getTypeCode() == XmlStructure.ELEMENT || child.getTypeCode() == XmlStructure.ELEMENT && parent.getTypeCode() != XmlStructure.ATTRIBUTE)) {
            throw new AssertionError((Object)"Trying to add a child to an non-element node");
        }
        Integer index = (Integer)child.getProperties().get(IStructureFeature.IAuthorNode.INDEX);
        int n = idx = index == null ? 0 : index;
        if (child.getTypeCode() == XmlStructure.ATTRIBUTE) {
            info = this.getAttributeInsertionInfo(parent, idx);
            newText = this.buildAttribute(parent, child);
        } else {
            info = this.getElementInsertionInfo(parent, idx);
            newText = this.buildElement(parent, child, info);
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(info._prefix);
        strBuf.append(newText);
        strBuf.append(info._suffix);
        ILangFeature.Context.get().replaceText(strBuf.toString(), info._start, info._end);
    }

    private String buildAttribute(IStructureFeature.IStructureNode parent, IStructureFeature.IAuthorNode child) {
        StringBuffer strBuf = new StringBuffer();
        XmlCursor cursor = ((XmlParseNode)parent.getCookie()).getCursor();
        QName eltName = cursor.getName();
        QName attrName = (QName)child.getProperties().get((Object)XmlStructure.NAMEPROP);
        String str = attrName.getNamespaceURI();
        if (str != null && str.trim().length() > 0 && !str.equals(eltName.getNamespaceURI())) {
            str = cursor.prefixForNamespace(attrName.getNamespaceURI());
            strBuf.append(str);
            strBuf.append(":");
        }
        strBuf.append(attrName.getLocalPart());
        strBuf.append("=\"");
        str = (String)child.getProperties().get((Object)XmlStructure.TEXTPROP);
        str = this.format(str, true);
        strBuf.append(str);
        strBuf.append("\"");
        return strBuf.toString();
    }

    private InsertionInfo getAttributeInsertionInfo(IStructureFeature.IStructureNode parent, int index) {
        InsertionInfo info = new InsertionInfo();
        XmlParseNode cookie = (XmlParseNode)parent.getCookie();
        XmlCursor cursor = cookie.getCursor();
        if ((cursor = cursor.newCursor()).toFirstAttribute()) {
            if (index == 0) {
                JavelinAnnotation ann = (JavelinAnnotation)cursor.getBookmark(class$com$bea$xml$streamImpl$JavelinAnnotation == null ? (class$com$bea$xml$streamImpl$JavelinAnnotation = XmlStructureFeature.class$("com.bea.xml.streamImpl.JavelinAnnotation")) : class$com$bea$xml$streamImpl$JavelinAnnotation);
                ILangToken tk = ann.getStartToken();
                info._start = info._end = tk.getStart();
                info._prefix = "";
                info._suffix = " ";
            } else {
                int i = 1;
                while (i < index) {
                    cursor.toNextAttribute();
                    ++i;
                }
                JavelinAnnotation ann = (JavelinAnnotation)cursor.getBookmark(class$com$bea$xml$streamImpl$JavelinAnnotation == null ? (class$com$bea$xml$streamImpl$JavelinAnnotation = XmlStructureFeature.class$("com.bea.xml.streamImpl.JavelinAnnotation")) : class$com$bea$xml$streamImpl$JavelinAnnotation);
                ILangToken tk = ann.getEndToken();
                info._start = info._end = tk.getEnd();
                info._prefix = " ";
                info._suffix = "";
            }
        } else {
            cursor = cookie.getCursor();
            JavelinAnnotation ann = (JavelinAnnotation)cursor.getBookmark(class$com$bea$xml$streamImpl$JavelinAnnotation == null ? (class$com$bea$xml$streamImpl$JavelinAnnotation = XmlStructureFeature.class$("com.bea.xml.streamImpl.JavelinAnnotation")) : class$com$bea$xml$streamImpl$JavelinAnnotation);
            ILangToken tk = ann.getEndToken();
            info._start = info._end = tk.getStart();
            info._prefix = " ";
            info._suffix = "";
        }
        return info;
    }

    private String buildElement(IStructureFeature.IStructureNode parent, IStructureFeature.IAuthorNode child, InsertionInfo info) {
        XmlCursor cursor = ((XmlParseNode)parent.getCookie()).getCursor();
        StringBuffer strBuf = new StringBuffer();
        info._indent = info._indent + 4 & 0xFFFFFFFC;
        this.buildElement(strBuf, this.getIndent("", info._indent), cursor, child);
        return strBuf.toString();
    }

    private void buildElement(StringBuffer strbuf, String indent, XmlCursor cursor, IStructureFeature.IAuthorNode element) {
        String name;
        QName qname = (QName)element.getProperties().get((Object)XmlStructure.NAMEPROP);
        strbuf.append(indent);
        strbuf.append('<');
        String ns = qname.getNamespaceURI();
        if (ns != null && ns.trim().length() > 0) {
            String prefix = cursor.prefixForNamespace(ns);
            if (prefix != null && prefix.length() > 0) {
                StringBuffer bufName = new StringBuffer();
                bufName.append(prefix);
                bufName.append(':');
                bufName.append(qname.getLocalPart());
                name = bufName.toString();
            } else {
                name = qname.getLocalPart();
            }
        } else {
            name = qname.getLocalPart();
        }
        strbuf.append(name);
        this.buildAttributes(strbuf, cursor, element);
        strbuf.append('>');
        String value = (String)element.getProperties().get((Object)XmlStructure.TEXTPROP);
        if (value != null) {
            value = this.format(value, false);
            strbuf.append(value);
        } else {
            strbuf.append('\n');
            indent = this.getIndent(indent, indent.length() + 4);
            List children = element.getChildren();
            int i = 0;
            while (i < children.size()) {
                IStructureFeature.IAuthorNode node = (IStructureFeature.IAuthorNode)children.get(i);
                if (node.getTypeCode() == XmlStructure.ELEMENT) {
                    this.buildElement(strbuf, indent, cursor, node);
                }
                ++i;
            }
            indent = this.getIndent(indent, indent.length() - 4);
            strbuf.append(indent);
        }
        strbuf.append("</");
        strbuf.append(name);
        strbuf.append(">\n");
    }

    private void buildAttributes(StringBuffer strbuf, XmlCursor cursor, IStructureFeature.IAuthorNode element) {
        String ns = ((QName)element.getProperties().get((Object)XmlStructure.NAMEPROP)).getNamespaceURI();
        List children = element.getChildren();
        int i = 0;
        while (i < children.size()) {
            IStructureFeature.IAuthorNode node = (IStructureFeature.IAuthorNode)children.get(i);
            if (node.getTypeCode() == XmlStructure.ATTRIBUTE) {
                QName qname = (QName)node.getProperties().get((Object)XmlStructure.NAMEPROP);
                String str = qname.getNamespaceURI();
                strbuf.append(' ');
                str = qname.getNamespaceURI();
                if (str != null && str.trim().length() > 0 && !str.equals(ns) && (str = cursor.prefixForNamespace(qname.getNamespaceURI())) != null && str.length() > 0) {
                    strbuf.append(str);
                    strbuf.append(":");
                }
                strbuf.append(qname.getLocalPart());
                strbuf.append("=\"");
                str = (String)node.getProperties().get((Object)XmlStructure.TEXTPROP);
                str = this.format(str, true);
                strbuf.append(str);
                strbuf.append("\"");
            }
            ++i;
        }
    }

    private InsertionInfo getElementInsertionInfo(IStructureFeature.IStructureNode parent, int idx) {
        int offset;
        InsertionInfo info = new InsertionInfo();
        XmlParseNode node = (XmlParseNode)parent.getCookie();
        if (parent.getTypeCode() == XmlStructure.DOCUMENT) {
            info._start = info._end = node.getLastToken().getEnd();
            info._prefix = "\n";
            info._suffix = "";
            info._indent = 0;
            return info;
        }
        XmlCursor cursor = node.getCursor();
        JavelinAnnotation ann = (JavelinAnnotation)cursor.getBookmark(class$com$bea$xml$streamImpl$JavelinAnnotation == null ? (class$com$bea$xml$streamImpl$JavelinAnnotation = XmlStructureFeature.class$("com.bea.xml.streamImpl.JavelinAnnotation")) : class$com$bea$xml$streamImpl$JavelinAnnotation);
        ILangToken tk = ann.getStartToken();
        info._indent = ILangFeature.Context.get().toLineColumn(tk.getStart()).getColumn() - 1;
        tk = ann.getEndToken();
        if (tk.getType() == 4) {
            info._start = tk.getStart();
            info._end = tk.getEnd();
            info._prefix = ">\n";
            StringBuffer strBuf = new StringBuffer();
            String qname = ILangFeature.Context.get().getText(ann.getStartToken().getStart(), ann.getEndToken().getEnd());
            int n = info._suffix.indexOf(cursor.getName().getLocalPart());
            qname = qname.substring(tk.getStart() + 1, n);
            strBuf.append(this.getIndent("", info._indent));
            strBuf.append('<');
            strBuf.append(qname.trim());
            strBuf.append(cursor.getName().getLocalPart());
            strBuf.append("/>");
            info._suffix = strBuf.toString();
            return info;
        }
        if (idx > 0) {
            cursor = cursor.newCursor();
            cursor.toFirstChild();
            int i = 1;
            while (i < idx) {
                cursor.toNextSibling();
                ++i;
            }
            cursor.toEndToken();
        }
        ann = (JavelinAnnotation)cursor.getBookmark(class$com$bea$xml$streamImpl$JavelinAnnotation == null ? (class$com$bea$xml$streamImpl$JavelinAnnotation = XmlStructureFeature.class$("com.bea.xml.streamImpl.JavelinAnnotation")) : class$com$bea$xml$streamImpl$JavelinAnnotation);
        tk = ann.getEndToken();
        info._start = info._end = (offset = this.toNewLine(tk.getEnd()));
        info._prefix = offset == tk.getEnd() ? "\n" : "";
        info._suffix = "";
        return info;
    }

    private int toNewLine(int offset) {
        int start = offset;
        String text;
        while ((text = ILangFeature.Context.get().getText(start, start + 20)) != null) {
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                switch (text.charAt(i)) {
                    case '\n': {
                        return start + i + 1;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return offset;
                    }
                }
                ++i;
            }
            start += 20;
        }
        return offset;
    }

    private EltCache getEltCache() {
        if (_threadLocalEltCache.get() == null) {
            EltCache c = new EltCache();
            XmlObject obj = null;
            try {
                obj = XmlObject.Factory.parse("<elt></elt>");
            }
            catch (Exception e) {
                // empty catch block
            }
            c.ELT_CURSOR = obj.newCursor();
            c.ELT_CURSOR.toFirstChild();
            try {
                obj = XmlObject.Factory.parse("<elt attr=\"\" />");
            }
            catch (Exception e) {
                // empty catch block
            }
            c.ATTR_ELT_CURSOR = obj.newCursor();
            c.ATTR_ELT_CURSOR.toFirstChild();
            c.ATTR_CURSOR = c.ATTR_ELT_CURSOR.newCursor();
            c.ATTR_CURSOR.toFirstAttribute();
            _threadLocalEltCache.set(c);
        }
        return (EltCache)_threadLocalEltCache.get();
    }

    private String format(String value, boolean attribute) {
        if (value.length() == 0) {
            return value;
        }
        EltCache c = this.getEltCache();
        if (attribute) {
            c.ATTR_CURSOR.setTextValue(value);
            value = c.ATTR_ELT_CURSOR.xmlText();
        } else {
            c.ELT_CURSOR.setTextValue(value);
            value = c.ELT_CURSOR.xmlText();
        }
        int start = attribute ? value.indexOf("attr") : 0;
        start = value.indexOf(attribute ? 34 : 62, start) + 1;
        int end = value.indexOf(attribute ? 34 : 60, start);
        value = value.substring(start, end);
        return value;
    }

    private String getIndent(String indent, int size) {
        if (size == indent.length()) {
            return indent;
        }
        if (size < indent.length()) {
            return indent.substring(0, size);
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(indent);
        while (strbuf.length() < size) {
            strbuf.append(INDENT_STRING);
        }
        return strbuf.substring(0, size);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$xmlext$xml$XmlStructureFeature == null ? (class$xmlext$xml$XmlStructureFeature = XmlStructureFeature.class$("xmlext.xml.XmlStructureFeature")) : class$xmlext$xml$XmlStructureFeature).desiredAssertionStatus();
        _threadLocalEltCache = new ThreadLocal(){};
    }

    private static class InsertionInfo {
        int _start;
        int _end;
        int _indent;
        String _prefix;
        String _suffix;

        private InsertionInfo() {
        }
    }

    private static class EltCache {
        XmlCursor ELT_CURSOR;
        XmlCursor ATTR_CURSOR;
        XmlCursor ATTR_ELT_CURSOR;

        private EltCache() {
        }
    }
}

