/*
 * Decompiled with CFR 0.152.
 */
package xmlext.xml;

import com.bea.compiler.IEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workshop.util.encoding.EncodingDetector;
import workshop.util.encoding.IEncodingDetector;

public class XmlEncoder
implements IEncoding,
IEncodingDetector {
    private static Pattern XML_PATTERN = Pattern.compile("\\A\\s*<\\?\\s*xml.*?\\?\\s*>", 2);
    private static Pattern XML_ENCODING_PATTERN = Pattern.compile("\\s+encoding\\s*=\\s*['\"](.+?)['\"]", 2);
    private static final int XML_TEST_LEN = 512;
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String UTF16_BE_ENCODING = "UTF-16BE";
    private static final String UTF16_LE_ENCODING = "UTF-16LE";
    private static final String EBCDIC_ENCODING = "Cp500";
    private static final String XML_DEFAULT_ENCODING = "UTF-8";
    public static final byte[] UTF16_BE = new byte[]{0, 60, 0, 63};
    public static final byte[] UTF16_LE = new byte[]{60, 0, 63, 0};
    public static final byte[] UTF8 = new byte[]{60, 63, 120, 109};
    public static final byte[] EBCDIC = new byte[]{76, 111, -89, -108};

    public Reader getVerifiedReader(InputStream in) throws IOException, UnsupportedCharsetException {
        return EncodingDetector.getReader((IEncodingDetector)this, (InputStream)in, (boolean)true);
    }

    public Reader getReader(InputStream in) throws IOException {
        try {
            return EncodingDetector.getReader((IEncodingDetector)this, (InputStream)in, (boolean)false);
        }
        catch (UnsupportedCharsetException uce) {
            return new InputStreamReader(in, "UTF-8");
        }
    }

    public Writer getVerifiedWriter(Reader content, OutputStream out) throws IOException, UnsupportedCharsetException {
        return EncodingDetector.getWriter((IEncodingDetector)this, (Reader)content, (OutputStream)out, (boolean)true);
    }

    public Writer getWriter(Reader content, OutputStream out) throws IOException {
        try {
            return EncodingDetector.getWriter((IEncodingDetector)this, (Reader)content, (OutputStream)out, (boolean)false);
        }
        catch (UnsupportedCharsetException e) {
            return new OutputStreamWriter(out, "UTF-8");
        }
    }

    public String getDefaultEncoding() {
        return "UTF-8";
    }

    public int getPreferredHeaderSize() {
        return 512;
    }

    public String findDeclaredEncoding(String snippet) {
        String encoding = null;
        Matcher m = XML_PATTERN.matcher(snippet);
        if (m.find()) {
            encoding = "UTF-8";
            String xmlHeader = snippet.substring(m.start(), m.end());
            if ((m = XML_ENCODING_PATTERN.matcher(xmlHeader)).find()) {
                encoding = m.group(1);
            }
        }
        return encoding;
    }

    public String guessEncodingFamily(byte[] bytes) {
        String encoding = null;
        if (EncodingDetector._startsWith((byte[])bytes, (byte[])UTF8)) {
            encoding = "UTF-8";
        } else if (EncodingDetector._startsWith((byte[])bytes, (byte[])UTF16_BE)) {
            encoding = UTF16_BE_ENCODING;
        } else if (EncodingDetector._startsWith((byte[])bytes, (byte[])UTF16_LE)) {
            encoding = UTF16_LE_ENCODING;
        } else if (EncodingDetector._startsWith((byte[])bytes, (byte[])EBCDIC)) {
            encoding = EBCDIC_ENCODING;
        }
        return encoding;
    }
}

