/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1;

import com.bea.xbean.common.Levenshtein;
import com.bea.xbean.common.XmlEncodingSniffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MXParser
implements XmlPullParser {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";
    protected boolean allStringsInterned;
    private boolean _recoverFromErrors;
    private static final boolean TRACE_SIZING = false;
    private static final int FORGIVE_EXTRA_START_TAGS = 2;
    private static final int FORGIVE_EDIT_PER_CHARACTERS = 5;
    protected boolean processNamespaces;
    protected boolean roundtripSupported;
    protected int lineNumber;
    protected int columnNumber;
    protected int charNumber;
    protected boolean seenRoot;
    protected boolean reachedEnd;
    protected byte eventType;
    protected boolean emptyElementTag;
    protected int depth;
    protected char[][] elRawName;
    protected int[] elRawNameEnd;
    protected int extraend;
    boolean atEOF;
    protected String[] elName;
    protected String[] elPrefix;
    protected String[] elUri;
    protected int[] elNamespaceCount;
    protected static final int LOOKUP_MAX = 1024;
    protected static final char LOOKUP_MAX_CHAR = '\u0400';
    protected static boolean[] lookupNameStartChar;
    protected static boolean[] lookupNameChar;
    protected int attributeCount;
    protected String[] attributeName;
    protected int[] attributeNameHash;
    protected String[] attributePrefix;
    protected String[] attributeUri;
    protected String[] attributeValue;
    protected int namespaceEnd;
    protected String[] namespacePrefix;
    protected int[] namespacePrefixHash;
    protected String[] namespaceUri;
    protected int entityEnd;
    protected String[] entityName;
    protected char[][] entityNameBuf;
    protected int[] entityNameHash;
    protected char[][] entityReplacementBuf;
    protected String[] entityReplacement;
    protected boolean recoverUnclosedTags = false;
    public static final int TK_UNDEFINED = 0;
    public static final int TK_LT = 1;
    public static final int TK_GT = 2;
    public static final int TK_LTS = 3;
    public static final int TK_SGT = 4;
    public static final int TK_ELMPREFIX = 5;
    public static final int TK_ELMCOLON = 6;
    public static final int TK_ELMNAME = 7;
    public static final int TK_ATTPREFIX = 8;
    public static final int TK_ATTCOLON = 9;
    public static final int TK_ATTNAME = 10;
    public static final int TK_XMLNS = 11;
    public static final int TK_NSCOLON = 12;
    public static final int TK_NSPREFIX = 13;
    public static final int TK_SPACE = 14;
    public static final int TK_EQUAL = 15;
    public static final int TK_QUOT = 16;
    public static final int TK_ATTVALUE = 17;
    public static final int TK_NSURI = 18;
    public static final int TK_PISTART = 19;
    public static final int TK_PIVALUE = 20;
    public static final int TK_PIEND = 21;
    public static final int TK_COMMENTSTART = 22;
    public static final int TK_COMMENTVALUE = 23;
    public static final int TK_COMMENTEND = 24;
    public static final int TK_ENTITYREF = 25;
    public static final int TK_TEXT = 26;
    public static final int TK_CDATASTART = 27;
    public static final int TK_CDATATEXT = 28;
    public static final int TK_CDATAEND = 29;
    public static final int TK_DOCDECL = 30;
    public static final int TK_IGWSPAGE = 31;
    public static final int TK_NSEQUAL = 32;
    public static final int TK_NSQUOT = 33;
    public static final int TK_ERROR = 34;
    protected int tkStartOffset;
    protected int tkLastTkOffset;
    protected int[] tkLens;
    protected int tkCount;
    protected int[] tkTypes;
    protected String[] tkDiags;
    protected String errorStartTagDiag;
    protected String errorMessage;
    protected static final int READ_CHUNK_SIZE = 8192;
    protected Reader reader;
    protected String inputEncoding;
    protected int bufLoadFactor = 95;
    protected char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256];
    protected int bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
    protected int bufAbsoluteStart;
    protected int bufStart;
    protected int bufEnd;
    protected int pos;
    protected int posStart;
    protected int posEnd;
    protected char[] pc = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 64];
    protected int pcStart;
    protected int pcEnd;
    protected boolean usePC;
    protected boolean seenStartTag;
    protected boolean seenEndTag;
    protected boolean pastEndTag;
    protected boolean seenAmpersand;
    protected boolean seenMarkup;
    protected boolean tokenize;
    protected String text;
    protected String entityRefName;
    public static final String FEATURE_RECOVER_FROM_ERRORS = "http://bea.com/xml/parser#recover";
    protected boolean tokenizeEnt;
    protected char[] charRefOneCharBuf = new char[1];
    private static int debug;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$xmlpull$mxp1$MXParser;

    protected void resetStringCache() {
    }

    protected String newString(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len);
    }

    protected String newStringIntern(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len).intern();
    }

    private static final void setName(char ch) {
        MXParser.lookupNameChar[ch] = true;
    }

    private static final void setNameStart(char ch) {
        char c = ch;
        lookupNameStartChar[c] = lookupNameStartChar[c] | true;
        MXParser.setName(ch);
    }

    private static final boolean isNameStartChar(char ch) {
        return ch < '\u0400' && lookupNameStartChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    private static final boolean isNameChar(char ch) {
        return ch < '\u0400' && lookupNameChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    protected void ensureAttributesCapacity(int size) {
        int attrPosSize;
        int n = attrPosSize = this.attributeName != null ? this.attributeName.length : 0;
        if (size >= attrPosSize) {
            int newSize = size > 7 ? 2 * size : 8;
            boolean needsCopying = attrPosSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeName, 0, arr, 0, attrPosSize);
            }
            this.attributeName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributePrefix, 0, arr, 0, attrPosSize);
            }
            this.attributePrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeUri, 0, arr, 0, attrPosSize);
            }
            this.attributeUri = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeValue, 0, arr, 0, attrPosSize);
            }
            this.attributeValue = arr;
            if (!this.allStringsInterned) {
                int[] iarr = new int[newSize];
                if (needsCopying) {
                    System.arraycopy(this.attributeNameHash, 0, iarr, 0, attrPosSize);
                }
                this.attributeNameHash = iarr;
            }
            arr = null;
        }
    }

    protected void ensureNamespacesCapacity(int size) {
        int namespaceSize;
        int n = namespaceSize = this.namespacePrefix != null ? this.namespacePrefix.length : 0;
        if (size >= namespaceSize) {
            int newSize = size > 7 ? 2 * size : 8;
            String[] newNamespacePrefix = new String[newSize];
            String[] newNamespaceUri = new String[newSize];
            if (this.namespacePrefix != null) {
                System.arraycopy(this.namespacePrefix, 0, newNamespacePrefix, 0, this.namespaceEnd);
                System.arraycopy(this.namespaceUri, 0, newNamespaceUri, 0, this.namespaceEnd);
            }
            this.namespacePrefix = newNamespacePrefix;
            this.namespaceUri = newNamespaceUri;
            if (!this.allStringsInterned) {
                int[] newNamespacePrefixHash = new int[newSize];
                if (this.namespacePrefixHash != null) {
                    System.arraycopy(this.namespacePrefixHash, 0, newNamespacePrefixHash, 0, this.namespaceEnd);
                }
                this.namespacePrefixHash = newNamespacePrefixHash;
            }
        }
    }

    protected static final int fastHash(char[] ch, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int hash = ch[off];
        try {
            hash = (hash << 7) + ch[off + len - 1];
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            aie.printStackTrace();
        }
        if (len > 16) {
            hash = (hash << 7) + ch[off + len / 4];
        }
        if (len > 8) {
            hash = (hash << 7) + ch[off + len / 2];
        }
        return hash;
    }

    protected void ensureEntityCapacity() {
        int entitySize;
        int n = entitySize = this.entityReplacementBuf != null ? this.entityReplacementBuf.length : 0;
        if (this.entityEnd >= entitySize) {
            int newSize = this.entityEnd > 7 ? 2 * this.entityEnd : 8;
            String[] newEntityName = new String[newSize];
            char[][] newEntityNameBuf = new char[newSize][];
            String[] newEntityReplacement = new String[newSize];
            char[][] newEntityReplacementBuf = new char[newSize][];
            if (this.entityName != null) {
                System.arraycopy(this.entityName, 0, newEntityName, 0, this.entityEnd);
                System.arraycopy(this.entityNameBuf, 0, newEntityNameBuf, 0, this.entityEnd);
                System.arraycopy(this.entityReplacement, 0, newEntityReplacement, 0, this.entityEnd);
                System.arraycopy(this.entityReplacementBuf, 0, newEntityReplacementBuf, 0, this.entityEnd);
            }
            this.entityName = newEntityName;
            this.entityNameBuf = newEntityNameBuf;
            this.entityReplacement = newEntityReplacement;
            this.entityReplacementBuf = newEntityReplacementBuf;
            if (!this.allStringsInterned) {
                int[] newEntityNameHash = new int[newSize];
                if (this.entityNameHash != null) {
                    System.arraycopy(this.entityNameHash, 0, newEntityNameHash, 0, this.entityEnd);
                }
                this.entityNameHash = newEntityNameHash;
            }
        }
    }

    protected void ensureTokensCapacity(int size) {
        int tkPosSize;
        int n = tkPosSize = this.tkLens != null ? this.tkLens.length : 0;
        if (size >= tkPosSize - this.tkCount) {
            int newSize = tkPosSize > 7 ? 2 * tkPosSize + size : 8;
            boolean needsCopying = tkPosSize > 0;
            int[] arr = null;
            arr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.tkLens, 0, arr, 0, tkPosSize);
            }
            this.tkLens = arr;
            arr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.tkTypes, 0, arr, 0, tkPosSize);
            }
            this.tkTypes = arr;
            String[] ars = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.tkDiags, 0, ars, 0, tkPosSize);
            }
            this.tkDiags = ars;
            ars = null;
            arr = null;
        }
    }

    protected void addTk(int type) {
        this.addTk(type, 0);
    }

    protected void addTk(int type, int n) {
        int len = this.charNumber - n - this.tkLastTkOffset;
        if (len <= 0) {
            return;
        }
        this.ensureTokensCapacity(1);
        this.tkTypes[this.tkCount] = type;
        this.tkLens[this.tkCount] = len;
        ++this.tkCount;
        this.tkLastTkOffset = this.charNumber - n;
    }

    protected void addError(String diag) {
        this.addError(0, diag);
    }

    protected void addError(int n, String diag) {
        int len = this.charNumber - n - this.tkLastTkOffset;
        if (len <= 0) {
            return;
        }
        this.ensureTokensCapacity(1);
        this.tkTypes[this.tkCount] = 34;
        this.tkLens[this.tkCount] = len;
        this.tkDiags[this.tkCount] = diag;
        ++this.tkCount;
        this.tkLastTkOffset = this.charNumber - n;
    }

    protected void setError(int oldtype, int len, String diag) {
        int i = this.tkCount - 1;
        while (i > 0 && len > 0) {
            if (this.tkTypes[i] == oldtype) {
                this.tkTypes[i] = 34;
                this.tkDiags[i] = diag;
                --len;
            }
            --i;
        }
    }

    public void resetTks() {
        this.tkStartOffset = this.tkLastTkOffset;
        this.tkCount = 0;
        this.errorStartTagDiag = null;
        this.errorMessage = null;
    }

    public int getTkCount() {
        return this.tkCount;
    }

    public int[] getTkTypes() {
        return this.tkTypes;
    }

    public int[] getTkLens() {
        return this.tkLens;
    }

    public String[] getTkDiags() {
        return this.tkDiags;
    }

    public boolean hasErrorStartTag() {
        return this.errorStartTagDiag != null;
    }

    public String getErrorStartTagDiag() {
        return this.errorStartTagDiag;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void reset() {
        this.lineNumber = 1;
        this.charNumber = 0;
        this.columnNumber = 0;
        this.seenRoot = false;
        this.reachedEnd = false;
        this.eventType = 0;
        this.emptyElementTag = false;
        this.depth = 0;
        this.attributeCount = 0;
        this.namespaceEnd = 0;
        this.entityEnd = 0;
        this.recoverUnclosedTags = false;
        this.tkStartOffset = 0;
        this.tkLastTkOffset = 0;
        this.tkCount = 0;
        this.reader = null;
        this.inputEncoding = null;
        this.bufAbsoluteStart = 0;
        this.bufStart = 0;
        this.bufEnd = 0;
        this.posEnd = 0;
        this.posStart = 0;
        this.pos = 0;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        this.seenStartTag = false;
        this.seenEndTag = false;
        this.pastEndTag = false;
        this.seenAmpersand = false;
        this.seenMarkup = false;
        this.resetStringCache();
    }

    protected void ensureElementsCapacity() {
        int elStackSize;
        int n = elStackSize = this.elName != null ? this.elName.length : 0;
        if (this.depth + 1 >= elStackSize) {
            int newSize = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
            boolean needsCopying = elStackSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elName, 0, arr, 0, elStackSize);
            }
            this.elName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elPrefix, 0, arr, 0, elStackSize);
            }
            this.elPrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elUri, 0, arr, 0, elStackSize);
            }
            this.elUri = arr;
            int[] iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elNamespaceCount, 0, iarr, 0, elStackSize);
            } else {
                iarr[0] = 0;
            }
            this.elNamespaceCount = iarr;
            iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elRawNameEnd, 0, iarr, 0, elStackSize);
            }
            this.elRawNameEnd = iarr;
            char[][] carr = new char[newSize][];
            if (needsCopying) {
                System.arraycopy(this.elRawName, 0, carr, 0, elStackSize);
            }
            this.elRawName = carr;
        }
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if (name == null) {
            throw new IllegalArgumentException("feature name should not be nulll");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("namespace processing feature can only be changed before parsing", this, null);
            }
            this.processNamespaces = state;
        } else if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(name)) {
            if (state) {
                throw new XmlPullParserException("processing DOCDECL is not supported");
            }
        } else if (FEATURE_RECOVER_FROM_ERRORS.equals(name)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("namespace processing feature can only be changed before parsing", this, null);
            }
            this._recoverFromErrors = state;
        } else {
            throw new XmlPullParserException("unknown feature " + name);
        }
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("feature name should not be nulll");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            return this.processNamespaces;
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(name)) {
            return false;
        }
        if (FEATURE_RECOVER_FROM_ERRORS.equals(name)) {
            return this._recoverFromErrors;
        }
        return FEATURE_XML_ROUNDTRIP.equals(name);
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException("unsupported property: '" + name + "'");
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setInput(Reader in) throws XmlPullParserException {
        this.reset();
        this.reader = in;
    }

    public void setInput(InputStream inputStream, String requstedEncoding) throws XmlPullParserException {
        Reader reader;
        String xmlEncoding;
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream can not be null");
        }
        try {
            XmlEncodingSniffer sniffer = new XmlEncodingSniffer(inputStream, requstedEncoding);
            xmlEncoding = sniffer.getXmlEncoding();
            reader = sniffer.getReader();
        }
        catch (UnsupportedEncodingException une) {
            throw new XmlPullParserException("could not create reader for encoding " + requstedEncoding + " : " + une, this, une);
        }
        catch (IOException e) {
            throw new XmlPullParserException("could not sniff encoding for from InputStream", this, e);
        }
        this.setInput(reader);
        this.inputEncoding = xmlEncoding;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) {
        this.ensureEntityCapacity();
        this.entityName[this.entityEnd] = this.newString(entityName.toCharArray(), 0, entityName.length());
        this.entityNameBuf[this.entityEnd] = entityName.toCharArray();
        this.entityReplacement[this.entityEnd] = replacementText;
        this.entityReplacementBuf[this.entityEnd] = replacementText.toCharArray();
        if (!this.allStringsInterned) {
            this.entityNameHash[this.entityEnd] = MXParser.fastHash(this.entityNameBuf[this.entityEnd], 0, this.entityNameBuf[this.entityEnd].length);
        }
        ++this.entityEnd;
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        if (!this.processNamespaces || depth == 0) {
            return 0;
        }
        if (depth < 0 || depth > this.depth) {
            throw new IllegalArgumentException("napespace count mayt be for depth 0.." + this.depth + " not " + depth);
        }
        return this.elNamespaceCount[depth];
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        if (pos < this.namespaceEnd) {
            return this.namespacePrefix[pos];
        }
        throw new XmlPullParserException("position " + pos + " exceeded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        if (pos < this.namespaceEnd) {
            return this.namespaceUri[pos];
        }
        throw new XmlPullParserException("position " + pos + " exceedded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespace(String prefix) {
        if (prefix != null) {
            int i = this.namespaceEnd - 1;
            while (i >= 0) {
                if (prefix.equals(this.namespacePrefix[i])) {
                    return this.namespaceUri[i];
                }
                --i;
            }
            if ("xml".equals(prefix)) {
                return XML_URI;
            }
            if ("xmlns".equals(prefix)) {
                return XMLNS_URI;
            }
        } else {
            int i = this.namespaceEnd - 1;
            while (i >= 0) {
                if (this.namespacePrefix[i] == null) {
                    return this.namespaceUri[i];
                }
                --i;
            }
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void recover(byte newEventType, int newDepth) {
        this.eventType = newEventType;
        this.depth = newDepth;
    }

    private static int findFragment(int bufMinPos, char[] b, int start, int end) {
        if (start < bufMinPos) {
            start = bufMinPos;
            if (start > end) {
                start = end;
            }
            return start;
        }
        if (end - start > 55) {
            start = end - 10;
        }
        int i = start + 1;
        while (--i > bufMinPos) {
            char c;
            if (end - i > 55 || (c = b[i]) == '<' && start - i > 10) break;
        }
        return i;
    }

    public String getPositionDescription() {
        int start;
        String fragment = null;
        if (this.posStart <= this.pos && (start = MXParser.findFragment(0, this.buf, this.posStart, this.pos)) < this.pos) {
            fragment = new String(this.buf, start, this.pos - start);
            if (this.bufAbsoluteStart > 0) {
                fragment = "..." + fragment;
            }
        }
        return " " + XmlPullParser.TYPES[this.eventType] + (fragment != null ? " seen " + this.printable(fragment) + "..." : "") + " @" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getCharNumber() {
        return this.charNumber;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.eventType == 4 || this.eventType == 5) {
            if (this.usePC) {
                int i = this.pcStart;
                while (i < this.pcEnd) {
                    if (!this.isS(this.pc[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            int i = this.posStart;
            while (i < this.posEnd) {
                if (!this.isS(this.buf[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.eventType == 7) {
            return true;
        }
        throw new XmlPullParserException("no content available to read");
    }

    public String getText() {
        if (this.eventType == 0 || this.eventType == 1) {
            return null;
        }
        if (this.eventType == 6) {
            return this.text;
        }
        if (this.text == null) {
            this.text = this.usePC ? new String(this.pc, this.pcStart, this.pcEnd - this.pcStart) : new String(this.buf, this.posStart, this.posEnd - this.posStart);
        }
        return this.text;
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        if (this.eventType == 4) {
            if (this.usePC) {
                holderForStartAndLength[0] = this.pcStart;
                holderForStartAndLength[1] = this.pcEnd - this.pcStart;
                return this.pc;
            }
            holderForStartAndLength[0] = this.posStart;
            holderForStartAndLength[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 2 || this.eventType == 3 || this.eventType == 5 || this.eventType == 9 || this.eventType == 6 || this.eventType == 8 || this.eventType == 7 || this.eventType == 10) {
            holderForStartAndLength[0] = this.posStart;
            holderForStartAndLength[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 0 || this.eventType == 1) {
            holderForStartAndLength[1] = -1;
            holderForStartAndLength[0] = -1;
            return null;
        }
        throw new IllegalArgumentException("unknown text eventType: " + this.eventType);
    }

    public String getNamespace() {
        if (this.eventType == 2) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        if (this.eventType == 3) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        return null;
    }

    public String getName() {
        if (this.eventType == 2) {
            return this.elName[this.depth];
        }
        if (this.eventType == 3) {
            return this.elName[this.depth];
        }
        if (this.eventType == 6) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            return this.entityRefName;
        }
        return null;
    }

    public String getPrefix() {
        if (this.eventType == 2) {
            return this.elPrefix[this.depth];
        }
        if (this.eventType == 3) {
            return this.elPrefix[this.depth];
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to check for empty element", this, null);
        }
        return this.emptyElementTag;
    }

    public int getAttributeCount() {
        if (this.eventType != 2) {
            return -1;
        }
        return this.attributeCount;
    }

    public String getAttributeNamespace(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return "";
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeUri[index];
    }

    public String getAttributeName(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeName[index];
    }

    public String getAttributePrefix(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return null;
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributePrefix[index];
    }

    public String getAttributeType(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return false;
    }

    public String getAttributeValue(int index) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeValue[index];
    }

    public String getAttributeValue(String namespace, String name) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (this.processNamespaces) {
            int i = 0;
            while (i < this.attributeCount) {
                if (namespace == this.attributeUri[i] && name.equals(this.attributeName[i])) {
                    return this.attributeValue[i];
                }
                ++i;
            }
            return null;
        }
        int i = 0;
        while (i < this.attributeCount) {
            if (name.equals(this.attributeName[i])) {
                return this.attributeValue[i];
            }
            ++i;
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.eventType;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException(XmlPullParser.TYPES[type] + " was expected but got" + this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", this, null);
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("event TEXT it must be immediately followed by END_TAG", this, null);
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.eventType == 4 && this.isWhitespace()) {
            this.next();
        }
        if (this.eventType != 2 && this.eventType != 3) {
            throw new XmlPullParserException("expected start or end tag", this, null);
        }
        return this.eventType;
    }

    public int next() throws XmlPullParserException, IOException {
        this.tokenizeEnt = false;
        this.tokenize = false;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        return this.nextImpl();
    }

    public int nextToken() throws XmlPullParserException {
        this.tokenizeEnt = true;
        this.tokenize = true;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        return this.nextImpl();
    }

    /*
     * Unable to fully structure code
     */
    protected int nextImpl() throws XmlPullParserException {
        block62: {
            this.resetTks();
            this.text = null;
            this.bufStart = this.posEnd;
            if (this.pastEndTag) {
                this.pastEndTag = false;
                --this.depth;
                this.namespaceEnd = this.elNamespaceCount[this.depth];
            }
            if (this.emptyElementTag) {
                this.emptyElementTag = false;
                this.pastEndTag = true;
                this.eventType = (byte)3;
                return 3;
            }
            if (this.extraend > 0 || this.atEOF && this.depth > 0) {
                if (this.extraend > 0) {
                    --this.extraend;
                }
                if (this.atEOF || this.extraend > 0) {
                    startname = new String(this.elRawName[this.depth], 0, this.elRawNameEnd[this.depth]);
                    this.throwErrorIfNotRecovering("Error 13.4: in starttag: start tag '" + startname + "' has no matching end tag");
                    this.errorStartTagDiag = "Error 13.4: in starttag: start tag '" + startname + "' has no matching end tag";
                }
                this.pastEndTag = true;
                this.eventType = (byte)3;
                return 3;
            }
            if (this.atEOF) {
                this.reachedEnd = true;
                this.eventType = 1;
                return 1;
            }
            if (this.depth <= 0) break block62;
            if (this.seenStartTag) {
                this.seenStartTag = false;
                this.eventType = this.parseStartTag();
                return this.eventType;
            }
            if (this.seenEndTag) {
                this.seenEndTag = false;
                this.eventType = this.parseEndTag();
                return this.eventType;
            }
            try {
                if (this.seenMarkup) {
                    this.seenMarkup = false;
                    ch = '<';
                } else if (this.seenAmpersand) {
                    this.seenAmpersand = false;
                    ch = '&';
                } else {
                    ch = this.more();
                }
                this.posStart = this.pos - 1;
                hadCharData = false;
                needsMerging = false;
                while (true) {
                    if (needsMerging) {
                        this.joinPC();
                        needsMerging = false;
                    }
                    if (ch != 60) ** GOTO lbl136
                    if (hadCharData) {
                        this.posEnd = this.pos - 1;
                        if (this.tokenizeEnt) {
                            this.addTk(26, 1);
                            this.seenMarkup = true;
                            this.eventType = (byte)4;
                            return 4;
                        }
                    }
                    if ((ch = (char)this.more()) == '/') {
                        if (!this.tokenizeEnt && hadCharData) {
                            this.addTk(26, 2);
                            this.seenEndTag = true;
                            this.posEnd = this.pos - 2;
                            this.eventType = (byte)4;
                            return 4;
                        }
                        this.eventType = this.parseEndTag();
                        return this.eventType;
                    }
                    if (ch != 33) ** GOTO lbl113
                    ch = this.more();
                    if (ch == '-') {
                        this.parseComment();
                        if (this.tokenize) {
                            this.eventType = (byte)9;
                            return 9;
                        }
                        if (!this.usePC && hadCharData) {
                            needsMerging = true;
                        }
                    } else if (ch == '[') {
                        this.posEnd = this.pos - 3;
                        oldStart = this.posStart;
                        oldEnd = this.posEnd;
                        this.parseCDSect();
                        if (this.tokenize) {
                            this.eventType = (byte)5;
                            return 5;
                        }
                        cdStart = this.posStart;
                        cdEnd = this.posEnd;
                        this.posStart = oldStart;
                        this.posEnd = oldEnd;
                        cdLen = cdEnd - cdStart;
                        if (hadCharData && cdLen > 0) {
                            if (!this.usePC) {
                                if (this.posEnd > this.posStart) {
                                    this.joinPC();
                                } else {
                                    this.usePC = true;
                                    this.pcEnd = 0;
                                    this.pcStart = 0;
                                }
                            }
                            if (this.pcEnd + cdLen >= this.pc.length) {
                                this.ensurePC(this.pcEnd + cdLen);
                            }
                            System.arraycopy(this.buf, cdStart, this.pc, this.pcEnd, cdLen);
                            this.pcEnd += cdLen;
                        }
                        if (!this.usePC && hadCharData) {
                            needsMerging = true;
                        }
                    } else {
                        this.throwErrorIfNotRecovering("unexpected character in markup " + this.printable(ch));
                        MXParser.debug("Error 1: invalid char " + this.printable(ch));
                        this.addError("Error 1: invalid char.");
                        this.eventType = (byte)11;
                        return 11;
lbl113:
                        // 1 sources

                        if (ch == '?') {
                            this.parsePI();
                            if (this.tokenize) {
                                this.eventType = (byte)8;
                                return 8;
                            }
                            if (!this.usePC && hadCharData) {
                                needsMerging = true;
                            }
                        } else {
                            if (MXParser.isNameStartChar(ch)) {
                                if (!this.tokenizeEnt && hadCharData) {
                                    this.addTk(26, 2);
                                    this.seenStartTag = true;
                                    this.posEnd = this.pos - 2;
                                    this.eventType = (byte)4;
                                    return 4;
                                }
                                this.eventType = this.parseStartTag();
                                return this.eventType;
                            }
                            this.throwErrorIfNotRecovering("unexpected character in markup " + this.printable(ch));
                            this.addTk(1, 1);
                            MXParser.debug("Error 2: invalid char " + this.printable(ch) + " in name.");
                            this.addError("Error 2: invalid char.");
                            this.eventType = (byte)11;
                            return 11;
lbl136:
                            // 1 sources

                            if (ch == '&') {
                                this.addTk(26, 1);
                                this.posEnd = this.pos - 1;
                                if (this.tokenizeEnt && hadCharData) {
                                    this.seenAmpersand = true;
                                    this.eventType = (byte)4;
                                    return 4;
                                }
                                oldStart = this.posStart;
                                oldEnd = this.posEnd;
                                resolvedEntity = this.parseEntityRef();
                                if (this.tokenizeEnt) {
                                    this.eventType = (byte)6;
                                    return 6;
                                }
                                if (resolvedEntity == null) {
                                    if (this.entityRefName == null) {
                                        this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                                    }
                                    this.throwErrorIfNotRecovering("could not resolve entity named '" + this.printable(this.entityRefName) + "'");
                                    this.addError("Error 3: could not resolve entity.");
                                    this.eventType = (byte)11;
                                    return 11;
                                }
                                this.posStart = oldStart;
                                this.posEnd = oldEnd;
                                if (!this.usePC) {
                                    if (hadCharData) {
                                        this.joinPC();
                                        needsMerging = false;
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                i = 0;
                                while (i < resolvedEntity.length) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = resolvedEntity[i];
                                    ++i;
                                }
                            } else {
                                hadCharData = true;
                                normalizedCR = false;
                                do {
                                    if (ch == '\r') {
                                        normalizedCR = true;
                                        this.posEnd = this.pos - 1;
                                        if (!this.usePC) {
                                            if (this.posEnd > this.posStart) {
                                                this.joinPC();
                                            } else {
                                                this.usePC = true;
                                                this.pcEnd = 0;
                                                this.pcStart = 0;
                                            }
                                        }
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = 10;
                                        continue;
                                    }
                                    if (ch == '\n') {
                                        if (!normalizedCR && this.usePC) {
                                            if (this.pcEnd >= this.pc.length) {
                                                this.ensurePC(this.pcEnd);
                                            }
                                            this.pc[this.pcEnd++] = 10;
                                        }
                                        normalizedCR = false;
                                        continue;
                                    }
                                    if (this.usePC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = ch;
                                    }
                                    normalizedCR = false;
                                } while ((ch = this.more()) != '<' && ch != 38);
                                continue;
                            }
                        }
                    }
                    ch = this.more();
                }
            }
            catch (IOException e) {
                this.atEOF = true;
                this.addTk(26, 0);
                this.eventType = (byte)4;
                return 4;
            }
        }
        if (this.seenRoot) {
            return this.parseEpilog();
        }
        return this.parseProlog();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte parseProlog() throws XmlPullParserException {
        try {
            char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
            if (this.eventType == 0) {
                if (ch == '\ufffe') {
                    this.throwErrorIfNotRecovering("first character in input was UNICODE noncharacter (0xFFFE)- input requires int swapping");
                    this.addError("Error 4: first char was 0xFFFE - input requires int swapping.");
                    return 11;
                }
                if (ch == '\ufeff') {
                    ch = this.more();
                }
            }
            this.seenMarkup = false;
            boolean gotS = false;
            this.posStart = this.pos - 1;
            while (true) {
                block32: {
                    block29: {
                        block30: {
                            block31: {
                                if (ch != '<') break block30;
                                if (gotS && this.tokenize) {
                                    this.addTk(31, 1);
                                    this.posEnd = this.pos - 1;
                                    this.seenMarkup = true;
                                    this.eventType = 7;
                                    return 7;
                                }
                                ch = this.more();
                                if (ch != '?') break block31;
                                this.parsePI();
                                if (this.tokenize) {
                                    this.eventType = 8;
                                    return 8;
                                }
                                break block29;
                            }
                            if (ch == '!') {
                                ch = this.more();
                                if (ch == 'D') {
                                    this.parseDocdecl();
                                    if (this.tokenize) {
                                        this.eventType = 10;
                                        return 10;
                                    }
                                    break block29;
                                } else {
                                    if (ch != '-') {
                                        this.throwErrorIfNotRecovering("unexpected markup <!" + this.printable(ch));
                                        this.addError("Error 5: in prolog: invalid char.");
                                        this.eventType = 11;
                                        return 11;
                                    }
                                    this.parseComment();
                                    if (this.tokenize) {
                                        this.eventType = 9;
                                        return 9;
                                    }
                                }
                                break block29;
                            } else {
                                if (ch == '/') {
                                    this.throwErrorIfNotRecovering("expected start tag name and not " + this.printable(ch));
                                    this.addError("Error 6: in prolog: invalid char.");
                                    this.eventType = 11;
                                    return 11;
                                }
                                if (MXParser.isNameStartChar(ch)) {
                                    this.seenRoot = true;
                                    return this.parseStartTag();
                                }
                                this.throwErrorIfNotRecovering("expected start tag name and not " + this.printable(ch));
                                this.addError("Error 7: in prolog: invalid char.");
                                this.seenMarkup = false;
                                this.eventType = 11;
                                return 11;
                            }
                        }
                        if (!this.isS(ch)) {
                            this.throwErrorIfNotRecovering("only whitespace content allowed before starttag and not " + this.printable(ch));
                            this.addError("Error 8: in prolog: invalid char.");
                            this.seenMarkup = false;
                            this.eventType = 11;
                            return 11;
                        }
                        break block32;
                    }
                    ch = this.more();
                    continue;
                }
                gotS = true;
                boolean normalizedCR = false;
                do {
                    if (ch == '\r') {
                        normalizedCR = true;
                        this.posEnd = this.pos - 1;
                        if (!this.usePC) {
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                        continue;
                    }
                    if (ch == '\n') {
                        if (!normalizedCR && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        normalizedCR = false;
                        continue;
                    }
                    if (this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = ch;
                    }
                    normalizedCR = false;
                } while ((ch = this.more()) == ' ' || ch == '\n' || ch == '\r' || ch == '\t');
            }
        }
        catch (IOException e) {
            this.atEOF = true;
            this.throwErrorIfNotRecovering("Error 7.2: in prolog: unexpected EOF.");
            this.addError("Error 7.2: in prolog: unexpected EOF.");
            this.eventType = 11;
            return 11;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte parseEpilog() throws XmlPullParserException {
        if (this.eventType == 1) {
            throw new XmlPullParserException("already reached end document", this, null);
        }
        if (this.reachedEnd) {
            this.eventType = 1;
            return 1;
        }
        boolean gotS = false;
        try {
            char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
            this.seenMarkup = false;
            this.posStart = this.pos - 1;
            while (true) {
                if (ch != '<') {
                    if (!this.isS(ch)) {
                        this.throwErrorIfNotRecovering("in epilog non whitespace content is not allowed but got " + this.printable(ch));
                        this.addError("Error 11: in epilog: invalid char.");
                        this.eventType = 11;
                        return 11;
                    }
                } else {
                    if (gotS && this.tokenize) {
                        this.addTk(31, 1);
                        this.posEnd = this.pos - 1;
                        this.seenMarkup = true;
                        this.eventType = 7;
                        return 7;
                    }
                    ch = this.more();
                    if (ch == '?') {
                        this.parsePI();
                        if (this.tokenize) {
                            this.eventType = 8;
                            return 8;
                        }
                    } else {
                        if (ch != '!') {
                            this.throwErrorIfNotRecovering("in epilog expected ignorable content and not " + this.printable(ch));
                            this.addError("Error 10: in epilog: invalid char.");
                            this.eventType = 11;
                            return 11;
                        }
                        ch = this.more();
                        if (ch != '-') {
                            this.throwErrorIfNotRecovering("unexpected markup <!" + this.printable(ch));
                            this.addError("Error 9: in epilog: invalid char.");
                            this.eventType = 11;
                            return 11;
                        }
                        this.parseComment();
                        if (this.tokenize) {
                            this.eventType = 9;
                            return 9;
                        }
                    }
                    ch = this.more();
                    continue;
                }
                gotS = true;
                boolean normalizedCR = false;
                do {
                    if (ch == '\r') {
                        normalizedCR = true;
                        this.posEnd = this.pos - 1;
                        if (!this.usePC) {
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                        continue;
                    }
                    if (ch == '\n') {
                        if (!normalizedCR && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        normalizedCR = false;
                        continue;
                    }
                    if (this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = ch;
                    }
                    normalizedCR = false;
                } while ((ch = this.more()) == ' ' || ch == '\n' || ch == '\r' || ch == '\t');
            }
        }
        catch (IOException ex) {
            this.atEOF = true;
            this.reachedEnd = true;
            if (this.charNumber - this.tkLastTkOffset == 0 && this.tkCount > 0 && this.tkTypes[this.tkCount - 1] == 34) {
                this.tkLastTkOffset -= this.tkLens[this.tkCount - 1];
                --this.tkCount;
            }
            this.addTk(31);
            if (this.tokenize && gotS) {
                this.posEnd = this.pos;
                this.eventType = 7;
                return 7;
            }
            this.eventType = 1;
            return 1;
        }
    }

    public byte parseEndTag() throws XmlPullParserException {
        try {
            String startname;
            this.eventType = (byte)3;
            this.addTk(3);
            char ch = this.more();
            if (!MXParser.isNameStartChar(ch)) {
                this.throwErrorIfNotRecovering("expected name start and not " + this.printable(ch));
                this.addError("Error 12: in endtag: invalid char.");
                this.eventType = 11;
                return 11;
            }
            this.posStart = this.pos - 3;
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            while (MXParser.isNameChar(ch = this.more())) {
            }
            int last = this.pos - 1;
            int matchtrial = -1;
            int trial = 0;
            while (matchtrial < 0 && trial <= 2 && trial <= this.depth) {
                block16: {
                    char[] cbuf = this.elRawName[this.depth - trial];
                    int off = nameStart - this.bufAbsoluteStart;
                    int len = last - off;
                    if (this.elRawNameEnd[this.depth - trial] == len) {
                        int i = 0;
                        while (i < len) {
                            if (this.buf[off++] == cbuf[i]) {
                                ++i;
                                continue;
                            }
                            break block16;
                        }
                        matchtrial = trial;
                    }
                }
                ++trial;
            }
            if (matchtrial != 0) {
                this.throwErrorIfNotRecovering("Error 13.1: in endtag: end tag name '" + new String(this.buf, nameStart - this.bufAbsoluteStart, last - nameStart + this.bufAbsoluteStart) + "' does not match '" + new String(this.elRawName[this.depth], 0, this.elRawNameEnd[this.depth]) + "'");
            }
            if (matchtrial < 0) {
                startname = new String(this.elRawName[this.depth], 0, this.elRawNameEnd[this.depth]);
                String endname = new String(this.buf, nameStart - this.bufAbsoluteStart, last - nameStart + this.bufAbsoluteStart);
                int forgiveEdits = (startname.length() + endname.length()) / 5;
                if (forgiveEdits < 20 && Levenshtein.distance(startname.toUpperCase(), endname.toUpperCase()) <= forgiveEdits) {
                    MXParser.debug("Error 13.0: end tag name '" + endname + "' is a misspelling of '" + startname + "'");
                    this.errorMessage = "Error 13.0: end tag name '" + endname + "' is a misspelling of '" + startname + "'";
                } else {
                    MXParser.debug("Error 13.1: in endtag: end tag name '" + endname + "' does not match '" + startname + "'");
                    this.errorMessage = "Error 13.1: in endtag: end tag name '" + endname + "' does not match '" + startname + "'";
                    this.throwErrorIfNotRecovering(this.errorMessage);
                    this.eventType = (byte)11;
                }
            }
            if (matchtrial > 0) {
                startname = new String(this.elRawName[this.depth], 0, this.elRawNameEnd[this.depth]);
                MXParser.debug("Error 13.3: in starttag: start tag '" + startname + "' has no matching end tag");
                this.errorStartTagDiag = "Error 13.3: in starttag: start tag '" + startname + "' has no matching end tag";
                this.extraend = matchtrial;
            }
            this.addTk(7, 1);
            while (this.isS(ch)) {
                ch = this.more();
            }
            this.addTk(14, 1);
            if (ch != '>') {
                this.throwErrorIfNotRecovering("expected > to finsh end tag not " + this.printable(ch));
                this.addError("Error 14: in endtag: invalid char.");
            }
            this.addTk(2);
            if (this.eventType == 11) {
                return this.eventType;
            }
            this.posEnd = this.pos;
            this.pastEndTag = true;
            this.eventType = 3;
            return 3;
        }
        catch (IOException e) {
            this.atEOF = true;
            this.posEnd = this.pos;
            this.errorMessage = "Error 22.1: in starttag: incomplete tag at EOF";
            this.throwErrorIfNotRecovering(this.errorMessage);
            this.eventType = 11;
            return 11;
        }
    }

    public byte parseStartTag() throws XmlPullParserException {
        ++this.depth;
        try {
            this.posStart = this.pos - 2;
            this.addTk(1, 1);
            this.emptyElementTag = false;
            this.attributeCount = 0;
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            int colonPos = -1;
            int ch = this.buf[this.pos - 1];
            if (ch == 58 && this.processNamespaces) {
                this.throwErrorIfNotRecovering("when namespaces processing enabled colon can not be at element name start");
                this.addError("Error 15: in starttag: ':' at start of name");
            }
            while (MXParser.isNameChar((char)(ch = this.more()))) {
                if (ch != 58 || !this.processNamespaces) continue;
                if (colonPos != -1) {
                    this.throwErrorIfNotRecovering("only one colon is allowed in name of element when namespaces are enabled");
                    this.addTk(7, 1);
                    this.addError("Error 16: in starttag: too many ':' in name.");
                }
                colonPos = this.pos - 1 + this.bufAbsoluteStart;
                this.addTk(5, 1);
                this.addTk(6);
            }
            this.addTk(7, 1);
            this.ensureElementsCapacity();
            int elLen = this.pos - 1 - (nameStart - this.bufAbsoluteStart);
            if (this.elRawName[this.depth] == null || this.elRawName[this.depth].length < elLen) {
                this.elRawName[this.depth] = new char[2 * elLen];
            }
            System.arraycopy(this.buf, nameStart - this.bufAbsoluteStart, this.elRawName[this.depth], 0, elLen);
            this.elRawNameEnd[this.depth] = elLen;
            String name = null;
            String prefix = null;
            if (this.processNamespaces) {
                if (colonPos != -1) {
                    prefix = this.elPrefix[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, colonPos - nameStart);
                    name = this.elName[this.depth] = this.newString(this.buf, colonPos + 1 - this.bufAbsoluteStart, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                } else {
                    this.elPrefix[this.depth] = null;
                    prefix = null;
                    name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
                }
            } else {
                name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
            }
            while (true) {
                if (this.isS((char)ch)) {
                    ch = this.more();
                    continue;
                }
                this.addTk(14, 1);
                if (ch == 62) {
                    this.addTk(2);
                    break;
                }
                if (ch == 47) {
                    if (this.emptyElementTag) {
                        this.throwErrorIfNotRecovering("repeated / in tag declaration");
                        this.addError("Error 17.1: in starttag: too many '/' in tag.");
                    }
                    this.emptyElementTag = true;
                    ch = this.more();
                    if (ch != 62) {
                        this.throwErrorIfNotRecovering("expected > to end empty tag not " + this.printable((char)ch));
                        if (ch == 60) {
                            this.seenMarkup = true;
                            this.addError(2, "Error 17.2: in starttag: expected '>' to end empty tag.");
                        } else {
                            this.addError("Error 17.2: in starttag: expected '>' to end empty tag.");
                        }
                        this.setError(7, 1, "Error 17.3: in starttag: tag not terminated.");
                        ch = 62;
                    }
                    this.addTk(4);
                    break;
                }
                if (MXParser.isNameStartChar((char)ch)) {
                    ch = this.parseAttribute();
                    if (ch == 60) {
                        MXParser.debug("Error 43: in starttag: unterminated tag");
                        this.setError(7, 1, "Error 43: in starttag: unterminated tag.");
                        this.seenMarkup = true;
                        break;
                    }
                    if (ch == 47 || ch == 62) continue;
                    ch = this.more();
                    continue;
                }
                this.throwErrorIfNotRecovering("start tag unexpected character " + this.printable((char)ch));
                if (ch == 60) {
                    this.addError(1, "Error 18: in starttag: invalid char.");
                    this.seenMarkup = true;
                    break;
                }
                this.addError("Error 18: in starttag: invalid char.");
                ch = this.more();
            }
            if (this.processNamespaces) {
                String uri = this.getNamespace(prefix);
                if (uri == null) {
                    if (prefix == null) {
                        uri = "";
                    } else {
                        this.throwErrorIfNotRecovering("could not determine namespace bound to element prefix " + prefix);
                        this.setError(5, 1, "Error 19: in starttag: undefined namespace prefix.");
                        this.elRawName[this.depth] = name.toCharArray();
                        this.elRawNameEnd[this.depth] = this.elRawName[this.depth].length;
                    }
                }
                this.elUri[this.depth] = uri;
                int i = 0;
                while (i < this.attributeCount) {
                    String attrPrefix = this.attributePrefix[i];
                    if (attrPrefix != null) {
                        String attrUri = this.getNamespace(attrPrefix);
                        if (attrUri == null) {
                            this.throwErrorIfNotRecovering("could not determine namespace bound to attribute prefix " + attrPrefix);
                            this.setError(8, 1, "Error 20: in starttag: undefined namespace for attribute prefix.");
                        }
                        this.attributeUri[i] = attrUri;
                    } else {
                        this.attributeUri[i] = "";
                    }
                    ++i;
                }
                int i2 = 1;
                while (i2 < this.attributeCount) {
                    int j = 0;
                    while (j < i2) {
                        if (this.attributeUri[j] == this.attributeUri[i2] && (this.allStringsInterned && this.attributeName[j].equals(this.attributeName[i2]) || !this.allStringsInterned && this.attributeNameHash[j] == this.attributeNameHash[i2] && this.attributeName[j].equals(this.attributeName[i2]))) {
                            String attr1 = this.attributeName[j];
                            if (this.attributeUri[j] != null) {
                                attr1 = this.attributeUri[j] + ":" + attr1;
                            }
                            String attr2 = this.attributeName[i2];
                            if (this.attributeUri[i2] != null) {
                                attr2 = this.attributeUri[i2] + ":" + attr2;
                            }
                            this.throwErrorIfNotRecovering("duplicated attributes " + attr1 + " and " + attr2);
                        }
                        ++j;
                    }
                    ++i2;
                }
            } else {
                int i = 1;
                while (i < this.attributeCount) {
                    int j = 0;
                    while (j < i) {
                        if (this.allStringsInterned && this.attributeName[j].equals(this.attributeName[i]) || !this.allStringsInterned && this.attributeNameHash[j] == this.attributeNameHash[i] && this.attributeName[j].equals(this.attributeName[i])) {
                            String attr1 = this.attributeName[j];
                            String attr2 = this.attributeName[i];
                            this.throwErrorIfNotRecovering("duplicated attributes " + attr1 + " and " + attr2);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.posEnd = this.pos;
            this.eventType = 2;
            return 2;
        }
        catch (IOException e) {
            this.atEOF = true;
            this.posEnd = this.pos;
            this.errorMessage = "Error 22.1: in starttag: incomplete tag at EOF";
            this.throwErrorIfNotRecovering(this.errorMessage);
            --this.depth;
            this.eventType = 11;
            return 11;
        }
    }

    protected char parseAttribute() throws XmlPullParserException, IOException {
        int prevPosStart = this.posStart + this.bufAbsoluteStart;
        int nameStart = this.pos - 1 + this.bufAbsoluteStart;
        int colonPos = -1;
        char ch = this.buf[this.pos - 1];
        if (ch == ':' && this.processNamespaces) {
            this.throwErrorIfNotRecovering("when namespaces processing enabled colon can not be at attribute name start");
            this.addError("Error 23: in parseAtt: ':' at start of attribute.");
        }
        boolean startsWithXmlns = this.processNamespaces && ch == 'x';
        int xmlnsPos = 0;
        ch = this.more();
        while (MXParser.isNameChar(ch)) {
            if (this.processNamespaces) {
                if (startsWithXmlns && xmlnsPos < 5) {
                    if (++xmlnsPos == 1) {
                        if (ch != 'm') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 2) {
                        if (ch != 'l') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 3) {
                        if (ch != 'n') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 4) {
                        if (ch != 's') {
                            startsWithXmlns = false;
                        }
                    } else if (xmlnsPos == 5) {
                        if (ch != ':') {
                            this.throwErrorIfNotRecovering("after xmlns in attribute name must be colonwhen namespaces are enabled");
                            this.addError("Error 24: in parseAtt: invalid char.");
                        }
                        this.addTk(11, 1);
                        this.addTk(12);
                    }
                }
                if (ch == ':') {
                    if (colonPos != -1) {
                        this.throwErrorIfNotRecovering("only one colon is allowed in attribute name when namespaces are enabled");
                        this.addError("Error 25: in parseAtt: to many ':' in attname.");
                    }
                    colonPos = this.pos - 1 + this.bufAbsoluteStart;
                    this.addTk(8, 1);
                    this.addTk(9);
                }
            }
            ch = this.more();
        }
        if (startsWithXmlns) {
            this.addTk(13, 1);
        } else {
            this.addTk(10, 1);
        }
        this.ensureAttributesCapacity(this.attributeCount);
        String name = null;
        String prefix = null;
        if (this.processNamespaces) {
            if (xmlnsPos < 4) {
                startsWithXmlns = false;
            }
            if (startsWithXmlns) {
                if (colonPos != -1) {
                    name = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                }
            } else {
                if (colonPos != -1) {
                    prefix = this.attributePrefix[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, colonPos - nameStart);
                    name = this.attributeName[this.attributeCount] = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                } else {
                    this.attributePrefix[this.attributeCount] = null;
                    prefix = null;
                    name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
                }
                if (!this.allStringsInterned) {
                    this.attributeNameHash[this.attributeCount] = name.hashCode();
                }
            }
        } else {
            name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
            if (!this.allStringsInterned) {
                this.attributeNameHash[this.attributeCount] = name.hashCode();
            }
        }
        while (this.isS(ch)) {
            ch = this.more();
        }
        this.addTk(14, 1);
        while (ch != '=') {
            this.throwErrorIfNotRecovering("expected = after attribute name");
            if (ch == '/' || ch == '>' || ch == '<') {
                this.addError(1, "Error 26: in parseAtt: invalid char.");
                return ch;
            }
            this.addError("Error 26: in parseAtt: invalid char.");
            ch = this.more();
        }
        if (startsWithXmlns) {
            this.addTk(32);
        } else {
            this.addTk(15);
        }
        ch = this.more();
        while (this.isS(ch)) {
            ch = this.more();
        }
        this.addTk(14, 1);
        char delimit = ch;
        while (delimit != '\"' && delimit != '\'') {
            this.throwErrorIfNotRecovering("attribute value must start with quotation or apostrophe not " + this.printable(delimit));
            if (ch == '/' || ch == '>' || ch == '<') {
                this.addError(1, "Error 27: in parseAtt: invalid char.");
                return ch;
            }
            this.addError("Error 27: in parseAtt: invalid char.");
            delimit = ch = this.more();
        }
        if (startsWithXmlns) {
            this.addTk(33);
        } else {
            this.addTk(16);
        }
        boolean normalizedCR = false;
        this.usePC = false;
        this.pcStart = this.pcEnd;
        this.posStart = this.pos;
        while (true) {
            if ((ch = this.more()) == delimit) {
                if (startsWithXmlns) {
                    this.addTk(18, 1);
                    this.addTk(33);
                    break;
                }
                this.addTk(17, 1);
                this.addTk(16);
                break;
            }
            if (ch == '<') {
                this.throwErrorIfNotRecovering("markup not allowed inside attribute value - illegal < ");
                this.addError(1, "Error 28: in parseAtt: invalid char.");
                if (startsWithXmlns) {
                    this.setError(33, 1, "Unterminated quote.");
                } else {
                    this.setError(16, 1, "Unterminated quote.");
                }
                return ch;
            }
            if (ch == '&') {
                if (startsWithXmlns) {
                    this.addTk(18, 1);
                } else {
                    this.addTk(17, 1);
                }
                this.posEnd = this.pos - 1;
                if (!this.usePC) {
                    boolean hadCharData;
                    boolean bl = hadCharData = this.posEnd > this.posStart;
                    if (hadCharData) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                boolean temp = this.tokenizeEnt;
                this.tokenizeEnt = false;
                char[] resolvedEntity = this.parseEntityRef();
                this.tokenizeEnt = temp;
                if (resolvedEntity == null) {
                    if (this.entityRefName == null) {
                        this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                    }
                    this.throwErrorIfNotRecovering("could not resolve entity named '" + this.printable(this.entityRefName) + "'");
                    this.setError(25, 1, "Error 29: in parseAtt: could not resolve entity.");
                    resolvedEntity = new char[]{};
                }
                int i = 0;
                while (i < resolvedEntity.length) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = resolvedEntity[i];
                    ++i;
                }
            } else if (ch == '\t' || ch == '\n' || ch == '\r') {
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcStart = 0;
                        this.pcEnd = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                if (ch != '\n' || !normalizedCR) {
                    this.pc[this.pcEnd++] = 32;
                }
            } else if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = ch;
            }
            normalizedCR = ch == '\r';
        }
        if (this.processNamespaces && startsWithXmlns) {
            String ns = null;
            ns = !this.usePC ? this.newStringIntern(this.buf, this.posStart, this.pos - 1 - this.posStart) : this.newStringIntern(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            this.ensureNamespacesCapacity(this.namespaceEnd);
            int prefixHash = -1;
            if (colonPos != -1) {
                if (ns.length() == 0) {
                    this.throwErrorIfNotRecovering("non-default namespace can not be declared to be empty string");
                    this.setError(33, 2, "Error 30: in parseAtt: non-default ns can not be declared to be empty string.");
                }
                this.namespacePrefix[this.namespaceEnd] = name;
                if (!this.allStringsInterned) {
                    prefixHash = this.namespacePrefixHash[this.namespaceEnd] = name.hashCode();
                }
            } else {
                this.namespacePrefix[this.namespaceEnd] = null;
                if (!this.allStringsInterned) {
                    this.namespacePrefixHash[this.namespaceEnd] = -1;
                    prefixHash = -1;
                }
            }
            this.namespaceUri[this.namespaceEnd] = ns;
            int startNs = this.elNamespaceCount[this.depth - 1];
            int i = this.namespaceEnd - 1;
            while (i >= startNs) {
                if ((this.allStringsInterned || name == null) && this.namespacePrefix[i] == name || !this.allStringsInterned && name != null && this.namespacePrefixHash[i] == prefixHash && name.equals(this.namespacePrefix[i])) {
                    String s = name == null ? "default" : "'" + name + "'";
                    this.throwErrorIfNotRecovering("duplicated namespace declaration for " + s + " prefix");
                    this.setError(13, 1, "Error 31: in parseAtt: duplicate namespaces declaration.");
                }
                --i;
            }
            ++this.namespaceEnd;
        } else {
            this.attributeValue[this.attributeCount] = !this.usePC ? new String(this.buf, this.posStart, this.pos - 1 - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            ++this.attributeCount;
        }
        this.posStart = prevPosStart - this.bufAbsoluteStart;
        return ch;
    }

    protected char[] parseEntityRef() throws XmlPullParserException {
        try {
            this.entityRefName = null;
            this.posStart = this.pos;
            char ch = this.more();
            if (ch == '#') {
                int charRef = 0;
                ch = this.more();
                if (ch == 'x') {
                    while (true) {
                        if ((ch = this.more()) >= '0' && ch <= '9') {
                            charRef = (char)(charRef * 16 + (ch - 48));
                            continue;
                        }
                        if (ch >= 'a' && ch <= 'f') {
                            charRef = (char)(charRef * 16 + (ch - 107));
                            continue;
                        }
                        if (ch >= 'A' && ch <= 'F') {
                            charRef = (char)(charRef * 16 + (ch - 75));
                            continue;
                        }
                        if (ch != ';') {
                            this.throwErrorIfNotRecovering("character reference (with hex value) may not contain " + this.printable(ch));
                            this.addTk(25, 1);
                            this.addError("Error 32: in parseEnt: invalid char.");
                            continue;
                        }
                        break;
                    }
                } else {
                    while (true) {
                        if (ch >= '0' && ch <= '9') {
                            charRef = (char)(charRef * 10 + (ch - 48));
                        } else {
                            if (ch == ';') break;
                            this.throwErrorIfNotRecovering("character reference (with decimal value) may not contain " + this.printable(ch));
                            this.addTk(25, 1);
                            this.addError("Error 33: in parseEnt: invalid char.");
                        }
                        ch = this.more();
                    }
                }
                this.posEnd = this.pos - 1;
                this.charRefOneCharBuf[0] = charRef;
                if (this.tokenizeEnt) {
                    this.text = this.newString(this.charRefOneCharBuf, 0, 1);
                }
                this.addTk(25);
                return this.charRefOneCharBuf;
            }
            while (MXParser.isNameChar(ch = this.more())) {
            }
            if (ch != ';') {
                MXParser.debug("Error 38: in parseEnt: malformed entity");
                this.addError("Error 38: in parseEnt: malformed entity.");
            }
            this.addTk(25);
            this.posEnd = this.pos - 1;
            int len = this.posEnd - this.posStart;
            if (len == 2 && this.buf[this.posStart] == 'l' && this.buf[this.posStart + 1] == 't') {
                if (this.tokenizeEnt) {
                    this.text = "<";
                } else {
                    this.charRefOneCharBuf[0] = 60;
                }
                return this.charRefOneCharBuf;
            }
            if (len == 3 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'm' && this.buf[this.posStart + 2] == 'p') {
                if (this.tokenizeEnt) {
                    this.text = "&";
                } else {
                    this.charRefOneCharBuf[0] = 38;
                }
                return this.charRefOneCharBuf;
            }
            if (len == 2 && this.buf[this.posStart] == 'g' && this.buf[this.posStart + 1] == 't') {
                if (this.tokenizeEnt) {
                    this.text = ">";
                } else {
                    this.charRefOneCharBuf[0] = 62;
                }
                return this.charRefOneCharBuf;
            }
            if (len == 4 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'p' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 's') {
                if (this.tokenizeEnt) {
                    this.text = "'";
                } else {
                    this.charRefOneCharBuf[0] = 39;
                }
                return this.charRefOneCharBuf;
            }
            if (len == 4 && this.buf[this.posStart] == 'q' && this.buf[this.posStart + 1] == 'u' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 't') {
                if (this.tokenizeEnt) {
                    this.text = "\"";
                } else {
                    this.charRefOneCharBuf[0] = 34;
                }
                return this.charRefOneCharBuf;
            }
            if (!this.allStringsInterned) {
                int hash = MXParser.fastHash(this.buf, this.posStart, this.posEnd - this.posStart);
                int i = this.entityEnd - 1;
                while (i >= 0) {
                    block42: {
                        if (hash == this.entityNameHash[i] && len == this.entityNameBuf[i].length) {
                            char[] entityBuf = this.entityNameBuf[i];
                            int j = 0;
                            while (j < len) {
                                if (this.buf[this.posStart + j] == entityBuf[j]) {
                                    ++j;
                                    continue;
                                }
                                break block42;
                            }
                            if (this.tokenizeEnt) {
                                this.text = this.entityReplacement[i];
                            }
                            return this.entityReplacementBuf[i];
                        }
                    }
                    --i;
                }
            } else {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                int i = this.entityEnd - 1;
                while (i >= 0) {
                    if (this.entityRefName == this.entityName[i]) {
                        if (this.tokenizeEnt) {
                            this.text = this.entityReplacement[i];
                        }
                        return this.entityReplacementBuf[i];
                    }
                    --i;
                }
            }
            if (this.tokenizeEnt) {
                this.text = null;
            }
            return null;
        }
        catch (IOException e) {
            this.throwErrorIfNotRecovering("Error 38.1: in starttag: incomplete entity at EOF");
            this.atEOF = true;
            this.posEnd = this.pos;
            this.errorMessage = "Error 38.1: in starttag: incomplete entity at EOF";
            return null;
        }
    }

    protected void parseComment() throws XmlPullParserException {
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber;
        try {
            char ch = this.more();
            if (ch != '-') {
                this.throwErrorIfNotRecovering("expected <!-- for comment start");
                this.addTk(22, 1);
                this.addError("Error 34: in parseComment: invalid char.");
            }
            if (this.tokenize) {
                this.posStart = this.pos;
            }
            this.addTk(22);
            curLine = this.lineNumber;
            curColumn = this.columnNumber;
            boolean seenDash = false;
            boolean seenDashDash = false;
            while (true) {
                if ((ch = this.more()) == '-') {
                    if (seenDashDash) {
                        this.addTk(23, 3);
                        this.addError("'--' is illegal inside a comment.");
                    }
                    if (!seenDash) {
                        seenDash = true;
                        continue;
                    }
                    seenDashDash = true;
                    seenDash = false;
                    continue;
                }
                if (ch == '>') {
                    if (seenDashDash) {
                        this.addTk(23, 3);
                        this.addTk(24);
                        break;
                    }
                    seenDashDash = false;
                    seenDash = false;
                    continue;
                }
                if (seenDashDash) {
                    this.addTk(23, 3);
                    this.addError(1, "Illegal char.");
                    seenDashDash = false;
                }
                seenDash = false;
            }
        }
        catch (IOException ex) {
            this.atEOF = true;
            this.throwErrorIfNotRecovering("comment started on line " + curLine + " and column " + curColumn + " was not closed");
            this.addError("Error 35: in parseComment: Unterminated comment.");
            return;
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 3;
        }
    }

    protected void parsePI() throws XmlPullParserException {
        this.addTk(19);
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber;
        try {
            boolean seenQ = false;
            while (true) {
                char ch;
                if ((ch = this.more()) == '?') {
                    seenQ = true;
                    continue;
                }
                if (ch == '>') {
                    if (seenQ) {
                        this.addTk(20, 2);
                        this.addTk(21);
                        break;
                    }
                    seenQ = false;
                    continue;
                }
                seenQ = false;
            }
        }
        catch (IOException ex) {
            this.atEOF = true;
            this.throwErrorIfNotRecovering("processing instruction started on line " + curLine + " and column " + curColumn + " was not closed");
            this.addError("Error 36: in parsePI: Unterminated PI.");
            return;
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 2;
        }
    }

    protected void parseDocdecl() throws XmlPullParserException {
        try {
            char ch = this.more();
            if (ch != 'O') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.1: in parseDocdecl: invalid char.");
            }
            if ((ch = this.more()) != 'C') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.2: in parseDocdecl: invalid char, expected <!DOCTYPE");
            }
            if ((ch = this.more()) != 'T') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.3: in parseDocdecl: invalid char, expected <!DOCTYPE");
            }
            if ((ch = this.more()) != 'Y') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.4: in parseDocdecl: invalid char, expected <!DOCTYPE");
            }
            if ((ch = this.more()) != 'P') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.5: in parseDocdecl: invalid char, expected <!DOCTYPE");
            }
            if ((ch = this.more()) != 'E') {
                this.throwErrorIfNotRecovering("expected <!DOCTYPE");
                this.addTk(30, 1);
                this.addError("Error 37.6: in parseDocdecl: invalid char, expected <!DOCTYPE");
            }
            this.posStart = this.pos;
            this.parseDTD();
            this.addTk(30);
        }
        catch (IOException e) {
            this.atEOF = true;
            this.posEnd = this.pos - 1;
            this.throwErrorIfNotRecovering("Unterminated DOCDECL at EOF.");
            this.addError("Error 37.8: Unterminated DOCDECL at EOF.");
        }
    }

    protected void parseCDSect() throws XmlPullParserException {
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber;
        try {
            char ch = this.more();
            if (ch != 'C') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.1: in parseCDSect: invalid char, expected <![CDATA[");
            }
            if ((ch = this.more()) != 'D') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.2: in parseCDSect: invalid char, expected <![CDATA[");
            }
            if ((ch = this.more()) != 'A') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.3: in parseCDSect: invalid char, expected <![CDATA[");
            }
            if ((ch = this.more()) != 'T') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.4: in parseCDSect: invalid char, expected <![CDATA[");
            }
            if ((ch = this.more()) != 'A') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.5: in parseCDSect: invalid char, expected <![CDATA[");
            }
            if ((ch = this.more()) != '[') {
                this.throwErrorIfNotRecovering("expected <![CDATA[ for character data start");
                this.addTk(30, 1);
                this.addError("Error 38.6: in parseCDSect: invalid char, expected <![CDATA[");
            }
            this.addTk(27);
            this.posStart = this.pos;
            curLine = this.lineNumber;
            curColumn = this.columnNumber;
            boolean seenBracket = false;
            boolean seenBracketBracket = false;
            while (true) {
                if ((ch = this.more()) == ']') {
                    if (!seenBracket) {
                        seenBracket = true;
                        continue;
                    }
                    seenBracketBracket = true;
                    seenBracket = false;
                    continue;
                }
                if (ch == '>') {
                    if (seenBracketBracket) {
                        this.addTk(28, 3);
                        this.addTk(29);
                        break;
                    }
                    seenBracketBracket = false;
                    seenBracketBracket = false;
                    continue;
                }
                seenBracketBracket = false;
            }
        }
        catch (IOException ex) {
            this.atEOF = true;
            this.throwErrorIfNotRecovering("CDATA section on line " + curLine + " and column " + curColumn + " was not closed");
            this.addError("Error 40: in parseCDSect: Unterminated CDATA.");
            return;
        }
        this.posEnd = this.pos - 3;
    }

    protected void fillBuf() throws IOException, XmlPullParserException {
        int len;
        int ret;
        if (this.reader == null) {
            throw new XmlPullParserException("reader must be set before parsing is started");
        }
        if (this.bufEnd > this.bufSoftLimit) {
            boolean compact = this.bufStart > this.bufSoftLimit;
            boolean expand = false;
            if (!compact) {
                if (this.bufStart < this.buf.length / 2) {
                    expand = true;
                } else {
                    compact = true;
                }
            }
            if (compact) {
                System.arraycopy(this.buf, this.bufStart, this.buf, 0, this.bufEnd - this.bufStart);
            } else if (expand) {
                int newSize = 2 * this.buf.length;
                char[] newBuf = new char[newSize];
                System.arraycopy(this.buf, this.bufStart, newBuf, 0, this.bufEnd - this.bufStart);
                this.buf = newBuf;
                if (this.bufLoadFactor > 0) {
                    this.bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
                }
            } else {
                throw new XmlPullParserException("internal error in fillBuffer()");
            }
            this.bufEnd -= this.bufStart;
            this.pos -= this.bufStart;
            this.posStart -= this.bufStart;
            this.posEnd -= this.bufStart;
            this.bufAbsoluteStart += this.bufStart;
            this.bufStart = 0;
        }
        if ((ret = this.reader.read(this.buf, this.bufEnd, len = this.buf.length - this.bufEnd > 8192 ? 8192 : this.buf.length - this.bufEnd)) > 0) {
            this.bufEnd += ret;
            return;
        }
        this.addError("Unexpected end of file.");
        if (ret == -1) {
            if (this.depth > 0) {
                this.recoverUnclosedTags = true;
            }
            this.posEnd = this.bufEnd;
            throw new EOFException("no more data available");
        }
        this.posEnd = this.bufEnd;
        throw new IOException("error reading input, returned " + ret);
    }

    protected char more() throws IOException, XmlPullParserException {
        char ch;
        if (this.pos >= this.bufEnd) {
            this.fillBuf();
        }
        if ((ch = this.buf[this.pos++]) == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        ++this.charNumber;
        return ch;
    }

    protected String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch > '\u007f' || ch < ' ') {
            return "\\u" + Integer.toHexString(ch);
        }
        return "" + ch;
    }

    protected String printable(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            buf.append(this.printable(s.charAt(i)));
            ++i;
        }
        s = buf.toString();
        return s;
    }

    protected void ensurePC(int end) {
        int newSize = end > 8192 ? 2 * end : 16384;
        char[] newPC = new char[newSize];
        System.arraycopy(this.pc, 0, newPC, 0, this.pcEnd);
        this.pc = newPC;
    }

    protected void joinPC() {
        int len = this.posEnd - this.posStart;
        int newEnd = this.pcEnd + len + 1;
        if (newEnd >= this.pc.length) {
            this.ensurePC(newEnd);
        }
        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
        this.pcEnd += len;
        this.usePC = true;
    }

    public static void debug(String s) {
        if (debug == 0) {
            String prop = System.getProperty("xbean.parser.debug");
            debug = "on".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) ? 1 : 2;
        } else if (debug == 1) {
            System.out.println(s);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parseDTD() throws IOException, XmlPullParserException {
        block34: {
            ch = this.more();
            while (this.isS(ch)) {
                ch = this.more();
            }
            ch = this.more();
            if (!MXParser.isNameStartChar(ch)) {
                this.addTk(34);
            }
            while (MXParser.isNameChar(ch)) {
                ch = this.more();
            }
            ch = this.more();
            if (this.isS(ch)) {
                while (this.isS(ch)) {
                    ch = this.more();
                }
            }
            if (ch == 'S') {
                this.parseSysExtID();
                ch = this.more();
            } else if (ch == 'P') {
                this.parsePubExtID();
                ch = this.more();
            }
            while (this.isS(ch)) {
                ch = this.more();
            }
            if (ch != '[') break block34;
            ch = this.more();
            ** GOTO lbl73
            {
                ch = this.more();
                do {
                    if (this.isS(ch)) continue block4;
                    this.addTk(30, 1);
                    if (ch == '<') {
                        ch = this.more();
                        if (ch == '!') {
                            ch = this.more();
                            if (ch == 'A') {
                                this.parseAttDecl();
                            } else if (ch == 'E') {
                                ch = this.more();
                                if (ch == 'L') {
                                    this.parseElmDecl();
                                } else if (ch == 'N') {
                                    this.parseEntDecl();
                                } else {
                                    this.addTk(34);
                                }
                            } else if (ch == '-') {
                                this.parseComment();
                            } else {
                                this.addTk(34);
                            }
                        } else if (ch == '?') {
                            this.parsePI();
                        } else {
                            this.addTk(34);
                        }
                    } else if (ch == '%') {
                        ch = this.more();
                        while (MXParser.isNameChar(ch)) {
                            ch = this.more();
                        }
                        if (ch != ';') {
                            this.addTk(34);
                        }
                    } else {
                        this.addTk(34);
                    }
                    ch = this.more();
                    while (this.isS(ch)) {
                        ch = this.more();
                    }
lbl73:
                    // 2 sources

                } while (ch != ']');
            }
            ch = this.more();
            while (this.isS(ch)) {
                ch = this.more();
            }
        }
        if (ch != '>') {
            this.addTk(34);
        }
    }

    protected void parseElmDecl() throws IOException, XmlPullParserException {
        int ch = 76;
        while (ch != 62) {
            ch = this.more();
        }
    }

    protected void parseAttDecl() throws IOException, XmlPullParserException {
        int ch = 65;
        while (ch != 62) {
            ch = this.more();
        }
    }

    protected void parseEntDecl() throws IOException, XmlPullParserException {
        char ch = this.more();
        if (ch != 'T') {
            this.addTk(34);
        }
        if ((ch = this.more()) != 'I') {
            this.addTk(34);
        }
        if ((ch = this.more()) != 'T') {
            this.addTk(34);
        }
        if ((ch = this.more()) != 'Y') {
            this.addTk(34);
        }
        if (!this.isS(ch = this.more())) {
            this.addTk(34);
        }
        while (this.isS(ch)) {
            ch = this.more();
        }
        boolean isPE = false;
        if (ch == '%') {
            ch = this.more();
            while (this.isS(ch)) {
                ch = this.more();
            }
            isPE = true;
        }
        if (MXParser.isNameStartChar(ch)) {
            int start = this.pos - 1;
            ch = this.more();
            while (MXParser.isNameChar(ch)) {
                ch = this.more();
            }
            String enName = new String(this.buf, start, this.pos - 1 - start);
            if (!this.isS(ch)) {
                this.addTk(34);
            }
            while (this.isS(ch)) {
                ch = this.more();
            }
            if (ch == '\"' || ch == '\'') {
                char delimiter = ch;
                this.usePC = false;
                this.pcStart = this.pcEnd;
                this.posStart = this.pos;
                ch = this.more();
                while (ch != delimiter) {
                    if (ch == '&') {
                        this.addTk(30, 1);
                        this.posEnd = this.pos - 1;
                        if (!this.usePC) {
                            boolean hadCharData;
                            boolean bl = hadCharData = this.posEnd > this.posStart;
                            if (hadCharData) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (!$assertionsDisabled && !this.usePC) {
                            throw new AssertionError();
                        }
                        char[] resolvedEntity = this.parseEntityRef();
                        if (resolvedEntity == null) {
                            if (this.entityRefName == null) {
                                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                            }
                            this.throwErrorIfNotRecovering("could not resolve entity named '" + this.printable(this.entityRefName) + "'");
                            this.setError(25, 1, "Error 29: in parseAtt: could not resolve entity.");
                            resolvedEntity = new char[]{};
                        }
                        int i = 0;
                        while (i < resolvedEntity.length) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = resolvedEntity[i];
                            ++i;
                        }
                    } else if (this.usePC) {
                        this.pc[this.pcEnd++] = ch;
                    }
                    ch = this.more();
                }
                int enLength = this.pos - 1 - this.posStart;
                String replacementText = !this.usePC ? new String(this.buf, this.posStart, enLength) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
                if (!isPE) {
                    this.defineEntityReplacementText(enName, replacementText);
                }
                ch = this.more();
            } else if (ch == 'S') {
                this.parseSysExtID();
            } else if (ch == 'P') {
                this.parsePubExtID();
            } else {
                this.addTk(34);
            }
            while (this.isS(ch)) {
                ch = this.more();
            }
        } else {
            this.addTk(34);
        }
        while (ch != '>') {
            ch = this.more();
        }
    }

    protected void parseSysExtID() throws IOException, XmlPullParserException {
        this.parseWord("YSTEM");
        char ch = this.more();
        while (this.isS(ch)) {
            ch = this.more();
        }
        if (ch != '\"' && ch != '\'') {
            while (ch != '\"' && ch != '\'') {
                ch = this.more();
            }
            this.addTk(34, 1);
        }
        char delimiter = ch;
        ch = this.more();
        while (ch != delimiter) {
            ch = this.more();
        }
    }

    protected void parsePubExtID() throws IOException, XmlPullParserException {
        this.parseWord("UBLIC");
        char ch = this.more();
        while (this.isS(ch)) {
            ch = this.more();
        }
        if (ch != '\"' && ch != '\'') {
            while (ch != '\"' && ch != '\'') {
                ch = this.more();
            }
            this.addTk(34, 1);
        }
        char delimiter = ch;
        ch = this.more();
        while (ch != delimiter) {
            ch = this.more();
        }
        ch = this.more();
        while (this.isS(ch)) {
            ch = this.more();
        }
        if (ch != '\"' && ch != '\'') {
            while (ch != '\"' && ch != '\'') {
                ch = this.more();
            }
            this.addTk(34, 1);
        }
        delimiter = ch;
        ch = this.more();
        while (ch != delimiter) {
            ch = this.more();
        }
    }

    private void parseWord(String s) throws IOException, XmlPullParserException {
        char[] sbuf = s.toCharArray();
        int i = 0;
        while (i < sbuf.length) {
            char ch = this.more();
            if (ch != sbuf[i]) {
                this.addTk(34);
            }
            ++i;
        }
    }

    private void throwErrorIfNotRecovering(String mes) throws XmlPullParserException {
        if (this._recoverFromErrors) {
            return;
        }
        throw new XmlPullParserException(mes, this, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$xmlpull$mxp1$MXParser == null ? (class$org$xmlpull$mxp1$MXParser = MXParser.class$("org.xmlpull.mxp1.MXParser")) : class$org$xmlpull$mxp1$MXParser).desiredAssertionStatus();
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        MXParser.setNameStart(':');
        char ch = 'A';
        while (ch <= 'Z') {
            MXParser.setNameStart(ch);
            ch = (char)(ch + '\u0001');
        }
        MXParser.setNameStart('_');
        char ch2 = 'a';
        while (ch2 <= 'z') {
            MXParser.setNameStart(ch2);
            ch2 = (char)(ch2 + '\u0001');
        }
        char ch3 = '\u00c0';
        while (ch3 <= '\u02ff') {
            MXParser.setNameStart(ch3);
            ch3 = (char)(ch3 + '\u0001');
        }
        char ch4 = '\u0370';
        while (ch4 <= '\u037d') {
            MXParser.setNameStart(ch4);
            ch4 = (char)(ch4 + '\u0001');
        }
        char ch5 = '\u037f';
        while (ch5 < '\u0400') {
            MXParser.setNameStart(ch5);
            ch5 = (char)(ch5 + '\u0001');
        }
        MXParser.setName('-');
        MXParser.setName('.');
        char ch6 = '0';
        while (ch6 <= '9') {
            MXParser.setName(ch6);
            ch6 = (char)(ch6 + '\u0001');
        }
        MXParser.setName('\u00b7');
        char ch7 = '\u0300';
        while (ch7 <= '\u036f') {
            MXParser.setName(ch7);
            ch7 = (char)(ch7 + '\u0001');
        }
        debug = 0;
    }
}

