/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import com.bluecast.xml.ASCIIXMLDecoder;
import com.bluecast.xml.ByteXMLDecoder;
import com.bluecast.xml.ISO8859_1XMLDecoder;
import com.bluecast.xml.UTF8XMLDecoder;
import com.bluecast.xml.UnicodeBigXMLDecoder;
import com.bluecast.xml.UnicodeLittleXMLDecoder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class XMLDecoderFactory {
    public static final String ByteSnifferCharset = "__BYTE_SNIFFER_CHARSET__";
    private static HashMap decoders = new HashMap();

    public static CharsetDecoder createDecoder(String encoding) throws UnsupportedEncodingException {
        CharsetDecoder d = (CharsetDecoder)decoders.get(encoding.toUpperCase());
        if (d != null) {
            return d;
        }
        throw new UnsupportedEncodingException("Encoding '" + encoding + "' not supported");
    }

    static {
        UTF8XMLDecoder utf8 = new UTF8XMLDecoder();
        ASCIIXMLDecoder ascii = new ASCIIXMLDecoder();
        ISO8859_1XMLDecoder iso8859 = new ISO8859_1XMLDecoder();
        UnicodeBigXMLDecoder utf16be = new UnicodeBigXMLDecoder();
        UnicodeLittleXMLDecoder utf16le = new UnicodeLittleXMLDecoder();
        ByteXMLDecoder byteConv = new ByteXMLDecoder();
        decoders.put(ByteSnifferCharset, byteConv);
        decoders.put("UTF-8", utf8);
        decoders.put("UTF8", utf8);
        decoders.put("US-ASCII", ascii);
        decoders.put("ASCII", ascii);
        decoders.put("ISO-8859-1", iso8859);
        decoders.put("ISO8859_1", iso8859);
        decoders.put("UTF-16LE", utf16le);
        decoders.put("UNICODELITTLE", utf16le);
        decoders.put("UNICODELITTLEUNMARKED", utf16le);
        decoders.put("UTF-16BE", utf16be);
        decoders.put("UNICODEBIG", utf16be);
        decoders.put("UNICODEBIGUNMARKED", utf16be);
    }
}

