/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import java.io.CharConversionException;

public final class UnicodeLittleXMLDecoder
implements CharsetDecoder {
    public CharsetDecoder newInstance() {
        return new UnicodeLittleXMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        boolean sawCR = false;
        int o = 0;
        int i = 0;
        while (i + 1 < in_len && o < out_len) {
            char c = (char)((0xFF & in_buf[in_off + i + 1]) << 8 | 0xFF & in_buf[in_off + i]);
            if (c >= ' ') {
                if (c > '\ud7ff' && (c < '\ue000' || c > '\ufffd') && (c < '\u10000' || c > '\u10ffff')) throw new CharConversionException("Illegal XML Character: 0x" + Integer.toHexString(c));
                sawCR = false;
                out_buf[out_off + o++] = c;
            } else {
                switch (c) {
                    case '\n': {
                        if (sawCR) {
                            sawCR = false;
                            break;
                        }
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\r': {
                        sawCR = true;
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o++] = 9;
                        break;
                    }
                    default: {
                        throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                    }
                }
            }
            i += 2;
        }
        result[0] = i;
        result[1] = o;
    }
}

