/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.xml;

import com.bluecast.io.CharsetDecoder;
import java.io.CharConversionException;

public final class ASCIIXMLDecoder
implements CharsetDecoder {
    public CharsetDecoder newInstance() {
        return new ASCIIXMLDecoder();
    }

    public int minBytesPerChar() {
        return 1;
    }

    public int maxBytesPerChar() {
        return 1;
    }

    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        boolean sawCR = false;
        int o = 0;
        int i = 0;
        while (i < in_len && o < out_len) {
            char c = (char)(0x7F & in_buf[in_off + i]);
            if (c >= ' ') {
                sawCR = false;
                out_buf[out_off + o++] = c;
            } else {
                switch (c) {
                    case '\n': {
                        if (sawCR) {
                            sawCR = false;
                            break;
                        }
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\r': {
                        sawCR = true;
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o++] = 9;
                        break;
                    }
                    default: {
                        throw new CharConversionException("Illegal XML character: 0x" + Integer.toHexString(c));
                    }
                }
            }
            ++i;
        }
        result[0] = i;
        result[1] = o;
    }
}

