/*
 * Decompiled with CFR 0.152.
 */
package com.bluecast.util;

public final class CharStringConverter {
    private static final float DEFAULT_LOAD = 0.7f;
    private float loadFactor;
    private int numEntries = 0;
    private int maxEntries;
    private int hashmask;
    private char[][] keys;
    private String[] values;

    public CharStringConverter(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int desiredSize = (int)((float)initialCapacity / loadFactor);
        int size = 16;
        while (size < desiredSize) {
            size <<= 1;
        }
        this.hashmask = size - 1;
        this.maxEntries = (int)((float)size * loadFactor);
        this.keys = new char[size][];
        this.values = new String[size];
        this.loadFactor = loadFactor;
    }

    public CharStringConverter() {
        this(0, 0.7f);
    }

    public CharStringConverter(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public int getCacheSize() {
        return this.numEntries;
    }

    public String convert(char[] ch) {
        return this.convert(ch, 0, ch.length);
    }

    public String convert(char[] ch, int start, int length) {
        if (this.numEntries >= this.maxEntries) {
            this.rehash();
        }
        int offset = CharStringConverter.hashKey(ch, start, length) & this.hashmask;
        char[] k = null;
        while ((k = this.keys[offset]) != null && !CharStringConverter.keysAreEqual(k, 0, k.length, ch, start, length)) {
            offset = offset - 1 & this.hashmask;
        }
        if (k != null) {
            return this.values[offset];
        }
        k = new char[length];
        System.arraycopy(ch, start, k, 0, length);
        String v = new String(k).intern();
        this.keys[offset] = k;
        this.values[offset] = v;
        ++this.numEntries;
        return v;
    }

    private void rehash() {
        int newlength = this.keys.length << 1;
        char[][] newkeys = new char[newlength][];
        String[] newvalues = new String[newlength];
        int newhashmask = newlength - 1;
        int i = 0;
        while (i < this.keys.length) {
            char[] k = this.keys[i];
            String v = this.values[i];
            if (k != null) {
                int newoffset = CharStringConverter.hashKey(k, 0, k.length) & newhashmask;
                char[] newk = null;
                while ((newk = newkeys[newoffset]) != null && !CharStringConverter.keysAreEqual(newk, 0, newk.length, k, 0, k.length)) {
                    newoffset = newoffset - 1 & newhashmask;
                }
                newkeys[newoffset] = k;
                newvalues[newoffset] = v;
            }
            ++i;
        }
        this.keys = newkeys;
        this.values = newvalues;
        this.maxEntries = (int)((float)newlength * this.loadFactor);
        this.hashmask = newhashmask;
    }

    public void clearCache() {
        int i = 0;
        while (i < this.keys.length) {
            this.keys[i] = null;
            this.values[i] = null;
            ++i;
        }
        this.numEntries = 0;
    }

    private static final boolean keysAreEqual(char[] a, int astart, int alength, char[] b, int bstart, int blength) {
        if (alength != blength) {
            return false;
        }
        int i = 0;
        while (i < alength) {
            if (a[astart + i] != b[bstart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int hashKey(char[] ch, int start, int length) {
        int hash = 0;
        int i = 0;
        while (i < length) {
            hash = (hash << 5) + ch[start + i];
            ++i;
        }
        return hash;
    }
}

