/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc.util;

import com.bea.xquery.exceptions.XQRLUserException;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Connection;
import com.bea.xquery.xdbc.DriverManager;
import com.bea.xquery.xdbc.PreparedStatement;
import com.bea.xquery.xdbc.iterators.TokenIterator;
import com.bea.xquery.xdbc.util.MaterializedQueryResults;
import com.bea.xquery.xdbc.util.Serializer;
import java.io.StringWriter;
import junit.framework.Assert;
import junit.framework.TestCase;

public class test_MaterializedQueryResults
extends TestCase {
    protected static Connection conn = null;
    protected PreparedStatement stmt = null;
    protected TokenIterator root = null;
    protected MaterializedQueryResults matres = null;
    protected TokenIterator iter = null;
    protected boolean excepted = false;
    protected final String TEST_DOCUMENT = "<test>sample</test>";

    public test_MaterializedQueryResults(String id) {
        super(id);
    }

    public void setUp() throws Exception {
        if (conn == null) {
            conn = DriverManager.getConnection();
        }
        this.stmt = conn.prepareStatement("<test>sample</test>");
        this.root = this.stmt.executeQuery();
    }

    public void tearDown() throws Exception {
        if (this.matres != null && this.matres.isOpen()) {
            this.matres.close();
        }
    }

    protected void createMatResults() throws Exception {
        this.matres = new MaterializedQueryResults(this.root);
    }

    protected void createEagerMatResults() throws Exception {
        this.matres = new MaterializedQueryResults(this.root, true);
    }

    public void testCreate() throws Exception {
        this.createMatResults();
    }

    public void testCreateEager() throws Exception {
        this.createEagerMatResults();
    }

    public void testOpenClose() throws Exception {
        this.createMatResults();
        Assert.assertTrue((String)"MatResults starts closed!", (boolean)this.matres.isOpen());
        this.matres.close();
        Assert.assertFalse((String)"MatResults failed to close!", (boolean)this.matres.isOpen());
    }

    public void testCreateIterator() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        this.iter.open();
        this.iter.close();
    }

    public void testLateIteratorOpen() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        this.matres.close();
        this.iter.open();
        this.iter.close();
    }

    public void testGetResults() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        StringWriter writer = new StringWriter();
        this.iter.open();
        Serializer serial = new Serializer(this.iter, writer);
        serial.process();
        this.iter.close();
        String results = writer.toString();
        Assert.assertEquals((String)"<test>sample</test>", (String)results);
    }

    public void testGetXQueryType() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        Assert.assertEquals((Object)XQueryType.ANYTYPE, (Object)this.iter.getXQueryType());
    }

    public void testCloseUnderlying() throws Exception {
        this.createMatResults();
        Assert.assertTrue((boolean)this.root.isOpen());
        this.matres.close();
        Assert.assertFalse((String)"MatResults failed to close underlying iterator!", (boolean)this.root.isOpen());
    }

    public void testCloseUnderlyingPart2() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        TokenIterator iter2 = this.matres.createIterator();
        this.matres.close();
        Assert.assertTrue((String)"MatResults closed underlying iterator too early!", (boolean)this.root.isOpen());
        this.iter.open();
        this.iter.close();
        Assert.assertTrue((String)"MatResults closed underlying iterator too early!", (boolean)this.root.isOpen());
        iter2.open();
        iter2.close();
        Assert.assertFalse((String)"MatResults failed to close underlying iterator!", (boolean)this.root.isOpen());
    }

    public void testCloseUnderlyingWithGetXQueryType() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        this.matres.close();
        this.iter.getXQueryType();
        Assert.assertFalse((String)"getXQueryType() failed to close underlying iterator!", (boolean)this.root.isOpen());
    }

    public void testEagerCloseUnderlying() throws Exception {
        this.createEagerMatResults();
        Assert.assertFalse((String)"Eager MatRes failed to close underlying iterator!", (boolean)this.root.isOpen());
    }

    public void testEagerIteratorReOpen() throws Exception {
        this.createEagerMatResults();
        this.iter = this.matres.createIterator();
        this.matres.close();
        this.iter.open();
        this.iter.close();
        this.iter.open();
        this.iter.close();
    }

    public void testEagerLateCreateIterator() throws Exception {
        this.createEagerMatResults();
        this.matres.close();
        this.iter = this.matres.createIterator();
        this.iter.open();
        this.iter.close();
    }

    public void testEagerGetType() throws Exception {
        this.createEagerMatResults();
        this.matres.close();
        this.iter = this.matres.createIterator();
        this.iter.getXQueryType();
        this.iter.open();
        this.iter.close();
        this.iter.open();
        this.iter.close();
    }

    public void testLateIteratorReOpen() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        this.iter.open();
        this.iter.close();
        this.matres.close();
        try {
            this.iter.open();
        }
        catch (XQRLUserException e) {
            this.excepted = true;
        }
        Assert.assertTrue((String)"Was able to re-open() iterator after MatRes closed!", (boolean)this.excepted);
    }

    public void testTooLateCreateIterator() throws Exception {
        this.createMatResults();
        this.matres.close();
        try {
            this.iter = this.matres.createIterator();
        }
        catch (XQRLUserException e) {
            this.excepted = true;
        }
        Assert.assertTrue((String)"Was able to create iterator after MatRes closed!", (boolean)this.excepted);
    }

    public void testTooLateOpenAfterGetType() throws Exception {
        this.createMatResults();
        this.iter = this.matres.createIterator();
        this.matres.close();
        this.iter.getXQueryType();
        try {
            this.iter.open();
        }
        catch (XQRLUserException e) {
            this.excepted = true;
        }
        Assert.assertTrue((String)"Was able to open iterator after getXQueryType() with MatRes closed!", (boolean)this.excepted);
    }
}

