/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc.util;

import com.bea.xquery.exceptions.XQRLException;
import com.bea.xquery.exceptions.XQRLUserException;
import com.bea.xquery.parsers.Parser;
import com.bea.xquery.tokens.BeginAttributeToken;
import com.bea.xquery.tokens.BeginElementToken;
import com.bea.xquery.tokens.CommentToken;
import com.bea.xquery.tokens.NamespaceToken;
import com.bea.xquery.tokens.PCDataToken;
import com.bea.xquery.tokens.PIToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.tokens.TextToken;
import com.bea.xquery.tokens.Token;
import com.bea.xquery.util.HashFactory;
import com.bea.xquery.xdbc.Context;
import com.bea.xquery.xdbc.iterators.TokenIterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import weblogic.apache.xerces.impl.xpath.regex.ParseException;
import weblogic.apache.xerces.impl.xpath.regex.RegularExpression;

public final class Serializer {
    private static final String[] EmptyStrings = new String[0];
    private TokenIterator iterator;
    private Set prefixes = HashFactory.createSet();
    private Writer writer;
    private int nsNum = 0;
    private RegularExpression entityRegexp;

    private void initRegexp() {
        try {
            this.entityRegexp = new RegularExpression("&[#A-Za-z0-9]*;");
        }
        catch (ParseException e) {
            System.out.println("can't init regexp!");
            System.exit(-1);
        }
    }

    public Serializer(TokenIterator iterator, Writer writer) {
        this.initRegexp();
        this.iterator = iterator;
        this.writer = writer;
    }

    public Serializer(TokenIterator iterator) {
        this.initRegexp();
        this.iterator = iterator;
    }

    public Serializer(Writer writer) {
        this.initRegexp();
        this.writer = writer;
    }

    public Serializer() {
        this.initRegexp();
    }

    public synchronized void setIterator(TokenIterator iterator) {
        this.iterator = iterator;
    }

    public synchronized void setWriter(Writer writer) {
        this.writer = writer;
    }

    public synchronized TokenIterator getIterator() {
        return this.iterator;
    }

    public synchronized Writer getWriter() {
        return this.writer;
    }

    private boolean isEntity(String s, int offset) {
        int semicolon = s.indexOf(59, offset);
        if (semicolon > 0) {
            return this.entityRegexp.matches(s.substring(offset, semicolon + 1));
        }
        return false;
    }

    private String normalize(String s, boolean attribute) {
        boolean isSimple = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<' || c == '>' || c == '&' || attribute && (c == '\"' || c == '\'')) {
                isSimple = false;
                break;
            }
            ++i;
        }
        if (isSimple) {
            return s;
        }
        StringBuffer res = new StringBuffer();
        int i2 = 0;
        while (i2 < s.length()) {
            char c = s.charAt(i2);
            switch (c) {
                case '<': {
                    res.append("&lt;");
                    break;
                }
                case '>': {
                    res.append("&gt;");
                    break;
                }
                case '&': {
                    if (this.isEntity(s, i2)) {
                        res.append(c);
                        break;
                    }
                    res.append("&amp;");
                    break;
                }
                case '\"': {
                    if (attribute) {
                        res.append("&quot;");
                        break;
                    }
                    res.append(c);
                    break;
                }
                case '\'': {
                    if (attribute) {
                        res.append("&apos;");
                        break;
                    }
                    res.append(c);
                    break;
                }
                default: {
                    res.append(c);
                }
            }
            ++i2;
        }
        return res.toString();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void process() throws IOException, XQRLException {
        Token t;
        Token last = null;
        while ((t = this.iterator.next()) != null) {
            void var1_2;
            switch (var1_2.getKind()) {
                case 3: {
                    this.writer.write("<?xml version=\"1.0\"?>\n");
                    break;
                }
                case 6: {
                    this.writer.flush();
                    break;
                }
                case 1: {
                    this.processElement(null, (BeginElementToken)var1_2);
                    break;
                }
                case 9: {
                    this.processProcInst((PIToken)var1_2);
                    break;
                }
                case 7: {
                    this.processComment((CommentToken)var1_2);
                    break;
                }
                case 19: {
                    this.writer.write(((PCDataToken)var1_2).toString());
                    break;
                }
                case 10: {
                    this.writer.write(this.normalize(((TextToken)var1_2).getContent().toString(), false));
                    break;
                }
                case 2: {
                    this.printAttribute(null, (BeginAttributeToken)var1_2);
                    break;
                }
                case 8: {
                    this.writer.write(var1_2.toString());
                    break;
                }
                default: {
                    if (Token.Kind.isSimple((Token)var1_2)) {
                        if (last != null && Token.Kind.isSimple(last)) {
                            this.writer.write(32);
                        }
                        this.writer.write(var1_2.toString());
                        break;
                    }
                    throw new XQRLUserException(6504, (Object)("unexpected token: " + Token.Kind.toString(var1_2.getKind())));
                }
            }
            last = var1_2;
        }
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void processElement(Namespaces ns, BeginElementToken e) throws IOException, XQRLException {
        Token t;
        QNameToken qName = e.getQName();
        ns = new Namespaces(ns);
        this.processNamespaces(ns);
        this.writer.write("<" + ns.getQualifiedName(qName));
        ns.process();
        this.processAttributes(ns);
        boolean emptyElement = true;
        if (!emptyElement) {
            this.writer.write(">");
        }
        block7: while ((t = this.iterator.next()) != null && t.getKind() != 4) {
            void var5_5;
            if (emptyElement) {
                this.writer.write(">");
                emptyElement = false;
            }
            switch (var5_5.getKind()) {
                case 1: {
                    this.processElement(ns, (BeginElementToken)var5_5);
                    break;
                }
                case 9: {
                    this.processProcInst((PIToken)var5_5);
                    break;
                }
                case 7: {
                    this.processComment((CommentToken)var5_5);
                    break;
                }
                case 19: {
                    this.writer.write(this.normalize(((PCDataToken)var5_5).toString(), false));
                    break;
                }
                case 10: {
                    this.writer.write(this.normalize(((TextToken)var5_5).getContent().toString(), false));
                    while (Token.Kind.isSimple(this.iterator.peekNext())) {
                        this.iterator.next();
                    }
                    continue block7;
                }
                default: {
                    throw new XQRLUserException(6504, (Object)("unexpected token: " + Token.Kind.toString(var5_5.getKind())));
                }
            }
        }
        if (t.getKind() != 4) {
            throw new XQRLUserException(6504, (Object)("expecting END_ELEMENT, got: " + Token.Kind.toString(t.getKind())));
        }
        if (emptyElement) {
            this.writer.write("/>");
        } else {
            this.writer.write("</" + ns.getQualifiedName(qName) + ">");
        }
    }

    private void processNamespaces(Namespaces ns) throws XQRLException {
        Token t;
        while ((t = this.iterator.peekNext()) != null && t.getKind() == 8) {
            t = this.iterator.next();
            QNameToken q = ((NamespaceToken)t).getQName();
            String prefix = q.getName().toString();
            if (prefix == null) {
                prefix = "";
            }
            ns.setNamespace(prefix, q.getURI().toString());
        }
    }

    private void printAttribute(Namespaces ns, BeginAttributeToken t) throws IOException, XQRLException {
        QNameToken a = t.getQName();
        if (ns != null) {
            this.writer.write(" " + ns.getQualifiedName(a) + "=\"");
        } else {
            this.writer.write(a.getName().toString() + (a.getURI() != null ? '@' + a.getURI().toString() : "") + "=\"");
        }
        boolean isList = false;
        while (this.iterator.peekNext().getKind() != 5) {
            String value = this.normalize(this.iterator.next().toString(), true);
            if (isList) {
                this.writer.write(" " + value);
                continue;
            }
            this.writer.write(value);
            isList = true;
        }
        this.writer.write("\"");
        this.iterator.next();
    }

    private void processAttributes(Namespaces ns) throws IOException, XQRLException {
        Token t;
        while ((t = this.iterator.peekNext()) != null && t.getKind() == 2) {
            t = this.iterator.next();
            this.printAttribute(ns, (BeginAttributeToken)t);
        }
    }

    private void processComment(CommentToken c) throws IOException, XQRLException {
        this.writer.write("<!--" + c.getContent().toString() + "-->");
    }

    private void processProcInst(PIToken p) throws IOException, XQRLException {
        this.writer.write("<?" + p.getQName().getName().toString() + " " + p.getContent().toString() + "?>");
    }

    public static final void main(String[] args) throws Exception {
        try {
            Context baseContext = new Context();
            FileReader r = new FileReader(args[0]);
            BufferedReader br = new BufferedReader(r, 8192);
            Parser p = Parser.createParser((Reader)br, (Context)baseContext);
            p.open();
            PrintWriter pw = new PrintWriter(System.out);
            Serializer s = new Serializer((TokenIterator)p, pw);
            s.process();
            p.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Namespaces {
        private Namespaces parent;
        private Map ns = HashFactory.createMap();

        public Namespaces(Namespaces parent) {
            this.parent = parent;
        }

        public void setNamespace(String prefix, String uri) {
            this.ns.put(uri, prefix);
            Serializer.this.prefixes.add(prefix);
        }

        private String createPrefix() {
            String pfx;
            do {
                pfx = "ns" + Serializer.this.nsNum++;
            } while (Serializer.this.prefixes.contains(pfx));
            Serializer.this.prefixes.add(pfx);
            return pfx;
        }

        private String getPrefix(String uri, boolean create) {
            String prefix = (String)this.ns.get(uri);
            if (prefix != null) {
                return prefix;
            }
            if (this.parent != null) {
                prefix = this.parent.getPrefix(uri, false);
                if (prefix == null && create) {
                    prefix = this.createPrefix();
                    this.ns.put(uri, prefix);
                }
                return prefix;
            }
            if (create) {
                prefix = this.createPrefix();
                this.ns.put(uri, prefix);
                return prefix;
            }
            return null;
        }

        public String getPrefix(String uri) {
            return this.getPrefix(uri, true);
        }

        public String getQualifiedName(QNameToken q) {
            String p = q.hasURI() ? this.getPrefix(q.getURI().toString()) : null;
            if (p != null && p.length() > 0) {
                return p + ":" + q.getName().toString();
            }
            return q.getName().toString();
        }

        public void process() throws IOException {
            String[] uris = this.ns.keySet().toArray(EmptyStrings);
            int i = 0;
            while (i < uris.length) {
                String prefix = (String)this.ns.get(uris[i]);
                if (prefix.length() > 0) {
                    Serializer.this.writer.write(" xmlns:" + prefix + "=\"" + uris[i] + "\"");
                } else {
                    Serializer.this.writer.write(" xmlns=\"" + uris[i] + "\"");
                }
                ++i;
            }
        }
    }
}

