/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc.util;

import com.bea.xquery.exceptions.XQRLException;
import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.exceptions.XQRLUserException;
import com.bea.xquery.iterators.MaterializedTokenStream;
import com.bea.xquery.tokens.Token;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.util.HashFactory;
import com.bea.xquery.xdbc.iterators.TokenIterator;
import java.util.Set;

public final class MaterializedQueryResults {
    private TokenIterator m_source;
    private MaterializedTokenStream m_tokenStream;
    private boolean m_closed;
    private boolean m_eager;
    private Set m_clients;

    public MaterializedQueryResults(TokenIterator inSource) throws XQRLException {
        this(inSource, false);
    }

    public MaterializedQueryResults(TokenIterator inSource, boolean inEager) throws XQRLException {
        this.m_source = inSource;
        this.m_source.open();
        this.m_tokenStream = new MaterializedTokenStream(this.m_source, inEager);
        this.m_eager = inEager;
        if (inEager) {
            this.m_source.close();
        }
        this.m_closed = false;
        this.m_clients = HashFactory.createSet();
    }

    public TokenIterator createIterator() throws XQRLUserException, XQRLSystemException {
        return new QueryResultIterator(this.m_tokenStream.createIterator());
    }

    public void close() throws XQRLException {
        this.m_closed = true;
        this.cleanup();
    }

    public boolean isOpen() {
        return !this.m_closed;
    }

    private void cleanup() throws XQRLException {
        if (this.m_source != null && this.m_source.isOpen() && this.m_closed && this.m_clients.size() == 0) {
            this.m_source.close();
        }
    }

    void register(QueryResultIterator iterator) throws XQRLUserException {
        if (!this.m_eager && !this.m_clients.contains(iterator) && this.m_closed) {
            throw new XQRLUserException(2035);
        }
        this.m_clients.add(iterator);
    }

    void deRegister(QueryResultIterator iterator) throws XQRLException {
        if (!this.m_clients.remove(iterator)) {
            throw new XQRLSystemException(1039);
        }
        this.cleanup();
    }

    private final class QueryResultIterator
    implements TokenIterator {
        private TokenIterator m_iter;

        QueryResultIterator(TokenIterator inRealIterator) throws XQRLUserException {
            this.m_iter = inRealIterator;
            MaterializedQueryResults.this.register(this);
        }

        public XQueryType getXQueryType() throws XQRLException {
            MaterializedQueryResults.this.register(this);
            XQueryType return_type = this.m_iter.getXQueryType();
            MaterializedQueryResults.this.deRegister(this);
            return return_type;
        }

        public void open() throws XQRLException {
            MaterializedQueryResults.this.register(this);
            this.m_iter.open();
        }

        public boolean isOpen() {
            return this.m_iter.isOpen();
        }

        public boolean hasNext() throws XQRLException {
            return this.m_iter.hasNext();
        }

        public Token peekNext() throws XQRLException {
            return this.m_iter.peekNext();
        }

        public Token next() throws XQRLException {
            return this.m_iter.next();
        }

        public void skipToNextNode() throws XQRLException {
            this.m_iter.skipToNextNode();
        }

        public void close() throws XQRLException {
            this.m_iter.close();
            MaterializedQueryResults.this.deRegister(this);
        }

        public void setName(String name) {
            this.m_iter.setName(name);
        }

        public String getName() {
            return this.m_iter.getName();
        }

        public void setBeginTokenIndex(int i) {
        }

        public void setEndTokenIndex(int i) {
        }
    }
}

