/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc.iterators;

import com.bea.xquery.compiler.NameTest;
import com.bea.xquery.exceptions.XQRLException;
import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.iterators.GenericIterator;
import com.bea.xquery.tokens.Identifier;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.tokens.Token;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.types.XQueryTypeAttributeNode;
import com.bea.xquery.types.XQueryTypeElementNode;
import com.bea.xquery.types.XQueryTypeNode;
import com.bea.xquery.xdbc.iterators.TokenIterator;

public class RangeIterator
extends GenericIterator {
    private TokenIterator m_iterator;
    protected int m_count;

    public RangeIterator() {
        super(null);
    }

    public RangeIterator(TokenIterator iterator) {
        super(null);
        this.bind(iterator);
    }

    public final void bind(TokenIterator iterator) {
        this.m_open = false;
        this.m_count = 0;
        this.m_iterator = iterator;
    }

    public XQueryType getXQueryType() throws XQRLException {
        this.open();
        Token t1 = this.next();
        if (t1 == null) {
            this.close();
            return XQueryType.EMPTY;
        }
        if (Token.Kind.isSimple(t1)) {
            this.close();
            return t1.getXQueryType(this.m_context);
        }
        if (Token.Kind.isNode(t1)) {
            switch (t1.getKind()) {
                case 1: {
                    QNameToken t2 = (QNameToken)this.next();
                    NameTest nameTest = t2.hasURI() ? new NameTest(0, t2.getURI(), t2.getName()) : new NameTest(4, t2.getName());
                    this.close();
                    return XQueryType.of((XQueryTypeNode)XQueryTypeElementNode.of((NameTest)nameTest, (boolean)false, (boolean)false, null, null));
                }
                case 2: {
                    QNameToken t2 = (QNameToken)this.next();
                    NameTest nameTest = t2.hasURI() ? new NameTest(0, t2.getURI(), t2.getName()) : new NameTest(4, t2.getName());
                    this.close();
                    return XQueryType.of((XQueryTypeNode)XQueryTypeAttributeNode.of((NameTest)nameTest, (boolean)true, null));
                }
                case 10: {
                    this.close();
                    return XQueryType.TEXT;
                }
            }
            this.close();
            return XQueryType.ANYTYPE;
        }
        this.close();
        throw new XQRLSystemException(5001);
    }

    protected void doSkip() throws XQRLException {
        this.m_iterator.skipToNextNode();
        this.m_count = this.m_count < 2 ? -1 : --this.m_count;
    }

    public Token fetchNext() throws XQRLException {
        if (this.m_count != -1) {
            Token r = this.m_iterator.next();
            if (Token.Kind.isNested(r)) {
                ++this.m_count;
            } else if (Token.Kind.isEnd(r)) {
                --this.m_count;
            }
            if (this.m_count == 0) {
                this.m_count = -1;
            }
            return r;
        }
        return null;
    }

    public void exhaust(Identifier id) throws XQRLException {
        if (id == null) {
            this.exhaust();
        } else {
            if (!this.m_iterator.hasNext()) {
                this.m_count = -1;
            }
            while (this.m_count != -1) {
                Token t = this.fetchNext();
                if (id == null || !Token.Kind.isNode(t)) continue;
                id.simNextId();
            }
        }
    }

    public final void exhaust() throws XQRLException {
        if (!this.m_iterator.hasNext()) {
            this.m_count = -1;
        }
        if (this.m_count == 0) {
            Token t = this.next();
            this.m_count = Token.Kind.isNested(t) ? 1 : -1;
        }
        int i = 0;
        while (i < this.m_count) {
            this.m_iterator.skipToNextNode();
            ++i;
        }
        this.m_count = -1;
    }

    public void skipItem(TokenIterator ioIter, Identifier id) throws XQRLException {
        Token tok = ioIter.peekNext();
        if (Token.Kind.isNode(tok)) {
            this.bind(ioIter);
            this.open();
            if (id != null) {
                this.exhaust(id);
            } else {
                this.exhaust();
            }
            this.close();
        } else if (Token.Kind.isSimple(tok)) {
            ioIter.next();
        } else {
            throw new XQRLSystemException(1036, (Object)tok);
        }
    }

    public void skipItem(TokenIterator ioIter) throws XQRLException {
        this.skipItem(ioIter, null);
    }
}

