/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc;

import com.bea.xquery.exceptions.XQRLException;
import com.bea.xquery.exceptions.XQRLUserException;
import com.bea.xquery.util.HashFactory;
import com.bea.xquery.xdbc.Connection;
import com.bea.xquery.xdbc.Context;
import com.bea.xquery.xdbcimpl.XQRLConnection;
import java.util.Map;

public class DriverManager {
    static DriverManager driverManager = new DriverManager();
    private final Map table = HashFactory.createMap();

    private DriverManager() {
    }

    public static synchronized Connection getConnection(String uri, boolean shareTypes) throws XQRLUserException {
        Context theContext = (Context)DriverManager.driverManager.table.get(uri);
        if (theContext == null) {
            throw new XQRLUserException(5503, (Object)uri);
        }
        theContext = new Context(theContext);
        return new XQRLConnection(theContext);
    }

    public static synchronized Connection getConnection(Connection parent, boolean shareTypes) throws XQRLUserException {
        if (parent == null) {
            throw new XQRLUserException(5504);
        }
        return new XQRLConnection(new Context(((XQRLConnection)parent).getContext()));
    }

    public static Connection getConnection() throws XQRLException {
        return new XQRLConnection(new Context());
    }

    public static synchronized void publish(String uri, Connection c) throws XQRLUserException {
        if (c == null) {
            throw new XQRLUserException(5504);
        }
        if (DriverManager.driverManager.table.get(uri) != null) {
            throw new XQRLUserException(5505, (Object)uri);
        }
        DriverManager.driverManager.table.put(uri, ((XQRLConnection)c).getContext());
    }
}

