/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.xdbc;

import com.bea.xquery.compiler.CompilerConstants;
import com.bea.xquery.compiler.Variable;
import com.bea.xquery.compiler.parser.Parser;
import com.bea.xquery.exceptions.DefaultErrorHandler;
import com.bea.xquery.exceptions.ErrorHandler;
import com.bea.xquery.exceptions.XQRLException;
import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.exceptions.XQRLUserException;
import com.bea.xquery.operators.Operator;
import com.bea.xquery.resolvers.XQueryEntityResolver;
import com.bea.xquery.runtime.collation.XQueryCollator;
import com.bea.xquery.runtime.nodeids.IdManager;
import com.bea.xquery.runtime.util.OperatorMap;
import com.bea.xquery.schema.XQuerySchemaManager;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.tokens.TokenFactory;
import com.bea.xquery.tokens.URIToken;
import com.bea.xquery.types.XQueryTypeManager;
import com.bea.xquery.util.HashFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.EntityResolver;

public class Context {
    public static final char NAMESPACE = '\u0000';
    public static final char VARIABLE = '\u0001';
    public static final char OPERATOR = '\u0002';
    public static final char DEFAULT = '\u0003';
    public static final char RECURSION_LEVEL = '\u0004';
    public static final char COLLATOR = '\u0005';
    public static final char TIMESTAMP = '\u0006';
    public static final char COUNTER = '\u0007';
    public static final char JDBCCONNECTION = '\b';
    public static final String ELEMENT = "element";
    public static final String FUNCTION = "function";
    public static final String COLLATION = "collation";
    public static final String WHITESPACES = "whitespaces";
    public static final String XMLSPACE = "xmlspace";
    public static final String COMMENTS = "comments";
    public static final String NOW = "now";
    public static final String NODEIDS = "nodeid";
    private ErrorHandler m_errorHandler = null;
    private Managers managers = null;
    private OperatorMaps maps = null;
    private Context parent;
    private static final Context staticContext;
    private EntityResolver resolver;
    private Map values = HashFactory.createMap();
    private static final String[] names;
    static /* synthetic */ Class class$com$bea$xquery$xdbc$Context;

    public Context(Context parent) {
        this.parent = parent == null ? staticContext : parent;
        this.managers = new Managers(this);
        this.maps = staticContext == null ? new OperatorMaps() : this.parent.maps;
        this.resolver = this.parent != null && this.parent.getEntityResolver() != null ? this.parent.getEntityResolver() : new XQueryEntityResolver();
        this.m_errorHandler = this.parent != null && this.parent.getErrorHandler() != null ? this.parent.getErrorHandler() : new DefaultErrorHandler();
        this.setGenerateNodeIdsForResult(new Boolean(false));
        this.setWhitespaceHandling(Boolean.FALSE);
        this.setCommentsHandling(Boolean.FALSE);
    }

    public Context() {
        this(null);
    }

    public void addCollator(String URI2, XQueryCollator collator) throws XQRLException {
        if (this.getLocalValue('\u0005', URI2) != null) {
            XQRLUserException e = new XQRLUserException(4513, (Object)URI2);
            this.getErrorHandler().error(e);
        }
        this.setValue('\u0005', URI2, collator);
    }

    public void addCollator(String URI2, String collatorClass) throws XQRLException {
        XQueryCollator collator;
        try {
            Class<?> clss = Class.forName(collatorClass);
            collator = (XQueryCollator)clss.newInstance();
        }
        catch (Exception ex) {
            throw new XQRLSystemException(3504, (Object)collatorClass, (Object)ex);
        }
        this.addCollator(URI2, collator);
    }

    public void addNamespace(String prefix, String URI2) throws XQRLException {
        if (this.getLocalValue('\u0000', prefix) != null) {
            XQRLUserException e = new XQRLUserException(4506, (Object)prefix);
            this.getErrorHandler().error(e);
        }
        this.setValue('\u0000', prefix, TokenFactory.createURI(URI2));
    }

    public void addOperator(Operator operator) throws XQRLException {
        String key = operator.getName().toString() + operator.getSignature().getInputTypes().size();
        this.setValue('\u0002', key, operator);
        if (operator.implementsComparisonOperator()) {
            this.maps.cmp.addFunction(this, operator);
        }
        if (operator.implementsArithmeticOperator()) {
            this.maps.arith.addFunction(this, operator);
        }
    }

    public void addVariable(Variable variable) throws XQRLUserException {
        if (this.getLocalValue('\u0001', variable.toString()) != null) {
            XQRLUserException e = new XQRLUserException(4504, (Object)variable.getName());
            this.getErrorHandler().fatalError(e);
        }
        this.setValue('\u0001', variable.toString(), variable);
    }

    public void addJdbcConnection(String name, Connection conn) throws XQRLException {
        if (this.getJdbcConnection(name) != null) {
            XQRLUserException e = new XQRLUserException(4515, (Object)name);
            this.getErrorHandler().fatalError(e);
        }
        this.setValue('\b', name, conn);
    }

    public OperatorMap getCmpMap() {
        return this.maps.cmp;
    }

    public OperatorMap getArithMap() {
        return this.maps.arith;
    }

    public XQueryCollator getCollator(URIToken inCollationURI) throws XQRLException {
        XQueryCollator result = (XQueryCollator)this.getValue('\u0005', inCollationURI.toString());
        if (result == null) {
            XQRLUserException e = new XQRLUserException(4514, (Object)inCollationURI);
            this.getErrorHandler().fatalError(e);
        }
        return result;
    }

    public Boolean getCommentsHandling() {
        return (Boolean)this.getValue('\u0003', COMMENTS);
    }

    public boolean getGenerateNodeIdsForResult() {
        return (Boolean)this.getValue('\u0003', NODEIDS);
    }

    public Calendar getCurrentTime() throws XQRLSystemException {
        Calendar cal = (Calendar)this.getValue('\u0006', NOW);
        if (cal == null) {
            throw new XQRLSystemException(3503);
        }
        return cal;
    }

    public URIToken getDefaultCollation() throws XQRLSystemException {
        URIToken result = (URIToken)this.getValue('\u0003', COLLATION);
        return result != null ? result : CompilerConstants.UNICODE_COLLATION_URI;
    }

    public XQueryCollator getDefaultCollator() throws XQRLException {
        return this.getCollator(this.getDefaultCollation());
    }

    public URIToken getDefaultElementNamespace() {
        return (URIToken)this.getValue('\u0003', ELEMENT);
    }

    public URIToken getDefaultFunctionNamespace() {
        return (URIToken)this.getValue('\u0003', FUNCTION);
    }

    public Boolean getDefaultStripXmlSpace() throws XQRLSystemException {
        Boolean result = (Boolean)this.getValue('\u0003', XMLSPACE);
        return result != null ? result : new Boolean(true);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver != null ? this.resolver : this.parent.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    public IdManager getIdManager() {
        return this.managers.idManager;
    }

    public Connection getJdbcConnection(String name) {
        Connection con = (Connection)this.getValue('\b', name);
        if (con == null) {
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                con = DriverManager.getConnection("jdbc:mysql://localhost/test");
            }
            catch (Exception e) {
                throw new Error("cannot load JDBC driver" + e.toString());
            }
        }
        return con;
    }

    public Operator getLocalOperator(QNameToken qname, int args) {
        String key = qname.toString() + args;
        return (Operator)this.getLocalValue('\u0002', key);
    }

    public URIToken getNamespace(String prefix) {
        return (URIToken)this.getValue('\u0000', prefix);
    }

    public Operator getOperator(QNameToken name, int args) throws XQRLUserException {
        return (Operator)this.getValue('\u0002', name.toString() + args);
    }

    public String getPrefix(String URI2) {
        if (this == staticContext) {
            return null;
        }
        Iterator it = this.values.entrySet().iterator();
        while (it.hasNext()) {
            ContextEntry entry = (ContextEntry)it.next().getValue();
            if (entry.type != '\u0000' || !entry.value.toString().equals(URI2)) continue;
            return entry.name;
        }
        return this.getParent().getPrefix(URI2);
    }

    public XQuerySchemaManager getSchemaManager() {
        return this.managers.schemaManager;
    }

    public int[] getTimeZone() throws XQRLSystemException {
        Calendar cal = this.getCurrentTime();
        int offset = (cal.get(15) + cal.get(16)) / 1000 / 60;
        int hours = offset / 60;
        int minutes = offset % 60;
        return new int[]{hours, minutes};
    }

    public XQueryTypeManager getTypeManager() {
        return this.managers.typeManager;
    }

    public Boolean getWhitespaceHandling() {
        return (Boolean)this.getValue('\u0003', WHITESPACES);
    }

    public Variable getVariable(String name) {
        return (Variable)this.getValue('\u0001', name);
    }

    public synchronized int incAndGetCounter(String inCounterName) {
        Counter counter = (Counter)this.getValue('\u0007', inCounterName);
        if (counter == null) {
            counter = new Counter();
            this.setValue('\u0007', inCounterName, counter);
        }
        return counter.incAndGet();
    }

    public String toString() {
        String result = this.localToString();
        if (this.parent != null) {
            result = result + this.parent.toString();
        }
        return result;
    }

    public void setCommentsHandling(Boolean value) {
        this.setValue('\u0003', COMMENTS, value);
    }

    public void setGenerateNodeIdsForResult(Boolean value) {
        this.setValue('\u0003', NODEIDS, value);
    }

    public void setCurrentTime() {
        Calendar cal = Calendar.getInstance();
        this.setValue('\u0006', NOW, cal);
    }

    public void setDefaultCollation(String URI2) throws XQRLSystemException, XQRLUserException {
        if (this.getDefaultCollation() != CompilerConstants.UNICODE_COLLATION_URI) {
            XQRLUserException e = new XQRLUserException(4512);
            this.getErrorHandler().error(e);
        }
        this.setValue('\u0003', COLLATION, TokenFactory.createURI(URI2));
    }

    public void setDefaultElementNamespace(String URI2) throws XQRLSystemException {
        this.setValue('\u0003', ELEMENT, TokenFactory.createURI(URI2));
    }

    public void setDefaultFunctionNamespace(String URI2) throws XQRLSystemException {
        this.setValue('\u0003', FUNCTION, TokenFactory.createURI(URI2));
    }

    public void setDefaultStripXmlSpace(Boolean value) throws XQRLSystemException {
        this.setValue('\u0003', XMLSPACE, value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            throw new NullPointerException("ErrorHandler cannot be null");
        }
        this.m_errorHandler = eh;
    }

    public void setWhitespaceHandling(Boolean value) {
        this.setValue('\u0003', WHITESPACES, value);
    }

    private Object getLocalValue(String key) {
        ContextEntry ctx = (ContextEntry)this.values.get(key);
        return ctx != null ? ctx.value : null;
    }

    private Object getLocalValue(char type, String name) {
        return this.getLocalValue(Context.makeInternalKey(type, name));
    }

    public Context getParent() {
        return this.parent;
    }

    private Object getValue(String key) {
        ContextEntry entry = (ContextEntry)this.values.get(key);
        if (entry != null) {
            return entry.value;
        }
        if (this.parent != null) {
            return this.parent.getValue(key);
        }
        return null;
    }

    private Object getValue(char type, String name) {
        return this.getValue(Context.makeInternalKey(type, name));
    }

    private String localToString() {
        String result = "\n*****************************************************";
        Collection collection = this.values.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ContextEntry entry = (ContextEntry)iterator.next();
            result = result + "\n" + entry.toString();
        }
        result = result + "\n*****************************************************";
        return result;
    }

    private static String makeInternalKey(char type, String name) {
        StringBuffer sb = new StringBuffer(name.length() + 2);
        sb.append(type);
        sb.append(name);
        return sb.toString();
    }

    private void removeValue(char type, String name) {
        this.values.remove(Context.makeInternalKey(type, name));
    }

    private void setValue(char type, String name, Object value) {
        ContextEntry entry = new ContextEntry(type, name, value);
        this.values.put(entry.internalKey, entry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        names = new String[]{"Namespace", "Variable", "Operator", "Default", "Recursion level", "Collator", "Timestamp", "Counter"};
        Context sc = null;
        try {
            sc = new Context();
            String resourceName = "com/bea/xquery/context/BaseContext.decl";
            InputStream iStream = (class$com$bea$xquery$xdbc$Context == null ? (class$com$bea$xquery$xdbc$Context = Context.class$("com.bea.xquery.xdbc.Context")) : class$com$bea$xquery$xdbc$Context).getClassLoader().getResourceAsStream(resourceName);
            if (iStream == null) {
                throw new XQRLSystemException(3501);
            }
            InputStreamReader reader = new InputStreamReader(iStream);
            try {
                Parser.initializeBaseContext((InputStreamReader)reader, (Context)sc);
            }
            catch (XQRLException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XQRLSystemException(999, (Object)e.getMessage());
            }
            CompilerConstants.init((Context)sc);
        }
        catch (Exception e) {
            System.err.println("tough luck, can't init constants! " + e);
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        staticContext = sc;
        try {
            staticContext.getSchemaManager().addSchema(TokenFactory.createURI("http://www.w3.org/2002/08/xquery-functions"), TokenFactory.createURI("rsrc://com/bea/xquery/context/xqrl-types.xsd"));
        }
        catch (Exception e) {
            System.err.println("tough luck, can't init basic schema! " + e);
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private static class OperatorMaps {
        OperatorMap cmp = new OperatorMap();
        OperatorMap arith = new OperatorMap();

        private OperatorMaps() {
        }
    }

    private static final class Managers {
        private IdManager idManager;
        private XQuerySchemaManager schemaManager;
        private XQueryTypeManager typeManager;

        Managers(Context context) {
            if (staticContext != null) {
                this.idManager = new IdManager();
                this.typeManager = new XQueryTypeManager(context.getParent().getTypeManager());
            } else {
                this.idManager = null;
                this.typeManager = new XQueryTypeManager();
            }
            this.schemaManager = new XQuerySchemaManager(context);
        }
    }

    private static final class ContextEntry {
        public char type;
        public String name;
        public Object value;
        private String internalKey;

        public ContextEntry(char type, String name, Object value) {
            this.type = type;
            this.name = name;
            this.value = value;
            this.internalKey = Context.makeInternalKey(type, name);
        }

        public boolean equals(Object o) {
            if (o instanceof ContextEntry) {
                ContextEntry e = (ContextEntry)o;
                return e.type == this.type && e.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.internalKey.hashCode();
        }

        public String toString() {
            return "[" + names[this.type] + "] " + this.name + "=" + this.value.toString();
        }
    }

    class Counter {
        private int m_counter = 0;

        Counter() {
        }

        synchronized int incAndGet() {
            return this.m_counter++;
        }
    }
}

