/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.tokens.BEA_Base64Token;
import com.bea.xquery.tokens.BEA_BeginAttributeToken;
import com.bea.xquery.tokens.BEA_BeginDocumentToken;
import com.bea.xquery.tokens.BEA_BeginElementToken;
import com.bea.xquery.tokens.BEA_BooleanToken;
import com.bea.xquery.tokens.BEA_CommentToken;
import com.bea.xquery.tokens.BEA_DateTimeToken;
import com.bea.xquery.tokens.BEA_DateToken;
import com.bea.xquery.tokens.BEA_DayTimeDurationToken;
import com.bea.xquery.tokens.BEA_DayToken;
import com.bea.xquery.tokens.BEA_DecimalToken;
import com.bea.xquery.tokens.BEA_DoubleToken;
import com.bea.xquery.tokens.BEA_DurationToken;
import com.bea.xquery.tokens.BEA_EndAttributeToken;
import com.bea.xquery.tokens.BEA_EndDocumentToken;
import com.bea.xquery.tokens.BEA_EndElementToken;
import com.bea.xquery.tokens.BEA_FloatToken;
import com.bea.xquery.tokens.BEA_GotoToken;
import com.bea.xquery.tokens.BEA_HexBinaryToken;
import com.bea.xquery.tokens.BEA_IntegerToken;
import com.bea.xquery.tokens.BEA_MonthDayToken;
import com.bea.xquery.tokens.BEA_MonthToken;
import com.bea.xquery.tokens.BEA_NamespaceToken;
import com.bea.xquery.tokens.BEA_PCDataToken;
import com.bea.xquery.tokens.BEA_PIToken;
import com.bea.xquery.tokens.BEA_QNameToken;
import com.bea.xquery.tokens.BEA_StringToken;
import com.bea.xquery.tokens.BEA_TextToken;
import com.bea.xquery.tokens.BEA_TimeToken;
import com.bea.xquery.tokens.BEA_URIToken;
import com.bea.xquery.tokens.BEA_YearMonthDurationToken;
import com.bea.xquery.tokens.BEA_YearMonthToken;
import com.bea.xquery.tokens.BEA_YearToken;
import com.bea.xquery.tokens.Base64Token;
import com.bea.xquery.tokens.BeginAttributeToken;
import com.bea.xquery.tokens.BeginDocumentToken;
import com.bea.xquery.tokens.BeginElementToken;
import com.bea.xquery.tokens.BooleanToken;
import com.bea.xquery.tokens.CommentToken;
import com.bea.xquery.tokens.DateTimeToken;
import com.bea.xquery.tokens.DateToken;
import com.bea.xquery.tokens.DayTimeDurationToken;
import com.bea.xquery.tokens.DayToken;
import com.bea.xquery.tokens.DecimalToken;
import com.bea.xquery.tokens.DoubleToken;
import com.bea.xquery.tokens.DurationToken;
import com.bea.xquery.tokens.EndAttributeToken;
import com.bea.xquery.tokens.EndDocumentToken;
import com.bea.xquery.tokens.EndElementToken;
import com.bea.xquery.tokens.FloatToken;
import com.bea.xquery.tokens.GotoToken;
import com.bea.xquery.tokens.HexBinaryToken;
import com.bea.xquery.tokens.Identifier;
import com.bea.xquery.tokens.IntegerToken;
import com.bea.xquery.tokens.MonthDayToken;
import com.bea.xquery.tokens.MonthToken;
import com.bea.xquery.tokens.NamespaceToken;
import com.bea.xquery.tokens.NodeToken;
import com.bea.xquery.tokens.PCDataToken;
import com.bea.xquery.tokens.PIToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.tokens.StringToken;
import com.bea.xquery.tokens.TextToken;
import com.bea.xquery.tokens.TimeToken;
import com.bea.xquery.tokens.Token;
import com.bea.xquery.tokens.URIToken;
import com.bea.xquery.tokens.YearMonthDurationToken;
import com.bea.xquery.tokens.YearMonthToken;
import com.bea.xquery.tokens.YearToken;
import com.bea.xquery.xdbc.iterators.TokenIterator;
import java.math.BigDecimal;

public final class TokenFactory {
    public static Base64Token createBase64(byte[] value) {
        return BEA_Base64Token.create(value, null);
    }

    public static Base64Token createBase64(byte[] value, QNameToken qName) {
        return BEA_Base64Token.create(value, qName);
    }

    public static Base64Token createBase64(String value) {
        return BEA_Base64Token.create(value, null);
    }

    public static Base64Token createBase64(String value, QNameToken qName) {
        return BEA_Base64Token.create(value, qName);
    }

    public static BeginAttributeToken createBeginAttribute(QNameToken qName) {
        return TokenFactory.createBeginAttribute(qName, null, null);
    }

    public static BeginAttributeToken createBeginAttribute(QNameToken qName, QNameToken type) {
        return TokenFactory.createBeginAttribute(qName, type, null);
    }

    public static BeginAttributeToken createBeginAttribute(QNameToken qName, QNameToken type, Identifier id) {
        return BEA_BeginAttributeToken.create(qName, type, id);
    }

    public static BeginDocumentToken createBeginDocument(URIToken uri, StringToken encoding) {
        return TokenFactory.createBeginDocument(uri, encoding, null);
    }

    public static BeginDocumentToken createBeginDocument(URIToken uri, StringToken encoding, Identifier id) {
        return BEA_BeginDocumentToken.create(uri, encoding, id);
    }

    public static BeginElementToken createBeginElement(QNameToken qName, QNameToken type) {
        return TokenFactory.createBeginElement(qName, type, null);
    }

    public static BeginElementToken createBeginElement(QNameToken qName, QNameToken type, Identifier id) {
        return BEA_BeginElementToken.create(qName, type, id);
    }

    public static BooleanToken createBoolean(boolean value) {
        return TokenFactory.createBoolean(value, null);
    }

    public static BooleanToken createBoolean(boolean value, QNameToken qName) {
        return BEA_BooleanToken.create(value, qName);
    }

    public static CommentToken createComment(PCDataToken value) throws XQRLSystemException {
        return TokenFactory.createComment(value, null);
    }

    public static CommentToken createComment(PCDataToken value, Identifier id) throws XQRLSystemException {
        return BEA_CommentToken.create(value, id);
    }

    public static DateToken createDate(int[] value) {
        return TokenFactory.createDate(value, (QNameToken)null);
    }

    public static DateToken createDate(int[] value, QNameToken qName) {
        return BEA_DateToken.create(value, qName);
    }

    public static DateToken createDate(int[] value, int[] timeZone) {
        return TokenFactory.createDate(value, timeZone, null);
    }

    public static DateToken createDate(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_DateToken.create(value, timeZone, qName);
    }

    public static DateToken createDate(String value) {
        return TokenFactory.createDate(value, null);
    }

    public static DateToken createDate(String value, QNameToken qName) {
        return BEA_DateToken.create(value, qName);
    }

    public static DateTimeToken createDateTime(int[] value) {
        return BEA_DateTimeToken.create(value, null);
    }

    public static DateTimeToken createDateTime(int[] value, int[] timeZone) {
        return TokenFactory.createDateTime(value, timeZone, null);
    }

    public static DateTimeToken createDateTime(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_DateTimeToken.create(value, timeZone, qName);
    }

    public static DateTimeToken createDateTime(String value) {
        return TokenFactory.createDateTime(value, null);
    }

    public static DateTimeToken createDateTime(String value, QNameToken qName) {
        return BEA_DateTimeToken.create(value, qName);
    }

    public static DayToken createDay(int[] value) {
        return TokenFactory.createDay(value, (QNameToken)null);
    }

    public static DayToken createDay(int[] value, int[] timeZone) {
        return TokenFactory.createDay(value, timeZone, null);
    }

    public static DayToken createDay(int[] value, QNameToken qName) {
        return BEA_DayToken.create(value, qName);
    }

    public static DayToken createDay(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_DayToken.create(value, timeZone, qName);
    }

    public static DayTimeDurationToken createDayTimeDuration(int[] value) {
        return TokenFactory.createDayTimeDuration(value, null);
    }

    public static DayTimeDurationToken createDayTimeDuration(int[] value, QNameToken qName) {
        return (DayTimeDurationToken)((Object)BEA_DayTimeDurationToken.create(value, qName));
    }

    public static DecimalToken createDecimal(BigDecimal value) {
        return TokenFactory.createDecimal(value, null);
    }

    public static DecimalToken createDecimal(BigDecimal value, QNameToken qName) {
        return BEA_DecimalToken.create(value, qName);
    }

    public static DecimalToken createDecimal(IntegerToken value) {
        return TokenFactory.createDecimal(value, null);
    }

    public static DecimalToken createDecimal(IntegerToken value, QNameToken qName) {
        return BEA_DecimalToken.create(value, qName);
    }

    public static DoubleToken createDouble(double value) {
        return TokenFactory.createDouble(value, null);
    }

    public static DoubleToken createDouble(double value, QNameToken qName) {
        return BEA_DoubleToken.create(value, qName);
    }

    public static DurationToken createDuration(int[] value) {
        return TokenFactory.createDuration(value, null);
    }

    public static DurationToken createDuration(int[] value, QNameToken qName) {
        return BEA_DurationToken.create(value, qName);
    }

    public static DurationToken createDuration(String value) {
        return TokenFactory.createDuration(value, null);
    }

    public static DurationToken createDuration(String value, QNameToken qName) {
        return BEA_DurationToken.create(value, qName);
    }

    public static EndAttributeToken createEndAttribute() {
        return BEA_EndAttributeToken.create();
    }

    public static EndDocumentToken createEndDocument() {
        return BEA_EndDocumentToken.create();
    }

    public static EndElementToken createEndElement() {
        return BEA_EndElementToken.create();
    }

    public static FloatToken createFloat(double value) {
        return TokenFactory.createFloat(value, null);
    }

    public static FloatToken createFloat(double value, QNameToken qName) {
        return BEA_FloatToken.create(value, qName);
    }

    public static GotoToken createGoto(TokenIterator source) throws XQRLSystemException {
        return new BEA_GotoToken(source);
    }

    public static HexBinaryToken createHexBinary(byte[] value) {
        return TokenFactory.createHexBinary(value, null);
    }

    public static HexBinaryToken createHexBinary(byte[] value, QNameToken qName) {
        return BEA_HexBinaryToken.create(value, qName);
    }

    public static HexBinaryToken createHexBinary(String value) {
        return TokenFactory.createHexBinary(value, null);
    }

    public static HexBinaryToken createHexBinary(String value, QNameToken qName) {
        return BEA_HexBinaryToken.create(value, qName);
    }

    public static IntegerToken createInteger(long value) {
        return TokenFactory.createInteger(value, null);
    }

    public static IntegerToken createInteger(long value, QNameToken qName) {
        return BEA_IntegerToken.create(value, qName);
    }

    public static MonthToken createMonth(int[] value) {
        return TokenFactory.createMonth(value, (QNameToken)null);
    }

    public static MonthToken createMonth(int[] value, int[] timeZone) {
        return TokenFactory.createMonth(value, timeZone, null);
    }

    public static MonthToken createMonth(int[] value, QNameToken qName) {
        return BEA_MonthToken.create(value, qName);
    }

    public static MonthToken createMonth(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_MonthToken.create(value, timeZone, qName);
    }

    public static MonthToken createMonth(String value) {
        return TokenFactory.createMonth(value, null);
    }

    public static MonthToken createMonth(String value, QNameToken qName) {
        return BEA_MonthToken.create(value, qName);
    }

    public static MonthDayToken createMonthDay(int[] value) {
        return TokenFactory.createMonthDay(value, (QNameToken)null);
    }

    public static MonthDayToken createMonthDay(int[] value, int[] timeZone) {
        return TokenFactory.createMonthDay(value, timeZone, null);
    }

    public static MonthDayToken createMonthDay(int[] value, QNameToken qName) {
        return BEA_MonthDayToken.create(value, qName);
    }

    public static MonthDayToken createMonthDay(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_MonthDayToken.create(value, timeZone, qName);
    }

    public static MonthDayToken createMonthDay(String value) {
        return TokenFactory.createMonthDay(value, null);
    }

    public static MonthDayToken createMonthDay(String value, QNameToken qName) {
        return BEA_MonthDayToken.create(value, qName);
    }

    public static NamespaceToken createNamespace(QNameToken qName) throws XQRLSystemException {
        return TokenFactory.createNamespace(qName, null);
    }

    public static NamespaceToken createNamespace(QNameToken qName, Identifier id) throws XQRLSystemException {
        return BEA_NamespaceToken.create(qName, id);
    }

    public static NodeToken createNode(Token t, Identifier id) throws XQRLSystemException {
        short kind = t.getKind();
        switch (kind) {
            case 2: {
                BeginAttributeToken b = (BeginAttributeToken)t;
                return TokenFactory.createBeginAttribute(b.getQName(), b.getTypeQName(), id);
            }
            case 3: {
                BeginDocumentToken b = (BeginDocumentToken)t;
                return TokenFactory.createBeginDocument(b.getBaseURI(), b.getEncoding(), id);
            }
            case 1: {
                BeginElementToken b = (BeginElementToken)t;
                return TokenFactory.createBeginElement(b.getQName(), b.getTypeQName(), id);
            }
            case 7: {
                return TokenFactory.createComment(((CommentToken)t).getContent(), id);
            }
            case 8: {
                return TokenFactory.createNamespace(((NamespaceToken)t).getQName(), id);
            }
            case 9: {
                PIToken p = (PIToken)t;
                return TokenFactory.createPI(p.getQName(), p.getContent(), id);
            }
            case 10: {
                return TokenFactory.createText(((TextToken)t).getContent(), id);
            }
        }
        throw new XQRLSystemException(1000, (Object)Token.Kind.toString(kind));
    }

    public static PCDataToken createPCData(char[] data) throws XQRLSystemException {
        return TokenFactory.createPCData(data, 0, data.length);
    }

    public static PCDataToken createPCData(char[] data, int offset, int length) throws XQRLSystemException {
        return BEA_PCDataToken.create(data, offset, length);
    }

    public static PCDataToken createPCData(String data) throws XQRLSystemException {
        return BEA_PCDataToken.create(data);
    }

    public static PCDataToken createPCData(StringBuffer data) throws XQRLSystemException {
        return BEA_PCDataToken.create(data);
    }

    public static PIToken createPI(QNameToken qName, PCDataToken content) throws XQRLSystemException {
        return TokenFactory.createPI(qName, content, null);
    }

    public static PIToken createPI(QNameToken qName, PCDataToken content, Identifier id) throws XQRLSystemException {
        return BEA_PIToken.create(qName, content, id);
    }

    public static QNameToken createQName(String qName) throws XQRLSystemException {
        return TokenFactory.createQName(qName, (String)null);
    }

    public static QNameToken createQName(String qName, String uri) throws XQRLSystemException {
        return TokenFactory.createQName(qName, uri != null ? TokenFactory.createURI(uri) : null);
    }

    public static QNameToken createQName(String qName, URIToken uri) throws XQRLSystemException {
        return TokenFactory.createQName(TokenFactory.createString(qName, true), uri);
    }

    public static QNameToken createQName(StringToken qName) throws XQRLSystemException {
        return TokenFactory.createQName(qName, null);
    }

    public static QNameToken createQName(StringToken qName, URIToken uri) throws XQRLSystemException {
        return BEA_QNameToken.create(qName, uri);
    }

    public static Token createSimple(Object o) throws XQRLSystemException {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return TokenFactory.createDouble((Double)o);
        }
        if (o instanceof Float) {
            return TokenFactory.createFloat(((Float)o).floatValue());
        }
        if (o instanceof Integer || o instanceof Long) {
            return TokenFactory.createInteger(((Number)o).longValue());
        }
        if (o instanceof String) {
            return TokenFactory.createString((String)o);
        }
        if (o instanceof StringBuffer) {
            return TokenFactory.createString((StringBuffer)o);
        }
        if (o instanceof Boolean) {
            return TokenFactory.createBoolean((Boolean)o);
        }
        throw new XQRLSystemException(2027, (Object)o.getClass().getName());
    }

    public static StringToken createString(char[] value) {
        return TokenFactory.createString(new String(value), false);
    }

    public static StringToken createString(String value) {
        return TokenFactory.createString(value, false);
    }

    public static StringToken createString(StringBuffer value) {
        return TokenFactory.createString(value.toString(), false);
    }

    public static StringToken createString(String value, boolean cache) {
        return TokenFactory.createString(value, null, cache);
    }

    public static StringToken createString(String value, QNameToken qName) {
        return TokenFactory.createString(value, qName, false);
    }

    public static StringToken createString(String value, QNameToken qName, boolean cache) {
        return BEA_StringToken.create(value, qName, cache);
    }

    public static TextToken createText(String value) throws XQRLSystemException {
        return TokenFactory.createText(TokenFactory.createPCData(value), null);
    }

    public static TextToken createText(String value, Identifier id) throws XQRLSystemException {
        return TokenFactory.createText(TokenFactory.createPCData(value), id);
    }

    public static TextToken createText(PCDataToken value) throws XQRLSystemException {
        return TokenFactory.createText(value, null);
    }

    public static TextToken createText(PCDataToken value, Identifier id) throws XQRLSystemException {
        return BEA_TextToken.create(value, id);
    }

    public static TimeToken createTime(int[] value) {
        return TokenFactory.createTime(value, (QNameToken)null);
    }

    public static TimeToken createTime(int[] value, QNameToken qName) {
        return BEA_TimeToken.create(value, qName);
    }

    public static TimeToken createTime(int[] value, int[] timeZone) {
        return TokenFactory.createTime(value, timeZone, null);
    }

    public static TimeToken createTime(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_TimeToken.create(value, timeZone, qName);
    }

    public static TimeToken createTime(String value) {
        return TokenFactory.createTime(value, null);
    }

    public static TimeToken createTime(String value, QNameToken qName) {
        return BEA_TimeToken.create(value, qName);
    }

    public static URIToken createURI(char[] value) {
        return TokenFactory.createURI(value, null);
    }

    public static URIToken createURI(String value) {
        return TokenFactory.createURI(value, null);
    }

    public static URIToken createURI(StringBuffer value) {
        return TokenFactory.createURI(new String(value), null);
    }

    public static URIToken createURI(char[] value, QNameToken qName) {
        return TokenFactory.createURI(new String(value), qName);
    }

    public static URIToken createURI(String value, QNameToken qName) {
        return BEA_URIToken.create(value, qName);
    }

    public static URIToken createURI(StringBuffer value, QNameToken qName) {
        return TokenFactory.createURI(new String(value), qName);
    }

    public static YearToken createYear(int[] value) {
        return BEA_YearToken.create(value, null);
    }

    public static YearToken createYear(int[] value, int[] timeZone) {
        return TokenFactory.createYear(value, timeZone, null);
    }

    public static YearToken createYear(int[] value, QNameToken qName) {
        return BEA_YearToken.create(value, qName);
    }

    public static YearToken createYear(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_YearToken.create(value, timeZone, qName);
    }

    public static YearToken createYear(String value) {
        return BEA_YearToken.create(value, null);
    }

    public static YearToken createYear(String value, QNameToken qName) {
        return BEA_YearToken.create(value, qName);
    }

    public static YearMonthToken createYearMonth(int[] value) {
        return BEA_YearMonthToken.create(value, null);
    }

    public static YearMonthToken createYearMonth(int[] value, int[] timeZone) {
        return TokenFactory.createYearMonth(value, timeZone, null);
    }

    public static YearMonthToken createYearMonth(int[] value, QNameToken qName) {
        return BEA_YearMonthToken.create(value, qName);
    }

    public static YearMonthToken createYearMonth(int[] value, int[] timeZone, QNameToken qName) {
        return BEA_YearMonthToken.create(value, timeZone, qName);
    }

    public static YearMonthToken createYearMonth(String value) {
        return BEA_YearMonthToken.create(value, null);
    }

    public static YearMonthToken createYearMonth(String value, QNameToken qName) {
        return BEA_YearMonthToken.create(value, qName);
    }

    public static YearMonthDurationToken createYearMonthDuration(int[] value) {
        return TokenFactory.createYearMonthDuration(value, null);
    }

    public static YearMonthDurationToken createYearMonthDuration(int[] value, QNameToken qName) {
        return (YearMonthDurationToken)BEA_YearMonthDurationToken.create(value, qName);
    }

    private TokenFactory() {
    }
}

