/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;

public interface Token {
    public boolean equals(Object var1);

    public short getKind();

    public Object getObject();

    public QNameToken getTypeQName();

    public XQueryType getXQueryType(Context var1);

    public int hashCode();

    public String toString();

    public static final class Kind {
        public static final short UNKNOWN = 0;
        public static final short BEGIN_ELEMENT = 1;
        public static final short BEGIN_ATTRIBUTE = 2;
        public static final short BEGIN_DOCUMENT = 3;
        public static final short END_ELEMENT = 4;
        public static final short END_ATTRIBUTE = 5;
        public static final short END_DOCUMENT = 6;
        public static final short COMMENT = 7;
        public static final short NAMESPACE = 8;
        public static final short PROC_INST = 9;
        public static final short TEXT = 10;
        public static final short QNAME = 11;
        public static final short BASE64BINARY = 12;
        public static final short BOOLEAN = 13;
        public static final short DECIMAL = 14;
        public static final short DOUBLE = 15;
        public static final short FLOAT = 16;
        public static final short HEXBINARY = 17;
        public static final short INTEGER = 18;
        public static final short PCDATA = 19;
        public static final short STRING = 20;
        public static final short URI = 21;
        public static final short DATE = 22;
        public static final short DATETIME = 23;
        public static final short DURATION = 24;
        public static final short GDAY = 25;
        public static final short GMONTH = 26;
        public static final short GMONTHDAY = 27;
        public static final short GYEAR = 28;
        public static final short GYEARMONTH = 29;
        public static final short TIME = 30;
        private static final String[] m_tokenStrings = new String[]{"UNKNOWN", "Begin element", "Begin attribute", "Begin document", "End element", "End attribute", "End document", "comment", "namespace", "processing-instruction", "text", "QName", "base64", "boolean", "decimal", "double", "float", "hex", "integer", "PCData", "string", "URI", "date", "dateTime", "duration", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "time"};

        public static final boolean isBegin(short kind) {
            return kind >= 1 && kind <= 3;
        }

        public static final boolean isBegin(Token t) {
            return Kind.isBegin(t.getKind());
        }

        public static final boolean isEnd(short kind) {
            return kind >= 4 && kind <= 6;
        }

        public static final boolean isEnd(Token t) {
            return Kind.isEnd(t.getKind());
        }

        public static final boolean isNested(short kind) {
            return Kind.isBegin(kind);
        }

        public static final boolean isNested(Token t) {
            return Kind.isNested(t.getKind());
        }

        public static final boolean isNode(short kind) {
            return Kind.isBegin(kind) || kind >= 7 && kind <= 10;
        }

        public static final boolean isNode(Token t) {
            return Kind.isNode(t.getKind());
        }

        public static final boolean isSimple(short kind) {
            return kind >= 11 && kind <= 30;
        }

        public static final boolean isSimple(Token t) {
            return Kind.isSimple(t.getKind());
        }

        public static final String toString(short kind) {
            return m_tokenStrings[kind];
        }

        public static final String getName(short kind) {
            switch (kind) {
                case 1: 
                case 4: {
                    return "element";
                }
                case 2: 
                case 5: {
                    return "attribute";
                }
                case 3: 
                case 6: {
                    return "document";
                }
            }
            return Kind.toString(kind);
        }

        private Kind() {
        }
    }
}

