/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.tokens.StringToken;
import com.bea.xquery.tokens.URIToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.util.HashFactory;
import com.bea.xquery.xdbc.Context;
import java.util.Map;

class BEA_QNameToken
extends BEA_Token
implements QNameToken {
    private final StringToken m_name;
    private final URIToken m_uri;
    private static final Map m_cache = HashFactory.createMyMap();

    public final void appendTo(StringBuffer sb) {
        sb.append('[');
        sb.append(this.m_name.getValue());
        if (this.m_uri != null && this.m_uri.toString() != null) {
            sb.append('@');
            sb.append(this.m_uri.getValue());
        }
        sb.append(']');
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QNameToken) {
            QNameToken t = (QNameToken)o;
            if (this.m_uri == null && t.getURI() != null) {
                return false;
            }
            if (this.m_uri != null && t.getURI() == null) {
                return false;
            }
            return this.m_name.equals(t.getName()) && (this.m_uri == null || this.m_uri.equals(t.getURI()));
        }
        return false;
    }

    public StringToken getName() {
        return this.m_name;
    }

    public final Object getObject() {
        return this.m_uri != null ? this.m_uri.getValue() : null;
    }

    public URIToken getURI() {
        return this.m_uri;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.QNAME;
    }

    public int hashCode() {
        return this.m_name.hashCode() + (this.m_uri != null ? this.m_uri.hashCode() : 0) + 1;
    }

    public boolean hasURI() {
        return !this.isURIEmpty();
    }

    public boolean isURIEmpty() {
        return this.m_uri == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        this.appendTo(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static QNameToken create(StringToken name, URIToken uri) throws XQRLSystemException {
        if (name.getValue() == null) {
            throw new XQRLSystemException(1048);
        }
        Map map = m_cache;
        synchronized (map) {
            BEA_QNameToken tNew = new BEA_QNameToken(name, uri);
            QNameToken t = (QNameToken)m_cache.get(tNew);
            if (t == null) {
                t = tNew;
                m_cache.put(t, t);
            }
            return t;
        }
    }

    private BEA_QNameToken(StringToken name, URIToken uri) {
        super((short)11);
        this.m_name = name;
        this.m_uri = uri;
    }
}

