/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.exceptions.XQRLSystemException;
import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.PCDataToken;
import com.bea.xquery.tokens.Token;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.util.HashFactory;
import com.bea.xquery.util.MyHashMap;
import com.bea.xquery.xdbc.Context;

final class BEA_PCDataToken
extends BEA_Token
implements PCDataToken {
    private char[] m_data;
    private int m_dataLen;
    private static final MyHashMap m_cache = HashFactory.createMyMap();
    private static int m_fudge = 16;
    private transient int m_hashCode;

    public PCDataToken append(Token t) {
        if (t instanceof PCDataToken) {
            char[] thatData = ((PCDataToken)t).getValue();
            int thatLen = ((PCDataToken)t).getLength();
            this.ensureCapacity(this.m_dataLen + thatLen);
            System.arraycopy(thatData, 0, this.m_data, this.m_dataLen, thatLen);
            this.m_dataLen += thatLen;
            return this;
        }
        return this.append(t.toString());
    }

    public PCDataToken append(char c) {
        this.ensureCapacity(this.m_dataLen + 1);
        this.m_data[this.m_dataLen++] = c;
        return this;
    }

    public PCDataToken append(String s) {
        int thatLength = s.length();
        this.ensureCapacity(this.m_dataLen + thatLength);
        s.getChars(0, thatLength, this.m_data, this.m_dataLen);
        this.m_dataLen += thatLength;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PCDataToken) {
            PCDataToken t = (PCDataToken)o;
            if (this.getLength() != t.getLength()) {
                return false;
            }
            char[] v = t.getValue();
            int i = 0;
            while (i < this.getLength()) {
                if (this.m_data[i] != v[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int getLength() {
        return this.m_dataLen;
    }

    public Object getObject() {
        return this.getValue();
    }

    public char[] getValue() {
        if (this.m_dataLen == this.m_data.length) {
            return this.m_data;
        }
        char[] result = new char[this.m_dataLen];
        System.arraycopy(this.m_data, 0, result, 0, this.m_dataLen);
        return result;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.ANYSIMPLETYPE;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int i = 0;
            while (i < this.m_dataLen) {
                this.m_hashCode = 31 * this.m_hashCode + this.m_data[i];
                ++i;
            }
        }
        return this.m_hashCode;
    }

    public String toString() {
        return new String(this.m_data, 0, this.m_dataLen);
    }

    static PCDataToken create(char[] data, int offset, int length) throws XQRLSystemException {
        return new BEA_PCDataToken(data, offset, length);
    }

    static PCDataToken create(String data) throws XQRLSystemException {
        return new BEA_PCDataToken(data);
    }

    static PCDataToken create(StringBuffer data) throws XQRLSystemException {
        return new BEA_PCDataToken(data);
    }

    private BEA_PCDataToken(char[] data, int offset, int length) throws XQRLSystemException {
        super((short)19);
        if (data == null || offset < 0 || length < 0) {
            throw new XQRLSystemException(1043, (Object)"BEA_PCDataToken");
        }
        this.m_data = new char[length];
        this.m_dataLen = length;
        System.arraycopy(data, offset, this.m_data, 0, length);
    }

    private BEA_PCDataToken(String data) throws XQRLSystemException {
        super((short)19);
        if (data == null) {
            throw new XQRLSystemException(1043, (Object)"BEA_PCDataToken");
        }
        this.m_data = data.toCharArray();
        this.m_dataLen = this.m_data.length;
    }

    private BEA_PCDataToken(StringBuffer data) throws XQRLSystemException {
        super((short)19);
        if (data == null) {
            throw new XQRLSystemException(1043, (Object)"BEA_PCDataToken");
        }
        this.m_data = BEA_PCDataToken.toChar(data);
        this.m_dataLen = this.m_data.length;
    }

    private void ensureCapacity(int capacity) {
        if (this.m_data.length < capacity) {
            char[] newData = new char[capacity + m_fudge];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_dataLen);
            this.m_data = newData;
        }
    }

    private void poolData() {
        if (this.getLength() <= 8) {
            char[] pooled = (char[])m_cache.get((Object)this);
            if (pooled != null) {
                this.m_data = pooled;
            } else {
                m_cache.put((Object)this, (Object)this.m_data);
            }
        }
    }

    private static char[] toChar(StringBuffer sb) {
        char[] charArray = new char[sb.length()];
        sb.getChars(0, sb.length(), charArray, 0);
        return charArray;
    }
}

