/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.IntegerToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;

class BEA_IntegerToken
extends BEA_Token
implements IntegerToken {
    private final long m_value;

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IntegerToken) {
            IntegerToken t = (IntegerToken)o;
            return this.getValue() == t.getValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue() == this.getValue();
        }
        return false;
    }

    public final Object getObject() {
        return new Long(this.m_value);
    }

    public final long getValue() {
        return this.m_value;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.INTEGER;
    }

    public final int hashCode() {
        return (int)this.m_value + 1;
    }

    public final String toString() {
        return Long.toString(this.m_value);
    }

    static IntegerToken create(long value, QNameToken name) {
        return name == null ? new BEA_IntegerToken(value) : new Derived(value, name);
    }

    protected BEA_IntegerToken(long value) {
        super((short)18);
        this.m_value = value;
    }

    private static final class Derived
    extends BEA_IntegerToken {
        private final QNameToken m_name;

        Derived(long value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        public QNameToken getTypeQName() {
            return this.m_name;
        }

        public XQueryType getXQueryType(Context ctx) {
            return ctx.getTypeManager().findType(this.m_name);
        }
    }
}

