/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.HexBinaryToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;
import java.util.Arrays;

class BEA_HexBinaryToken
extends BEA_Token
implements HexBinaryToken {
    private static char[] m_convert = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private transient int m_hashCode;
    private final byte[] m_value;

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HexBinaryToken) {
            HexBinaryToken t = (HexBinaryToken)o;
            return Arrays.equals(this.m_value, t.getValue());
        }
        return false;
    }

    public final Object getObject() {
        return this.m_value;
    }

    public final byte[] getValue() {
        return this.m_value;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.HEXBINARY;
    }

    public final int hashCode() {
        if (this.m_hashCode == 0) {
            int i = 0;
            while (i < this.m_value.length) {
                this.m_hashCode = 37 * this.m_hashCode + this.m_value[i];
                ++i;
            }
        }
        return this.m_hashCode;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.m_value.length) {
            byte octet = this.m_value[i];
            sb.append(m_convert[(octet & 0xF0) >>> 4]);
            sb.append(m_convert[octet & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    static HexBinaryToken create(byte[] value, QNameToken name) {
        return name == null ? new BEA_HexBinaryToken(value) : new Derived(value, name);
    }

    static HexBinaryToken create(String value, QNameToken name) {
        return name == null ? new BEA_HexBinaryToken(value) : new Derived(value, name);
    }

    protected BEA_HexBinaryToken(byte[] value) {
        super((short)17);
        this.m_value = value;
    }

    protected BEA_HexBinaryToken(String value) {
        super((short)17);
        char[] cData = value.toCharArray();
        this.m_value = new byte[cData.length];
        int i = 0;
        while (i < cData.length) {
            this.m_value[i] = (byte)cData[i];
            ++i;
        }
    }

    private static final class Derived
    extends BEA_HexBinaryToken {
        private final QNameToken m_name;

        Derived(byte[] value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        Derived(String value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        public QNameToken getTypeQName() {
            return this.m_name;
        }

        public XQueryType getXQueryType(Context ctx) {
            return ctx.getTypeManager().findType(this.m_name);
        }
    }
}

