/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.FloatToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;

class BEA_FloatToken
extends BEA_Token
implements FloatToken {
    private final float m_value;

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FloatToken) {
            FloatToken t = (FloatToken)o;
            return this.getValue() == t.getValue();
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() == this.getValue();
        }
        return false;
    }

    public final Object getObject() {
        return new Float(this.m_value);
    }

    public final float getValue() {
        return this.m_value;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.FLOAT;
    }

    public final int hashCode() {
        return (int)this.m_value + 1;
    }

    public final String toString() {
        return Float.toString(this.m_value);
    }

    static FloatToken create(double value, QNameToken name) {
        return name == null ? new BEA_FloatToken(value) : new Derived(value, name);
    }

    protected BEA_FloatToken(double value) {
        super((short)16);
        this.m_value = (float)value;
    }

    private static final class Derived
    extends BEA_FloatToken {
        private final QNameToken m_name;

        public Derived(double value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        public QNameToken getTypeQName() {
            return this.m_name;
        }

        public XQueryType getXQueryType(Context ctx) {
            return ctx.getTypeManager().findType(this.m_name);
        }
    }
}

