/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.DecimalToken;
import com.bea.xquery.tokens.IntegerToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;
import java.math.BigDecimal;

class BEA_DecimalToken
extends BEA_Token
implements DecimalToken {
    private final BigDecimal m_value;

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DecimalToken) {
            DecimalToken t = (DecimalToken)o;
            return this.getValue().equals(t.getValue());
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).equals(this.getValue());
        }
        return false;
    }

    public final Object getObject() {
        return this.m_value;
    }

    public final BigDecimal getValue() {
        return this.m_value;
    }

    public final int hashCode() {
        return this.m_value.hashCode() + 1;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.DECIMAL;
    }

    public final String toString() {
        return this.m_value.toString();
    }

    static DecimalToken create(BigDecimal value, QNameToken name) {
        return name == null ? new BEA_DecimalToken(value) : new Derived(value, name);
    }

    static DecimalToken create(IntegerToken value, QNameToken name) {
        return name == null ? new BEA_DecimalToken(value) : new Derived(value, name);
    }

    protected BEA_DecimalToken(BigDecimal value) {
        super((short)14);
        this.m_value = value;
    }

    protected BEA_DecimalToken(IntegerToken value) {
        this(new BigDecimal((double)value.getValue()));
    }

    private static final class Derived
    extends BEA_DecimalToken {
        private final QNameToken m_name;

        Derived(BigDecimal value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        Derived(IntegerToken value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        public QNameToken getTypeQName() {
            return this.m_name;
        }

        public XQueryType getXQueryType(Context ctx) {
            return ctx.getTypeManager().findType(this.m_name);
        }
    }
}

