/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xquery.tokens;

import com.bea.xquery.tokens.BEA_Token;
import com.bea.xquery.tokens.BooleanToken;
import com.bea.xquery.tokens.QNameToken;
import com.bea.xquery.types.XQueryType;
import com.bea.xquery.xdbc.Context;

class BEA_BooleanToken
extends BEA_Token
implements BooleanToken {
    private final boolean m_value;
    private static final BooleanToken m_true = new BEA_BooleanToken(true);
    private static final BooleanToken m_false = new BEA_BooleanToken(false);

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BooleanToken) {
            BooleanToken t = (BooleanToken)o;
            return this.getValue() == t.getValue();
        }
        if (o instanceof Boolean) {
            return ((Boolean)o).booleanValue() == this.getValue();
        }
        return false;
    }

    public final Object getObject() {
        return new Boolean(this.m_value);
    }

    public final boolean getValue() {
        return this.m_value;
    }

    public XQueryType getXQueryType(Context ctx) {
        return XQueryType.BOOLEAN;
    }

    public final int hashCode() {
        return this.m_value ? 1 : 0;
    }

    public final String toString() {
        return this.m_value ? "true" : "false";
    }

    static BooleanToken create(boolean value, QNameToken name) {
        return name == null ? (value ? m_true : m_false) : new Derived(value, name);
    }

    protected BEA_BooleanToken(boolean value) {
        super((short)13);
        this.m_value = value;
    }

    private static final class Derived
    extends BEA_BooleanToken {
        private final QNameToken m_name;

        Derived(boolean value, QNameToken name) {
            super(value);
            this.m_name = name;
        }

        public QNameToken getTypeQName() {
            return this.m_name;
        }

        public XQueryType getXQueryType(Context ctx) {
            return ctx.getTypeManager().findType(this.m_name);
        }
    }
}

