/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.streamImpl;

import com.bea.xml.streamImpl.StreamQueue;
import com.bea.xml.streamImpl.XMLEventImpl;
import java.io.IOException;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class XmlSubStream
implements XMLInputStream {
    private StreamQueue _streamQueue;
    int _currentEventNo;
    private ReferenceResolver refRes;
    private int _depth;
    private boolean _open;

    XmlSubStream(StreamQueue sq, int cen) throws XMLStreamException {
        this._streamQueue = sq;
        this._currentEventNo = cen;
        this._depth = 0;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this._depth >= 0) {
            XMLEvent peek;
            boolean hasNext = this._streamQueue.hasNext(this);
            if (hasNext && this._depth == 0 && (peek = this._streamQueue.getPeek(this)) != null && peek.getType() == 4) {
                --this._depth;
                return false;
            }
            return hasNext;
        }
        return false;
    }

    public void skipElement() throws XMLStreamException {
        int tagCount = 0;
        boolean done = false;
        while (this.hasNext() && !done) {
            XMLEvent e = this.next();
            switch (e.getType()) {
                case 2: {
                    ++tagCount;
                    break;
                }
                case 4: {
                    if (--tagCount > 0) break;
                    done = true;
                    break;
                }
                case 128: 
                case 512: {
                    done = true;
                    break;
                }
            }
        }
    }

    public final XMLEvent next() throws XMLStreamException {
        int type;
        if (!this.hasNext()) {
            return null;
        }
        XMLEvent currentEvent = this._streamQueue.getNext(this);
        int n = type = currentEvent != null ? currentEvent.getType() : 128;
        if (type == 2) {
            ++this._depth;
        } else if (type == 4) {
            --this._depth;
            if (this._depth < 0) {
                currentEvent = null;
            }
        }
        return currentEvent;
    }

    public XMLEventImpl nextImpl() throws XMLStreamException {
        int type;
        if (!this.hasNext()) {
            return null;
        }
        XMLEventImpl currentEvent = (XMLEventImpl)this._streamQueue.getNext(this);
        int n = type = currentEvent != null ? currentEvent.getType() : 128;
        if (type == 2) {
            ++this._depth;
        } else if (type == 4) {
            --this._depth;
            if (this._depth < 0) {
                currentEvent = null;
            }
        }
        return currentEvent;
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return this._streamQueue.registerSubstream(this);
    }

    public void close() throws XMLStreamException {
        try {
            if (this._streamQueue != null) {
                this._streamQueue.unregisterSubstream(this);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("IOException: " + e);
        }
    }

    public void skip() throws XMLStreamException {
        if (this.hasNext()) {
            this.next();
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.hasNext()) {
            return null;
        }
        return this._streamQueue.getPeek(this);
    }

    public boolean skip(int eventType) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent e = this.peek();
            if (e == null) {
                return false;
            }
            if (e.getType() == eventType) {
                return true;
            }
            this.next();
        }
        return false;
    }

    protected boolean matchName(XMLName name1, XMLName name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        if (name1.getNamespaceUri() != null && name1.getNamespaceUri().equals(name2.getNamespaceUri())) {
            if (name1.getLocalName() != null) {
                return name1.getLocalName().equals(name2.getLocalName());
            }
            return true;
        }
        if (name1.getLocalName() != null) {
            return name1.getLocalName().equals(name2.getLocalName());
        }
        return false;
    }

    public boolean skip(XMLName name) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent e = this.peek();
            if (e == null) {
                return false;
            }
            if ((e.getType() == 2 || e.getType() == 4) && this.matchName(name, e.getName())) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public boolean skip(XMLName name, int eventType) throws XMLStreamException {
        while (this.skip(name)) {
            XMLEvent e = this.peek();
            if (e == null) {
                return false;
            }
            if (e.getType() == eventType) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.refRes;
    }

    public void setReferenceResolver(ReferenceResolver resolver) {
        this.refRes = resolver;
    }
}

