/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.streamImpl;

import weblogic.xml.stream.XMLName;

public class XMLNameImpl
implements XMLName {
    private String namespaceUri;
    private String localName;
    private String prefix;

    public void setNamespaceUri(String namespaceUri) {
        if (namespaceUri != null && namespaceUri.equals("")) {
            return;
        }
        this.namespaceUri = namespaceUri;
    }

    public XMLNameImpl(String namespaceUri, String localName, String prefix) {
        this.setNamespaceUri(namespaceUri);
        this.localName = localName;
        this.prefix = prefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        if (this.prefix != null && this.prefix.length() > 0) {
            return this.prefix + ":" + this.localName;
        }
        return this.localName;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XMLName) {
            XMLName name = (XMLName)obj;
            String lname = this.localName;
            if (!(lname != null ? lname.equals(name.getLocalName()) : name.getLocalName() == null)) {
                return false;
            }
            String uri = this.namespaceUri;
            return uri == null ? name.getNamespaceUri() == null : uri.equals(name.getNamespaceUri());
        }
        return false;
    }

    public String toString() {
        if (this.getNamespaceUri() != null) {
            return "['" + this.getNamespaceUri() + "']:" + this.getQualifiedName();
        }
        return this.getQualifiedName();
    }
}

